/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.FrontendRepositoryProperties;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RepositoryAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.EditorJobAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.ModelAccess;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXObjectReferenceCannotBeResolved;
import com.arcway.lib.ui.editor.exception.EEXRelationCardinalityViolation;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.agent.AbstractCurrentModelAndModificationsAccessAgent;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.repository.interFace.data.IRepositoryPropertyOrCategoryReference;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.IIDSampleAndLockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.RepositoryRelationContributionTypeCardinality;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationObjectType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectTypeCategoryReference;
import java.util.List;
import java.util.Map;

public class CurrentModelAndModificationsAccessAgent
extends AbstractCurrentModelAndModificationsAccessAgent<IRepositoryPropertyOrCategoryReference, IRepositoryPropertyReference, IRepositoryObjectTypeCategoryReference, IRepositoryObjectReference> {
    private static final ILogger logger = Logger.getLogger(CurrentModelAndModificationsAccessAgent.class);
    private final IRepositoryInterfaceRO repositoryInterface;
    private final RepositoryAccessAgent repositoryAccessAgent;
    private final EditorJobAccessAgent editorJobAccessAgent;
    private final ModelAccess modelAccess;

    public CurrentModelAndModificationsAccessAgent(IRepositoryInterfaceRO repositoryInterface, EditorJobAccessAgent editorJobAccessAgent, ModelAccess modelAccess) {
        this.repositoryInterface = repositoryInterface;
        this.repositoryAccessAgent = new RepositoryAccessAgent(repositoryInterface, modelAccess);
        this.editorJobAccessAgent = editorJobAccessAgent;
        this.modelAccess = modelAccess;
    }

    public IRepositoryObjectReference getParentObjectReferenceForNewObject(IRepositoryObjectReference newObject) {
        return this.editorJobAccessAgent.getParentObjectReferenceForNewObject(newObject);
    }

    public void addObject(Object objectReference, Object parentObjectReference) {
        this.editorJobAccessAgent.addObject(objectReference, parentObjectReference);
    }

    public Object getParent(Object reference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryObjectReference objectReference = (IRepositoryObjectReference)reference;
        return this.getParent(objectReference);
    }

    private IRepositoryObjectReference getParent(IRepositoryObjectReference objectReference) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        IRepositoryObjectReference parentObjectReference;
        try {
            parentObjectReference = this.repositoryAccessAgent.getParent(objectReference);
        }
        catch (EEXObjectReferenceCannotBeResolved e) {
            parentObjectReference = this.getParentObjectReferenceForNewObject(objectReference);
        }
        return parentObjectReference;
    }

    public ISet_<? extends Object> getRelationsThatMustBeCreated(Object relationTypeID, Object objectID, Object roleID) {
        return new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    }

    public ISet_<? extends Object> getRelationsThatMayBeCreated(Object relationTypeID, Object objectID, Object roleID, boolean relationsWithPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return this.repositoryAccessAgent.getPotentialRelationContributors((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID, relationsWithPermissionOnly);
    }

    public ISet_<? extends Object> getRelationsThatAreRecommendedToBeCreated(Object relationTypeID, Object objectID, Object roleID, boolean relationsWithPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    }

    public ISet_<? extends Object> getRelationsThatMustNotBeCreated(Object relationTypeID, Object objectID, Object roleID) {
        return new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    }

    public ISet_<? extends Object> getRelationsThatMustBeDeleted(Object relationTypeID, Object objectID, Object roleID) {
        return new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    }

    public ISet_<? extends Object> getRelationsThatMayBeDeleted(Object relationTypeID, Object objectID, Object roleID, boolean relationsWithPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return this.repositoryAccessAgent.getRelationContributorsOfExistingRelations((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
    }

    public ISet_<? extends Object> getRelationsThatMustNotBeDeleted(Object relationTypeID, Object objectID, Object roleID) {
        return new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    }

    public ISet_<? extends Object> getCreatedRelations(Object relationTypeID, Object objectID, Object roleID) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return this.editorJobAccessAgent.getNewRelations((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
    }

    public ISet_<? extends Object> getDeletedRelations(Object relationTypeID, Object objectID, Object roleID) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return this.editorJobAccessAgent.getDeletedRelations((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
    }

    public ISet_<? extends Object> getCreatedAndNotDeletedRelations(Object relationTypeID, Object objectID, Object roleID, boolean withPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        HashSet_ relations = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        relations.addAll(this.getRelationsThatMayBeDeleted(relationTypeID, objectID, roleID, withPermissionOnly));
        relations.removeAll(this.getDeletedRelations(relationTypeID, objectID, roleID));
        relations.addAll(this.getCreatedRelations(relationTypeID, objectID, roleID));
        return relations;
    }

    public Object getParentsValueForProperty(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryObjectReference parentObjectReference = propertyReference.getObjectReference();
        List<Object> parentsCurrentValueForProperty_asList = this.repositoryAccessAgent.getAncestorsCurrentValuesForProperty(parentObjectReference = this.getParent(parentObjectReference), propertyReference.getObjectReference().getObjectTypeID(), propertyReference.getPropertyTypeID(), 1);
        if (!parentsCurrentValueForProperty_asList.isEmpty()) {
            return parentsCurrentValueForProperty_asList.get(0);
        }
        return null;
    }

    public List<Object> getAncestorsValuesForProperty(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryObjectReference parentObjectReference = propertyReference.getObjectReference();
        parentObjectReference = this.getParent(parentObjectReference);
        return this.repositoryAccessAgent.getAncestorsCurrentValuesForProperty(parentObjectReference, propertyReference.getObjectReference().getObjectTypeID(), propertyReference.getPropertyTypeID(), 0);
    }

    public boolean isRelationPossible(Object relationTypeID, Object roleID1, Object objectID, Object objectReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.isRelationPossible((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IRepositoryPropertySetSample)objectID, (IRepositoryObjectReference)objectReference);
    }

    public int getMinCardinality(Object relationTypeID, Object roleID) {
        return this.getCardinality(relationTypeID, roleID).getMinimum();
    }

    public int getMaxCardinality(Object relationTypeID, Object roleID) {
        int maximum = this.getCardinality(relationTypeID, roleID).getMaximum();
        return maximum < 0 ? Integer.MAX_VALUE : maximum;
    }

    private RepositoryRelationContributionTypeCardinality getCardinality(Object relationTypeID, Object roleID) {
        return this.repositoryAccessAgent.getCardinality((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID);
    }

    public String getRelatedItemLocation(Object relationRef, PresentationContext currentPresentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getObjectPath((IRepositoryObjectReference)relationRef, currentPresentationContext);
    }

    public String getLabelForRelation(Object relationTypeID, Object roleID, Object objectID, Object relationRef, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryObjectReference objectReference = (IRepositoryObjectReference)relationRef;
        String parentPath = this.getParentPath(objectReference, presentationContext);
        String parentPathPostfix = parentPath.length() > 2 ? " (" + parentPath.substring(1, parentPath.length() - 1) + ")" : "";
        return String.valueOf(this.repositoryAccessAgent.getObjectName(objectReference, presentationContext)) + parentPathPostfix;
    }

    private String getPath(IRepositoryObjectReference objectReference, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        String path;
        try {
            IRepositoryObjectReference parentObjectReference = this.repositoryAccessAgent.getParent(objectReference);
            if (parentObjectReference != null) {
                String parentPath = this.getParentPath(objectReference, presentationContext);
                String objectName = this.repositoryAccessAgent.getObjectName(objectReference, presentationContext);
                path = String.valueOf(parentPath) + objectName + "/";
            } else {
                path = "/";
            }
        }
        catch (EEXObjectReferenceCannotBeResolved e) {
            path = "";
        }
        return path;
    }

    private String getParentPath(IRepositoryObjectReference objectReference, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        String parentPath;
        try {
            IRepositoryObjectReference parentObjectReference = this.repositoryAccessAgent.getParent(objectReference);
            parentPath = parentObjectReference != null ? this.getPath(parentObjectReference, presentationContext) : "";
        }
        catch (EEXObjectReferenceCannotBeResolved e) {
            parentPath = "";
        }
        return parentPath;
    }

    public String getLabelDecorationForRelation(Object relationTypeID, Object roleID, Object objectID, Object relationRef, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return null;
    }

    public IStreamResource getIconForObject16x16(IRepositoryObjectReference objectReference, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getObjectIcon16x16(objectReference.getObjectTypeID(), objectReference.getObjectID(), presentationContext);
    }

    public IStreamResource getIconForObjectType16x16(Object objectRef) {
        return this.repositoryAccessAgent.getObjectTypeIcon16x16((IRepositoryObjectReference)objectRef);
    }

    public IStreamResource getIconForRelation16x16(Object relationTypeID, Object roleID, Object objectID, Object relationRef, PresentationContext presentationContext) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        IRepositoryObjectReference relatedObjectReference = (IRepositoryObjectReference)relationRef;
        return this.repositoryAccessAgent.getObjectIcon16x16(relatedObjectReference.getObjectTypeID(), relatedObjectReference.getObjectID(), presentationContext);
    }

    public IStreamResource getIconDecorationForRelation7x8(Object relationTypeID, Object roleID, Object objectID, Object relationRef) {
        return null;
    }

    public ITextProvider getToolTipTextForRelation(Object relationTypeID, Object roleID, Object objectID, Object relationRef) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return null;
    }

    public boolean relationExists(Object relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.relationExists(relationSample);
    }

    public boolean relationContributorExists(Object roleID, Object objectID, Object relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.relationContributorExists((IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID, (ICrossLinkRepositoryRelationSample)relationSample);
    }

    public void addDeletedRelation(Object relationTypeID, Object roleID, Object objectID, Object objectReference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        this.editorJobAccessAgent.addDeletedRelation(relationTypeID, roleID, objectID, objectReference);
    }

    public void addNewRelation(Object relationTypeID, Object roleID1, Object objectID, Object objectReference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        this.editorJobAccessAgent.addNewRelation(relationTypeID, roleID1, objectID, objectReference);
    }

    public void addNewRelation(Object relationTypeID, Object newRelationSample) {
        this.editorJobAccessAgent.addNewRelation(relationTypeID, newRelationSample);
    }

    public void checkRelationCardinality(Object relationTypeID, Object roleID, Object objectID) throws EEXRelationCardinalityViolation, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        this.editorJobAccessAgent.checkRelationCardinality((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
    }

    public void updateRelationChangeSetsAccordingToNewCurrentState(Object relationTypeID, Object roleID, Object objectID) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        this.editorJobAccessAgent.updateRelationChangeSetsAccordingToNewCurrentState(relationTypeID, roleID, objectID);
    }

    public boolean relationModified(Object relationTypeID, Object roleID, Object objectID) {
        return this.editorJobAccessAgent.relationModified(relationTypeID, roleID, objectID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getDefaultValueForProperty(IRepositoryPropertyReference propertyReference) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot, EEXLockDenied {
        Object editorValue = null;
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
        IRepositoryObjectTypeID objectTypeID = propertyReference.getObjectReference().getObjectTypeID();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        IRepositoryAttributeSetType repositoryAttributeSetType = objectType.getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        IRepositoryData data = null;
        if (repositoryPropertyType.getIDType().isID()) {
            IGenericModificationObjectType genericModificationObjectType = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)typeManager).getGenericModificationObjectType(objectType);
            try {
                IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
                Assert.checkArgumentBeeingNotNull((Object)snapshot);
                IRepositoryObject parentObject = null;
                try {
                    IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)propertyReference.getObjectReference(), (IRepositorySnapshotRO)snapshot);
                    parentObject = this.repositoryAccessAgent.getParent(repositoryObject);
                }
                catch (EXObjectReferenceCannotBeResolved e) {
                    IRepositoryObjectReference parentObjectReference = this.getParentObjectReferenceForNewObject(propertyReference.getObjectReference());
                    if (parentObjectReference == null) {
                        return null;
                    }
                    try {
                        parentObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)parentObjectReference, (IRepositorySnapshotRO)snapshot);
                    }
                    catch (EXObjectReferenceCannotBeResolved e1) {
                        logger.error("EXObjectReferenceCannotBeResolved", (Throwable)e1);
                        throw new RuntimeException(e1);
                    }
                }
                IIDSampleAndLockDeprecated sampleAndLock = this.modelAccess.getLockAndPermissionProvider().getSampleAndIDLockForProperty(propertyReference);
                if (sampleAndLock == null) {
                    sampleAndLock = genericModificationObjectType.getNextFreeObjectID(repositoryPropertyType, parentObject);
                    this.modelAccess.getLockAndPermissionProvider().storeSampleAndIDLock(propertyReference, sampleAndLock);
                }
                data = sampleAndLock.getIDSample();
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
            catch (EXLockDenied e) {
                throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
        }
        if (data == null) {
            data = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)typeManager).getGenericModificationPropertyType(repositoryPropertyType).getDefaultValue();
        }
        IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(typeManager);
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(repositoryDataType);
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendDataTypeParameters parameters = frontendPropertyType.getFrontendDataTypeParameters();
        return frontendDataType.getCurrentValueAsEditorValue(data, parameters);
    }

    public Object getModifiedPropertyValue(IRepositoryPropertyReference reference) {
        return this.editorJobAccessAgent.getModifiedPropertyValue(reference);
    }

    public boolean isPropertyModified(IRepositoryPropertyReference propertyReference) {
        return this.editorJobAccessAgent.isPropertyModified(propertyReference);
    }

    public void refreshPropertyValue(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, JvmExternalResourceInteractionException, EEXRepositoryAccessException, EEXDataValidation {
        if (this.editorJobAccessAgent.isPropertyModified(propertyReference)) {
            Object newValue = this.getModifiedPropertyValue(propertyReference);
            try {
                Object currentValue = this.repositoryAccessAgent.getCurrentValueForProperty(propertyReference);
                IHasher_<Object> propertyValueHasher = FrontendRepositoryProperties.getPropertyValueHasher(this.repositoryInterface.getTypeManager(), propertyReference);
                if (propertyValueHasher.isEqual(newValue, currentValue)) {
                    this.editorJobAccessAgent.resetPropertyValue(propertyReference, newValue);
                } else {
                    this.editorJobAccessAgent.setPropertyValue(propertyReference, newValue, true);
                }
            }
            catch (EEXObjectReferenceCannotBeResolved exVCNBR) {
                this.editorJobAccessAgent.setPropertyValue(propertyReference, newValue, true);
            }
        }
    }

    public void resetPropertyValue(IRepositoryPropertyReference propertyReference, Object newValue) throws EEXDataValidation, JvmExternalResourceInteractionException {
        this.editorJobAccessAgent.resetPropertyValue(propertyReference, newValue);
    }

    public void setPropertyValue(IRepositoryPropertyReference propertyReference, Object newValue) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, JvmExternalResourceInteractionException, EEXRepositoryAccessException, EEXDataValidation {
        this.editorJobAccessAgent.setPropertyValue(propertyReference, newValue, false);
    }

    public Object getCurrentValueForProperty(IRepositoryPropertyReference reference) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getCurrentValueForProperty(reference);
    }

    public Map<String, String> getValueRangeForPropertyAsEditorValue(IRepositoryPropertyReference reference) {
        return this.repositoryAccessAgent.getValueRangeForPropertyAsEditorValue(reference);
    }

    public ISortedSet_<String> getValueRangeKeysForPropertyAsEditorValue(IRepositoryPropertyReference reference) {
        return this.repositoryAccessAgent.getValueRangeKeysForPropertyAsEditorValue(reference);
    }

    public boolean isDatePropertyWithTimeComponent(IRepositoryPropertyReference propertyReference) {
        return this.repositoryAccessAgent.isDatePropertyWithTimeComponent(propertyReference);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> getDefaultValueForObjectTypeCategory(IRepositoryObjectTypeCategoryReference reference) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot, EEXLockDenied {
        return RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(reference);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor getLabelForObjectTypeCategory(ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> key) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getLabelForObjectTypeCategory(key, ((IRepositoryObjectTypeCategoryReference)key.getObjectTypeCategoryReference()).getObjectReference().getObjectTypeID());
    }

    public IList_<ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference>> getValueRangeKeysOfObjectTypeCategoryAsEditorValue(IRepositoryObjectTypeCategoryReference reference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getValueRangeKeysOfObjectTypeCategoryAsEditorValue(reference, reference);
    }

    public boolean isObjectTypeCategoryModified(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) {
        return this.editorJobAccessAgent.isObjectTypeCategoryModified(objectTypeCategoryReference);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> getCurrentValueForObjectTypeCategory(IRepositoryObjectTypeCategoryReference reference) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getCurrentValueForObjectTypeCategory(reference, reference);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> getModifiedObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) {
        return this.editorJobAccessAgent.getModifiedObjectTypeCategoryValue(objectTypeCategoryReference);
    }

    public void setObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> newValue) throws EEXNotReproducibleSnapshot, JvmExternalResourceInteractionException, EEXDataValidation, EEXSnapshotClosed, EEXRepositoryAccessException {
        this.editorJobAccessAgent.setObjectTypeCategoryValue(objectTypeCategoryReference, newValue, false);
    }

    public void resetObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> newValue) throws EEXNotReproducibleSnapshot, JvmExternalResourceInteractionException, EEXDataValidation, EEXSnapshotClosed, EEXRepositoryAccessException {
        this.editorJobAccessAgent.resetObjectTypeCategoryValue(objectTypeCategoryReference, newValue);
    }

    public void refreshObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXDataValidation {
        if (this.editorJobAccessAgent.isObjectTypeCategoryModified(objectTypeCategoryReference)) {
            ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> newValue = this.editorJobAccessAgent.getModifiedObjectTypeCategoryValue(objectTypeCategoryReference);
            try {
                ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> currentValue = this.repositoryAccessAgent.getCurrentValueForObjectTypeCategory(objectTypeCategoryReference, objectTypeCategoryReference);
                if (newValue == null && currentValue == null || newValue != null && newValue.equals(currentValue)) {
                    this.editorJobAccessAgent.resetObjectTypeCategoryValue(objectTypeCategoryReference, newValue);
                } else {
                    this.editorJobAccessAgent.setObjectTypeCategoryValue(objectTypeCategoryReference, newValue, true);
                }
            }
            catch (EEXObjectReferenceCannotBeResolved exVCNBR) {
                this.editorJobAccessAgent.setObjectTypeCategoryValue(objectTypeCategoryReference, newValue, true);
            }
        }
    }

    public boolean isPropertyVisibleForCurrentCategory(IRepositoryPropertyReference propertyReference) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot, EEXObjectReferenceCannotBeResolved {
        if (this.repositoryAccessAgent.isObjectTypeSupportingObjectTypeCategories(propertyReference.getObjectReference().getObjectTypeID())) {
            ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor toBeValueForObjectTypeCategory = this.getToBeObjectTypeCategoryValue(new RepositoryObjectTypeCategoryReference(propertyReference.getObjectReference()));
            return this.repositoryAccessAgent.isPropertyVisibleForCategory(propertyReference, toBeValueForObjectTypeCategory);
        }
        return true;
    }

    public IEditorMessageSet getPropertyMessages(IRepositoryPropertyReference propertyReference) {
        throw new UnsupportedOperationException();
    }

    public IEditorMessageSet getObjectTypeCategoryMessages(IRepositoryObjectTypeCategoryReference propertyReference) throws EEXNotReproducibleSnapshot {
        throw new UnsupportedOperationException();
    }

    public IEditorMessageSet getRelationContributionMessages(Object relationTypeID, Object roleID1, Object objectID1) throws EEXNotReproducibleSnapshot {
        throw new UnsupportedOperationException();
    }

    public IEditorMessageSet getRelationMessages(Object relationTypeID, Object roleID1, Object objectID1, Object objectID2) throws EEXNotReproducibleSnapshot {
        throw new UnsupportedOperationException();
    }
}

