/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.repository.RepositoryEditorLayoutFactory;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.ModelAccess;
import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.ram.IRAMData;
import com.arcway.lib.codec.data.codecs.ram.RAMData;
import com.arcway.lib.codec.data.codecs.ram.RAMDataCoDecForData;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.WidgetReference;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.specification.editor.Editor;
import com.arcway.lib.ui.modelaccess.ILayout;
import com.arcway.lib.ui.modelaccess.factory.IModelAccessAndLayoutFactory;
import com.arcway.lib.ui.modelaccess.factory.IModelAccessAndLayoutFactoryExtension;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.relation.DTCollection_CrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.manager.EXRepositoryInterfaceNotFound;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationObjectType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.manager.IGenericModificationTypeManager;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.List;

public class RepositoryEditorFactory
implements IModelAccessAndLayoutFactory,
IModelAccessAndLayoutFactoryExtension {
    private final ICollection_<IModelAccessAndLayoutFactory> factories;

    public static Input createEditorInputForObjectCreation(IRepositoryInterfaceRO repositoryInterface, IRepositoryObjectReference parentRepositoryObjectReference, IRepositoryObjectTypeID concreteRepositoryObjectTypeID, ICollection_<ICrossLinkRepositoryRelationsReference> initialRelations) {
        Input input = new Input(repositoryInterface, parentRepositoryObjectReference, concreteRepositoryObjectTypeID, initialRelations);
        return input;
    }

    public static Input createEditorInputForObjectModification(IRepositoryInterfaceRO repositoryInterface, IRepositoryObjectReference repositoryObjectReference) {
        Input input = new Input(repositoryInterface, repositoryObjectReference);
        return input;
    }

    public RepositoryEditorFactory() {
        ArrayList_ factoriesRW = new ArrayList_(1);
        factoriesRW.add((Object)this);
        this.factories = factoriesRW;
    }

    public ICollection_<IModelAccessAndLayoutFactory> getFactories() {
        return this.factories;
    }

    public boolean supportsInput(Object inputAsObject) {
        return inputAsObject instanceof Input;
    }

    public IEditorModelAccess createModelAccess(Object inputAsObject) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        ModelAccess repositoryAccessAgent;
        if (this.supportsInput(inputAsObject)) {
            ArrayList_ initialRelations;
            block14: {
                Input input = (Input)inputAsObject;
                IRepositoryInterfaceRO repositoryInterface = RepositoryInterfaces.getRepositoryInterface((Object)input.repositoryReference);
                IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
                IRepositoryObjectReference repositoryObjectReference = input.getRepositoryObjectReference(repositoryTypeManager);
                IRepositoryObjectReference parentRepositoryObjectReference = input.getParentRepositoryObjectReference(repositoryTypeManager);
                ICollection_ initialRelationsOfInput = input.getInitialRelations(repositoryTypeManager);
                repositoryAccessAgent = new ModelAccess(repositoryInterface);
                boolean[] objectExistsVar = new boolean[1];
                IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)repositoryAccessAgent.getSnapshot();
                Assert.checkArgumentBeeingNotNull((Object)snapshot);
                try {
                    RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)repositoryObjectReference, (IRepositorySnapshotRO)snapshot);
                    objectExistsVar[0] = true;
                }
                catch (EXNotReproducibleSnapshot e) {
                    throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
                }
                catch (EXObjectReferenceCannotBeResolved e) {
                    objectExistsVar[0] = false;
                }
                boolean objectExists = objectExistsVar[0];
                boolean[] parentObjectExistsVar = new boolean[1];
                boolean parentObjectExists = false;
                if (parentRepositoryObjectReference != null) {
                    try {
                        RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)parentRepositoryObjectReference, (IRepositorySnapshotRO)snapshot);
                        parentObjectExistsVar[0] = true;
                    }
                    catch (EXObjectReferenceCannotBeResolved e) {
                        parentObjectExistsVar[0] = false;
                    }
                    catch (EXNotReproducibleSnapshot e) {
                        throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
                    }
                    parentObjectExists = parentObjectExistsVar[0];
                }
                initialRelations = new ArrayList_();
                if (!objectExists && parentObjectExists) {
                    repositoryAccessAgent.getLockAndPermissionProvider().acquireCreateLockForObject(parentRepositoryObjectReference, repositoryObjectReference.getObjectTypeID(), repositoryObjectReference.getObjectID());
                    repositoryAccessAgent.addObject(repositoryObjectReference, parentRepositoryObjectReference);
                    initialRelations = initialRelationsOfInput;
                    break block14;
                }
                if (objectExists || parentObjectExists) break block14;
                return null;
            }
            try {
                repositoryAccessAgent.addInitialRelationSamples((ICollection_<? extends Object>)initialRelations);
            }
            catch (EXRepositoryInterfaceNotFound e) {
                repositoryAccessAgent = null;
            }
            catch (EXDataCreationFailed e) {
                repositoryAccessAgent = null;
            }
        } else {
            repositoryAccessAgent = null;
        }
        return repositoryAccessAgent;
    }

    public ILayout createLayout(Object inputAsObject) {
        ILayout layout;
        if (this.supportsInput(inputAsObject)) {
            Input input = (Input)inputAsObject;
            try {
                IRepositoryInterfaceRO repositoryInterface = RepositoryInterfaces.getRepositoryInterface((Object)input.repositoryReference);
                IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
                IRepositoryObjectReference repositoryObjectReference = input.getRepositoryObjectReference(repositoryTypeManager);
                IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(repositoryObjectReference.getObjectTypeID());
                IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
                IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
                Editor layoutSpecification = frontendObjectType.getFormEditorLayoutSpecification();
                final List<WidgetReference> generatedLayout = layoutSpecification != null ? RepositoryEditorLayoutFactory.generateLayout(repositoryObjectReference, repositoryObjectType, layoutSpecification) : RepositoryEditorLayoutFactory.generateDefaultLayout(repositoryObjectReference, repositoryObjectType);
                layout = new ILayout(){

                    public List<WidgetReference> getLayout() {
                        return generatedLayout;
                    }
                };
            }
            catch (EXRepositoryInterfaceNotFound e) {
                layout = null;
            }
            catch (EXDataCreationFailed e) {
                layout = null;
            }
        } else {
            layout = null;
        }
        return layout;
    }

    public int getHashCodeForInput(Object inputAsObject) {
        Input input = (Input)inputAsObject;
        int hashCode = RepositoryInterfaces.getHashCodeForRepositoryInterfaceReference((Object)input.repositoryReference) ^ input.canonicalStringForRepositoryObjectReference.hashCode();
        return hashCode;
    }

    public boolean areInputsEqual(Object inputAsObject1, Object inputAsObject2) {
        Input input1 = (Input)inputAsObject1;
        Input input2 = (Input)inputAsObject2;
        boolean equals = RepositoryInterfaces.areRepositoryInterfaceReferencesEqual((Object)input1.repositoryReference, (Object)input2.repositoryReference) && input1.canonicalStringForRepositoryObjectReference.equals(input2.canonicalStringForRepositoryObjectReference);
        return equals;
    }

    public boolean exists(Object inputAsObject) {
        Input input = (Input)inputAsObject;
        final boolean[] objectExists = new boolean[1];
        input.doWithReferencedObject(new Input.IReferencedObjectProcessor(){

            @Override
            public void doWithReferencedObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
                objectExists[0] = true;
            }

            @Override
            public void objectNotFound(IRepositorySnapshotRO snapshotRO) throws EXNotReproducibleSnapshot {
                objectExists[0] = false;
            }

            @Override
            public void interfaceNotFound() {
                objectExists[0] = false;
            }
        });
        return objectExists[0];
    }

    public IStreamResource getIcon16x16(Object inputAsObject, final PresentationContext presentationContext) {
        final Input input = (Input)inputAsObject;
        final IStreamResource[] icon16x16x = new IStreamResource[1];
        input.doWithReferencedObject(new Input.IReferencedObjectProcessor(){

            @Override
            public void doWithReferencedObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
                IRepositoryObjectType repositoryObjectType = object.getObjectType();
                IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryObjectType.getRepositoryTypeManagerRO());
                icon16x16x[0] = frontendTypeManager.getLabelForObject(object, presentationContext).getIcon16x16();
                if (icon16x16x[0] == null) {
                    IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
                    icon16x16x[0] = frontendObjectType.getLabel().getIcon16x16();
                }
            }

            @Override
            public void objectNotFound(IRepositorySnapshotRO snapshotRO) throws EXNotReproducibleSnapshot {
                try {
                    IRepositoryObjectType repositoryObjectType = snapshotRO.getTypeManager().getObjectType(input.getRepositoryObjectReference(snapshotRO.getTypeManager()).getObjectTypeID());
                    IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryObjectType.getRepositoryTypeManagerRO());
                    IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
                    icon16x16x[0] = frontendObjectType.getLabel().getIcon16x16();
                }
                catch (EXDataCreationFailed e) {
                    icon16x16x[0] = Icons16x16.UNKNOWN;
                }
            }

            @Override
            public void interfaceNotFound() {
                icon16x16x[0] = Icons16x16.UNKNOWN;
            }
        });
        return icon16x16x[0];
    }

    public String getName(Object inputAsObject, final PresentationContext presentationContext) {
        final Input input = (Input)inputAsObject;
        final String[] name = new String[1];
        input.doWithReferencedObject(new Input.IReferencedObjectProcessor(){

            @Override
            public void doWithReferencedObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
                IRepositoryObjectType repositoryObjectType = object.getObjectType();
                IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryObjectType.getRepositoryTypeManagerRO());
                name[0] = frontendTypeManager.getLabelForObject(object, presentationContext).getText();
                if (name[0] == null) {
                    IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
                    name[0] = frontendObjectType.getLabel().getText();
                }
            }

            @Override
            public void objectNotFound(IRepositorySnapshotRO snapshotRO) throws EXNotReproducibleSnapshot {
                try {
                    IRepositoryObjectType repositoryObjectType = snapshotRO.getTypeManager().getObjectType(input.getRepositoryObjectReference(snapshotRO.getTypeManager()).getObjectTypeID());
                    IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryObjectType.getRepositoryTypeManagerRO());
                    IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
                    name[0] = frontendObjectType.getLabel().getText();
                }
                catch (EXDataCreationFailed e) {
                    name[0] = "???";
                }
            }

            @Override
            public void interfaceNotFound() {
                name[0] = "???";
            }
        });
        return name[0];
    }

    public String getToolTipText(Object input, PresentationContext presentationContext) {
        return this.getName(input, presentationContext);
    }

    public Object getObjectReferenceForInput(Object input) {
        IRepositoryObjectReference repositoryObjectReference;
        Input typedInput = (Input)input;
        try {
            IRepositoryInterfaceRO repositoryInterface = typedInput.getRepositoryInterface();
            repositoryObjectReference = typedInput.getRepositoryObjectReference(repositoryInterface.getTypeManager());
        }
        catch (EXRepositoryInterfaceNotFound e) {
            throw new RuntimeException(e);
        }
        catch (EXDataCreationFailed e) {
            throw new RuntimeException(e);
        }
        return repositoryObjectReference;
    }

    public static class Input {
        private final Object repositoryReference;
        private final RAMData serializedParentRepositoryObjectReference;
        private final RAMData serializedRepositoryObjectReference;
        private final String canonicalStringForRepositoryObjectReference;
        private final RAMData serializedInitialRelations;

        private Input(IRepositoryInterfaceRO repositoryInterface, IRepositoryObjectReference parentRepositoryObjectReference, IRepositoryObjectTypeID concreteRepositoryObjectTypeID, ICollection_<ICrossLinkRepositoryRelationsReference> initialRelations) {
            IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
            IRepositoryObjectType concreteRepositoryObjectType = typeManager.getObjectType(concreteRepositoryObjectTypeID);
            IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)typeManager);
            IGenericModificationObjectType genericModificationObjectType = genericModificationTypeManager.getGenericModificationObjectType(concreteRepositoryObjectType);
            Assert.checkArgument((boolean)genericModificationObjectType.isCreatableGenerically());
            IRepositoryPropertySetSample uidSample = genericModificationObjectType.allocateNewObjectID();
            RepositoryObjectReference newRepositoryObjectReference = new RepositoryObjectReference(concreteRepositoryObjectTypeID, uidSample);
            ArrayList_ initialRelationsRW = new ArrayList_(initialRelations.size());
            for (ICrossLinkRepositoryRelationsReference relationsReference : initialRelations) {
                IRepositoryRelationTypeID relationTypeID = relationsReference.getRelationTypeID();
                ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType(relationTypeID);
                IMap_ roleID2objectID = relationsReference.getRoleID2ObjectIDMap();
                HashMap_ roleID2objectIDRW = new HashMap_(roleID2objectID.size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
                for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationType.getAllRelationContributionTypes()) {
                    IRepositoryRelationContributionRoleID roleID = relationContributionType.getRepositoryRelationContributionRoleID();
                    IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)roleID2objectID.getByKey((Object)roleID);
                    if (objectID == null) {
                        objectID = uidSample;
                    }
                    roleID2objectIDRW.put((Object)roleID, (Object)objectID);
                }
                CrossLinkRepositoryRelationSample relationSample = new CrossLinkRepositoryRelationSample(relationTypeID, (IMap_)roleID2objectIDRW);
                initialRelationsRW.add((Object)relationSample);
            }
            this.repositoryReference = RepositoryInterfaces.getRepositoryInterfaceReference((IRepositoryInterfaceRO)repositoryInterface);
            this.serializedParentRepositoryObjectReference = RAMDataCoDecForData.encodeIntoRAMData((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager), (Object)parentRepositoryObjectReference);
            this.serializedRepositoryObjectReference = RAMDataCoDecForData.encodeIntoRAMData((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager), (Object)newRepositoryObjectReference);
            this.serializedInitialRelations = RAMDataCoDecForData.encodeIntoRAMData((IDataType)DTCollection_CrossLinkRepositoryRelationSample.getInstance((IRepositoryTypeManagerRO)typeManager), (Object)initialRelationsRW);
            this.canonicalStringForRepositoryObjectReference = RepositoryReferences.createCanonicalString((IRepositoryObjectReference)newRepositoryObjectReference);
        }

        private Input(IRepositoryInterfaceRO repositoryInterface, IRepositoryObjectReference repositoryObjectReference) {
            IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
            this.repositoryReference = RepositoryInterfaces.getRepositoryInterfaceReference((IRepositoryInterfaceRO)repositoryInterface);
            this.serializedParentRepositoryObjectReference = RAMDataCoDecForData.encodeIntoRAMData((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager), null);
            this.serializedRepositoryObjectReference = RAMDataCoDecForData.encodeIntoRAMData((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager), (Object)repositoryObjectReference);
            this.serializedInitialRelations = RAMDataCoDecForData.encodeIntoRAMData((IDataType)DTCollection_CrossLinkRepositoryRelationSample.getInstance((IRepositoryTypeManagerRO)typeManager), (Object)new ArrayList_(0));
            this.canonicalStringForRepositoryObjectReference = RepositoryReferences.createCanonicalString((IRepositoryObjectReference)repositoryObjectReference);
        }

        public IRepositoryInterfaceRO getRepositoryInterface() throws EXRepositoryInterfaceNotFound {
            IRepositoryInterfaceRO repositoryInterface = RepositoryInterfaces.getRepositoryInterface((Object)this.repositoryReference);
            return repositoryInterface;
        }

        private IRepositoryObjectReference getRepositoryObjectReference(IRepositoryTypeManagerRO typeManager) throws EXDataCreationFailed {
            IRepositoryObjectReference repositoryObjectReference = (IRepositoryObjectReference)RAMDataCoDecForData.decodeFromRAMData((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager), (IRAMData)this.serializedRepositoryObjectReference);
            return repositoryObjectReference;
        }

        private IRepositoryObjectReference getParentRepositoryObjectReference(IRepositoryTypeManagerRO typeManager) throws EXDataCreationFailed {
            IRepositoryObjectReference parentRepositoryObjectReference = (IRepositoryObjectReference)RAMDataCoDecForData.decodeFromRAMData((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)typeManager), (IRAMData)this.serializedParentRepositoryObjectReference);
            return parentRepositoryObjectReference;
        }

        private ICollection_<ICrossLinkRepositoryRelationSample> getInitialRelations(IRepositoryTypeManagerRO typeManager) throws EXDataCreationFailed {
            ICollection_ initialRelations = (ICollection_)RAMDataCoDecForData.decodeFromRAMData((IDataType)DTCollection_CrossLinkRepositoryRelationSample.getInstance((IRepositoryTypeManagerRO)typeManager), (IRAMData)this.serializedInitialRelations);
            return initialRelations;
        }

        public void doWithReferencedObject(final IReferencedObjectProcessor processor) {
            final boolean[] done = new boolean[1];
            try {
                final IRepositoryInterfaceRO repositoryInterface = this.getRepositoryInterface();
                RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                    public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                        try {
                            IRepositoryObjectReference repositoryObjectReference = this.getRepositoryObjectReference(repositoryInterface.getTypeManager());
                            IRepositoryObject object = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)repositoryObjectReference, (IRepositorySnapshotRO)repositorySnapshot);
                            processor.doWithReferencedObject(object);
                            done[0] = true;
                        }
                        catch (EXObjectReferenceCannotBeResolved e) {
                            processor.objectNotFound(repositorySnapshot);
                            done[0] = true;
                        }
                        catch (EXDataCreationFailed e) {
                            processor.objectNotFound(repositorySnapshot);
                            done[0] = true;
                        }
                    }
                });
            }
            catch (EXRepositoryInterfaceNotFound eXRepositoryInterfaceNotFound) {
                // empty catch block
            }
            if (!done[0]) {
                processor.interfaceNotFound();
            }
        }

        public static interface IReferencedObjectProcessor {
            public void doWithReferencedObject(IRepositoryObject var1) throws EXNotReproducibleSnapshot;

            public void objectNotFound(IRepositorySnapshotRO var1) throws EXNotReproducibleSnapshot;

            public void interfaceNotFound();
        }
    }
}

