/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import java.util.ArrayList;
import java.util.Collection;

public class EditorJob {
    public static final IRepositoryObjectTypeCategoryID MARKER_FOR_DEFAULT_CATEGORY = new IRepositoryObjectTypeCategoryID(){

        public String toCanonicalString() {
            return null;
        }
    };
    private final IListRW_<RepositoryObjectSampleWithParentObjectReference> objectSamples2parentObjectReferences;
    private final ISetRW_<IRepositoryObjectReference> objectsToDelete = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    private final IMapRW_<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID> categoriesToBeChanged = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    private final IMapRW_<IRepositoryPropertyReference, IRepositoryPropertySample> propertiesToModify = new HashMap_(IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER);
    private final IMapRW_<IRepositoryRelationTypeID, HashSet_<ICrossLinkRepositoryRelationSample>> relationsToCreate = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
    private final IMapRW_<IRepositoryRelationTypeID, HashSet_<ICrossLinkRepositoryRelationReference>> relationsToDelete = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
    private final IRepositoryInterfaceRO repositoryInterface;

    public EditorJob(IRepositoryInterfaceRO repositoryInterface) {
        this.repositoryInterface = repositoryInterface;
        this.objectSamples2parentObjectReferences = new ArrayList_();
    }

    public void addObject(IRepositoryObjectReference objectReference, IRepositoryObjectReference parentObjectReference) {
        IRepositoryPropertySetSample mainObjectUidSample = objectReference.getObjectID();
        IRepositoryObjectTypeID mainObjectTypeID = objectReference.getObjectTypeID();
        IRepositoryObjectType mainObjectType = this.repositoryInterface.getTypeManager().getObjectType(mainObjectTypeID);
        HashMap_ mainObjectPropertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryPropertyTypeID mainObjectPropertyTypeID : mainObjectUidSample.getPropertyTypeIDs()) {
            mainObjectPropertySamples.put((Object)mainObjectPropertyTypeID, (Object)mainObjectUidSample.getPropertySample(mainObjectPropertyTypeID));
        }
        RepositoryObjectSample mainObjectSample = new RepositoryObjectSample(mainObjectType, null, (IMap_)mainObjectPropertySamples);
        this.objectSamples2parentObjectReferences.add((Object)new RepositoryObjectSampleWithParentObjectReference((IRepositoryObjectSample)mainObjectSample, parentObjectReference));
    }

    public IList_<RepositoryObjectSampleWithParentObjectReference> getCreatedObjects() {
        return this.objectSamples2parentObjectReferences;
    }

    public ISetRW_<IRepositoryObjectReference> getDeletedObjects() {
        return this.objectsToDelete;
    }

    public void extendObjectSamples() {
        ArrayList_ extendedObjectSamples2parentObjectReferences = new ArrayList_();
        for (RepositoryObjectSampleWithParentObjectReference sampleToObject : this.objectSamples2parentObjectReferences) {
            IRepositoryObjectTypeCategoryID newCategoryID;
            HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
            IRepositoryObjectSample objectSample = sampleToObject.getObjectSample();
            IRepositoryObjectReference parentObject = sampleToObject.getParentObjectReference();
            IRepositoryObjectTypeID repositoryObjectTypeID = objectSample.getObjectTypeID();
            IRepositoryObjectType objectType = this.repositoryInterface.getTypeManager().getObjectType(repositoryObjectTypeID);
            IRepositoryPropertySetSample propertySetSample = objectSample.getPropertySetSample();
            IRepositoryPropertySetSample objectID = objectSample.getObjectID(this.repositoryInterface.getTypeManager());
            RepositoryObjectReference objectReference = new RepositoryObjectReference(repositoryObjectTypeID, objectID);
            ICollection_ attributeSetTypes = objectType.getAttributeSetTypes();
            for (IRepositoryAttributeSetType attributeSetType : attributeSetTypes) {
                ICollection_ propertyTypes = attributeSetType.getPropertyTypes();
                for (IRepositoryPropertyType propertyType : propertyTypes) {
                    IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
                    if (propertySetSample.getPropertySample(propertyTypeID) != null) {
                        IRepositoryPropertySample propertySample = propertySetSample.getPropertySample(propertyTypeID);
                        propertySamples.put((Object)propertyTypeID, (Object)propertySample);
                        continue;
                    }
                    RepositoryPropertyReference propertyReference = new RepositoryPropertyReference((IRepositoryObjectReference)objectReference, propertyTypeID);
                    IRepositoryPropertySample modifiedPropertySample = (IRepositoryPropertySample)this.propertiesToModify.getByKey((Object)propertyReference);
                    if (modifiedPropertySample == null) {
                        IRepositoryData data = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)this.repositoryInterface.getTypeManager()).getGenericModificationPropertyType(propertyType).getDefaultValue();
                        RepositoryPropertySample propertySample = new RepositoryPropertySample(data);
                        propertySamples.put((Object)propertyTypeID, (Object)propertySample);
                        continue;
                    }
                    propertySamples.put((Object)propertyTypeID, (Object)modifiedPropertySample);
                }
            }
            IRepositoryObjectTypeCategoryID categoryID = null;
            if (this.categoriesToBeChanged.containsKey((Object)objectReference) && (newCategoryID = (IRepositoryObjectTypeCategoryID)this.categoriesToBeChanged.getByKey((Object)objectReference)) != MARKER_FOR_DEFAULT_CATEGORY) {
                categoryID = newCategoryID;
            }
            objectSample = new RepositoryObjectSample(objectType, categoryID, (IMap_)propertySamples);
            extendedObjectSamples2parentObjectReferences.add((Object)new RepositoryObjectSampleWithParentObjectReference(objectSample, parentObject));
        }
        this.objectSamples2parentObjectReferences.clear();
        this.objectSamples2parentObjectReferences.addAll((ICollection_)extendedObjectSamples2parentObjectReferences);
    }

    public IRepositoryObjectReference getParentObjectReferenceForNewObject(IRepositoryObjectReference objectToCreate) {
        IRepositoryObjectReference parentObjectReference = null;
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        for (RepositoryObjectSampleWithParentObjectReference objectSampleWithParentObjectReference : this.objectSamples2parentObjectReferences) {
            IRepositoryObjectSample objectSample = objectSampleWithParentObjectReference.getObjectSample();
            IRepositoryObjectReference objectReference = objectSample.getObjectReference(typeManager);
            if (!IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)objectReference, (Object)objectToCreate)) continue;
            parentObjectReference = objectSampleWithParentObjectReference.getParentObjectReference();
            break;
        }
        return parentObjectReference;
    }

    public IMap_<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID> getObjectTypeCategoriesToBeChanged() {
        return this.categoriesToBeChanged;
    }

    public Collection<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>> getObjectTypeCategoriesToBeChanged_forTransactionExecution() {
        ArrayList<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>> tuples = new ArrayList<Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>>(this.categoriesToBeChanged.size());
        for (IEntry_ entry : this.categoriesToBeChanged.asJavaCollection()) {
            IRepositoryObjectTypeCategoryID value = (IRepositoryObjectTypeCategoryID)entry.getValue();
            if (value == MARKER_FOR_DEFAULT_CATEGORY) {
                value = null;
            }
            tuples.add((Tuple<IRepositoryObjectReference, IRepositoryObjectTypeCategoryID>)new Tuple((Object)((IRepositoryObjectReference)entry.getKey()), (Object)value));
        }
        return tuples;
    }

    public void changeCategory(IRepositoryObjectReference objectReference, IRepositoryObjectTypeCategoryID newCategory) {
        this.categoriesToBeChanged.put((Object)objectReference, (Object)newCategory);
    }

    public void removeCategory(IRepositoryObjectReference objectReference) {
        this.categoriesToBeChanged.removeAsEntry((Object)objectReference);
    }

    public void addProperty(Object propertyReference, Object propertySample) {
        IRepositoryPropertyReference repositoryPropertyReference = (IRepositoryPropertyReference)propertyReference;
        IRepositoryPropertySample oldPropertySample = (IRepositoryPropertySample)this.propertiesToModify.getByKey((Object)repositoryPropertyReference);
        if (oldPropertySample != null) {
            this.disposePropertySample(oldPropertySample);
        }
        this.propertiesToModify.put((Object)((IRepositoryPropertyReference)propertyReference), (Object)((IRepositoryPropertySample)propertySample));
    }

    public IMap_<IRepositoryPropertyReference, IRepositoryPropertySample> getModifiedProperties() {
        return this.propertiesToModify;
    }

    public void removeProperty(Object propertyReference) {
        IRepositoryPropertyReference repositoryPropertyReference = (IRepositoryPropertyReference)propertyReference;
        IRepositoryPropertySample propertySample = (IRepositoryPropertySample)this.propertiesToModify.getByKey((Object)repositoryPropertyReference);
        if (propertySample != null) {
            this.disposePropertySample(propertySample);
        }
        this.propertiesToModify.removeAsEntry((Object)repositoryPropertyReference);
    }

    public void addNewRelation(IRepositoryRelationTypeID relationTypeID, ICrossLinkRepositoryRelationSample relationSample) {
        HashSet_ relationSamples = (HashSet_)this.relationsToCreate.getByKey((Object)relationTypeID);
        if (relationSamples == null) {
            relationSamples = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        }
        relationSamples.add((Object)relationSample);
        this.relationsToCreate.put((Object)relationTypeID, (Object)relationSamples);
    }

    public void removeNewRelation(IRepositoryRelationTypeID relationTypeID, ICrossLinkRepositoryRelationSample relationSample) {
        HashSet_ relationSamples = (HashSet_)this.relationsToCreate.getByKey((Object)relationTypeID);
        relationSamples.remove((Object)relationSample);
    }

    public ISet_<ICrossLinkRepositoryRelationSample> getNewRelations() {
        HashSet_ relations = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        for (IEntry_ entry : this.relationsToCreate) {
            relations.addAll((ICollection_)entry.getValue());
        }
        return relations;
    }

    public ICollection_<ICrossLinkRepositoryRelationSample> getNewRelations(IRepositoryRelationTypeID relationTypeID) {
        HashSet_ createdRelations = (HashSet_)this.relationsToCreate.getByKey((Object)relationTypeID);
        if (createdRelations == null) {
            createdRelations = new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER);
        }
        return createdRelations;
    }

    public void addDeletedRelation(IRepositoryRelationTypeID relationTypeID, ICrossLinkRepositoryRelationReference relationReference) {
        HashSet_ relationReferences = (HashSet_)this.relationsToDelete.getByKey((Object)relationTypeID);
        if (relationReferences == null) {
            relationReferences = new HashSet_(ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER);
        }
        relationReferences.add((Object)relationReference);
        this.relationsToDelete.put((Object)relationTypeID, (Object)relationReferences);
    }

    public void removeDeletedRelation(IRepositoryRelationTypeID relationTypeID, ICrossLinkRepositoryRelationReference relationReference) {
        HashSet_ relationReferences = (HashSet_)this.relationsToDelete.getByKey((Object)relationTypeID);
        relationReferences.remove((Object)relationReference);
    }

    public ISet_<ICrossLinkRepositoryRelationReference> getDeletedRelations() {
        HashSet_ relations = new HashSet_(ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER);
        for (IEntry_ entry : this.relationsToDelete) {
            relations.addAll((ICollection_)entry.getValue());
        }
        return relations;
    }

    public ICollection_<ICrossLinkRepositoryRelationReference> getDeletedRelations(IRepositoryRelationTypeID relationTypeID) {
        HashSet_ deletedRelations = (HashSet_)this.relationsToDelete.getByKey((Object)relationTypeID);
        if (deletedRelations == null) {
            deletedRelations = new HashSet_(ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER);
        }
        return deletedRelations;
    }

    public void clear() {
        this.objectSamples2parentObjectReferences.clear();
        this.reset();
    }

    public void clearObjectSamples() {
        ArrayList_ clearedObjectSamples2parentObjectReferences = new ArrayList_();
        for (RepositoryObjectSampleWithParentObjectReference sampleToObject : this.objectSamples2parentObjectReferences) {
            HashMap_ propertySamples = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
            IRepositoryObjectSample objectSample = sampleToObject.getObjectSample();
            IRepositoryObjectReference parentObject = sampleToObject.getParentObjectReference();
            IRepositoryPropertySetSample propertySetSample = objectSample.getPropertySetSample();
            IRepositoryObjectType objectType = this.repositoryInterface.getTypeManager().getObjectType(objectSample.getObjectTypeID());
            IRepositoryAttributeSetType attributeSetType = objectType.getIDAttributeSetType();
            for (IRepositoryPropertyType propertyType : attributeSetType.getPropertyTypes()) {
                IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
                IRepositoryPropertySample propertySample = propertySetSample.getPropertySample(propertyTypeID);
                propertySamples.put((Object)propertyTypeID, (Object)propertySample);
            }
            objectSample = new RepositoryObjectSample(objectType, null, (IMap_)propertySamples);
            clearedObjectSamples2parentObjectReferences.add((Object)new RepositoryObjectSampleWithParentObjectReference(objectSample, parentObject));
        }
        this.objectSamples2parentObjectReferences.clear();
        this.objectSamples2parentObjectReferences.addAll((ICollection_)clearedObjectSamples2parentObjectReferences);
    }

    public void reset() {
        this.objectsToDelete.clear();
        this.categoriesToBeChanged.clear();
        this.disposeAllPropertySamples();
        this.propertiesToModify.clear();
        this.relationsToCreate.clear();
        this.relationsToDelete.clear();
    }

    public void disposeAllPropertySamples() {
        for (IEntry_ entry : this.propertiesToModify) {
            IRepositoryPropertySample propertySample = (IRepositoryPropertySample)entry.getValue();
            this.disposePropertySample(propertySample);
        }
    }

    private void disposePropertySample(IRepositoryPropertySample propertySample) {
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        IRepositoryDataType dataType = propertySample.getValue().getDataType();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(typeManager);
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(dataType);
        frontendDataType.disposePropertySample(propertySample);
    }
}

