/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.references;

import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RelatedObject;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IRelationRelatedRequestRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObject;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import java.util.ArrayList;
import java.util.Collection;

public class ImportJobRelationReference {
    public static final IHasher_<ImportJobRelationReference> REFERENCES_EQUAL_RELATION_HASHER = new IHasher_<ImportJobRelationReference>(){

        public boolean isEqual(ImportJobRelationReference object1, ImportJobRelationReference object2) {
            if (object1.type == Type.IMPORTED_RELATION_UNMATCHED) {
                return object2.type == Type.IMPORTED_RELATION_UNMATCHED && ((Tuple)object1.relationsAndRelatedObjects.iterator().next()).getT1() == ((Tuple)object2.relationsAndRelatedObjects.iterator().next()).getT1();
            }
            return object2.type != Type.IMPORTED_RELATION_UNMATCHED && RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER.isEqual((Object)object1.relatedObject2, (Object)object2.relatedObject2);
        }

        public int getHashCode(ImportJobRelationReference object) {
            if (object.type == Type.IMPORTED_RELATION_UNMATCHED) {
                return ((ICrossLinkRelation)((Tuple)object.relationsAndRelatedObjects.iterator().next()).getT1()).hashCode();
            }
            return RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER.getHashCode((Object)object.relatedObject2);
        }
    };
    private final int versionStamp;
    private final RelationSetType relationSetType;
    private final Type type;
    private final RelatedObject relatedObject2;
    private final Collection<Tuple<IRelationRelatedRequestRO, ICrossLinkRelationContributionTypeForImportedObject>> relationCreationRequests;
    private final Collection<Tuple<ICrossLinkRelation, IObject>> relationsAndRelatedObjects;
    private final ICrossLinkRepositoryRelationContributionType contributionType2;
    private final ICrossLinkRelationContributionTypeForImportedObject contributionType1;

    public ImportJobRelationReference(RelatedObject existingRelatedObject, int versionStamp) {
        this.versionStamp = versionStamp;
        this.relationSetType = RelationSetType.MUST_NOT_DELETE;
        this.type = Type.EXISTING_RELATION;
        this.relatedObject2 = existingRelatedObject;
        this.relationCreationRequests = null;
        this.relationsAndRelatedObjects = null;
        this.contributionType2 = null;
        this.contributionType1 = null;
    }

    public ImportJobRelationReference(ICrossLinkRelation importedRelation, IObject relatedImportedOrContextObject, int versionStamp) {
        this.versionStamp = versionStamp;
        this.relationSetType = RelationSetType.MUST_NOT_CREATE;
        this.type = Type.IMPORTED_RELATION_UNMATCHED;
        this.relationCreationRequests = new ArrayList<Tuple<IRelationRelatedRequestRO, ICrossLinkRelationContributionTypeForImportedObject>>(0);
        this.relationsAndRelatedObjects = new ArrayList<Tuple<ICrossLinkRelation, IObject>>(1);
        this.relationsAndRelatedObjects.add((Tuple<ICrossLinkRelation, IObject>)new Tuple((Object)importedRelation, (Object)relatedImportedOrContextObject));
        this.relatedObject2 = null;
        this.contributionType2 = null;
        this.contributionType1 = null;
    }

    public ImportJobRelationReference(Collection<Tuple<ICrossLinkRelation, IObject>> relationsAndRelatedObjects, Collection<Tuple<IRelationRelatedRequestRO, ICrossLinkRelationContributionTypeForImportedObject>> relationCreationRequests, RelatedObject relatedObject, RelationSetType relationSetType, int versionStamp) {
        assert (relationSetType == RelationSetType.MAY_CREATE_RECOMMENDED || relationSetType == RelationSetType.MAY_CREATE_DEFAULT || relationSetType == RelationSetType.MAY_DELETE);
        this.versionStamp = versionStamp;
        this.relationSetType = relationSetType;
        this.type = Type.IMPORTED_RELATION;
        this.relationsAndRelatedObjects = relationsAndRelatedObjects != null ? relationsAndRelatedObjects : new ArrayList(0);
        this.relationCreationRequests = relationCreationRequests != null ? relationCreationRequests : new ArrayList(0);
        this.relatedObject2 = relatedObject;
        this.contributionType2 = null;
        this.contributionType1 = null;
    }

    public ImportJobRelationReference(ICrossLinkRelationContributionTypeForImportedObject contributionType, RelatedObject relatedObject, RelationSetType relationSetType, int versionStamp) {
        assert (relationSetType == RelationSetType.MAY_CREATE_DEFAULT || relationSetType == RelationSetType.MAY_DELETE);
        this.versionStamp = versionStamp;
        this.relationSetType = relationSetType;
        this.type = Type.RELATION_CREATION_REQUEST;
        this.contributionType1 = contributionType;
        this.relatedObject2 = relatedObject;
        this.relationsAndRelatedObjects = null;
        this.relationCreationRequests = null;
        this.contributionType2 = null;
    }

    public int getVersionStamp() {
        return this.versionStamp;
    }

    public boolean isExistingRelation() {
        return this.type == Type.EXISTING_RELATION;
    }

    public boolean isImportedRelation() {
        return this.type == Type.IMPORTED_RELATION;
    }

    public boolean isUnmatchedImportedRelation() {
        return this.type == Type.IMPORTED_RELATION_UNMATCHED;
    }

    public boolean isRelationCreationRequest() {
        return this.type == Type.RELATION_CREATION_REQUEST;
    }

    public RelationSetType getRelationSetType() {
        return this.relationSetType;
    }

    public RelatedObject getRelatedObject2() {
        return this.relatedObject2;
    }

    public IRepositoryObjectReference getObjectReference2() {
        if (this.relatedObject2 != null) {
            return this.relatedObject2.getObjectReference();
        }
        return null;
    }

    public ICrossLinkRepositoryRelationContributionType getContributionType2() {
        if (!this.isUnmatchedImportedRelation()) {
            return this.relatedObject2.getContributionType();
        }
        return this.contributionType2;
    }

    public Collection<Tuple<IRelationRelatedRequestRO, ICrossLinkRelationContributionTypeForImportedObject>> getRelationCreationRequests() {
        return this.relationCreationRequests;
    }

    public Collection<Tuple<ICrossLinkRelation, IObject>> getRelationsAndRelatedObjects() {
        return this.relationsAndRelatedObjects;
    }

    public Tuple<ICrossLinkRelation, IObject> getUnmatchedRelationAndRelatedObject() {
        return this.relationsAndRelatedObjects.iterator().next();
    }

    public ICrossLinkRelationContributionTypeForImportedObject getContributionType() {
        return this.contributionType1;
    }

    public static enum RelationSetType {
        MUST_NOT_CREATE,
        MUST_NOT_DELETE,
        MAY_CREATE_RECOMMENDED,
        MAY_CREATE_DEFAULT,
        MAY_DELETE;

    }

    private static enum Type {
        EXISTING_RELATION,
        IMPORTED_RELATION,
        IMPORTED_RELATION_UNMATCHED,
        RELATION_CREATION_REQUEST;

    }
}

