/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.IMessagesChangeListener;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationContributionsRelated;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationRelated;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationRelatedWithContributionsOfSpecialType;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectTypeCategoryRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectsRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryPropertiesRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryPropertyRelated;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.IRelatedTypeCaseHandler;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobChangeListener;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReferenceWithIDDefiningObjectTypeID;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectTypeCategoryReferenceWithIDDefiningObjectTypeID;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReferenceWithIDDefiningObjectTypeID;
import java.util.Collection;

public class MessageStorage {
    private ListenerKey listenerKey = null;
    private final IImportJob importJob;
    private final IRepositorySnapshotRO repositorySnapshot;
    private final ListenerManager<IMessagesChangeListener> messageChangeListeners = new ListenerManager();
    private boolean messagesAreValid = false;
    private boolean isExecutable = false;
    private IMessageSet lockMessages = new MessageSet();
    private final MessageSet allMessages = new MessageSet();
    private final MessageSet unrelatedMessages = new MessageSet();
    private final IMapRW_<RepositoryObjectReferenceWithIDDefiningObjectTypeID, MessageSet> objectRelatedMessages = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
    private final IMapRW_<RepositoryPropertyReferenceWithIDDefiningObjectTypeID, MessageSet> propertyRelatedMessages = new HashMap_(IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER);
    private final IMapRW_<RepositoryObjectTypeCategoryReferenceWithIDDefiningObjectTypeID, MessageSet> objectTypeCategoryRelatedMessages = new HashMap_(IRepositoryObjectTypeCategoryReference.REFERENCES_EQUAL_OBJECT_TYPE_CATGEORIES_HASHER);
    private final IMapRW_<ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution, MessageSet> relationContributionRelatedMessages = new HashMap_(ICrossLinkRepositoryRelationsReference.REFERECING_EQUAL_SET_OF_RELATIONS_HASHER);
    private final IMapRW_<ICrossLinkRepositoryRelationReference, MessageSet> relationRelatedMessages = new HashMap_(ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER);

    public MessageStorage(IImportJob importJob, IRepositorySnapshotRO repositorySnapshot) {
        this.importJob = importJob;
        this.repositorySnapshot = repositorySnapshot;
        this.listenerKey = new ListenerKey();
        importJob.addChangeListener(this.listenerKey, new IImportJobChangeListener(){

            public void dispose() {
                MessageStorage.this.dispose();
            }

            public void importJobChanged() throws EXNotReproducibleSnapshot {
                try {
                    MessageStorage.this.invalidate();
                }
                catch (EEXNotReproducibleSnapshot e) {
                    throw (EXNotReproducibleSnapshot)e.getCause();
                }
            }
        });
        this.lockMessages = importJob.getLockMessages();
    }

    public IRepositoryTypeManagerRO getTypeManager() {
        return this.repositorySnapshot.getTypeManager();
    }

    public void dispose() {
        if (this.listenerKey != null) {
            this.messageChangeListeners.dispose();
            this.importJob.removeChangeListener(this.listenerKey);
            this.listenerKey = null;
        }
    }

    public void addMessagesChangeListener(ListenerKey key, IMessagesChangeListener listener) {
        this.messageChangeListeners.addListener(key, (IDisposeListener)listener);
    }

    public void removeMessagesChangeListener(ListenerKey key) {
        this.messageChangeListeners.removeListener(key);
    }

    public boolean isExecutable() throws EEXNotReproducibleSnapshot {
        this.validate();
        return this.isExecutable;
    }

    public IMessageSet updateLocks() throws EEXNotReproducibleSnapshot {
        try {
            this.importJob.updateLocks(this.repositorySnapshot);
            this.lockMessages = this.importJob.getLockMessages();
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        this.invalidate();
        return this.lockMessages;
    }

    public IMessageSet getAllMessages() throws EEXNotReproducibleSnapshot {
        this.validate();
        return this.allMessages;
    }

    public IMessageSet getUnrelatedMessages() throws EEXNotReproducibleSnapshot {
        this.validate();
        return this.unrelatedMessages;
    }

    public IMessageSet getObjectMessages(IRepositoryObjectReference objectReference) throws EEXNotReproducibleSnapshot {
        this.validate();
        return MessageStorage.getMessages(this.objectRelatedMessages, new RepositoryObjectReferenceWithIDDefiningObjectTypeID(objectReference, this.getTypeManager()));
    }

    public IMessageSet getPropertyMessages(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot {
        this.validate();
        return MessageStorage.getMessages(this.propertyRelatedMessages, new RepositoryPropertyReferenceWithIDDefiningObjectTypeID(propertyReference, this.getTypeManager()));
    }

    public IMessageSet getObjectTypeCategoryMessages(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot {
        this.validate();
        return MessageStorage.getMessages(this.objectTypeCategoryRelatedMessages, new RepositoryObjectTypeCategoryReferenceWithIDDefiningObjectTypeID(objectTypeCategoryReference, this.getTypeManager()));
    }

    public IMessageSet getRelationContributionRelatedMessages(ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationContributionsReference) throws EEXNotReproducibleSnapshot {
        this.validate();
        return MessageStorage.getMessages(this.relationContributionRelatedMessages, relationContributionsReference);
    }

    public IMessageSet getRelationRelatedMessages(ICrossLinkRepositoryRelationReference relationReference) throws EEXNotReproducibleSnapshot {
        this.validate();
        return MessageStorage.getMessages(this.relationRelatedMessages, relationReference);
    }

    private void invalidate() throws EEXNotReproducibleSnapshot {
        this.messagesAreValid = false;
        final EEXNotReproducibleSnapshot[] eexNotReproducibleSnapshot = new EEXNotReproducibleSnapshot[1];
        this.messageChangeListeners.callListeners((IListenerCaller)new IListenerCaller<IMessagesChangeListener>(){

            public void callListener(IMessagesChangeListener listener) {
                if (eexNotReproducibleSnapshot[0] == null) {
                    try {
                        listener.messagesChanged();
                    }
                    catch (EEXNotReproducibleSnapshot e) {
                        eexNotReproducibleSnapshot[0] = e;
                    }
                }
            }
        });
        if (eexNotReproducibleSnapshot[0] != null) {
            throw eexNotReproducibleSnapshot[0];
        }
    }

    private void validate() throws EEXNotReproducibleSnapshot {
        if (!this.messagesAreValid) {
            IMessageSet executionMessages;
            IMessageSet interpretationMessages = this.importJob.getInterpretationMessages();
            try {
                Tuple executable = this.importJob.isExecutable(this.repositorySnapshot);
                executionMessages = (IMessageSet)executable.getT2();
                this.isExecutable = (Boolean)executable.getT1();
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
            this.allMessages.clear();
            this.unrelatedMessages.clear();
            this.objectRelatedMessages.clear();
            this.propertyRelatedMessages.clear();
            this.objectTypeCategoryRelatedMessages.clear();
            this.relationContributionRelatedMessages.clear();
            this.relationRelatedMessages.clear();
            for (RepositoryAccessException message : interpretationMessages.getMessages()) {
                this.recognizeMessage(message);
            }
            for (RepositoryAccessException message : executionMessages.getMessages()) {
                this.recognizeMessage(message);
            }
            for (RepositoryAccessException message : this.lockMessages.getMessages()) {
                this.recognizeMessage(message);
            }
            this.messagesAreValid = true;
        }
    }

    private void recognizeMessage(final RepositoryAccessException message) {
        this.recognizeInAllMessages(message);
        message.switchRelatedType(new IRelatedTypeCaseHandler(){

            public void caseObjectRelated(IEXRepositoryObjectRelated relatedMessage) {
                IRepositoryObjectReference objectReference = relatedMessage.getObjectReference();
                MessageStorage.this.recognizeObjectRelatedMessage(objectReference, message);
            }

            public void caseObjectsRelated(IEXRepositoryObjectsRelated relatedMessage) {
                for (IRepositoryObjectReference objectReference : relatedMessage.getObjectReferences()) {
                    MessageStorage.this.recognizeObjectRelatedMessage(objectReference, message);
                }
            }

            public void casePropertyRelated(IEXRepositoryPropertyRelated relatedMessage) {
                IRepositoryPropertyReference propertyReference = relatedMessage.getPropertyReference();
                MessageStorage.this.recognizePropertyRelatedMessage(propertyReference, message);
            }

            public void casePropertiesRelated(IEXRepositoryPropertiesRelated relatedMessage) {
                IRepositoryPropertyTypeID propertyTypeID = relatedMessage.getPropertyTypeID();
                Collection objectReferences = relatedMessage.getPropertyObjectReferences();
                for (IRepositoryObjectReference repositoryObjectReference : objectReferences) {
                    RepositoryPropertyReference propertyReference = new RepositoryPropertyReference(repositoryObjectReference, propertyTypeID);
                    MessageStorage.this.recognizePropertyRelatedMessage((IRepositoryPropertyReference)propertyReference, message);
                }
            }

            public void caseObjectTypeCategoryRelated(IEXRepositoryObjectTypeCategoryRelated relatedMessage) {
                IRepositoryObjectTypeCategoryReference objectTypeCategoryReference = relatedMessage.getObjectTypeCategoryReference();
                MessageStorage.this.recognizeObjectTypeCategoryRelatedMessage(objectTypeCategoryReference, message);
            }

            public void caseCrossLinkRelationRelated(IEXCrossLinkRelationRelated relatedMessage) {
                ICrossLinkRepositoryRelationReference relationReference = relatedMessage.getRelationReference();
                ISet_ affectedRelationsContributions = relatedMessage.getAffectedRelatationContributions();
                MessageStorage.this.recognizeRelationRelatedMessage(relationReference, message);
                IRepositoryRelationTypeID relationTypeID = relationReference.getRelationTypeID();
                for (IRepositoryRelationContributionRoleID affectedRelationContribution : affectedRelationsContributions) {
                    ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationContributionReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)affectedRelationContribution, (IRepositoryPropertySetSample)relationReference.getObjectID(affectedRelationContribution));
                    MessageStorage.this.recognizeRelationContributionsRelatedMessage(relationContributionReference, message);
                }
            }

            public void caseCrossLinkRelationRelatedWithContributionsOfSpecialType(IEXCrossLinkRelationRelatedWithContributionsOfSpecialType relatedMessage) {
                IRepositoryRelationTypeID relationTypeID = relatedMessage.getRelationTypeID();
                for (IRepositoryRelationContributionRoleID roleID : relatedMessage.getAffectedRelatationContributions()) {
                    Class objectIDType = relatedMessage.getObjectIDType(roleID);
                    if (objectIDType != IRepositoryPropertySetSample.class) continue;
                    IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)relatedMessage.getObjectID(roleID);
                    ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationContributionReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
                    MessageStorage.this.recognizeRelationContributionsRelatedMessage(relationContributionReference, message);
                }
            }

            public void caseCrossLinkRelationContributionsRelated(IEXCrossLinkRelationContributionsRelated relatedMessage) {
                ISet_ relationContributionReferences = relatedMessage.getRelationContributionsReferences();
                for (ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationContributionReference : relationContributionReferences) {
                    MessageStorage.this.recognizeRelationContributionsRelatedMessage(relationContributionReference, message);
                }
            }

            public void caseUnspecified() {
                MessageStorage.this.recognizeUnrelatedRelatedMessage(message);
            }
        });
    }

    private void recognizeUnrelatedRelatedMessage(RepositoryAccessException message) {
        this.unrelatedMessages.add(message);
    }

    private void recognizeObjectRelatedMessage(IRepositoryObjectReference reference, RepositoryAccessException message) {
        this.recognizeObjectRelatedMessage(new RepositoryObjectReferenceWithIDDefiningObjectTypeID(reference, this.getTypeManager()), message);
    }

    private void recognizeObjectRelatedMessage(RepositoryObjectReferenceWithIDDefiningObjectTypeID reference, RepositoryAccessException message) {
        MessageSet messages = MessageStorage.getMessages(this.objectRelatedMessages, reference);
        messages.add(message);
    }

    private void recognizePropertyRelatedMessage(IRepositoryPropertyReference reference, RepositoryAccessException message) {
        this.recognizePropertyRelatedMessage(new RepositoryPropertyReferenceWithIDDefiningObjectTypeID(reference, this.getTypeManager()), message);
    }

    private void recognizePropertyRelatedMessage(RepositoryPropertyReferenceWithIDDefiningObjectTypeID reference, RepositoryAccessException message) {
        MessageSet messages = MessageStorage.getMessages(this.propertyRelatedMessages, reference);
        messages.add(message);
        this.recognizeObjectRelatedMessage(reference.getObjectReference(), message);
    }

    private void recognizeObjectTypeCategoryRelatedMessage(IRepositoryObjectTypeCategoryReference reference, RepositoryAccessException message) {
        this.recognizeObjectTypeCategoryRelatedMessage(new RepositoryObjectTypeCategoryReferenceWithIDDefiningObjectTypeID(reference, this.getTypeManager()), message);
    }

    private void recognizeObjectTypeCategoryRelatedMessage(RepositoryObjectTypeCategoryReferenceWithIDDefiningObjectTypeID reference, RepositoryAccessException message) {
        MessageSet messages = MessageStorage.getMessages(this.objectTypeCategoryRelatedMessages, reference);
        messages.add(message);
        this.recognizeObjectRelatedMessage(reference.getObjectReference(), message);
    }

    private void recognizeRelationRelatedMessage(ICrossLinkRepositoryRelationReference reference, RepositoryAccessException message) {
        MessageSet messages = MessageStorage.getMessages(this.relationRelatedMessages, reference);
        messages.add(message);
    }

    private void recognizeRelationContributionsRelatedMessage(ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution reference, RepositoryAccessException message) {
        MessageSet messages = MessageStorage.getMessages(this.relationContributionRelatedMessages, reference);
        messages.add(message);
        IRepositoryTypeManagerRO typeManager = this.repositorySnapshot.getTypeManager();
        IRepositoryRelationTypeID relationTypeID = reference.getRelationTypeID();
        ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType(relationTypeID);
        IRepositoryRelationContributionRoleID roleID = reference.getRoleID();
        ICrossLinkRepositoryRelationContributionType relationContributionType = relationType.getRelationContributionType(roleID);
        IRepositoryObjectType objectType = relationContributionType.getRelatedObjectType();
        IRepositoryPropertySetSample objectID = reference.getObjectID();
        RepositoryObjectReferenceWithIDDefiningObjectTypeID objectReference = new RepositoryObjectReferenceWithIDDefiningObjectTypeID(objectType, objectID);
        this.recognizeObjectRelatedMessage(objectReference, message);
    }

    private void recognizeInAllMessages(RepositoryAccessException message) {
        this.allMessages.add(message);
    }

    private static <KEY> MessageSet getMessages(IMapRW_<KEY, MessageSet> relatedMessages, KEY key) {
        MessageSet messages = (MessageSet)relatedMessages.getByKey(key);
        if (messages == null) {
            messages = new MessageSet();
            relatedMessages.put(key, (Object)messages);
        }
        return messages;
    }
}

