/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.FrontendRepositoryProperties;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RepositoryAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.general.references.ContentReferenceAccessType;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageStorage;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ImportJobReferenceInterpreter;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.MessageStorage;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobObjectTypeCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobPropertyReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobRelationReference;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.importexport.imporT.importjob.ImportJobHelper;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithObjectTypes;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithRelationCreationRequests;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.ICrossLinkRelationTypeRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobChangeListener;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IPropertyRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IRelationRelatedRequestRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelationType;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportJob;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IProperty;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.RelationRelatedRequest;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.EXInvalidObjectTypeCategoryID;
import com.arcway.repository.lib.high.implementation.filearchive.FileResourceForFileInFileArchive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ImportJobAccessAgent {
    private final IImportJob importJob;
    private final IRepositorySnapshotRO repositorySnapshot;
    private final MessageStorage repositoryMessageStorage;
    private final EditorMessageStorage editorMessageStorage;

    public ImportJobAccessAgent(IRepositorySnapshotRO repositorySnapshotRO, IImportJob importJob, ImportJobReferenceInterpreter contentReferenceInterpreter) {
        this.importJob = importJob;
        this.repositorySnapshot = repositorySnapshotRO;
        this.repositoryMessageStorage = new MessageStorage(importJob, repositorySnapshotRO);
        this.editorMessageStorage = new EditorMessageStorage(this.repositoryMessageStorage, contentReferenceInterpreter);
    }

    public void dispose() {
        this.editorMessageStorage.dispose();
    }

    private IRepositoryTypeManagerRO getTypeManager() {
        return this.repositorySnapshot.getTypeManager();
    }

    public void addChangeListener(ListenerKey key, IImportJobChangeListener listener) {
        this.importJob.addChangeListener(key, listener);
    }

    public void removeChangeListener(ListenerKey key) {
        this.importJob.removeChangeListener(key);
    }

    public int getImportMode(Object element) {
        IImportedObject importedObject = (IImportedObject)element;
        return importedObject.getImportMode();
    }

    public void setImportMode(Object object, int mode) throws EEXNotReproducibleSnapshot {
        IImportedObject importedObject = (IImportedObject)object;
        ArrayList<IImportedObjectRO> changedObjects = new ArrayList<IImportedObjectRO>();
        this.setImportMode(changedObjects, importedObject, mode);
    }

    public boolean getImportFlag(Object object) {
        IImportedObject importedObject = (IImportedObject)object;
        return importedObject.getImportFlag();
    }

    public void setImportFlag(Object object, boolean imported) throws EEXNotReproducibleSnapshot {
        IImportedObject importedObject = (IImportedObject)object;
        try {
            importedObject.setImportFlag(imported);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
    }

    public IStreamResource getFileFromImportJob(IRepositoryFileID importedFileID) {
        return new FileResourceForFileInFileArchive(importedFileID, this.repositorySnapshot.getRepositoryInterface().getTypeManager());
    }

    public void setPropertyValue(Object propertyReference, Object newValue) throws EEXNotReproducibleSnapshot, JvmExternalResourceInteractionException, EEXRepositoryAccessException {
        ImportJobPropertyReference reference = (ImportJobPropertyReference)propertyReference;
        IProperty property = reference.getProperty();
        IRepositoryPropertyType repositoryPropertyType = property.getRepositoryPropertyType();
        FrontendRepositoryProperties.FrontendRepositoryPropertyContext propertyContext = FrontendRepositoryProperties.getPropertyContext(repositoryPropertyType, this.getTypeManager().getRepositoryInterface());
        IRepositoryPropertySample propertySample = propertyContext.getFrontendDataType().getPropertySampleForEditorValue(newValue, repositoryPropertyType, propertyContext.getFrontendDataTypeParameters());
        propertyContext.getRepositoryDataType().snapData(propertySample.getValue(), propertyContext.getRepositoryDataTypeParameters());
        try {
            property.setToBeValue(propertySample.getValue());
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        this.validate(property);
    }

    public boolean propertyModified(Object reference) {
        ImportJobPropertyReference propertyReference = (ImportJobPropertyReference)reference;
        return propertyReference.getReferenceType() != ContentReferenceAccessType.TO_COMPARE;
    }

    public Object getModifiedPropertyValue(Object propertyReference) {
        Object returnVal = null;
        ImportJobPropertyReference reference = (ImportJobPropertyReference)propertyReference;
        IProperty property = reference.getProperty();
        IRepositoryPropertyType repositoryPropertyType = property.getRepositoryPropertyType();
        FrontendRepositoryProperties.FrontendRepositoryPropertyContext propertyContext = FrontendRepositoryProperties.getPropertyContext(repositoryPropertyType, this.getTypeManager().getRepositoryInterface());
        IRepositoryData toBeValue = property.getToBeValue();
        if (toBeValue == null) {
            toBeValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode((IPropertyRO)property, (IRepositorySnapshotRO)this.repositorySnapshot);
        }
        returnVal = propertyContext.getFrontendDataType().getCurrentValueAsEditorValue(toBeValue, propertyContext.getFrontendDataTypeParameters());
        return returnVal;
    }

    public void resetPropertyValue(Object reference, Object newValue) throws EEXNotReproducibleSnapshot, EEXRepositoryAccessException, JvmExternalResourceInteractionException {
        this.setPropertyValue(reference, newValue);
    }

    public boolean isObjectTypeCategoryModified(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) {
        return objectTypeCategoryReference.getReferenceType() != ContentReferenceAccessType.TO_COMPARE;
    }

    public void setObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference, final ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> newValue) throws EEXNotReproducibleSnapshot, EEXDataValidation {
        IRepositoryObjectTypeCategory objectTypeCategory;
        IImportedObject object = objectTypeCategoryReference.getObject();
        IRepositoryObjectTypeCategoryID categoryID = null;
        if (!RepositoryAccessAgent.isDefaultObjectTypeCategory(newValue) && (objectTypeCategory = this.repositorySnapshot.getObjectTypeCategory(categoryID = new IRepositoryObjectTypeCategoryID(){

            public String toCanonicalString() {
                return newValue.getKey();
            }
        })) == null) {
            throw new EEXDataValidation((Exception)new EXInvalidObjectTypeCategoryID(categoryID));
        }
        try {
            object.setToBeRepositoryObjectTypeCategory(categoryID);
        }
        catch (EXNotReproducibleSnapshot eNRS) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)eNRS));
        }
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> getModifiedObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) {
        IImportedObject object = objectTypeCategoryReference.getObject();
        IRepositoryObjectTypeCategoryID categoryID = object.isToBeRepositoryObjectTypeCategoryChanged() ? object.getToBeRepositoryObjectTypeCategory() : ImportJobHelper.determineEffectiveObjectTypeCategoryValueIfToBeValueIsNotSet((IImportedObjectRO)object, (IRepositorySnapshotRO)this.repositorySnapshot);
        return categoryID != null ? new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor((Object)objectTypeCategoryReference, categoryID.toCanonicalString()) : RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(objectTypeCategoryReference);
    }

    public void resetObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> newValue) throws EEXDataValidation, EEXNotReproducibleSnapshot {
        this.setObjectTypeCategoryValue(objectTypeCategoryReference, newValue);
    }

    public void addNewRelation(ImportJobRelationReference relationRef) throws EEXNotReproducibleSnapshot {
        try {
            if (relationRef.isImportedRelation()) {
                assert (relationRef.getRelationSetType() == ImportJobRelationReference.RelationSetType.MAY_CREATE_DEFAULT || relationRef.getRelationSetType() == ImportJobRelationReference.RelationSetType.MAY_CREATE_RECOMMENDED || relationRef.getRelationSetType() == ImportJobRelationReference.RelationSetType.MAY_DELETE);
                for (Tuple<ICrossLinkRelation, IObject> importedRelation : relationRef.getRelationsAndRelatedObjects()) {
                    ((ICrossLinkRelation)importedRelation.getT1()).setImportFlag(true);
                }
            } else if (relationRef.isRelationCreationRequest()) {
                HashMap_ map_role_object = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
                map_role_object.put((Object)relationRef.getContributionType2().getRepositoryRelationContributionRoleID(), (Object)relationRef.getObjectReference2());
                RelationRelatedRequest relationCreationRequest = new RelationRelatedRequest((IMap_)map_role_object);
                relationRef.getContributionType().addRelationCreationRequest((IRelationRelatedRequestRO)relationCreationRequest);
            } else assert (false);
        }
        catch (EXNotReproducibleSnapshot eNRS) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)eNRS));
        }
    }

    public void addDeletedRelation(ImportJobRelationReference relationRef) throws EEXNotReproducibleSnapshot {
        try {
            if (relationRef.isImportedRelation()) {
                assert (relationRef.getRelationSetType() == ImportJobRelationReference.RelationSetType.MAY_CREATE_DEFAULT || relationRef.getRelationSetType() == ImportJobRelationReference.RelationSetType.MAY_CREATE_RECOMMENDED || relationRef.getRelationSetType() == ImportJobRelationReference.RelationSetType.MAY_DELETE);
                for (Tuple<ICrossLinkRelation, IObject> tuple : relationRef.getRelationsAndRelatedObjects()) {
                    ((ICrossLinkRelation)tuple.getT1()).setImportFlag(false);
                }
                for (Tuple<ICrossLinkRelation, IObject> tuple : relationRef.getRelationCreationRequests()) {
                    ((ICrossLinkRelationContributionTypeForImportedObject)tuple.getT2()).removeRelationCreationRequest((IRelationRelatedRequestRO)tuple.getT1());
                }
            } else assert (false);
        }
        catch (EXNotReproducibleSnapshot eXNotReproducibleSnapshot) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)eXNotReproducibleSnapshot));
        }
    }

    public void refreshPropertyValue(Object property) throws EEXNotReproducibleSnapshot, EEXRepositoryAccessException {
        ImportJobPropertyReference propertyReference = (ImportJobPropertyReference)property;
        if (propertyReference.getReferenceType() != ContentReferenceAccessType.TO_COMPARE) {
            this.validate(propertyReference.getProperty());
        }
    }

    public String getLabelForImportedObject(Object element, PresentationContext presentationContext) {
        IImportedObject importedObject = (IImportedObject)element;
        IRepositoryObjectSample objectSample = ImportJobHelper.getObjectSample((IImportedObject)importedObject, (IRepositorySnapshotRO)this.repositorySnapshot);
        IRepositoryTypeManagerRO repositoryTypeManager = this.getTypeManager();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(objectSample, presentationContext != null ? presentationContext : PresentationContext.getVirtualMachineUserLocaleForNow());
        return label != null ? label.getText() : "[Label not available]";
    }

    private List<IImportedObjectRO> setImportMode(List<IImportedObjectRO> list, IImportedObject importedObject, int mode) throws EEXNotReproducibleSnapshot {
        try {
            switch (mode) {
                case 2: {
                    importedObject.setImportMode(2);
                    for (IImportedObject child : importedObject.getChildren()) {
                        if (!this.isMergeEnabled(child)) continue;
                        this.setImportMode(list, child, 2);
                    }
                    break;
                }
                case 1: {
                    importedObject.setImportMode(1);
                    for (IImportedObject child : importedObject.getChildren()) {
                        this.setImportMode(list, child, 1);
                    }
                    break;
                }
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        list.add((IImportedObjectRO)importedObject);
        return list;
    }

    public boolean isMergeEnabled(IImportedObject importedObject) {
        return importedObject.getMatchingObject() != null;
    }

    private void validate(IProperty property) throws EEXNotReproducibleSnapshot, EEXRepositoryAccessException {
    }

    public Tuple<ISet_<RelationSampleWithRelationCreationRequests>, ISet_<RelationSampleWithObjectTypes>> getRelationSamplesForCreationAndDeletionRequests(IRepositoryRelationTypeID relationTypeID) throws EEXNotReproducibleSnapshot {
        ICrossLinkRelationType relationTypeInImportJob = this.importJob.getCrossLinkRelationType(relationTypeID);
        if (relationTypeInImportJob != null) {
            try {
                ThreeTuple result = ImportJobHelper.getRelationSamplesForCreationAndDeletionRequests((ICrossLinkRelationTypeRO)relationTypeInImportJob, (IImportJobRO)this.importJob, (IRepositorySnapshotRO)this.repositorySnapshot);
                return new Tuple((Object)((ISet_)result.getComponent1()), (Object)((ISet_)result.getComponent2()));
            }
            catch (EXNotReproducibleSnapshot eNRS) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)eNRS));
            }
        }
        return new Tuple((Object)new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER), (Object)new HashSet_(ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER));
    }

    public Collection<? extends ICrossLinkRelation> getImportedRelationsOfType(IRepositoryRelationTypeID relationTypeID) {
        ICrossLinkRelationType relationTypeInImportJob = this.importJob.getCrossLinkRelationType(relationTypeID);
        if (relationTypeInImportJob != null) {
            return relationTypeInImportJob.getRelations();
        }
        return new HashSet(0);
    }

    public RelationSampleWithObjectTypes getRelationSampleForImportedRelation(ICrossLinkRelation importedRelation) throws RepositoryAccessException {
        Tuple sampleAndMessageSet = ImportJobHelper.getRelationSampleForImportedRelation((ICrossLinkRelationRO)importedRelation);
        if (!((IMessageSet)sampleAndMessageSet.getT2()).isEmpty()) {
            throw (RepositoryAccessException)((Object)((IMessageSet)sampleAndMessageSet.getT2()).getMessages().get(0));
        }
        return (RelationSampleWithObjectTypes)sampleAndMessageSet.getT1();
    }

    public EditorMessageStorage getEditorMessageStorage() {
        return this.editorMessageStorage;
    }

    public MessageStorage getRepositoryMessageStorage() {
        return this.repositoryMessageStorage;
    }
}

