/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.exception.IFrontendException;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendRelationContributionType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendRelationType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.general.references.ContentReferenceAccessType;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessage;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageLevel;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageSet;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.IMessagesChangeListener;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ImportJobReferenceInterpreter;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.MessageStorage;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobObjectTypeCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobPropertyReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobRelationReference;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.ui.dialog.imports.IEditorMessageStorage;
import com.arcway.lib.ui.dialog.imports.IEditorMessagesChangeListener;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.modelaccess.ModelAccessError;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationContributionsRelated;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationRelated;
import com.arcway.repository.interFace.exceptions.IEXCrossLinkRelationRelatedWithContributionsOfSpecialType;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectTypeCategoryRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryObjectsRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryPropertiesRelated;
import com.arcway.repository.interFace.exceptions.IEXRepositoryPropertyRelated;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.IRelatedTypeCaseHandler;
import com.arcway.repository.interFace.exceptions.MessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.exceptions.RepositoryException;
import com.arcway.repository.interFace.importexport.imporT.importjob.ImportJobHelper;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IPropertyRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObject;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EditorMessageStorage
implements IEditorMessageStorage<ImportJobPropertyReference, ImportJobObjectTypeCategoryReference>,
IMessagesChangeListener {
    private static final long DELAY_TO_REFRESH_IN_MILLISECS = 200L;
    private final ListenerKey messagesChangeListenerKey = new ListenerKey();
    private final MessageStorage messageStorage;
    private final IMapRW_<RepositoryAccessException, EditorMessage> messageCache;
    private final IMapRW_<Object, IMessageSet> objectMessageSets;
    private EditorMessageSet allMessages = null;
    private EditorMessageSet unrelatedMessages = null;
    private final IMapRW_<Object, EditorMessageSet> objectMessages;
    private final IMapRW_<ImportJobPropertyReference, EditorMessageSet> propertyMessages;
    private final IMapRW_<ImportJobObjectTypeCategoryReference, EditorMessageSet> objectTypeCategoryMessages;
    private final IMapRW_<ISet_<Object>, EditorMessageSet> objectsMessages;
    private final IMapRW_<IRepositoryRelationTypeID, IMapRW_<IRepositoryRelationContributionRoleID, IMapRW_<IObjectRO, EditorMessageSet>>> relationContributionsMessages;
    private final IMapRW_<IRepositoryRelationTypeID, IMapRW_<IRepositoryRelationContributionRoleID, IMapRW_<IObjectRO, IMapRW_<ImportJobRelationReference, EditorMessageSet>>>> relationMessages;
    private final Map<IImportedObject, Collection<Tuple<List<String>, IEditorMessage>>> messagesForImportedObjectCache;
    private final IRepositoryTypeManagerRO repositoryTypeManager;
    private final IFrontendTypeManager frontendTypeManager;
    private final ListenerManager<IEditorMessagesChangeListener> editorMessagesChangedListeners = new ListenerManager();
    private final IHasher_<Object> objectReferenceHasher;
    private boolean isDisposed = false;
    private final Runnable messagesChangedPropagator = new Runnable(){

        @Override
        public void run() {
            if (!EditorMessageStorage.this.isDisposed) {
                EditorMessageStorage.this.editorMessagesChangedListeners.callListeners((IListenerCaller)new IListenerCaller<IEditorMessagesChangeListener>(){

                    public void callListener(IEditorMessagesChangeListener listener) {
                        listener.messagesChanged();
                    }
                });
            }
        }
    };
    private final IMessageSet EMPTY_MESSAGE_SET = new MessageSet();
    private final EditorMessageSet EMPTY_EDITOR_MESSAGE_SET = new EditorMessageSet(this.EMPTY_MESSAGE_SET, this);

    public EditorMessageStorage(MessageStorage messageStorage, ImportJobReferenceInterpreter contentReferenceInterpreter) {
        this.messageStorage = messageStorage;
        this.repositoryTypeManager = messageStorage.getTypeManager();
        this.frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(this.repositoryTypeManager);
        this.objectReferenceHasher = contentReferenceInterpreter.getObjectReferenceHasher();
        IHasher_<ISet_<Object>> objectReferencesHasher = new IHasher_<ISet_<Object>>(){

            public int getHashCode(ISet_<Object> objects) {
                int hashCode = 0;
                for (Object o : objects) {
                    hashCode ^= EditorMessageStorage.this.objectReferenceHasher.getHashCode(o);
                }
                return hashCode;
            }

            public boolean isEqual(ISet_<Object> objects1, ISet_<Object> objects2) {
                if (objects1.size() != objects2.size()) {
                    return false;
                }
                return objects1.containsAll(objects2);
            }
        };
        this.objectMessageSets = new HashMap_(this.objectReferenceHasher);
        this.objectMessages = new HashMap_(this.objectReferenceHasher);
        this.propertyMessages = new HashMap_(ImportJobPropertyReference.REFERENCING_EQUAL_PROPERTIES_HASHER);
        this.objectTypeCategoryMessages = new HashMap_(ImportJobObjectTypeCategoryReference.REFERENCING_EQUAL_OBJECTTYPECATEGORIES_HASHER);
        this.objectsMessages = new HashMap_((IHasher_)objectReferencesHasher);
        this.relationContributionsMessages = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
        this.relationMessages = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
        this.messageCache = new HashMap_(RepositoryAccessException.HASHER);
        this.messagesForImportedObjectCache = new HashMap<IImportedObject, Collection<Tuple<List<String>, IEditorMessage>>>();
        this.reset();
        messageStorage.addMessagesChangeListener(this.messagesChangeListenerKey, this);
    }

    private void reset() {
        this.messageCache.clear();
        this.objectMessageSets.clear();
        this.objectMessages.clear();
        this.propertyMessages.clear();
        this.objectTypeCategoryMessages.clear();
        this.objectsMessages.clear();
        this.relationContributionsMessages.clear();
        this.relationMessages.clear();
        this.messagesForImportedObjectCache.clear();
        this.unrelatedMessages = null;
        this.allMessages = null;
    }

    public void dispose() {
        this.messageStorage.removeMessagesChangeListener(this.messagesChangeListenerKey);
        this.editorMessagesChangedListeners.dispose();
        this.isDisposed = true;
    }

    EditorMessage getEditorMessageForRepositoryAccessException(RepositoryAccessException repositoryAccessException) {
        EditorMessage editorMessage = (EditorMessage)this.messageCache.getByKey((Object)repositoryAccessException);
        if (editorMessage == null) {
            editorMessage = new EditorMessage(repositoryAccessException, this.frontendTypeManager);
            this.messageCache.put((Object)repositoryAccessException, (Object)editorMessage);
        }
        return editorMessage;
    }

    public void addMessagesChangeListener(ListenerKey key, IEditorMessagesChangeListener listener) {
        this.editorMessagesChangedListeners.addListener(key, (IDisposeListener)listener);
    }

    public void removeMessagesChangeListener(ListenerKey key) {
        this.editorMessagesChangedListeners.removeListener(key);
    }

    public IMessageSet updateLocks() throws EEXNotReproducibleSnapshot {
        return this.messageStorage.updateLocks();
    }

    @Override
    public void messagesChanged() throws EEXNotReproducibleSnapshot {
        this.reset();
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        renderer.processInEventLoop(200L, this.messagesChangedPropagator);
    }

    public EditorMessageSet getMessageSetForAllMessages() throws EEXNotReproducibleSnapshot {
        if (this.allMessages == null) {
            this.allMessages = new EditorMessageSet(this.messageStorage.getAllMessages(), this);
        }
        return this.allMessages;
    }

    public EditorMessageSet getMessageSetForUnrelatedMessages() throws EEXNotReproducibleSnapshot {
        if (this.unrelatedMessages == null) {
            this.unrelatedMessages = new EditorMessageSet(this.messageStorage.getUnrelatedMessages(), this);
        }
        return this.unrelatedMessages;
    }

    public Collection<Tuple<List<String>, IEditorMessage>> getLabledMessagesForObject(Object object) throws EEXNotReproducibleSnapshot {
        IImportedObject importedObject = (IImportedObject)object;
        Collection<Tuple<List<String>, IEditorMessage>> errors = this.messagesForImportedObjectCache.get(importedObject);
        if (errors == null) {
            Collection<Tuple<List<String>, EEXRepositoryAccessException>> exceptions = this.getMessagesForImportedObject(importedObject);
            errors = new ArrayList<Tuple<List<String>, IEditorMessage>>();
            for (Tuple<List<String>, EEXRepositoryAccessException> labelsAndE : exceptions) {
                List labels = (List)labelsAndE.getT1();
                EEXRepositoryAccessException e = (EEXRepositoryAccessException)labelsAndE.getT2();
                final RepositoryAccessException rae = (RepositoryAccessException)e.getCause();
                IMessageLevel messageLevel = this.getErrorLevelForException(rae);
                ModelAccessError error = new ModelAccessError(messageLevel, new ITextProvider(){

                    public String getText(PresentationContext presentationContext) {
                        return EditorMessageStorage.this.getMessageForException((RepositoryException)rae, presentationContext);
                    }
                }, e.getIcon16x16());
                Tuple labelsAndMessage = new Tuple((Object)labels, (Object)error);
                errors.add((Tuple<List<String>, IEditorMessage>)labelsAndMessage);
            }
            this.messagesForImportedObjectCache.put(importedObject, errors);
        }
        return errors;
    }

    IMessageLevel getErrorLevelForException(RepositoryAccessException repositoryAccessException) {
        return EditorMessageLevel.getEditorMessageLevel(repositoryAccessException.getExceptionLevel());
    }

    String getMessageForException(RepositoryException repositoryAccessException, PresentationContext presentationContext) {
        IFrontendException frontendException = this.frontendTypeManager.getFrontendException((Exception)repositoryAccessException);
        return frontendException.getExceptionMessage(presentationContext);
    }

    private Collection<Tuple<List<String>, EEXRepositoryAccessException>> getMessagesForImportedObject(final IImportedObject importedObject) throws EEXNotReproducibleSnapshot {
        ArrayList<Object> eexs;
        IRepositoryPropertySetSample objectIDOfCurrentObjectRW;
        IRepositoryObjectTypeID repositoryObjectTypeIDOfCurrentObject = importedObject.getObjectType().getObjectType().getRepositoryObjectTypeID();
        try {
            objectIDOfCurrentObjectRW = ImportJobHelper.getObjectReference((IObjectRO)importedObject).getObjectID();
        }
        catch (ImportJobHelper.RelatedObjectNotMatched e1) {
            objectIDOfCurrentObjectRW = null;
        }
        final IRepositoryPropertySetSample objectIDOfCurrentObject = objectIDOfCurrentObjectRW;
        try {
            IRepositoryObjectReference objectReference = ImportJobHelper.getObjectReference((IObjectRO)importedObject);
            IMessageSet exs = this.messageStorage.getObjectMessages(objectReference);
            eexs = new ArrayList(exs.getSizeHint());
            final IRepositoryObjectType repositoryObjectTypeOfCurrentObject = this.repositoryTypeManager.getObjectType(repositoryObjectTypeIDOfCurrentObject);
            for (RepositoryAccessException ex : exs.getMessages()) {
                final ArrayList labels = new ArrayList();
                ex.switchRelatedType(new IRelatedTypeCaseHandler(){

                    public void caseUnspecified() {
                    }

                    public void casePropertyRelated(IEXRepositoryPropertyRelated relatedMessage) {
                        IRepositoryPropertyReference propertyReference = relatedMessage.getPropertyReference();
                        IRepositoryObjectTypeID objectTypeID = propertyReference.getObjectReference().getObjectTypeID();
                        IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
                        this.addPropertyLabel(objectTypeID, propertyTypeID);
                    }

                    public void casePropertiesRelated(IEXRepositoryPropertiesRelated relatedMessage) {
                        IRepositoryObjectTypeID objectTypeID = relatedMessage.getObjectTypeIDOfPropertyType();
                        IRepositoryPropertyTypeID propertyTypeID = relatedMessage.getPropertyTypeID();
                        this.addPropertyLabel(objectTypeID, propertyTypeID);
                    }

                    private void addPropertyLabel(IRepositoryObjectTypeID objectTypeID, IRepositoryPropertyTypeID propertyTypeID) {
                        IFrontendPropertyType frontendPropertyType;
                        String label;
                        IRepositoryPropertyType repositoryPropertyType;
                        IRepositoryObjectType repositoryObjectType = EditorMessageStorage.this.repositoryTypeManager.findObjectType(objectTypeID);
                        if (repositoryObjectType != null && (repositoryPropertyType = repositoryObjectType.getAttributeSetType(propertyTypeID).findPropertyType(propertyTypeID)) != null && (label = (frontendPropertyType = EditorMessageStorage.this.frontendTypeManager.getFrontendPropertyType(repositoryPropertyType)).getLabel().getText()) != null && label.length() > 0) {
                            labels.add(label);
                        }
                    }

                    public void caseObjectTypeCategoryRelated(IEXRepositoryObjectTypeCategoryRelated relatedMessage) {
                        labels.add(ObjectTypeCategoryLabels.LABEL_CATEGORY);
                    }

                    public void caseObjectsRelated(IEXRepositoryObjectsRelated relatedMessage) {
                    }

                    public void caseObjectRelated(IEXRepositoryObjectRelated relatedMessage) {
                    }

                    public void caseCrossLinkRelationRelated(IEXCrossLinkRelationRelated relatedMessage) {
                        IFrontendRelationType frontendRelationType;
                        String label;
                        IRepositoryRelationTypeID relationTypeID = relatedMessage.getRelationReference().getRelationTypeID();
                        ICrossLinkRepositoryRelationType repositoryRelationType = EditorMessageStorage.this.repositoryTypeManager.findCrossLinkRelationType(relationTypeID);
                        if (repositoryRelationType != null && (label = (frontendRelationType = EditorMessageStorage.this.frontendTypeManager.getFrontendRelationType(repositoryRelationType)).getLabel().getText()) != null && label.length() > 0) {
                            labels.add(label);
                        }
                    }

                    public void caseCrossLinkRelationRelatedWithContributionsOfSpecialType(IEXCrossLinkRelationRelatedWithContributionsOfSpecialType relatedMessage) {
                        IRepositoryRelationTypeID relationTypeID = relatedMessage.getRelationTypeID();
                        ICrossLinkRepositoryRelationType repositoryRelationType = EditorMessageStorage.this.repositoryTypeManager.findCrossLinkRelationType(relationTypeID);
                        if (repositoryRelationType != null) {
                            for (IRepositoryRelationContributionRoleID roleID : relatedMessage.getAffectedRelatationContributions()) {
                                IObjectRO object;
                                ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType = repositoryRelationType.findRelationContributionType(roleID);
                                if (repositoryRelationContributionType == null) continue;
                                Class objectIDType = relatedMessage.getObjectIDType(roleID);
                                if (objectIDType == IRepositoryPropertySetSample.class) {
                                    IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)relatedMessage.getObjectID(roleID);
                                    this.addLabelForRelationContribution(repositoryRelationContributionType, objectID);
                                    continue;
                                }
                                if (objectIDType != IObjectRO.class || (object = (IObjectRO)relatedMessage.getObjectID(roleID)) != importedObject) continue;
                                this.addLabelForRelationContributionType(repositoryRelationContributionType);
                            }
                        }
                    }

                    public void caseCrossLinkRelationContributionsRelated(IEXCrossLinkRelationContributionsRelated relatedMessage) {
                        ISet_ relationsReferences = relatedMessage.getRelationContributionsReferences();
                        for (ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference : relationsReferences) {
                            IRepositoryRelationTypeID relationTypeID = relationsReference.getRelationTypeID();
                            ICrossLinkRepositoryRelationType repositoryRelationType = EditorMessageStorage.this.repositoryTypeManager.findCrossLinkRelationType(relationTypeID);
                            if (repositoryRelationType == null) continue;
                            IRepositoryPropertySetSample objectID = relationsReference.getObjectID();
                            IRepositoryRelationContributionRoleID roleID = relationsReference.getRoleID();
                            ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType = repositoryRelationType.findRelationContributionType(roleID);
                            if (repositoryRelationContributionType == null) continue;
                            this.addLabelForRelationContribution(repositoryRelationContributionType, objectID);
                        }
                    }

                    private void addLabelForRelationContribution(ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType, IRepositoryPropertySetSample objectID) {
                        IRepositoryObjectType abstractObjectType;
                        if (objectIDOfCurrentObject != null && (abstractObjectType = repositoryRelationContributionType.getRelatedObjectType()).isSuperTypeOf(repositoryObjectTypeOfCurrentObject) && IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)objectID, (Object)objectIDOfCurrentObject)) {
                            this.addLabelForRelationContributionType(repositoryRelationContributionType);
                        }
                    }

                    private void addLabelForRelationContributionType(ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType) {
                        IFrontendRelationType frontendRelationType = EditorMessageStorage.this.frontendTypeManager.getFrontendRelationType(repositoryRelationContributionType.getRelatedRelationType());
                        String label = frontendRelationType.getLabel().getText();
                        IFrontendRelationContributionType frontendRelationContributionType = EditorMessageStorage.this.frontendTypeManager.getFrontendRelationContributionType(repositoryRelationContributionType);
                        String labelRC = frontendRelationContributionType.getLabel().getText();
                        if (labelRC != null && labelRC.length() > 0) {
                            label = label != null && label.length() > 0 ? String.valueOf(label) + " (" + labelRC + ")" : labelRC;
                        }
                        if (label != null && label.length() > 0) {
                            labels.add(label);
                        }
                    }
                });
                eexs.add((Tuple<List<String>, EEXRepositoryAccessException>)new Tuple(labels, (Object)new EEXRepositoryAccessException((Exception)((Object)ex), RepositoryAccessExceptionLabelProvider.getIconForException(ex))));
            }
        }
        catch (ImportJobHelper.RelatedObjectNotMatched e) {
            eexs = new ArrayList<Tuple<List<String>, EEXRepositoryAccessException>>();
        }
        return eexs;
    }

    public EditorMessageSet getMessageSetForObject(Object importedObjectUntyped) throws EEXNotReproducibleSnapshot {
        EditorMessageSet objectMessageSet = (EditorMessageSet)this.objectMessages.getByKey(importedObjectUntyped);
        if (objectMessageSet == null) {
            objectMessageSet = new EditorMessageSet(this.getIMessageSetForObject(importedObjectUntyped), this);
            this.objectMessages.put(importedObjectUntyped, (Object)objectMessageSet);
        }
        return objectMessageSet;
    }

    private IMessageSet getIMessageSetForObject(Object importedObjectUntyped) throws EEXNotReproducibleSnapshot {
        IMessageSet objectMessageSet = (IMessageSet)this.objectMessageSets.getByKey(importedObjectUntyped);
        if (objectMessageSet == null) {
            try {
                IRepositoryObjectReference repositoryObjectReference;
                if (importedObjectUntyped instanceof IRepositoryObjectReference) {
                    repositoryObjectReference = (IRepositoryObjectReference)importedObjectUntyped;
                } else {
                    IObjectRO object = (IObjectRO)importedObjectUntyped;
                    repositoryObjectReference = ImportJobHelper.getObjectReference((IObjectRO)object);
                }
                objectMessageSet = this.messageStorage.getObjectMessages(repositoryObjectReference);
                this.objectMessageSets.put(importedObjectUntyped, (Object)objectMessageSet);
            }
            catch (ImportJobHelper.RelatedObjectNotMatched e) {
                objectMessageSet = this.EMPTY_MESSAGE_SET;
            }
        }
        return objectMessageSet;
    }

    public EditorMessageSet getMessageSetForObjects(Collection<Object> importedObjects) throws EEXNotReproducibleSnapshot {
        HashSet_ importedObjectSet = new HashSet_(importedObjects, this.objectReferenceHasher);
        EditorMessageSet objectsMessageSet = (EditorMessageSet)this.objectsMessages.getByKey((Object)importedObjectSet);
        if (objectsMessageSet == null) {
            MessageSet messages = new MessageSet();
            for (Object importedObject : importedObjects) {
                messages.addAll(this.getIMessageSetForObject(importedObject));
            }
            objectsMessageSet = new EditorMessageSet((IMessageSet)messages, this);
            this.objectsMessages.put((Object)importedObjectSet, (Object)objectsMessageSet);
        }
        return objectsMessageSet;
    }

    public EditorMessageSet getMessageSetForProperty(ImportJobPropertyReference propertyReference) throws EEXNotReproducibleSnapshot {
        EditorMessageSet propertyMessageSet = (EditorMessageSet)this.propertyMessages.getByKey((Object)propertyReference);
        if (propertyMessageSet == null) {
            propertyMessageSet = new EditorMessageSet(this.getIMessageSetForProperty(propertyReference), this);
            this.propertyMessages.put((Object)propertyReference, (Object)propertyMessageSet);
        }
        return propertyMessageSet;
    }

    private IMessageSet getIMessageSetForProperty(ImportJobPropertyReference propertyReference) throws EEXNotReproducibleSnapshot {
        IRepositoryPropertyReference repositoryPropertyReference;
        if (propertyReference.getReferenceType() != ContentReferenceAccessType.TO_COMPARE) {
            try {
                repositoryPropertyReference = ImportJobHelper.getPropertyReference((IPropertyRO)propertyReference.getProperty());
            }
            catch (ImportJobHelper.RelatedObjectNotMatched e) {
                repositoryPropertyReference = null;
            }
        } else {
            repositoryPropertyReference = null;
        }
        IMessageSet propertyMessageSet = repositoryPropertyReference != null ? this.messageStorage.getPropertyMessages(repositoryPropertyReference) : this.EMPTY_MESSAGE_SET;
        return propertyMessageSet;
    }

    public EditorMessageSet getMessageSetForObjectTypeCategory(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot {
        EditorMessageSet objectTypeCategoryMessageSet = (EditorMessageSet)this.objectTypeCategoryMessages.getByKey((Object)objectTypeCategoryReference);
        if (objectTypeCategoryMessageSet == null) {
            objectTypeCategoryMessageSet = new EditorMessageSet(this.getIMessageSetForObjectTypeCategory(objectTypeCategoryReference), this);
            this.objectTypeCategoryMessages.put((Object)objectTypeCategoryReference, (Object)objectTypeCategoryMessageSet);
        }
        return objectTypeCategoryMessageSet;
    }

    private IMessageSet getIMessageSetForObjectTypeCategory(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot {
        IRepositoryObjectTypeCategoryReference repositoryObjectTypeCategoryReference;
        if (objectTypeCategoryReference.getReferenceType() != ContentReferenceAccessType.TO_COMPARE) {
            try {
                repositoryObjectTypeCategoryReference = ImportJobHelper.getObjectTypeCategoryReference((IImportedObjectRO)objectTypeCategoryReference.getObject());
            }
            catch (ImportJobHelper.RelatedObjectNotMatched e) {
                repositoryObjectTypeCategoryReference = null;
            }
        } else {
            repositoryObjectTypeCategoryReference = null;
        }
        IMessageSet objectTypeCategoryMessageSet = repositoryObjectTypeCategoryReference != null ? this.messageStorage.getObjectTypeCategoryMessages(repositoryObjectTypeCategoryReference) : this.EMPTY_MESSAGE_SET;
        return objectTypeCategoryMessageSet;
    }

    public EditorMessageSet getMessageSetForRelationContribution(Object relationTypeIDUntyped, Object roleIDUntyped, Object objectIDUntyped) throws EEXNotReproducibleSnapshot {
        EditorMessageSet editorMessageSet;
        IMapRW_ object2MessageSet;
        IRepositoryRelationTypeID relationTypeID = (IRepositoryRelationTypeID)relationTypeIDUntyped;
        IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)roleIDUntyped;
        IObjectRO object = (IObjectRO)objectIDUntyped;
        IRepositoryObjectType concreteObjectType1 = object.getObjectType().getObjectType();
        IMapRW_ roleID2Object2MessageSet = (IMapRW_)this.relationContributionsMessages.getByKey((Object)relationTypeID);
        if (roleID2Object2MessageSet == null) {
            roleID2Object2MessageSet = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
            this.relationContributionsMessages.put((Object)relationTypeID, (Object)roleID2Object2MessageSet);
        }
        if ((object2MessageSet = (IMapRW_)roleID2Object2MessageSet.getByKey((Object)roleID)) == null) {
            object2MessageSet = new HashMap_(IHasher_.OBJECT_IDENTITY_HASHER);
            roleID2Object2MessageSet.put((Object)roleID, (Object)object2MessageSet);
        }
        if ((editorMessageSet = (EditorMessageSet)object2MessageSet.getByKey((Object)object)) == null) {
            try {
                IRepositoryObjectReference objectReference = ImportJobHelper.getObjectReference((IObjectRO)object);
                IRepositoryPropertySetSample objectID = objectReference.getObjectID();
                ICrossLinkRepositoryRelationType abstractRelationType = this.repositoryTypeManager.findCrossLinkRelationType(relationTypeID);
                MessageSet repositoryMessageSet = new MessageSet();
                if (abstractRelationType != null) {
                    for (ICrossLinkRepositoryRelationType concreteRelationType : abstractRelationType.getAllInstanciableRelationTypesOfThisType()) {
                        IRepositoryObjectType abstractObjectType1OfConcreteRelationType = concreteRelationType.getRelationContributionType(roleID).getRelatedObjectType();
                        if (!abstractObjectType1OfConcreteRelationType.isSuperTypeOf(concreteObjectType1)) continue;
                        ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)concreteRelationType.getRepositoryRelationTypeID(), (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
                        repositoryMessageSet.addAll(this.messageStorage.getRelationContributionRelatedMessages(relationsReference));
                    }
                }
                editorMessageSet = new EditorMessageSet((IMessageSet)repositoryMessageSet, this);
            }
            catch (ImportJobHelper.RelatedObjectNotMatched e) {
                editorMessageSet = this.EMPTY_EDITOR_MESSAGE_SET;
            }
            object2MessageSet.put((Object)object, (Object)editorMessageSet);
        }
        return editorMessageSet;
    }

    public EditorMessageSet getMessageSetForRelation(Object relationTypeIDUntyped, Object roleID1Untyped, Object objectID1Untyped, Object object2Untyped) throws EEXNotReproducibleSnapshot {
        EditorMessageSet editorMessageSet;
        IMapRW_ importJobRelationReference_2_editorMessageSet;
        IMapRW_ object1_2_MessageSet;
        IRepositoryRelationTypeID relationTypeID = (IRepositoryRelationTypeID)relationTypeIDUntyped;
        IRepositoryRelationContributionRoleID roleID1 = (IRepositoryRelationContributionRoleID)roleID1Untyped;
        IObjectRO object1 = (IObjectRO)objectID1Untyped;
        ImportJobRelationReference object2 = (ImportJobRelationReference)object2Untyped;
        IRepositoryObjectType concreteObjectType1 = object1.getObjectType().getObjectType();
        IMapRW_ roleID2Object2MessageSet = (IMapRW_)this.relationMessages.getByKey((Object)relationTypeID);
        if (roleID2Object2MessageSet == null) {
            roleID2Object2MessageSet = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
            this.relationMessages.put((Object)relationTypeID, (Object)roleID2Object2MessageSet);
        }
        if ((object1_2_MessageSet = (IMapRW_)roleID2Object2MessageSet.getByKey((Object)roleID1)) == null) {
            object1_2_MessageSet = new HashMap_(IHasher_.OBJECT_IDENTITY_HASHER);
            roleID2Object2MessageSet.put((Object)roleID1, (Object)object1_2_MessageSet);
        }
        if ((importJobRelationReference_2_editorMessageSet = (IMapRW_)object1_2_MessageSet.getByKey((Object)object1)) == null) {
            importJobRelationReference_2_editorMessageSet = new HashMap_(IHasher_.OBJECT_IDENTITY_HASHER);
            object1_2_MessageSet.put((Object)object1, (Object)importJobRelationReference_2_editorMessageSet);
        }
        if ((editorMessageSet = (EditorMessageSet)importJobRelationReference_2_editorMessageSet.getByKey((Object)object2)) == null) {
            try {
                IRepositoryObjectReference objectReference1 = ImportJobHelper.getObjectReference((IObjectRO)object1);
                IRepositoryPropertySetSample objectID1 = objectReference1.getObjectID();
                ICrossLinkRepositoryRelationType abstractRelationType = this.repositoryTypeManager.findCrossLinkRelationType(relationTypeID);
                MessageSet repositoryMessageSet = new MessageSet();
                if (abstractRelationType != null) {
                    IRepositoryObjectType abstractObjectType2OfConcreteRelationType;
                    IRepositoryObjectReference objectReference2 = object2.getObjectReference2();
                    IRepositoryRelationContributionRoleID roleID2 = EditorMessageStorage.getRoleID2(abstractRelationType, roleID1);
                    IRepositoryObjectType concreteObjectType2 = this.getObjectType2(object2);
                    MessageSet relationContributionMessageSet = new MessageSet();
                    for (ICrossLinkRepositoryRelationType concreteRelationType : abstractRelationType.getAllInstanciableRelationTypesOfThisType()) {
                        IRepositoryObjectType abstractObjectType1OfConcreteRelationType = concreteRelationType.getRelationContributionType(roleID1).getRelatedObjectType();
                        abstractObjectType2OfConcreteRelationType = concreteRelationType.getRelationContributionType(roleID2).getRelatedObjectType();
                        if (!abstractObjectType1OfConcreteRelationType.isSuperTypeOf(concreteObjectType1) || !abstractObjectType2OfConcreteRelationType.isSuperTypeOf(concreteObjectType2)) continue;
                        ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)concreteRelationType.getRepositoryRelationTypeID(), (IRepositoryRelationContributionRoleID)roleID1, (IRepositoryPropertySetSample)objectID1);
                        relationContributionMessageSet.addAll(this.messageStorage.getRelationContributionRelatedMessages(relationsReference));
                    }
                    for (RepositoryAccessException rae : relationContributionMessageSet.getMessages()) {
                        boolean isObject2Referenced;
                        if (rae.getRelatedType() != IEXCrossLinkRelationRelatedWithContributionsOfSpecialType.class) continue;
                        IEXCrossLinkRelationRelatedWithContributionsOfSpecialType relatedMessage = (IEXCrossLinkRelationRelatedWithContributionsOfSpecialType)rae;
                        Class objectIDType = relatedMessage.getObjectIDType(roleID2);
                        if (objectIDType == IRepositoryPropertySetSample.class) {
                            if (objectReference2 != null) {
                                IRepositoryPropertySetSample objectID2InMessage = (IRepositoryPropertySetSample)relatedMessage.getObjectID(roleID2);
                                IRepositoryPropertySetSample objectID2 = objectReference2.getObjectID();
                                isObject2Referenced = IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)objectID2InMessage, (Object)objectID2);
                            } else {
                                isObject2Referenced = false;
                            }
                        } else if (objectIDType == IObjectRO.class) {
                            IObjectRO object2InMessage = (IObjectRO)relatedMessage.getObjectID(roleID2);
                            Collection<Tuple<ICrossLinkRelation, IObject>> relationsAndRelatedObjects = object2.getRelationsAndRelatedObjects();
                            if (relationsAndRelatedObjects != null) {
                                isObject2Referenced = false;
                                for (Tuple<ICrossLinkRelation, IObject> relationAndRelatedObject : relationsAndRelatedObjects) {
                                    isObject2Referenced |= object2InMessage == relationAndRelatedObject.getT2();
                                }
                            } else {
                                isObject2Referenced = false;
                            }
                        } else {
                            isObject2Referenced = false;
                        }
                        if (!isObject2Referenced) continue;
                        repositoryMessageSet.add(rae);
                    }
                    if (objectReference2 != null) {
                        IRepositoryPropertySetSample objectID2 = objectReference2.getObjectID();
                        for (ICrossLinkRepositoryRelationType concreteRelationType : abstractRelationType.getAllInstanciableRelationTypesOfThisType()) {
                            abstractObjectType2OfConcreteRelationType = concreteRelationType.getRelationContributionType(roleID2).getRelatedObjectType();
                            if (!abstractObjectType2OfConcreteRelationType.isSuperTypeOf(concreteObjectType2)) continue;
                            CrossLinkRepositoryRelationReference relationReference = new CrossLinkRepositoryRelationReference(concreteRelationType, roleID1, objectID1, objectID2);
                            IMessageSet relationRelatedMessages = this.messageStorage.getRelationRelatedMessages((ICrossLinkRepositoryRelationReference)relationReference);
                            repositoryMessageSet.addAll(relationRelatedMessages);
                        }
                    }
                }
                editorMessageSet = new EditorMessageSet((IMessageSet)repositoryMessageSet, this);
            }
            catch (ImportJobHelper.RelatedObjectNotMatched e) {
                editorMessageSet = this.EMPTY_EDITOR_MESSAGE_SET;
            }
            importJobRelationReference_2_editorMessageSet.put((Object)object2, (Object)editorMessageSet);
        }
        return editorMessageSet;
    }

    private IRepositoryObjectType getObjectType2(ImportJobRelationReference object2) {
        IRepositoryObjectReference objectReference2 = object2.getObjectReference2();
        IRepositoryObjectType concreteObjectType2 = objectReference2 != null ? this.repositoryTypeManager.findObjectType(objectReference2.getObjectTypeID()) : ((IObject)object2.getRelationsAndRelatedObjects().iterator().next().getT2()).getObjectType().getObjectType();
        return concreteObjectType2;
    }

    private static IRepositoryRelationContributionRoleID getRoleID2(ICrossLinkRepositoryRelationType abstractRelationType, IRepositoryRelationContributionRoleID roleID1) {
        ICollection_ relationContributionTypes = abstractRelationType.getAllRelationContributionTypes();
        IIterator_ i = relationContributionTypes.iterator();
        ICrossLinkRepositoryRelationContributionType abstractRelationContributionType2 = (ICrossLinkRepositoryRelationContributionType)i.next();
        if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID1, (Object)abstractRelationContributionType2.getRepositoryRelationContributionRoleID())) {
            abstractRelationContributionType2 = (ICrossLinkRepositoryRelationContributionType)i.next();
        }
        IRepositoryRelationContributionRoleID roleID2 = abstractRelationContributionType2.getRepositoryRelationContributionRoleID();
        return roleID2;
    }
}

