/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessage;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageCategory;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageLevel;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageStorage;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.ISortedMap_;
import com.arcway.lib.java.maps.SortedMap_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IEditorMessageCategory;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.repository.interFace.exceptions.ExceptionCategory;
import com.arcway.repository.interFace.exceptions.ExceptionLevel;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;

public class EditorMessageSet
implements IEditorMessageSet {
    private final IMessageSet messageSet;
    private final EditorMessageStorage messageStorage;
    private ISortedSet_<? extends IEditorMessage> allMessages;
    private ISortedMap_<IMessageLevel, ISortedMap_<EditorMessageCategory, ISortedSet_<EditorMessage>>> categorized;

    public EditorMessageSet(IMessageSet messageSet, EditorMessageStorage messageStorage) {
        this.messageSet = messageSet;
        this.messageStorage = messageStorage;
    }

    public boolean isEmpty() {
        return this.messageSet.isEmpty();
    }

    public IMessageLevel getHighestLevel() {
        return EditorMessageLevel.getEditorMessageLevel(this.messageSet.getHighestLevel());
    }

    public IMessageLevel getUniqueLevel() {
        return EditorMessageLevel.getEditorMessageLevel(this.messageSet.getUniqueLevel());
    }

    public IEditorMessageCategory getUnqiueCategory() {
        return EditorMessageCategory.getEditorMessageCategory(this.messageSet.getUniqueCategory());
    }

    public ISortedSet_<? extends IEditorMessage> getMessages() {
        if (this.allMessages == null) {
            this.allMessages = this.convertMessages((ISortedSet_<RepositoryAccessException>)this.messageSet.getMessages());
        }
        return this.allMessages;
    }

    public ISortedMap_<IMessageLevel, ? extends ISortedMap_<? extends IEditorMessageCategory, ? extends ISortedSet_<? extends IEditorMessage>>> getCategorized() {
        if (this.categorized == null) {
            this.categorized = this.convertMessags((ISortedMap_<ExceptionLevel, ? extends ISortedMap_<ExceptionCategory, ? extends ISortedSet_<RepositoryAccessException>>>)this.messageSet.getCategorized());
        }
        return this.categorized;
    }

    private ISortedMap_<IMessageLevel, ISortedMap_<EditorMessageCategory, ISortedSet_<EditorMessage>>> convertMessags(ISortedMap_<ExceptionLevel, ? extends ISortedMap_<ExceptionCategory, ? extends ISortedSet_<RepositoryAccessException>>> repositoryAccessExceptions) {
        SortedMap_ editorMessages = new SortedMap_(IMessageLevel.COMPARATOR);
        for (IEntry_ entry : repositoryAccessExceptions) {
            editorMessages.put((Object)EditorMessageLevel.getEditorMessageLevel((ExceptionLevel)entry.getKey()), this.convertMessages((ISortedMap_<ExceptionCategory, ? extends ISortedSet_<RepositoryAccessException>>)((ISortedMap_)entry.getValue())));
        }
        return editorMessages;
    }

    private ISortedMap_<EditorMessageCategory, ISortedSet_<EditorMessage>> convertMessages(ISortedMap_<ExceptionCategory, ? extends ISortedSet_<RepositoryAccessException>> repositoryAccessExceptions) {
        SortedMap_ editorMessages = new SortedMap_(EditorMessageCategory.COMPARATOR);
        for (IEntry_ entry : repositoryAccessExceptions) {
            editorMessages.put((Object)EditorMessageCategory.getEditorMessageCategory((ExceptionCategory)entry.getKey()), this.convertMessages((ISortedSet_<RepositoryAccessException>)((ISortedSet_)entry.getValue())));
        }
        return editorMessages;
    }

    private ISortedSet_<EditorMessage> convertMessages(ISortedSet_<RepositoryAccessException> repositoryAccessExceptions) {
        SortedSet_ editorMessages = new SortedSet_(EditorMessage.COMPARATOR);
        for (RepositoryAccessException repositoryAccessException : repositoryAccessExceptions) {
            editorMessages.add((Object)this.messageStorage.getEditorMessageForRepositoryAccessException(repositoryAccessException));
        }
        return editorMessages;
    }

    public IStreamResource getDecorator7x8() {
        IStreamResource icon = null;
        IEditorMessageCategory uniqueCategory = this.getUnqiueCategory();
        if (uniqueCategory != null) {
            icon = uniqueCategory.getDecorator7x8();
        }
        if (icon == null) {
            IMessageLevel highestMessageLevel = this.getHighestLevel();
            icon = highestMessageLevel == null ? null : highestMessageLevel.getDecorator7x8();
        }
        return icon;
    }

    public IStreamResource getIcon16x16() {
        IStreamResource icon = null;
        IEditorMessageCategory uniqueCategory = this.getUnqiueCategory();
        if (uniqueCategory != null) {
            icon = uniqueCategory.getIcon16x16();
        }
        if (icon == null) {
            IMessageLevel highestMessageLevel = this.getHighestLevel();
            icon = highestMessageLevel.getIcon16x16();
        }
        return icon;
    }

    public ITextProvider getToolTipText() {
        return new ITextProvider(){

            public String getText(PresentationContext presentationContext) {
                String text = "";
                for (IEditorMessage message : EditorMessageSet.this.allMessages) {
                    text = String.valueOf(text) + message.getMessageText(presentationContext) + "\n";
                }
                return text;
            }
        };
    }
}

