/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.interFace.exception.IFrontendException;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageLevel;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;

public class EditorMessage
implements IEditorMessage {
    public static IComparator_<EditorMessage> COMPARATOR = new IComparator_<EditorMessage>(){

        public int sgn(EditorMessage object1, EditorMessage object2) {
            return RepositoryAccessException.COMPARATOR.sgn((Object)object1.repositoryAccessException, (Object)object2.repositoryAccessException);
        }

        public int getHashCode(EditorMessage object) {
            return RepositoryAccessException.COMPARATOR.getHashCode((Object)object.repositoryAccessException);
        }
    };
    private final RepositoryAccessException repositoryAccessException;
    private final IFrontendTypeManager frontendTypeManager;
    private IStreamResource icon16x16Cache = null;
    private boolean icon16x16CacheFilled = false;
    private String textCache = null;
    private boolean textCacheFilled = false;

    public EditorMessage(RepositoryAccessException repositoryAccessException, IFrontendTypeManager frontendTypeManager) {
        this.repositoryAccessException = repositoryAccessException;
        this.frontendTypeManager = frontendTypeManager;
    }

    public IStreamResource getIcon16x16() {
        if (!this.icon16x16CacheFilled) {
            this.icon16x16Cache = RepositoryAccessExceptionLabelProvider.getIconForException(this.repositoryAccessException);
            this.icon16x16CacheFilled = true;
        }
        return this.icon16x16Cache;
    }

    public IMessageLevel getMessageLevel() {
        return EditorMessageLevel.getEditorMessageLevel(this.repositoryAccessException.getExceptionLevel());
    }

    public String getMessageText(PresentationContext presentationContext) {
        if (!this.textCacheFilled) {
            IFrontendException frontendException = this.frontendTypeManager.getFrontendException((Exception)((Object)this.repositoryAccessException));
            this.textCache = frontendException.getExceptionMessage(presentationContext);
            this.textCacheFilled = true;
        }
        return this.textCache;
    }
}

