/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess;

import com.arcway.frontend.definition.lib.Messages;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.FrontendRepositoryProperties;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RelatedObject;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RepositoryAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.general.references.ContentReferenceAccessType;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.EditorMessageStorage;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ImportJobAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.MessageStorage;
import com.arcway.frontend.definition.lib.ui.editor.imports.modelaccess.ModelAccess;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.IImportEditorPropertyOrCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobObjectTypeCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobPropertyReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobRelationReference;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.dialog.imports.ICurrentModelAndModificationsAccessAgent_Import;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXObjectReferenceCannotBeResolved;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.agent.AbstractCurrentModelAndModificationsAccessAgent;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.importexport.imporT.importjob.ImportJobHelper;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithObjectTypes;
import com.arcway.repository.interFace.importexport.imporT.importjob.RelationSampleWithRelationCreationRequests;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportJobChangeListener;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IImportedObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IObjectRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IPropertyRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.ro.IRelationRelatedRequestRO;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IContextObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelation;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.ICrossLinkRelationContributionTypeForImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObjectTypeCategory;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IObject;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IProperty;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectSample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CurrentModelAndModificationsAccessAgent
extends AbstractCurrentModelAndModificationsAccessAgent<IImportEditorPropertyOrCategoryReference, ImportJobPropertyReference, ImportJobObjectTypeCategoryReference, IImportedObject>
implements ICurrentModelAndModificationsAccessAgent_Import<IImportEditorPropertyOrCategoryReference, ImportJobPropertyReference, ImportJobObjectTypeCategoryReference, IImportedObject>,
IImportJobChangeListener {
    private final IRepositoryInterfaceRO repositoryInterface;
    private final ModelAccess modelAccess;
    private final RepositoryAccessAgent repositoryAccessAgent;
    private final ImportJobAccessAgent importJobAccessAgent;
    private final ListenerKey importJobChangeListenerKey;
    private int currentVersionStamp;
    private int relationSetCache_versionStamp = -1;
    private IRepositoryRelationTypeID relationSetCache_relationTypeID = null;
    private IRepositoryRelationContributionRoleID relationSetCache_roleID1 = null;
    private IRepositoryPropertySetSample relationSetCache_objectID1 = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_mustNotDeleteRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_mayCreateRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_mayCreateRecommendedRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_mustNotCreateRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_mayDeleteRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_newRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_deletedRelations = null;
    private ISetRW_<ImportJobRelationReference> relationSetCache_newAndNotDeletedRelations = null;
    private final IValueRetriever<ImportJobPropertyReference, Object> propertyValueRetriever = new IValueRetriever<ImportJobPropertyReference, Object>(){

        @Override
        public Object getCurrentValue(ImportJobPropertyReference propertyReference) throws EEXObjectReferenceCannotBeResolved, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
            IProperty property = propertyReference.getProperty();
            try {
                IRepositoryPropertyReference currentValue = ImportJobHelper.getPropertyReference((IPropertyRO)property);
                return CurrentModelAndModificationsAccessAgent.this.repositoryAccessAgent.getCurrentValueForProperty(currentValue);
            }
            catch (ImportJobHelper.RelatedObjectNotMatched ronmE) {
                throw new EEXObjectReferenceCannotBeResolved((Exception)((Object)ronmE), Icons16x16.ERROR);
            }
        }

        @Override
        public Object getImportedValue(ImportJobPropertyReference propertyReference) {
            IProperty property = propertyReference.getProperty();
            return CurrentModelAndModificationsAccessAgent.getImportedValueForProperty((IPropertyRO)property, CurrentModelAndModificationsAccessAgent.this.repositoryInterface);
        }

        @Override
        public ContentReferenceAccessType getReferenceType(ImportJobPropertyReference reference) {
            return reference.getReferenceType();
        }
    };
    private final IValueRetriever<ImportJobObjectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference>> objectTypeCategoryValueRetriever = new IValueRetriever<ImportJobObjectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference>>(){

        @Override
        public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> getCurrentValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXObjectReferenceCannotBeResolved, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
            IImportedObject object = objectTypeCategoryReference.getObject();
            try {
                IRepositoryObjectTypeCategoryReference repositoryObjectTypeCategoryReference = ImportJobHelper.getObjectTypeCategoryReference((IImportedObjectRO)object);
                return CurrentModelAndModificationsAccessAgent.this.repositoryAccessAgent.getCurrentValueForObjectTypeCategory(repositoryObjectTypeCategoryReference, objectTypeCategoryReference);
            }
            catch (ImportJobHelper.RelatedObjectNotMatched ronmE) {
                throw new EEXObjectReferenceCannotBeResolved((Exception)((Object)ronmE), Icons16x16.ERROR);
            }
        }

        @Override
        public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> getImportedValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) {
            IImportedObject object = objectTypeCategoryReference.getObject();
            IImportedObjectTypeCategory importedObjectTypeCategory = object.getImportedObjectTypeCategory();
            ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor catgeoryKey = importedObjectTypeCategory != null ? new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor((Object)objectTypeCategoryReference, importedObjectTypeCategory.getImportedObjectTypeCategory().getObjectTypeCategoryID().toCanonicalString()) : RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(objectTypeCategoryReference);
            return catgeoryKey;
        }

        @Override
        public ContentReferenceAccessType getReferenceType(ImportJobObjectTypeCategoryReference reference) {
            return reference.getReferenceType();
        }
    };
    private final IValueRetriever<ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference>, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor> objectTypeCategoryLabelRetriever = new IValueRetriever<ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference>, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor>(){

        @Override
        public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor getCurrentValue(ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> key) throws EEXObjectReferenceCannotBeResolved, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
            return CurrentModelAndModificationsAccessAgent.this.repositoryAccessAgent.getLabelForObjectTypeCategory(key, ((ImportJobObjectTypeCategoryReference)key.getObjectTypeCategoryReference()).getObject().getObjectType().getObjectType().getRepositoryObjectTypeID());
        }

        @Override
        public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor getImportedValue(ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> key) {
            IImportedObjectTypeCategory importedObjectTypeCategory = ((ImportJobObjectTypeCategoryReference)key.getObjectTypeCategoryReference()).getObject().getImportedObjectTypeCategory();
            if (importedObjectTypeCategory == null) {
                if (!$assertionsDisabled && !RepositoryAccessAgent.isDefaultObjectTypeCategory(key)) {
                    throw new AssertionError();
                }
                return CurrentModelAndModificationsAccessAgent.this.repositoryAccessAgent.getLabelForDefaultObjectTypeCategory(((ImportJobObjectTypeCategoryReference)key.getObjectTypeCategoryReference()).getObject().getObjectType().getObjectType().getRepositoryObjectTypeID());
            }
            String importedCategoryID = importedObjectTypeCategory.getImportedObjectTypeCategory().getObjectTypeCategoryID().toCanonicalString();
            if (!$assertionsDisabled && !importedCategoryID.equals(key.getKey())) {
                throw new AssertionError();
            }
            IStreamResource importedIconFile = CurrentModelAndModificationsAccessAgent.this.importJobAccessAgent.getFileFromImportJob(importedObjectTypeCategory.getImportedObjectTypeCategory().getIconFileID());
            return new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor(importedObjectTypeCategory.getImportedObjectTypeCategory().getDisplayName(), importedIconFile);
        }

        @Override
        public ContentReferenceAccessType getReferenceType(ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> key) {
            return ((ImportJobObjectTypeCategoryReference)key.getObjectTypeCategoryReference()).getReferenceType();
        }
    };

    public CurrentModelAndModificationsAccessAgent(IRepositoryInterfaceRO repositoryInterface, ModelAccess repositoryAccess, ImportJobAccessAgent importJobAccessAgent) {
        this.repositoryInterface = repositoryInterface;
        this.modelAccess = repositoryAccess;
        this.repositoryAccessAgent = new RepositoryAccessAgent(repositoryInterface, (IEditorModelAccess<?, ?, ?, ?>)repositoryAccess);
        this.importJobAccessAgent = importJobAccessAgent;
        this.importJobChangeListenerKey = new ListenerKey();
        this.importJobAccessAgent.addChangeListener(this.importJobChangeListenerKey, this);
        this.currentVersionStamp = 0;
    }

    public String getLabelForRelation(Object relationTypeID, Object roleID, Object objectID, Object relationRef, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        String labelForRelation = null;
        ImportJobRelationReference relationRef_ = (ImportJobRelationReference)relationRef;
        if (relationRef_.isExistingRelation() || relationRef_.isRelationCreationRequest()) {
            labelForRelation = this.repositoryAccessAgent.getObjectName(relationRef_.getObjectReference2(), presentationContext);
        } else if (relationRef_.isImportedRelation()) {
            IImportedObject importedObject = CurrentModelAndModificationsAccessAgent.getImportedObjectInRole2(relationRef_);
            labelForRelation = importedObject != null ? this.getLabelForImportedObject(importedObject, presentationContext) : this.repositoryAccessAgent.getObjectName(relationRef_.getObjectReference2(), presentationContext);
        } else if (relationRef_.isUnmatchedImportedRelation()) {
            IObject relatedObject = (IObject)relationRef_.getUnmatchedRelationAndRelatedObject().getT2();
            if (relatedObject instanceof IImportedObject) {
                return this.getLabelForImportedObject((IImportedObject)relatedObject, presentationContext);
            }
            if (relatedObject instanceof IContextObject) {
                return this.getLabelForUnmatchedContextObject((IContextObject)relatedObject, presentationContext);
            }
        }
        return labelForRelation;
    }

    private String getLabelForImportedObject(IImportedObject importedObject, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryObjectType objectType = importedObject.getObjectType().getObjectType();
        IRepositoryObjectTypeCategoryID category = importedObject.getToBeRepositoryObjectTypeCategory();
        HashMap_ properties = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IProperty property : importedObject.getProperties()) {
            IRepositoryPropertyTypeID repositoryPropertyTypeID = property.getRepositoryPropertyType().getRepositoryPropertyTypeID();
            IRepositoryData toBeValue = property.getToBeValue();
            if (toBeValue == null) {
                toBeValue = ImportJobHelper.determineEffectivePropertyValueIfToBeValueIsNullDependingOnImportMode((IPropertyRO)property, (IRepositorySnapshotRO)this.modelAccess.getSnapshot());
            }
            RepositoryPropertySample propertySample = new RepositoryPropertySample(toBeValue);
            properties.put((Object)repositoryPropertyTypeID, (Object)propertySample);
        }
        RepositoryObjectSample importedObjectSample = new RepositoryObjectSample(objectType, category, (IMap_)properties);
        return this.getLabelForObjectSample((IRepositoryObjectSample)importedObjectSample, presentationContext);
    }

    private String getLabelForUnmatchedContextObject(IContextObject contextObject, PresentationContext presentationContext) {
        return this.getLabelForObjectSample(contextObject.getObjectSample(), presentationContext);
    }

    private String getLabelForObjectSample(IRepositoryObjectSample importedObjectSample, PresentationContext presentationContext) {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IExpiringFrontendLabel labelForObject = frontendTypeManager.getLabelForObject(importedObjectSample, presentationContext);
        return labelForObject.getText();
    }

    private static IImportedObject getImportedObjectInRole2(ImportJobRelationReference relationRef_) {
        for (Tuple<ICrossLinkRelation, IObject> importedRelation : relationRef_.getRelationsAndRelatedObjects()) {
            if (!(importedRelation.getT2() instanceof IImportedObject)) continue;
            return (IImportedObject)importedRelation.getT2();
        }
        return null;
    }

    public String getLabelDecorationForRelation(Object relationTypeID, Object roleID, Object objectID, Object relationRef, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ImportJobRelationReference importJobRelationReference = (ImportJobRelationReference)relationRef;
        if (importJobRelationReference.isImportedRelation() && !importJobRelationReference.getRelationsAndRelatedObjects().isEmpty() || importJobRelationReference.isUnmatchedImportedRelation()) {
            return Messages.getString("ModelAccessAgentForImport.NewDecorator");
        }
        return null;
    }

    public IStreamResource getIconForObject16x16(IImportedObject objectReference, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.getObjectIcon16x16(ImportJobHelper.getObjectSample((IImportedObject)objectReference, (IRepositorySnapshotRO)this.modelAccess.getSnapshot()), presentationContext);
    }

    public IStreamResource getIconForObjectType16x16(Object objectRef) {
        IImportedObject objectRef_ = (IImportedObject)objectRef;
        IRepositoryObjectType repositoryObjectType = objectRef_.getObjectType().getObjectType();
        return this.repositoryAccessAgent.getObjectTypeIcon16x16(repositoryObjectType.getRepositoryObjectTypeID());
    }

    public IStreamResource getIconForRelation16x16(Object relationTypeID, Object roleID, Object objectID, Object relationRef, PresentationContext presentationContext) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        ImportJobRelationReference relationRef_ = (ImportJobRelationReference)relationRef;
        if (relationRef_.isUnmatchedImportedRelation()) {
            IObject relatedObject = (IObject)relationRef_.getUnmatchedRelationAndRelatedObject().getT2();
            IRepositoryObjectTypeID repositoryObjectTypeID = relatedObject.getObjectType().getObjectType().getRepositoryObjectTypeID();
            return this.repositoryAccessAgent.getObjectTypeIcon16x16(repositoryObjectTypeID);
        }
        if (relationRef_.isExistingRelation() || relationRef_.isImportedRelation() || relationRef_.isRelationCreationRequest()) {
            return this.repositoryAccessAgent.getObjectIcon16x16(relationRef_.getObjectReference2(), presentationContext);
        }
        assert (false);
        return null;
    }

    public IStreamResource getIconDecorationForRelation7x8(Object relationTypeID, Object roleID, Object objectID, Object relationRef) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getRelationMessages(relationTypeID, roleID, objectID, relationRef).getDecorator7x8();
    }

    public ITextProvider getToolTipTextForRelation(Object relationTypeID, Object roleID, Object objectID, Object relationRef) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getRelationMessages(relationTypeID, roleID, objectID, relationRef).getToolTipText();
    }

    public Object getParent(Object relationRef) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        throw new UnsupportedOperationException();
    }

    public boolean isCompareModeDepending(IImportEditorPropertyOrCategoryReference referenceAsObject) {
        assert (referenceAsObject instanceof ImportJobPropertyReference || referenceAsObject instanceof ImportJobObjectTypeCategoryReference);
        ContentReferenceAccessType referenceType = null;
        if (referenceAsObject instanceof ImportJobPropertyReference) {
            referenceType = ((ImportJobPropertyReference)referenceAsObject).getReferenceType();
        } else if (referenceAsObject instanceof ImportJobObjectTypeCategoryReference) {
            referenceType = ((ImportJobObjectTypeCategoryReference)referenceAsObject).getReferenceType();
        }
        return referenceType == ContentReferenceAccessType.TO_COMPARE;
    }

    public boolean isImportModeDepending(IImportEditorPropertyOrCategoryReference referenceAsObject) {
        assert (referenceAsObject instanceof ImportJobPropertyReference || referenceAsObject instanceof ImportJobObjectTypeCategoryReference);
        ContentReferenceAccessType referenceType = null;
        boolean toBeValueIsNotSet = false;
        if (referenceAsObject instanceof ImportJobPropertyReference) {
            ImportJobPropertyReference reference = (ImportJobPropertyReference)referenceAsObject;
            referenceType = reference.getReferenceType();
            toBeValueIsNotSet = reference.getProperty().getToBeValue() == null;
        } else if (referenceAsObject instanceof ImportJobObjectTypeCategoryReference) {
            ImportJobObjectTypeCategoryReference reference = (ImportJobObjectTypeCategoryReference)referenceAsObject;
            referenceType = reference.getReferenceType();
            boolean bl = toBeValueIsNotSet = !reference.getObject().isToBeRepositoryObjectTypeCategoryChanged();
        }
        if (referenceType == ContentReferenceAccessType.TO_COMPARE) {
            return false;
        }
        return toBeValueIsNotSet;
    }

    public int getMinCardinality(Object relationTypeID, Object roleID) {
        throw new UnsupportedOperationException();
    }

    public int getMaxCardinality(Object relationTypeID, Object roleID) {
        throw new UnsupportedOperationException();
    }

    public boolean isRelationPossible(Object relationTypeID, Object givenRoleID, Object givenObject, Object relationRef) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        throw new UnsupportedOperationException();
    }

    public String getRelatedItemLocation(Object relationRef, PresentationContext currentPresentationContext) {
        return "";
    }

    public synchronized ISet_<? extends Object> getRelationsThatMustBeCreated(Object relationTypeID, Object objectID1, Object roleID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
    }

    public synchronized ISet_<? extends Object> getRelationsThatMayBeCreated(Object relationTypeID, Object objectID1, Object roleID1, boolean relationsWithPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_mayCreateRelations;
    }

    public synchronized ISet_<? extends Object> getRelationsThatAreRecommendedToBeCreated(Object relationTypeID, Object objectID1, Object roleID1, boolean relationsWithPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_mayCreateRecommendedRelations;
    }

    public synchronized ISet_<? extends Object> getRelationsThatMustNotBeCreated(Object relationTypeID, Object objectID1, Object roleID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_mustNotCreateRelations;
    }

    public synchronized ISet_<? extends Object> getRelationsThatMustBeDeleted(Object relationTypeID, Object objectID1, Object roleID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        return new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
    }

    public synchronized ISet_<? extends Object> getRelationsThatMayBeDeleted(Object relationTypeID, Object objectID1, Object roleID1, boolean relationsWithPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_mayDeleteRelations;
    }

    public synchronized ISet_<? extends Object> getRelationsThatMustNotBeDeleted(Object relationTypeID, Object objectID1, Object roleID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_mustNotDeleteRelations;
    }

    public synchronized ISet_<? extends Object> getDeletedRelations(Object relationTypeID, Object objectID1, Object roleID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_deletedRelations;
    }

    public synchronized ISet_<? extends Object> getCreatedRelations(Object relationTypeID, Object objectID1, Object roleID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_newRelations;
    }

    public synchronized ISet_<? extends Object> getCreatedAndNotDeletedRelations(Object relationTypeID, Object objectID1, Object roleID1, boolean withPermissionOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.determineRelationSets((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID1, (IImportedObject)objectID1);
        return this.relationSetCache_newAndNotDeletedRelations;
    }

    private void determineRelationSets(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IImportedObject object1InImportJob) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        try {
            IRepositoryPropertySetSample repositoryObjectID1 = ImportJobHelper.getObjectReference((IObjectRO)object1InImportJob).getObjectID();
            if (!(this.relationSetCache_versionStamp == this.currentVersionStamp && this.relationSetCache_relationTypeID != null && this.relationSetCache_roleID1 != null && this.relationSetCache_objectID1 != null && IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER.isEqual((Object)relationTypeID, (Object)this.relationSetCache_relationTypeID) && IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID1, (Object)this.relationSetCache_roleID1) && IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)repositoryObjectID1, (Object)this.relationSetCache_objectID1))) {
                this.determineRelationSets_internal(relationTypeID, roleID1, object1InImportJob, repositoryObjectID1);
            }
        }
        catch (ImportJobHelper.RelatedObjectNotMatched eRONM) {
            this.clearRelationSetCache();
        }
    }

    private void clearRelationSetCache() {
        this.relationSetCache_mustNotDeleteRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_mayCreateRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_mayCreateRecommendedRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_mustNotCreateRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_mayDeleteRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_newRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_deletedRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
        this.relationSetCache_newAndNotDeletedRelations = new HashSet_(ImportJobRelationReference.REFERENCES_EQUAL_RELATION_HASHER);
    }

    /*
     * WARNING - void declaration
     */
    private void determineRelationSets_internal(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IImportedObject object1InImportJob, IRepositoryPropertySetSample repositoryObjectID1) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        this.relationSetCache_versionStamp = this.currentVersionStamp;
        this.relationSetCache_relationTypeID = relationTypeID;
        this.relationSetCache_roleID1 = roleID1;
        this.relationSetCache_objectID1 = repositoryObjectID1;
        this.clearRelationSetCache();
        ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
        HashSet_ potentiallyRelatedItems = object1InImportJob.getImportMode() == 2 ? new HashSet_(this.repositoryAccessAgent.getPotentialRelationContributors(relationTypeID, roleID1, repositoryObjectID1, false), RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER) : new HashSet_(RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        HashSet_ existingRelatedItems = new HashSet_(this.repositoryAccessAgent.getRelationContributorsOfExistingRelations(relationTypeID, roleID1, repositoryObjectID1), RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        HashSet_ relatedItemsOfToBeDeletedRelations = new HashSet_(RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        HashMap_ relatedItemsOfToBeCreatedRelations = new HashMap_(RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        for (ICrossLinkRepositoryRelationType instantiableSubRelationType : relationType.getAllInstanciableRelationTypesOfThisType()) {
            IRepositoryObjectReference objectReference2;
            ICrossLinkRepositoryRelationContributionType contributionType2 = RepositoryAccessAgent.getSecondContributionType(instantiableSubRelationType, roleID1);
            Tuple<ISet_<RelationSampleWithRelationCreationRequests>, ISet_<RelationSampleWithObjectTypes>> creationAndDeletionRequests = this.importJobAccessAgent.getRelationSamplesForCreationAndDeletionRequests(instantiableSubRelationType.getRepositoryRelationTypeID());
            for (RelationSampleWithObjectTypes relationSampleWithObjectTypes : (ISet_)creationAndDeletionRequests.getT2()) {
                if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)repositoryObjectID1, (Object)relationSampleWithObjectTypes.getObjectID(roleID1))) continue;
                objectReference2 = relationSampleWithObjectTypes.getObjectReference(contributionType2.getRepositoryRelationContributionRoleID());
                RelatedObject relatedObjectToBeDeleted = new RelatedObject(contributionType2, objectReference2);
                relatedItemsOfToBeDeletedRelations.add((Object)relatedObjectToBeDeleted);
                potentiallyRelatedItems.remove((Object)relatedObjectToBeDeleted);
                existingRelatedItems.remove((Object)relatedObjectToBeDeleted);
            }
            for (RelationSampleWithRelationCreationRequests relationSampleWithRelationCreationRequests : (ISet_)creationAndDeletionRequests.getT1()) {
                if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)repositoryObjectID1, (Object)relationSampleWithRelationCreationRequests.getObjectID(roleID1))) continue;
                objectReference2 = relationSampleWithRelationCreationRequests.getObjectReference(contributionType2.getRepositoryRelationContributionRoleID());
                RelatedObject relatedObjectToBeCreated = new RelatedObject(contributionType2, objectReference2);
                relatedItemsOfToBeCreatedRelations.put((Object)relatedObjectToBeCreated, (Object)relationSampleWithRelationCreationRequests);
                potentiallyRelatedItems.remove((Object)relatedObjectToBeCreated);
            }
        }
        HashMap_ relatedItemsInImportedRelations = new HashMap_(RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        for (ICrossLinkRepositoryRelationType instantiableSubRelationType : relationType.getAllInstanciableRelationTypesOfThisType()) {
            ICrossLinkRepositoryRelationContributionType contributionType2 = RepositoryAccessAgent.getSecondContributionType(instantiableSubRelationType, roleID1);
            for (ICrossLinkRelation iCrossLinkRelation : this.importJobAccessAgent.getImportedRelationsOfType(instantiableSubRelationType.getRepositoryRelationTypeID())) {
                try {
                    if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)ImportJobHelper.getObjectReference((IObjectRO)iCrossLinkRelation.getRelationContribution(roleID1).getRelatedObject()).getObjectID(), (Object)repositoryObjectID1)) continue;
                    try {
                        RelationSampleWithObjectTypes sample = this.importJobAccessAgent.getRelationSampleForImportedRelation(iCrossLinkRelation);
                        IRepositoryObjectReference objectReference2 = sample.getObjectReference(contributionType2.getRepositoryRelationContributionRoleID());
                        RelatedObject relatedObjectInImportedRelation = new RelatedObject(contributionType2, objectReference2);
                        ArrayList<Tuple> importedRelations = (ArrayList<Tuple>)relatedItemsInImportedRelations.getByKey((Object)relatedObjectInImportedRelation);
                        if (importedRelations == null) {
                            importedRelations = new ArrayList<Tuple>();
                            relatedItemsInImportedRelations.put((Object)relatedObjectInImportedRelation, importedRelations);
                        }
                        importedRelations.add(new Tuple((Object)iCrossLinkRelation, (Object)iCrossLinkRelation.getRelationContribution(contributionType2.getRepositoryRelationContributionRoleID()).getRelatedObject()));
                        potentiallyRelatedItems.remove((Object)relatedObjectInImportedRelation);
                    }
                    catch (RepositoryAccessException raE) {
                        this.relationSetCache_mustNotCreateRelations.add((Object)new ImportJobRelationReference(iCrossLinkRelation, iCrossLinkRelation.getRelationContribution(contributionType2.getRepositoryRelationContributionRoleID()).getRelatedObject(), this.currentVersionStamp));
                    }
                }
                catch (ImportJobHelper.RelatedObjectNotMatched raE) {
                    // empty catch block
                }
            }
        }
        for (IEntry_ entry : relatedItemsInImportedRelations) {
            if (existingRelatedItems.contains((Object)((RelatedObject)entry.getKey()))) {
                this.relationSetCache_mustNotDeleteRelations.add((Object)new ImportJobRelationReference((RelatedObject)entry.getKey(), this.currentVersionStamp));
            } else {
                boolean checked;
                Collection importedRelations = (Collection)entry.getValue();
                RelationSampleWithRelationCreationRequests relationSampleWithRelationCreationRequests = (RelationSampleWithRelationCreationRequests)relatedItemsOfToBeCreatedRelations.getByKey((Object)((RelatedObject)entry.getKey()));
                List<Tuple<IRelationRelatedRequestRO, ICrossLinkRelationContributionTypeForImportedObject>> relationCreationRequests = relationSampleWithRelationCreationRequests == null || relationSampleWithRelationCreationRequests.getRelationCreationRequests() == null ? Collections.emptyList() : relationSampleWithRelationCreationRequests.getRelationCreationRequests();
                boolean bl = checked = !relationCreationRequests.isEmpty() || CurrentModelAndModificationsAccessAgent.containsAnyRelationWithImportFlagSet(importedRelations);
                if (relatedItemsOfToBeDeletedRelations.contains((Object)((RelatedObject)entry.getKey()))) {
                    ImportJobRelationReference importJobRelationReference2 = new ImportJobRelationReference((Collection)entry.getValue(), relationCreationRequests, (RelatedObject)entry.getKey(), ImportJobRelationReference.RelationSetType.MAY_DELETE, this.currentVersionStamp);
                    this.relationSetCache_mayDeleteRelations.add((Object)importJobRelationReference2);
                    if (!checked) {
                        this.relationSetCache_deletedRelations.add((Object)importJobRelationReference2);
                    } else {
                        this.relationSetCache_newAndNotDeletedRelations.add((Object)importJobRelationReference2);
                    }
                } else {
                    ImportJobRelationReference importJobRelationReference = new ImportJobRelationReference((Collection)entry.getValue(), relationCreationRequests, (RelatedObject)entry.getKey(), ImportJobRelationReference.RelationSetType.MAY_CREATE_RECOMMENDED, this.currentVersionStamp);
                    this.relationSetCache_mayCreateRecommendedRelations.add((Object)importJobRelationReference);
                    this.relationSetCache_mayCreateRelations.add((Object)importJobRelationReference);
                    if (checked) {
                        this.relationSetCache_newRelations.add((Object)importJobRelationReference);
                        this.relationSetCache_newAndNotDeletedRelations.add((Object)importJobRelationReference);
                    }
                }
            }
            relatedItemsOfToBeCreatedRelations.removeAsEntry((Object)((RelatedObject)entry.getKey()));
            relatedItemsOfToBeDeletedRelations.remove((Object)((RelatedObject)entry.getKey()));
            existingRelatedItems.remove((Object)((RelatedObject)entry.getKey()));
        }
        for (RelatedObject existingRelatedItem : existingRelatedItems) {
            this.relationSetCache_mustNotDeleteRelations.add((Object)new ImportJobRelationReference(existingRelatedItem, this.currentVersionStamp));
            relatedItemsOfToBeCreatedRelations.removeAsEntry((Object)existingRelatedItem);
        }
        for (RelatedObject relatedItemOfToBeDeletedRelation : relatedItemsOfToBeDeletedRelations) {
            void var14_25;
            RelationSampleWithRelationCreationRequests relationSampleWithCreationRequests = (RelationSampleWithRelationCreationRequests)relatedItemsOfToBeCreatedRelations.getByKey((Object)relatedItemOfToBeDeletedRelation);
            Object var14_22 = null;
            if (relationSampleWithCreationRequests == null || relationSampleWithCreationRequests.getRelationCreationRequests() == null || relationSampleWithCreationRequests.getRelationCreationRequests().isEmpty()) {
                IRepositoryRelationTypeID instantiableRelationTypeID = relatedItemOfToBeDeletedRelation.getContributionType().getRelatedRelationType().getRepositoryRelationTypeID();
                ImportJobRelationReference importJobRelationReference = new ImportJobRelationReference(object1InImportJob.getCrossLinkRelationContributionType(instantiableRelationTypeID, roleID1), relatedItemOfToBeDeletedRelation, ImportJobRelationReference.RelationSetType.MAY_DELETE, this.currentVersionStamp);
                this.relationSetCache_deletedRelations.add((Object)importJobRelationReference);
            } else {
                ImportJobRelationReference importJobRelationReference = new ImportJobRelationReference(Collections.emptySet(), relationSampleWithCreationRequests.getRelationCreationRequests(), relatedItemOfToBeDeletedRelation, ImportJobRelationReference.RelationSetType.MAY_DELETE, this.currentVersionStamp);
                this.relationSetCache_newAndNotDeletedRelations.add((Object)importJobRelationReference);
            }
            this.relationSetCache_mayDeleteRelations.add((Object)var14_25);
            relatedItemsOfToBeCreatedRelations.removeAsEntry((Object)relatedItemOfToBeDeletedRelation);
        }
        for (IEntry_ relatedItemOfToBeCreatedRelation : relatedItemsOfToBeCreatedRelations) {
            ImportJobRelationReference importJobRelationReference3 = new ImportJobRelationReference(Collections.emptySet(), ((RelationSampleWithRelationCreationRequests)relatedItemOfToBeCreatedRelation.getValue()).getRelationCreationRequests(), (RelatedObject)relatedItemOfToBeCreatedRelation.getKey(), ImportJobRelationReference.RelationSetType.MAY_CREATE_DEFAULT, this.currentVersionStamp);
            this.relationSetCache_mayCreateRelations.add((Object)importJobRelationReference3);
            this.relationSetCache_newRelations.add((Object)importJobRelationReference3);
            this.relationSetCache_newAndNotDeletedRelations.add((Object)importJobRelationReference3);
        }
        for (RelatedObject potentiallyRelatedItem : potentiallyRelatedItems) {
            IRepositoryRelationTypeID instantiableRelationTypeID = potentiallyRelatedItem.getContributionType().getRelatedRelationType().getRepositoryRelationTypeID();
            ImportJobRelationReference importJobRelationReference = new ImportJobRelationReference(object1InImportJob.getCrossLinkRelationContributionType(instantiableRelationTypeID, roleID1), potentiallyRelatedItem, ImportJobRelationReference.RelationSetType.MAY_CREATE_DEFAULT, this.currentVersionStamp);
            this.relationSetCache_mayCreateRelations.add((Object)importJobRelationReference);
        }
        if (this.relationSetCache_versionStamp != this.currentVersionStamp) {
            this.determineRelationSets_internal(relationTypeID, roleID1, object1InImportJob, repositoryObjectID1);
        }
    }

    private static boolean containsAnyRelationWithImportFlagSet(Collection<Tuple<ICrossLinkRelation, IObject>> importedRelations) {
        for (Tuple<ICrossLinkRelation, IObject> importedRelation : importedRelations) {
            if (!((ICrossLinkRelation)importedRelation.getT1()).getImportFlag()) continue;
            return true;
        }
        return false;
    }

    public boolean relationExists(Object relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.repositoryAccessAgent.relationExists(relationSample);
    }

    public Object getParentsValueForProperty(ImportJobPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        List<Object> ancestorValues = this.getAncestorsValuesForProperty(propertyReference, true);
        if (!ancestorValues.isEmpty()) {
            return ancestorValues.get(0);
        }
        return null;
    }

    public List<Object> getAncestorsValuesForProperty(ImportJobPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getAncestorsValuesForProperty(propertyReference, false);
    }

    private List<Object> getAncestorsValuesForProperty(ImportJobPropertyReference propertyReference, boolean parentOnly) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        if (propertyReference.getReferenceType() == ContentReferenceAccessType.TO_COMPARE) {
            if (this.modelAccess.getCompareMode() == 1) {
                IImportedObject parent = propertyReference.getProperty().getObject().getParent();
                if (parent != null) {
                    return this.getImportedAncestorsValuesForProperty(parent, propertyReference.getProperty().getObject().getObjectType().getObjectType().getRepositoryObjectTypeID(), propertyReference.getProperty().getRepositoryPropertyType().getRepositoryPropertyTypeID(), parentOnly ? 1 : 0);
                }
                return Collections.emptyList();
            }
            return this.getAncestorsCurrentValuesForProperty((IPropertyRO)propertyReference.getProperty(), parentOnly);
        }
        ArrayList<Object> ancestorsToBePropertyValues = new ArrayList<Object>();
        this.addAncestorsToBePropertyValues((IPropertyRO)propertyReference.getProperty(), parentOnly, ancestorsToBePropertyValues);
        return ancestorsToBePropertyValues;
    }

    private final List<Object> getImportedAncestorsValuesForProperty(IImportedObject object, IRepositoryObjectTypeID propertyOwningObjectTypeID, IRepositoryPropertyTypeID propertyTypeID, int maximumNumberOfSteps) {
        ArrayList<Object> ancestorsValues = new ArrayList<Object>();
        int step = 0;
        IImportedObject currentObject = object;
        do {
            ++step;
            if (!this.repositoryAccessAgent.isPropertyDefinedForObject(currentObject.getObjectType().getObjectType().getRepositoryObjectTypeID(), propertyOwningObjectTypeID, propertyTypeID)) continue;
            IProperty property = currentObject.getProperty(propertyTypeID);
            ancestorsValues.add(CurrentModelAndModificationsAccessAgent.getImportedValueForProperty((IPropertyRO)property, this.repositoryInterface));
        } while ((currentObject = currentObject.getParent()) != null && (step == 0 || step < maximumNumberOfSteps));
        return ancestorsValues;
    }

    private final List<Object> getAncestorsCurrentValuesForProperty(IPropertyRO property, boolean parentOnly) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        try {
            IRepositoryObjectReference matchingObjectReference = property.getObject().getMatchingObject();
            IRepositoryObjectReference parentObjectReference = this.repositoryAccessAgent.getParent(matchingObjectReference);
            if (parentObjectReference != null) {
                return this.repositoryAccessAgent.getAncestorsCurrentValuesForProperty(parentObjectReference, matchingObjectReference.getObjectTypeID(), property.getRepositoryPropertyType().getRepositoryPropertyTypeID(), parentOnly ? 1 : 0);
            }
            return Collections.emptyList();
        }
        catch (EEXObjectReferenceCannotBeResolved eORCNBR) {
            assert (false);
            return Collections.emptyList();
        }
    }

    private final void addAncestorsToBePropertyValues(IPropertyRO importedProperty, boolean parentOnly, List<Object> ancestorsToBePropertyValues) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IImportedObjectRO importedObject = importedProperty.getObject();
        if (importedObject.getImportMode() == 1) {
            if (importedObject.getImportTarget() != null) {
                ancestorsToBePropertyValues.addAll(this.repositoryAccessAgent.getAncestorsCurrentValuesForProperty(importedObject.getImportTarget(), importedProperty.getObject().getObjectType().getObjectType().getRepositoryObjectTypeID(), importedProperty.getRepositoryPropertyType().getRepositoryPropertyTypeID(), parentOnly ? 1 : 0));
            } else {
                ancestorsToBePropertyValues.add(CurrentModelAndModificationsAccessAgent.getToBeValueForProperty(importedProperty, this.repositoryInterface));
                IImportedObjectRO parent = importedProperty.getObject().getParent();
                assert (parent != null);
                if (parent != null) {
                    this.addAncestorsToBePropertyValues(parent.getProperty(importedProperty.getRepositoryPropertyType().getRepositoryPropertyTypeID()), parentOnly, ancestorsToBePropertyValues);
                }
            }
        } else if (importedObject.getImportMode() == 2) {
            ancestorsToBePropertyValues.addAll(this.getAncestorsCurrentValuesForProperty(importedProperty, parentOnly));
        }
    }

    public boolean relationContributorExists(Object roleID, Object objectID, Object relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.importJobAccessAgent.removeChangeListener(this.importJobChangeListenerKey);
        this.importJobAccessAgent.dispose();
    }

    public void importJobChanged() throws EXNotReproducibleSnapshot {
        ++this.currentVersionStamp;
    }

    public void addDeletedRelation(Object relationTypeID, Object editedObjectRoleID, Object editedObject, Object relationReference) throws EEXNotReproducibleSnapshot {
        ImportJobRelationReference relationReference_ = (ImportJobRelationReference)relationReference;
        if (relationReference_.getVersionStamp() == this.currentVersionStamp) {
            this.importJobAccessAgent.addDeletedRelation(relationReference_);
        } else assert (false);
    }

    public void addNewRelation(Object relationTypeID, Object editedObjectRoleID, Object editedObject, Object relationReference) throws EEXNotReproducibleSnapshot {
        ImportJobRelationReference relationReference_ = (ImportJobRelationReference)relationReference;
        if (relationReference_.getVersionStamp() == this.currentVersionStamp) {
            this.importJobAccessAgent.addNewRelation((ImportJobRelationReference)relationReference);
        } else assert (false);
    }

    public void addNewRelation(Object relationTypeID, Object newRelationSample) {
        throw new UnsupportedOperationException();
    }

    public void addObject(Object objectReference, Object parentObjectReference) {
        throw new UnsupportedOperationException();
    }

    public int getImportMode(Object element) {
        return this.importJobAccessAgent.getImportMode(element);
    }

    public EditorMessageStorage getEditorMessageStorage() {
        return this.importJobAccessAgent.getEditorMessageStorage();
    }

    public MessageStorage getRepositoryMessageStorage() {
        return this.importJobAccessAgent.getRepositoryMessageStorage();
    }

    public String getLabelForImportedObject(Object element, PresentationContext presentationContext) {
        return this.importJobAccessAgent.getLabelForImportedObject(element, presentationContext);
    }

    public IImportedObject getParentObjectReferenceForNewObject(IImportedObject newObjectReference) {
        throw new UnsupportedOperationException();
    }

    public boolean relationModified(Object relationTypeID, Object editedObjectRoleID, Object editedObjectID) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return !this.getCreatedRelations(relationTypeID, editedObjectID, editedObjectRoleID).isEmpty() || !this.getDeletedRelations(relationTypeID, editedObjectID, editedObjectRoleID).isEmpty();
    }

    public void checkRelationCardinality(Object relationTypeID, Object editedObjectRoleID, Object object) {
    }

    public void updateRelationChangeSetsAccordingToNewCurrentState(Object relationTypeID, Object editedObjectRoleID, Object editedObjectID) {
        ++this.currentVersionStamp;
    }

    public void setImportFlag(Object object, boolean imported) throws EEXNotReproducibleSnapshot {
        this.importJobAccessAgent.setImportFlag(object, imported);
    }

    public boolean getImportFlag(Object element) {
        return this.importJobAccessAgent.getImportFlag(element);
    }

    public void setImportMode(Object object, int mode) throws EEXNotReproducibleSnapshot {
        this.importJobAccessAgent.setImportMode(object, mode);
    }

    public boolean isMergeEnabled(IImportedObject importedObject) {
        return this.importJobAccessAgent.isMergeEnabled(importedObject);
    }

    public Object getDefaultValueForProperty(ImportJobPropertyReference importJobPropertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXLockDenied {
        IRepositoryPropertyType repositoryPropertyType = importJobPropertyReference.getProperty().getRepositoryPropertyType();
        Object editorValue = null;
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        IRepositoryData data = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)typeManager).getGenericModificationPropertyType(repositoryPropertyType).getDefaultValue();
        IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(typeManager);
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(repositoryDataType);
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendDataTypeParameters parameters = frontendPropertyType.getFrontendDataTypeParameters();
        editorValue = frontendDataType.getCurrentValueAsEditorValue(data, parameters);
        return editorValue;
    }

    public ISortedSet_<String> getValueRangeKeysForPropertyAsEditorValue(ImportJobPropertyReference reference) {
        return this.repositoryAccessAgent.getValueRangeKeysForPropertyAsEditorValue(reference.getProperty().getRepositoryPropertyType());
    }

    public Map<String, String> getValueRangeForPropertyAsEditorValue(ImportJobPropertyReference reference) {
        return this.repositoryAccessAgent.getValueRangeForPropertyAsEditorValue(reference.getProperty().getRepositoryPropertyType());
    }

    public Object getCurrentValueForProperty(ImportJobPropertyReference reference) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getCurrentValueForPropertyOrObjectTypeCategory(this.propertyValueRetriever, reference);
    }

    private static final Object getImportedValueForProperty(IPropertyRO property, IRepositoryInterfaceRO repositoryInterface) {
        FrontendRepositoryProperties.FrontendRepositoryPropertyContext propertyContext = FrontendRepositoryProperties.getPropertyContext(property.getRepositoryPropertyType(), repositoryInterface);
        return propertyContext.getFrontendDataType().getCurrentValueAsEditorValue(property.getImportedValue(), propertyContext.getFrontendDataTypeParameters());
    }

    private static final Object getToBeValueForProperty(IPropertyRO property, IRepositoryInterfaceRO repositoryInterface) {
        FrontendRepositoryProperties.FrontendRepositoryPropertyContext propertyContext = FrontendRepositoryProperties.getPropertyContext(property.getRepositoryPropertyType(), repositoryInterface);
        return propertyContext.getFrontendDataType().getCurrentValueAsEditorValue(property.getToBeValue(), propertyContext.getFrontendDataTypeParameters());
    }

    public Object getModifiedPropertyValue(ImportJobPropertyReference propertyReference) {
        return this.importJobAccessAgent.getModifiedPropertyValue(propertyReference);
    }

    public boolean isPropertyModified(ImportJobPropertyReference reference) {
        return this.importJobAccessAgent.propertyModified(reference);
    }

    public void refreshPropertyValue(ImportJobPropertyReference property) throws EEXNotReproducibleSnapshot, EEXRepositoryAccessException, EEXSnapshotClosed {
        this.importJobAccessAgent.refreshPropertyValue(property);
    }

    public void setPropertyValue(ImportJobPropertyReference propertyReference, Object newValue) throws EEXNotReproducibleSnapshot, JvmExternalResourceInteractionException, EEXSnapshotClosed, EEXRepositoryAccessException, EEXDataValidation {
        this.importJobAccessAgent.setPropertyValue(propertyReference, newValue);
    }

    public void resetPropertyValue(ImportJobPropertyReference reference, Object newValue) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXRepositoryAccessException, EEXDataValidation, JvmExternalResourceInteractionException {
        this.importJobAccessAgent.resetPropertyValue(reference, newValue);
    }

    public boolean isDatePropertyWithTimeComponent(ImportJobPropertyReference propertyReference) {
        IProperty property = propertyReference.getProperty();
        IRepositoryPropertyType repositoryPropertyType = property.getRepositoryPropertyType();
        boolean isWithTimeComponent = ((RDTDateUTC64Bitmsec.Parameters)repositoryPropertyType.getDataTypeParameters()).isWithTimeComponent();
        return isWithTimeComponent;
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> getDefaultValueForObjectTypeCategory(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXLockDenied {
        return RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(objectTypeCategoryReference);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> getCurrentValueForObjectTypeCategory(ImportJobObjectTypeCategoryReference reference) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getCurrentValueForPropertyOrObjectTypeCategory(this.objectTypeCategoryValueRetriever, reference);
    }

    public boolean isObjectTypeCategoryModified(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) {
        return this.importJobAccessAgent.isObjectTypeCategoryModified(objectTypeCategoryReference);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> getModifiedObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) {
        return this.importJobAccessAgent.getModifiedObjectTypeCategoryValue(objectTypeCategoryReference);
    }

    public void setObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> newValue) throws EEXDataValidation, EEXNotReproducibleSnapshot {
        this.importJobAccessAgent.setObjectTypeCategoryValue(objectTypeCategoryReference, newValue);
    }

    public void resetObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> newValue) throws EEXDataValidation, EEXNotReproducibleSnapshot {
        this.importJobAccessAgent.resetObjectTypeCategoryValue(objectTypeCategoryReference, newValue);
    }

    public IList_<ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference>> getValueRangeKeysOfObjectTypeCategoryAsEditorValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        if (objectTypeCategoryReference.getReferenceType() == ContentReferenceAccessType.TO_COMPARE && this.modelAccess.getCompareMode() == 1) {
            ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor importedCategoryKey;
            IImportedObjectTypeCategory importedObjectTypeCategory = objectTypeCategoryReference.getObject().getImportedObjectTypeCategory();
            if (importedObjectTypeCategory == null) {
                importedCategoryKey = RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(objectTypeCategoryReference);
            } else {
                String importedCategoryID = importedObjectTypeCategory.getImportedObjectTypeCategory().getObjectTypeCategoryID().toCanonicalString();
                importedCategoryKey = new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor((Object)objectTypeCategoryReference, importedCategoryID);
            }
            return new ArrayList_(importedCategoryKey);
        }
        try {
            IImportedObject object = objectTypeCategoryReference.getObject();
            IRepositoryObjectTypeCategoryReference repositoryObjectTypeCategoryReference = ImportJobHelper.getObjectTypeCategoryReference((IImportedObjectRO)object);
            return this.repositoryAccessAgent.getValueRangeKeysOfObjectTypeCategoryAsEditorValue(repositoryObjectTypeCategoryReference, objectTypeCategoryReference);
        }
        catch (ImportJobHelper.RelatedObjectNotMatched ronmE) {
            throw new EEXObjectReferenceCannotBeResolved((Exception)((Object)ronmE), Icons16x16.ERROR);
        }
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor getLabelForObjectTypeCategory(ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<ImportJobObjectTypeCategoryReference> key) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getCurrentValueForPropertyOrObjectTypeCategory(this.objectTypeCategoryLabelRetriever, key);
    }

    public void refreshObjectTypeCategoryValue(ImportJobObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot, EEXRepositoryAccessException, EEXSnapshotClosed, JvmExternalResourceInteractionException, EEXDataValidation {
    }

    public boolean isPropertyVisibleForCurrentCategory(ImportJobPropertyReference propertyReference) throws EEXSnapshotClosed, EEXNotReproducibleSnapshot, EEXObjectReferenceCannotBeResolved {
        if (this.repositoryAccessAgent.isObjectTypeSupportingObjectTypeCategories(propertyReference.getProperty().getObject().getObjectType().getObjectType().getRepositoryObjectTypeID())) {
            ImportJobObjectTypeCategoryReference objectTypeCategoryReference = new ImportJobObjectTypeCategoryReference(propertyReference.getProperty().getObject(), ContentReferenceAccessType.TO_BE);
            ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor toBeValueForObjectTypeCategory = this.getToBeObjectTypeCategoryValue(objectTypeCategoryReference);
            return this.repositoryAccessAgent.isPropertyVisibleForCategory(propertyReference.getProperty().getObject().getObjectType().getObjectType().getRepositoryObjectTypeID(), propertyReference.getProperty().getRepositoryPropertyType().getRepositoryPropertyTypeID(), toBeValueForObjectTypeCategory);
        }
        return true;
    }

    private <REFERENCE_TYPE, VALUE_TYPE> VALUE_TYPE getCurrentValueForPropertyOrObjectTypeCategory(IValueRetriever<REFERENCE_TYPE, VALUE_TYPE> valueRetriever, REFERENCE_TYPE reference) throws EEXObjectReferenceCannotBeResolved, EEXSnapshotClosed, EEXNotReproducibleSnapshot {
        if (valueRetriever.getReferenceType(reference) == ContentReferenceAccessType.TO_COMPARE) {
            if (this.modelAccess.getCompareMode() == 0) {
                return valueRetriever.getCurrentValue(reference);
            }
            return valueRetriever.getImportedValue(reference);
        }
        return valueRetriever.getCurrentValue(reference);
    }

    public IEditorMessageSet getPropertyMessages(ImportJobPropertyReference propertyReference) throws EEXNotReproducibleSnapshot {
        return this.importJobAccessAgent.getEditorMessageStorage().getMessageSetForProperty(propertyReference);
    }

    public IEditorMessageSet getObjectTypeCategoryMessages(ImportJobObjectTypeCategoryReference propertyReference) throws EEXNotReproducibleSnapshot {
        return this.importJobAccessAgent.getEditorMessageStorage().getMessageSetForObjectTypeCategory(propertyReference);
    }

    public IEditorMessageSet getRelationContributionMessages(Object relationTypeID, Object roleID1, Object objectID1) throws EEXNotReproducibleSnapshot {
        return this.importJobAccessAgent.getEditorMessageStorage().getMessageSetForRelationContribution(relationTypeID, roleID1, objectID1);
    }

    public IEditorMessageSet getRelationMessages(Object relationTypeID, Object roleID1, Object objectID1, Object objectID2) throws EEXNotReproducibleSnapshot {
        return this.importJobAccessAgent.getEditorMessageStorage().getMessageSetForRelation(relationTypeID, roleID1, objectID1, objectID2);
    }

    private static interface IValueRetriever<REFERENCE_TYPE, VALUE_TYPE> {
        public VALUE_TYPE getCurrentValue(REFERENCE_TYPE var1) throws EEXObjectReferenceCannotBeResolved, EEXSnapshotClosed, EEXNotReproducibleSnapshot;

        public VALUE_TYPE getImportedValue(REFERENCE_TYPE var1);

        public ContentReferenceAccessType getReferenceType(REFERENCE_TYPE var1);
    }
}

