/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.imports;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendAttributeSetType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.general.references.ContentReferenceAccessType;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.IImportEditorContentReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobObjectTypeCategoryReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobPropertyReference;
import com.arcway.frontend.definition.lib.ui.editor.imports.references.ImportJobRelationsReference;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.lib.ui.editor.WidgetReference;
import com.arcway.lib.ui.editor.WidgetTypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.layoutspecification.IWidgetSpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.parameters.FileWidgetParameters;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.editor.TableWidgetParameters;
import com.arcway.lib.ui.editor.parameters.importdialog.EntryWidgetParameters;
import com.arcway.lib.ui.editor.specification.sequential.EntrySpecification;
import com.arcway.lib.ui.editor.specification.sequential.PageSpecification;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.RepositoryRelationContributionTypeCardinality;
import com.arcway.repository.interFace.importexport.imporT.importjob.rw.IImportedObject;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationAttributeSetType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.IGenericModificationRelationType;
import com.arcway.repository.lib.high.genericmodifications.interFace.type.manager.IGenericModificationTypeManager;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTDuration64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.RDTFloat64BitIEEE754;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTURL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportJobEditorLayoutFactory {
    private static final HashMap<Object, WidgetTypeID> WIDGET_TYPE_MAP = ImportJobEditorLayoutFactory.fillDefaultWidgetMap();

    public static List<WidgetReference> generateDefaultLayout(IImportedObject importedObject, IRepositoryObjectType repositoryObjectType) {
        ArrayList<WidgetReference> pages = new ArrayList<WidgetReference>();
        if (repositoryObjectType != null) {
            for (IRepositoryAttributeSetType attributeSetType : repositoryObjectType.getAttributeSetTypes()) {
                WidgetReference widgetReference;
                ArrayList<Object> contentReferences;
                WidgetReference page = new WidgetReference((IWidgetTypeID)WidgetTypeID.DIALOGPAGE, ImportJobEditorLayoutFactory.getPageWidgetParameters(attributeSetType, repositoryObjectType));
                WidgetReference table = new WidgetReference((IWidgetTypeID)WidgetTypeID.TABLE, (WidgetParameters)ImportJobEditorLayoutFactory.getTableWidgetParameters(attributeSetType, repositoryObjectType));
                page.addChild(table);
                if (repositoryObjectType.canBeSpecialisedByCategories() == IRepositoryObjectType.EnumCategorySupportType.YES) {
                    ArrayList<ImportJobObjectTypeCategoryReference> contentReferences2 = new ArrayList<ImportJobObjectTypeCategoryReference>();
                    contentReferences2.add(new ImportJobObjectTypeCategoryReference(importedObject, ContentReferenceAccessType.STANDALONE));
                    WidgetReference widgetReference2 = new WidgetReference(contentReferences2, (IWidgetTypeID)WidgetTypeID.SINGLECHOICE, new WidgetParameters(ObjectTypeCategoryLabels.LABEL_CATEGORY, "", true, 0, 1));
                    table.addChild(widgetReference2);
                    WidgetReference horizontalSeparatorReference = new WidgetReference((IWidgetTypeID)WidgetTypeID.HORIZONTAL_SEPARATOR, new WidgetParameters("", "", false, 0, 1));
                    table.addChild(horizontalSeparatorReference);
                }
                String id = "";
                for (IRepositoryPropertyType repositoryPropertyType : attributeSetType.getPropertyTypes()) {
                    IRepositoryDataType dataType = repositoryPropertyType.getDataType();
                    id = repositoryPropertyType.getRepositoryPropertyTypeID().toCanonicalString();
                    contentReferences = new ArrayList<Object>();
                    contentReferences.add(importedObject.getProperty(repositoryPropertyType.getRepositoryPropertyTypeID()));
                    if (dataType == null) continue;
                    widgetReference = new WidgetReference(contentReferences, ImportJobEditorLayoutFactory.getWidgetTypeID(repositoryPropertyType.getRepositoryPropertyTypeID(), repositoryObjectType), ImportJobEditorLayoutFactory.getPropertyWidgetParameters(repositoryPropertyType.getRepositoryPropertyTypeID(), repositoryObjectType));
                    table.addChild(widgetReference);
                }
                for (ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType : attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes()) {
                    id = repositoryRelationContributionType.getRepositoryRelationContributionRoleID().toCanonicalString();
                    ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution repositoryRelationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)repositoryRelationContributionType.getRelatedRelationType().getRepositoryRelationTypeID(), (IRepositoryRelationContributionRoleID)repositoryRelationContributionType.getRepositoryRelationContributionRoleID(), (IRepositoryPropertySetSample)importedObject.getObjectID());
                    contentReferences = new ArrayList();
                    contentReferences.add(repositoryRelationsReference);
                    widgetReference = new WidgetReference(contentReferences, (IWidgetTypeID)WIDGET_TYPE_MAP.get(repositoryRelationContributionType.getCardinality()), ImportJobEditorLayoutFactory.getRelationWidgetParameters(repositoryRelationContributionType, repositoryObjectType, importedObject));
                    table.addChild(widgetReference);
                }
                int j = id.indexOf("uid");
                if (j != -1) continue;
                pages.add(page);
            }
        }
        return pages;
    }

    public static List<WidgetReference> generateLayout(IImportedObject importedObject, IRepositoryObjectType repositoryObjectType, Sequence layoutSpecification) {
        ArrayList<WidgetReference> pages = new ArrayList<WidgetReference>();
        for (PageSpecification pageSpec : layoutSpecification.getPageSpecifications()) {
            WidgetReference page = new WidgetReference((IWidgetTypeID)WidgetTypeID.DIALOGPAGE, pageSpec.getWidgetParameters());
            for (EntrySpecification entry : pageSpec.getEntrySpecifications()) {
                Collection<Object> contentReferences;
                EntryWidgetParameters parameters = entry.getWidgetParameters();
                IWidgetSpecification childWidgetSpec = entry.getWidgetSpecification();
                if (!(childWidgetSpec instanceof WidgetSpecification)) continue;
                WidgetSpecification subWidgetSpec = (WidgetSpecification)childWidgetSpec;
                Tuple<IWidgetTypeID, WidgetParameters> subWidgetTypeAndParameters = ImportJobEditorLayoutFactory.determineWidgetTypeAndParameters(subWidgetSpec, repositoryObjectType);
                if (parameters.isWithIncomingOrAsIsWidget()) {
                    contentReferences = new ArrayList<IImportEditorContentReference>();
                    contentReferences.addAll(ImportJobEditorLayoutFactory.createContentReferences(subWidgetSpec, importedObject, repositoryObjectType, ContentReferenceAccessType.TO_COMPARE));
                    contentReferences.addAll(ImportJobEditorLayoutFactory.createContentReferences(subWidgetSpec, importedObject, repositoryObjectType, ContentReferenceAccessType.TO_BE));
                    ((WidgetParameters)subWidgetTypeAndParameters.getT2()).setWidgetSubTypeID((IWidgetTypeID)subWidgetTypeAndParameters.getT1());
                    WidgetReference row = new WidgetReference(contentReferences, (IWidgetTypeID)WidgetTypeID.WIDGETROW, (WidgetParameters)subWidgetTypeAndParameters.getT2());
                    page.addChild(row);
                    continue;
                }
                contentReferences = ImportJobEditorLayoutFactory.createContentReferences(subWidgetSpec, importedObject, repositoryObjectType, ContentReferenceAccessType.STANDALONE);
                WidgetReference widgetReference = new WidgetReference(contentReferences, (IWidgetTypeID)subWidgetTypeAndParameters.getT1(), (WidgetParameters)subWidgetTypeAndParameters.getT2());
                page.addChild(widgetReference);
            }
            pages.add(page);
        }
        return pages;
    }

    private static Tuple<IWidgetTypeID, WidgetParameters> determineWidgetTypeAndParameters(WidgetSpecification widgetSpec, IRepositoryObjectType repositoryObjectType) {
        WidgetParameters widgetParameters;
        IWidgetTypeID widgetTypeID = widgetSpec.getWidgetTypeID();
        WidgetParameters widgetParameters2 = widgetParameters = widgetTypeID != null ? widgetSpec.getWidgetParameters().copy() : null;
        if (widgetTypeID == null) {
            if (!widgetSpec.getPropertyTypeIDs().isEmpty()) {
                final String namePropertyTypeIDString = (String)widgetSpec.getPropertyTypeIDs().iterator().next();
                IRepositoryPropertyTypeID namePropertyTypeID = new IRepositoryPropertyTypeID(){

                    public String toCanonicalString() {
                        return namePropertyTypeIDString;
                    }
                };
                widgetParameters = ImportJobEditorLayoutFactory.getPropertyWidgetParameters(namePropertyTypeID, repositoryObjectType);
                widgetTypeID = ImportJobEditorLayoutFactory.getWidgetTypeID(namePropertyTypeID, repositoryObjectType);
            } else assert (false);
        }
        return new Tuple((Object)widgetTypeID, (Object)widgetParameters);
    }

    private static Collection<IImportEditorContentReference> createContentReferences(WidgetSpecification widgetSpec, IImportedObject importedObject, IRepositoryObjectType repositoryObjectType, ContentReferenceAccessType mode) {
        ArrayList<IImportEditorContentReference> contentReferences = new ArrayList<IImportEditorContentReference>();
        if (widgetSpec.isObjectTypeCategoryContained()) {
            assert (repositoryObjectType.canBeSpecialisedByCategories() == IRepositoryObjectType.EnumCategorySupportType.YES);
            ImportJobObjectTypeCategoryReference importJobObjectTypeCategoryReference = new ImportJobObjectTypeCategoryReference(importedObject, mode);
            contentReferences.add(importJobObjectTypeCategoryReference);
        }
        for (final String string : widgetSpec.getPropertyTypeIDs()) {
            assert (string.length() == string.trim().length());
            IRepositoryPropertyTypeID propertyTypeID = new IRepositoryPropertyTypeID(){

                public String toCanonicalString() {
                    return string;
                }
            };
            ImportJobPropertyReference reference = new ImportJobPropertyReference(importedObject.getProperty(propertyTypeID), mode);
            contentReferences.add(reference);
        }
        for (Map.Entry entry : widgetSpec.getRelationTypeIDs2relationContributionRoleIDs().entrySet()) {
            final String relationTypeID = (String)entry.getKey();
            assert (relationTypeID.length() == relationTypeID.trim().length());
            IRepositoryRelationTypeID repositoryRelationTypeID = new IRepositoryRelationTypeID(){

                public String toCanonicalString() {
                    return relationTypeID;
                }
            };
            final String roleID = (String)entry.getValue();
            assert (roleID.length() == roleID.trim().length());
            IRepositoryRelationContributionRoleID repositoryRelationContributionRoleID = new IRepositoryRelationContributionRoleID(){

                public String toCanonicalString() {
                    return roleID;
                }
            };
            ImportJobRelationsReference reference = new ImportJobRelationsReference(repositoryRelationTypeID, repositoryRelationContributionRoleID, importedObject, mode);
            contentReferences.add(reference);
        }
        return contentReferences;
    }

    private static IWidgetTypeID getWidgetTypeID(IRepositoryPropertyTypeID repositoryPropertyTypeID, IRepositoryObjectType repositoryObjectType) {
        IRepositoryAttributeSetType repositoryAttributeSetType = repositoryObjectType.getAttributeSetType(repositoryPropertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(repositoryPropertyTypeID);
        IRepositoryDataType dataType = repositoryPropertyType.getDataType();
        WidgetTypeID widgetTypeID = WIDGET_TYPE_MAP.get(dataType.getClass());
        return widgetTypeID;
    }

    private static TableWidgetParameters getTableWidgetParameters(IRepositoryAttributeSetType attributeSetType, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendAttributeSetType frontendAttributeSetType = frontendTypeManager.getFrontendAttributeSetType(attributeSetType);
        String label = frontendAttributeSetType.getLabel().getText();
        if (label == null) {
            label = attributeSetType.getRepositoryAttributeSetTypeID().toCanonicalString();
        }
        return new TableWidgetParameters(label, "", true, 1);
    }

    private static WidgetParameters getPageWidgetParameters(IRepositoryAttributeSetType attributeSetType, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendAttributeSetType frontendAttributeSetType = frontendTypeManager.getFrontendAttributeSetType(attributeSetType);
        String label = frontendAttributeSetType.getLabel().getText();
        if (label == null) {
            label = attributeSetType.getRepositoryAttributeSetTypeID().toCanonicalString();
        }
        return new WidgetParameters(label, "", true);
    }

    private static WidgetParameters getRelationWidgetParameters(ICrossLinkRepositoryRelationContributionType repositoryRelationContributionType, IRepositoryObjectType repositoryObjectType, IImportedObject importedObject) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        ICollection_ relationContributionTypes = repositoryRelationContributionType.getRelatedRelationType().getAllRelationContributionTypes();
        ICrossLinkRepositoryRelationContributionType secondRelationContributionType = repositoryRelationContributionType;
        for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
            if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)relationContributionType.getRelatedObjectType().getRepositoryObjectTypeID(), (Object)importedObject.getObjectType().getObjectType().getRepositoryObjectTypeID())) continue;
            secondRelationContributionType = relationContributionType;
        }
        IRepositoryObjectType objectType = secondRelationContributionType.getRelatedObjectType();
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(objectType);
        String label = frontendObjectType.getLabel().getText();
        if (label == null) {
            label = repositoryRelationContributionType.getRelatedRelationType().getRepositoryRelationTypeID().toCanonicalString();
        }
        ICrossLinkRepositoryRelationType relationType = secondRelationContributionType.getRelatedRelationType();
        IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryTypeManager);
        IGenericModificationRelationType genericModificationRelationType = genericModificationTypeManager.getGenericModificationRelationType(relationType);
        boolean relationTypeModifiable = genericModificationRelationType.isCreatableAndDeletableGenerically();
        return new WidgetParameters(label, "", relationTypeModifiable);
    }

    private static WidgetParameters getPropertyWidgetParameters(IRepositoryPropertyTypeID propertyTypeID, IRepositoryObjectType repositoryObjectType) {
        IRepositoryTypeManagerRO repositoryTypeManager = repositoryObjectType.getRepositoryTypeManagerRO();
        IRepositoryAttributeSetType repositoryAttributeSetType = repositoryObjectType.getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendLabel label = frontendPropertyType.getLabel();
        IGenericModificationTypeManager genericModificationTypeManager = GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryTypeManager);
        IGenericModificationAttributeSetType genericModificationAttributeSetType = genericModificationTypeManager.getGenericModificationAttributeSetType(repositoryAttributeSetType);
        String widgetLabel = label.getText();
        boolean modifiable = genericModificationAttributeSetType.arePropertiesModifiableGenerically();
        boolean isFileProperty = IRepositoryDataTypeID.IS_EQUAL_DATA_TYPE_ID_HASHER.isEqual((Object)repositoryPropertyType.getDataType().getRepositoryDataTypeID(), (Object)RDTFile.DATA_TYPE_ID);
        if (!isFileProperty) {
            return new WidgetParameters(widgetLabel, widgetLabel, modifiable, 1, 1, true);
        }
        return new FileWidgetParameters(widgetLabel, widgetLabel, modifiable, false, 1, 1, true, FileWidgetParameters.Mode.SHOW_ALL);
    }

    public static HashMap<Object, WidgetTypeID> fillDefaultWidgetMap() {
        HashMap<Object, WidgetTypeID> map = new HashMap<Object, WidgetTypeID>();
        map.put(RDTBoolean.class, WidgetTypeID.BOOLEAN);
        map.put(RDTDuration64Bitmsec.class, WidgetTypeID.DURATION);
        map.put(RDTFreeString.class, WidgetTypeID.FREESTRING);
        map.put(RDTFreeText.class, WidgetTypeID.FREETEXT);
        map.put(RDTDateUTC64Bitmsec.class, WidgetTypeID.DATE);
        map.put(RDTDisplayName.class, WidgetTypeID.FREESTRING);
        map.put(RDTInteger32Bit.class, WidgetTypeID.FREESTRING);
        map.put(RDTInteger64Bit.class, WidgetTypeID.FREESTRING);
        map.put(RDTFloat64BitIEEE754.class, WidgetTypeID.FREESTRING);
        map.put(RDTLocale.class, WidgetTypeID.LANGUAGE);
        map.put(RDTUID.class, WidgetTypeID.FREESTRING);
        map.put(RDTURL.class, WidgetTypeID.URL);
        map.put(RDTFile.class, WidgetTypeID.FILE);
        map.put(RDTMultipleChoice.class, WidgetTypeID.MULTIPLECHOICE);
        map.put(RDTSingleChoice.class, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C0_0, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C0_1, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C0_n, WidgetTypeID.MULTIPLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C1_1, WidgetTypeID.SINGLECHOICE);
        map.put(RepositoryRelationContributionTypeCardinality.C1_n, WidgetTypeID.MULTIPLECHOICE);
        return map;
    }
}

