/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.general.modelaccess;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.FrontendRepositoryProperties;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RelatedObject;
import com.arcway.frontend.definition.lib.ui.widgetAdapter.IPrefixIDFormatPropertyTypeInformation;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXObjectReferenceCannotBeResolved;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.playground.IPropertyTypeInformation;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.RepositoryObjects;
import com.arcway.repository.interFace.data.RepositoryProperties;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositoryRelations;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.RepositoryRelationContributionTypeCardinality;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.RepositoryTypes;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IAbstractRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationSample;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTPrefixIDFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RepositoryAccessAgent {
    private static final ILogger LOGGER = Logger.getLogger(RepositoryAccessAgent.class);
    private static final IRepositoryObjectTypeCategoryID DEFAULT_OBJECT_TYPE_CATEGORY_ID = new IRepositoryObjectTypeCategoryID(){

        public String toCanonicalString() {
            return "__StringRepresentingTheDefaultObjectTypeCatgeoryIDInsteadOfNull__";
        }
    };
    private final IEditorModelAccess<?, ?, ?, ?> modelAccess;
    private final IRepositoryInterfaceRO repositoryInterface;

    public RepositoryAccessAgent(IRepositoryInterfaceRO repositoryInterface, IEditorModelAccess<?, ?, ?, ?> modelAccess) {
        this.repositoryInterface = repositoryInterface;
        this.modelAccess = modelAccess;
    }

    public Object getCurrentValueForProperty(IRepositoryPropertyReference propertyReference) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        Object returnVal = null;
        IRepositoryData value = null;
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryProperty property = RepositoryReferences.getPropertyFromReference((IRepositoryPropertyReference)propertyReference, (IRepositorySnapshotRO)snapshot);
            value = property.getValue();
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            throw new EEXObjectReferenceCannotBeResolved((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
        FrontendRepositoryProperties.FrontendRepositoryPropertyContext propertyContext = FrontendRepositoryProperties.getPropertyContext(propertyReference, this.repositoryInterface);
        returnVal = propertyContext.getFrontendDataType().getCurrentValueAsEditorValue(value, propertyContext.getFrontendDataTypeParameters());
        return returnVal;
    }

    public static <OBJECT_TYPE_CATEGORY_REFERENCE> ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<OBJECT_TYPE_CATEGORY_REFERENCE> getDefaultObjectTypeCategoryAsEditorValue(OBJECT_TYPE_CATEGORY_REFERENCE objectTypeCategoryReference) {
        return new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor(objectTypeCategoryReference, DEFAULT_OBJECT_TYPE_CATEGORY_ID.toCanonicalString());
    }

    public static boolean isDefaultObjectTypeCategory(ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<?> editorValue) {
        return DEFAULT_OBJECT_TYPE_CATEGORY_ID.toCanonicalString().equals(editorValue.getKey());
    }

    public boolean isObjectTypeSupportingObjectTypeCategories(IRepositoryObjectTypeID objectTypeID) {
        IRepositoryObjectType objectType = this.repositoryInterface.getTypeManager().getObjectType(objectTypeID);
        return objectType.canBeSpecialisedByCategories() == IRepositoryObjectType.EnumCategorySupportType.YES;
    }

    public <OBJECT_TYPE_CATEGORY_REFERENCE> ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<OBJECT_TYPE_CATEGORY_REFERENCE> getCurrentValueForObjectTypeCategory(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference, OBJECT_TYPE_CATEGORY_REFERENCE referenceForKey) throws EEXObjectReferenceCannotBeResolved, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObject object = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectTypeCategoryReference.getObjectReference(), (IRepositorySnapshotRO)snapshot);
            IRepositoryObjectTypeCategory objectTypeCategory = object.getObjectTypeCategory();
            ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor categoryIDAsEditorValue = objectTypeCategory != null ? new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor(referenceForKey, objectTypeCategory.getObjectTypeCategoryID().toCanonicalString()) : RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(referenceForKey);
            return categoryIDAsEditorValue;
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            throw new EEXObjectReferenceCannotBeResolved((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor getLabelForObjectTypeCategory(final ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<?> key, IRepositoryObjectTypeID objectTypeID) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        if (!RepositoryAccessAgent.isDefaultObjectTypeCategory(key)) {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            IRepositoryObjectTypeCategory category = snapshot.getObjectTypeCategory(new IRepositoryObjectTypeCategoryID(){

                public String toCanonicalString() {
                    return key.getKey();
                }
            });
            try {
                return new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor(category.getDisplayName(), category.getIcon());
            }
            catch (EXNotReproducibleSnapshot eNRS) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)eNRS));
            }
        }
        return this.getLabelForDefaultObjectTypeCategory(objectTypeID);
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor getLabelForDefaultObjectTypeCategory(IRepositoryObjectTypeID objectTypeID) {
        return new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryLabelForEditor(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY, this.getObjectTypeIcon16x16(objectTypeID));
    }

    public <OBJECT_TYPE_CATEGORY_REFERENCE> IList_<ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<OBJECT_TYPE_CATEGORY_REFERENCE>> getValueRangeKeysOfObjectTypeCategoryAsEditorValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference, OBJECT_TYPE_CATEGORY_REFERENCE referenceForKeys) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        IRepositoryObjectTypeID objectTypeID = objectTypeCategoryReference.getObjectReference().getObjectTypeID();
        IRepositoryObjectType objectType = this.repositoryInterface.getTypeManager().getObjectType(objectTypeID);
        IList_ allObjectTypeCategoriesForObjectType = snapshot.getAllObjectTypeCategoriesForObjectType(objectType);
        ArrayList_ keys = new ArrayList_();
        keys.add(RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(referenceForKeys));
        for (IRepositoryObjectTypeCategory category : allObjectTypeCategoriesForObjectType) {
            keys.add((Object)new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor(referenceForKeys, category.getObjectTypeCategoryID().toCanonicalString()));
        }
        return keys;
    }

    public <OBJECT_TYPE_CATEGORY_REFERENCE> boolean isPropertyVisibleForCategory(IRepositoryPropertyReference propertyReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<OBJECT_TYPE_CATEGORY_REFERENCE> objectTypeCategory) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.isPropertyVisibleForCategory(propertyReference.getObjectReference().getObjectTypeID(), propertyReference.getPropertyTypeID(), objectTypeCategory);
    }

    public <OBJECT_TYPE_CATEGORY_REFERENCE> boolean isPropertyVisibleForCategory(IRepositoryObjectTypeID objectTypeID, IRepositoryPropertyTypeID propertyTypeID, final ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<OBJECT_TYPE_CATEGORY_REFERENCE> objectTypeCategory) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        IRepositoryObjectType objectType = this.repositoryInterface.getTypeManager().getObjectType(objectTypeID);
        IRepositoryPropertyType propertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)propertyTypeID);
        if (propertyType.isCategoryIndependentlyFixProperty()) {
            return true;
        }
        if (RepositoryAccessAgent.isDefaultObjectTypeCategory(objectTypeCategory)) {
            return true;
        }
        IRepositoryObjectTypeCategory category = snapshot.getObjectTypeCategory(new IRepositoryObjectTypeCategoryID(){

            public String toCanonicalString() {
                return objectTypeCategory.getKey();
            }
        });
        return category.getVisibleProperties().contains((Object)propertyTypeID);
    }

    public final IStreamResource getObjectIcon16x16(IRepositoryObjectReference repositoryObjectReference, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        return this.getObjectIcon16x16(repositoryObjectReference.getObjectTypeID(), repositoryObjectReference.getObjectID(), presentationContext);
    }

    public final IStreamResource getObjectIcon16x16(IRepositoryObjectTypeID repositoryObjectTypeID, IRepositoryPropertySetSample repositoryObjectID, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(repositoryObjectTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
        IStreamResource[] objectIcon = new IStreamResource[1];
        IRepositorySnapshotRO repositorySnapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)repositorySnapshot);
        try {
            IRepositoryObject repositoryObject = repositorySnapshot.findRepositoryObject(repositoryObjectType, repositoryObjectID);
            if (repositoryObject != null) {
                objectIcon[0] = frontendTypeManager.getLabelForObject(repositoryObject, presentationContext).getIcon16x16();
            }
            if (objectIcon[0] == null) {
                objectIcon[0] = frontendObjectType.getLabel().getIcon16x16();
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        return objectIcon[0];
    }

    public final IStreamResource getObjectIcon16x16(IRepositoryObjectSample repositoryObjectSample, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IRepositorySnapshotRO repositorySnapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)repositorySnapshot);
        return frontendTypeManager.getLabelForObject(repositoryObjectSample, presentationContext).getIcon16x16();
    }

    public final IStreamResource getObjectTypeIcon16x16(IRepositoryObjectReference repositoryObjectReference) {
        return this.getObjectTypeIcon16x16(repositoryObjectReference.getObjectTypeID());
    }

    public final IStreamResource getObjectTypeIcon16x16(IRepositoryObjectTypeID repositoryObjectTypeID) {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(repositoryObjectTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
        return frontendObjectType.getLabel().getIcon16x16();
    }

    public String getObjectName(IRepositoryObjectReference objectReference, PresentationContext presentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryObjectTypeID repositoryObjectTypeID = objectReference.getObjectTypeID();
        IRepositoryPropertySetSample repositoryObjectID = objectReference.getObjectID();
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        IRepositoryObjectType repositoryObjectType = repositoryTypeManager.getObjectType(repositoryObjectTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
        IFrontendObjectType frontendObjectType = frontendTypeManager.getFrontendObjectType(repositoryObjectType);
        String[] objectName = new String[1];
        IRepositorySnapshotRO repositorySnapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)repositorySnapshot);
        try {
            IRepositoryObject repositoryObject = repositorySnapshot.findRepositoryObject(repositoryObjectType, repositoryObjectID);
            if (repositoryObject != null) {
                objectName[0] = frontendTypeManager.getLabelForObject(repositoryObject, presentationContext).getText();
            }
            if (objectName[0] == null) {
                objectName[0] = frontendObjectType.getLabel().getText();
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        return objectName[0];
    }

    public IRepositoryObjectReference getParent(IRepositoryObjectReference objectReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXObjectReferenceCannotBeResolved {
        RepositoryObjectReference returnVal = null;
        try {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            IRepositoryObject parentObject = null;
            IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectReference, (IRepositorySnapshotRO)snapshot);
            parentObject = this.getParent(repositoryObject);
            if (parentObject != null) {
                returnVal = new RepositoryObjectReference(parentObject);
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            throw new EEXObjectReferenceCannotBeResolved((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
        return returnVal;
    }

    public final List<Object> getAncestorsCurrentValuesForProperty(IRepositoryObjectReference objectReference, IRepositoryObjectTypeID propertyOwningObjectTypeID, IRepositoryPropertyTypeID propertyTypeID, int maximumNumberOfSteps) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        try {
            ArrayList<Object> ancestorsValues = new ArrayList<Object>();
            int step = 0;
            IRepositoryObjectReference currentObjectReference = objectReference;
            do {
                ++step;
                if (!this.isPropertyDefinedForObject(currentObjectReference.getObjectTypeID(), propertyOwningObjectTypeID, propertyTypeID)) continue;
                Object propertyValue = this.getCurrentValueForProperty((IRepositoryPropertyReference)new RepositoryPropertyReference(currentObjectReference, propertyTypeID));
                ancestorsValues.add(propertyValue);
            } while ((currentObjectReference = this.getParent(currentObjectReference)) != null && (step == 0 || step < maximumNumberOfSteps));
            return ancestorsValues;
        }
        catch (EEXObjectReferenceCannotBeResolved eORCNBR) {
            assert (false);
            return Collections.emptyList();
        }
    }

    public String getObjectPath(IRepositoryObjectReference objectReference, PresentationContext currentPresentationContext) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getObjectName(objectReference, currentPresentationContext));
            IRepositoryObjectReference parent = this.getParent(objectReference);
            while (parent != null) {
                buffer.insert(0, String.valueOf(this.getObjectName(parent, currentPresentationContext)) + " / ");
                parent = this.getParent(parent);
            }
            return buffer.toString();
        }
        catch (EEXObjectReferenceCannotBeResolved eORCBR) {
            return null;
        }
    }

    public boolean isPropertyDefinedForObject(IRepositoryObjectTypeID objectTypeInQuestion, IRepositoryObjectTypeID propertyOwningObjectTypeID, IRepositoryPropertyTypeID propertyTypeID) {
        IRepositoryObjectType objectTypeOfObjectInQuestion;
        IRepositoryObjectType objectTypeOfPropertyOwner = this.repositoryInterface.getTypeManager().getObjectType(propertyOwningObjectTypeID);
        IRepositoryObjectType commonSuperObjectType = RepositoryObjectTypes.findCommonSuperObjectType((IRepositoryObjectType)objectTypeOfPropertyOwner, (IRepositoryObjectType)(objectTypeOfObjectInQuestion = this.repositoryInterface.getTypeManager().getObjectType(objectTypeInQuestion)));
        return RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)commonSuperObjectType, (IRepositoryPropertyTypeID)propertyTypeID) != null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRepositoryPropertyReference getParentsPropertyReference(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        returnVal = null;
        propertyTypeID = propertyReference.getPropertyTypeID();
        objectReference = propertyReference.getObjectReference();
        objectTypeID = objectReference.getObjectTypeID();
        hasher = IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER;
        try {
            snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            if (snapshot == null) {
                return null;
            }
            parentObject = null;
            try {
                repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectReference, (IRepositorySnapshotRO)snapshot);
                parentObject = this.getParent(repositoryObject);
                ** GOTO lbl17
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                return null;
lbl17:
                // 1 sources

                if (true) ** GOTO lbl23
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            RepositoryAccessAgent.LOGGER.error("EXNotReproducibleSnapshot", (Throwable)e);
            throw new EEXNotReproducibleSnapshot((Exception)e);
        }
        do {
            parentObject = this.getParent(parentObject);
lbl23:
            // 2 sources

        } while (parentObject != null && !hasher.isEqual((Object)objectTypeID, (Object)parentObject.getObjectType().getRepositoryObjectTypeID()));
        if (parentObject == null) {
            return returnVal;
        }
        typeManager = this.repositoryInterface.getTypeManager();
        objectType = typeManager.getObjectType(objectTypeID);
        repositoryAttributeSetType = objectType.getAttributeSetType(propertyTypeID);
        repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        property = parentObject.getAttributeSet(repositoryAttributeSetType).getProperty(repositoryPropertyType);
        return new RepositoryPropertyReference(property);
    }

    public ISet_<RelatedObject> getRelationContributorsOfExistingRelations(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        HashSet_ existingRelations = new HashSet_(RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        try {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
            for (ICrossLinkRepositoryRelationType instantiableRelationType : relationType.getAllInstanciableRelationTypesOfThisType()) {
                ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)instantiableRelationType.getRepositoryRelationTypeID(), (IRepositoryRelationContributionRoleID)roleID1, (IRepositoryPropertySetSample)objectID1);
                IRepositoryIterator_ICrossLinkRepositoryRelation relations = RepositoryReferences.getAllRelationsFromReference((ICrossLinkRepositoryRelationsReference)relationsReference, (IRepositorySnapshotRO)snapshot);
                ICrossLinkRepositoryRelationContributionType contributionType2 = RepositoryAccessAgent.getSecondContributionType(instantiableRelationType, roleID1);
                while (relations.hasNext()) {
                    ICrossLinkRepositoryRelation relation = relations.nextIRepositoryRelation();
                    ICrossLinkRepositoryRelationContribution relationContribution = relation.getRelationContribution(contributionType2);
                    IRepositoryObject object = relationContribution.getAttributeSet().getObject();
                    existingRelations.add((Object)new RelatedObject(contributionType2, (IRepositoryObjectReference)new RepositoryObjectReference(object)));
                }
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXMissingCrossLinkTarget eXMissingCrossLinkTarget) {
            // empty catch block
        }
        return existingRelations;
    }

    public ISet_<RelatedObject> getPotentialRelationContributors(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1, boolean relationsWithPermissionOnly) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        HashSet_ potentialRelationContributors = new HashSet_(RelatedObject.IS_EQUAL_RELATED_OBJECT_HASHER);
        try {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
            ISet_<RelatedObject> relationContributorsOfExistingRelations = this.getRelationContributorsOfExistingRelations(relationTypeID, roleID1, objectID1);
            for (ICrossLinkRepositoryRelationType instantiableRelationType : relationType.getAllInstanciableRelationTypesOfThisType()) {
                ICrossLinkRepositoryRelationContributionType contributionType2 = null;
                for (ICrossLinkRepositoryRelationContributionType relationContributionType : instantiableRelationType.getAllRelationContributionTypes()) {
                    if (this.equalRelationContributionRoleID(roleID1, relationContributionType.getRepositoryRelationContributionRoleID())) continue;
                    contributionType2 = relationContributionType;
                    break;
                }
                assert (contributionType2 != null);
                IRepositoryIterator_IRepositoryObject objects = snapshot.findAllObjectOfType(contributionType2.getRelatedObjectType());
                while (objects.hasNext()) {
                    int maximumRCsOfSecondObject;
                    RelatedObject relatedObject;
                    IRepositoryAttributeSetType idAttributeSetType;
                    IRepositoryObject object = objects.nextIRepositoryObject();
                    IRepositoryPropertySetSample secondRepositoryObjectID = object.getAttributeSet(idAttributeSetType = object.getObjectType().getIDAttributeSetType()).sample();
                    if (this.equalPropertySetSamples(objectID1, secondRepositoryObjectID) || relationContributorsOfExistingRelations.contains((Object)(relatedObject = new RelatedObject(contributionType2, (IRepositoryObjectReference)new RepositoryObjectReference(object))))) continue;
                    boolean showRelation = contributionType2.getCardinality().isMaximumInfinite() ? true : ((maximumRCsOfSecondObject = contributionType2.getCardinality().getMaximum()) == 0 ? false : (maximumRCsOfSecondObject == 1 ? !this.hasExistingRelations(relationTypeID, contributionType2.getRepositoryRelationContributionRoleID(), secondRepositoryObjectID) : true));
                    if (showRelation && relationsWithPermissionOnly && relationsWithPermissionOnly) {
                        try {
                            this.modelAccess.getLockAndPermissionProvider().checkPermissionForCreateOrDeleteRelation((Object)relationTypeID, (Object)roleID1, (Object)objectID1, (Object)new RepositoryObjectReference(object));
                        }
                        catch (EEXNotReproducibleSnapshot e) {
                            throw e;
                        }
                        catch (Exception e) {
                            showRelation = false;
                        }
                    }
                    if (!showRelation) continue;
                    potentialRelationContributors.add((Object)relatedObject);
                }
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            LOGGER.error("EXNotReproducibleSnapshot", (Throwable)e);
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        return potentialRelationContributors;
    }

    public Map<String, String> getValueRangeForPropertyAsEditorValue(IRepositoryPropertyReference propertyReference) {
        return FrontendRepositoryProperties.getValueRangeForEnumerationProperty(FrontendRepositoryProperties.getPropertyContext(propertyReference, this.repositoryInterface));
    }

    public Map<String, String> getValueRangeForPropertyAsEditorValue(IRepositoryPropertyType repositoryPropertyType) {
        return FrontendRepositoryProperties.getValueRangeForEnumerationProperty(FrontendRepositoryProperties.getPropertyContext(repositoryPropertyType, this.repositoryInterface));
    }

    public ISortedSet_<String> getValueRangeKeysForPropertyAsEditorValue(IRepositoryPropertyReference propertyReference) {
        return RepositoryProperties.getValueRangeKeysForEnumerationProperty((RepositoryProperties.RepositoryPropertyContext)RepositoryProperties.getPropertyContext((IRepositoryPropertyReference)propertyReference, (IRepositoryInterfaceRO)this.repositoryInterface));
    }

    public ISortedSet_<String> getValueRangeKeysForPropertyAsEditorValue(IRepositoryPropertyType repositoryPropertyType) {
        return RepositoryProperties.getValueRangeKeysForEnumerationProperty((RepositoryProperties.RepositoryPropertyContext)RepositoryProperties.getPropertyContext((IRepositoryPropertyType)repositoryPropertyType));
    }

    public boolean isDatePropertyWithTimeComponent(IRepositoryPropertyReference propertyReference) {
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
        IRepositoryObjectTypeID objectTypeID = propertyReference.getObjectReference().getObjectTypeID();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        IRepositoryAttributeSetType repositoryAttributeSetType = objectType.getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        boolean isWithTimeComponent = ((RDTDateUTC64Bitmsec.Parameters)repositoryPropertyType.getDataTypeParameters()).isWithTimeComponent();
        return isWithTimeComponent;
    }

    public RepositoryRelationContributionTypeCardinality getCardinality(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID) {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        ICrossLinkRepositoryRelationType relationType = repositoryTypeManager.getCrossLinkRelationType(relationTypeID);
        ICrossLinkRepositoryRelationContributionType relationContributionType = relationType.getRelationContributionType(roleID);
        return relationContributionType.getCardinality();
    }

    public boolean isRelationPossible(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1, IRepositoryObjectReference objectReference2) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        IRepositoryPropertySetSample secondObjectObjectID = objectReference2.getObjectID();
        IRepositoryObjectTypeID secondObjectObjectTypeID = objectReference2.getObjectTypeID();
        IRepositoryObjectType secondObjectObjectType = repositoryTypeManager.getObjectType(secondObjectObjectTypeID);
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        try {
            IRepositoryObject secondObject = snapshot.findRepositoryObject(secondObjectObjectType, secondObjectObjectID);
            if (secondObject == null) {
                return false;
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        ICrossLinkRepositoryRelationType relationType = repositoryTypeManager.getCrossLinkRelationType(relationTypeID);
        IRepositoryPropertySetSample firstObjectObjectID = objectID1;
        ICrossLinkRepositoryRelationContributionType firstObjectRelationContributionType = relationType.getRelationContributionType(roleID1);
        if (this.equalPropertySetSamples(secondObjectObjectID, firstObjectObjectID)) {
            return false;
        }
        IList_ types = RepositoryTypes.findPossibleRelationContributionTypes((ICrossLinkRepositoryRelationContributionType)firstObjectRelationContributionType, (IRepositoryObjectType)secondObjectObjectType);
        return !types.isEmpty();
    }

    public boolean relationContributorExists(IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1, ICrossLinkRepositoryRelationSample relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ICrossLinkRepositoryRelationSample repositoryRelationSample = relationSample;
        ISet_ relationContributionRoleIDs = repositoryRelationSample.getRelationContributionRoleIDs();
        for (IRepositoryRelationContributionRoleID roleID : relationContributionRoleIDs) {
            if (this.equalRelationContributionRoleID(roleID1, roleID)) continue;
            IRepositoryPropertySetSample objectID = repositoryRelationSample.getObjectID(roleID);
            if (this.equalPropertySetSamples(objectID1, objectID)) {
                return true;
            }
            IRepositorySnapshotRO repositorySnapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)repositorySnapshot);
            ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(repositoryRelationSample.getRelationTypeID());
            ICrossLinkRepositoryRelationContributionType relationContributionType = relationType.getRelationContributionType(roleID);
            IRepositoryObjectType objectType = relationContributionType.getRelatedObjectType();
            try {
                IRepositoryObject object = repositorySnapshot.findRepositoryObject(objectType, objectID);
                if (object == null) continue;
                return true;
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
        }
        return false;
    }

    public boolean relationExists(Object relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ICrossLinkRepositoryRelationSample repositoryRelationSample = (ICrossLinkRepositoryRelationSample)relationSample;
        ICrossLinkRepositoryRelation relation = this.getRepositoryRelation(repositoryRelationSample);
        return relation != null;
    }

    public boolean relationExists(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1, IRepositoryObjectReference objectReference2) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryTypeManagerRO repositoryTypeManager = this.repositoryInterface.getTypeManager();
        HashMap_ contributionMap = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        contributionMap.put((Object)roleID1, (Object)objectID1);
        ICrossLinkRepositoryRelationType relationType = repositoryTypeManager.getCrossLinkRelationType(relationTypeID);
        ICrossLinkRepositoryRelationContributionType firstObjectRelationContributionType = relationType.getRelationContributionType(roleID1);
        IRepositoryObjectTypeID objectTypeID = objectReference2.getObjectTypeID();
        IRepositoryObjectType objectType = repositoryTypeManager.getObjectType(objectTypeID);
        IList_ types = RepositoryTypes.findPossibleRelationContributionTypes((ICrossLinkRepositoryRelationContributionType)firstObjectRelationContributionType, (IRepositoryObjectType)objectType);
        for (ICrossLinkRepositoryRelationContributionType type : types) {
            contributionMap.put((Object)type.getRepositoryRelationContributionRoleID(), (Object)objectReference2.getObjectID());
        }
        CrossLinkRepositoryRelationSample relationSample = new CrossLinkRepositoryRelationSample(relationTypeID, (IMap_)contributionMap);
        ICrossLinkRepositoryRelation relation = null;
        try {
            relation = RepositoryRelations.findCrossLinkRelation((ICrossLinkRepositoryRelationSample)relationSample, (IRepositorySnapshotRO)((IRepositorySnapshotRO)this.modelAccess.getSnapshot()));
        }
        catch (EXMissingCrossLinkTarget e) {
            return false;
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        return relation != null;
    }

    protected boolean equalPropertySetSamples(IRepositoryPropertySetSample sample1, IRepositoryPropertySetSample sample2) {
        return IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)sample2, (Object)sample1);
    }

    protected boolean equalRelationContributionRoleID(IRepositoryRelationContributionRoleID roleID1, IRepositoryRelationContributionRoleID roleID2) {
        return IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID2, (Object)roleID1);
    }

    protected boolean equalRelationContributionTypes(ICrossLinkRepositoryRelationContributionType type1, ICrossLinkRepositoryRelationContributionType type2) {
        return IAbstractRepositoryRelationContributionType.IS_EQUAL_IRELATION_CONTRIBUTION_HASHER.isEqual((Object)type2, (Object)type1);
    }

    public IRepositoryObject getParent(IRepositoryObject repositoryObject) throws EXNotReproducibleSnapshot {
        IRepositoryObject result = RepositoryObjects.getParentObject((IRepositoryObject)repositoryObject);
        return result;
    }

    private ICrossLinkRepositoryRelation getRepositoryRelation(ICrossLinkRepositoryRelationSample repositoryRelationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ICrossLinkRepositoryRelation relation = null;
        try {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            relation = RepositoryRelations.findCrossLinkRelation((ICrossLinkRepositoryRelationSample)repositoryRelationSample, (IRepositorySnapshotRO)snapshot);
            return relation;
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXMissingCrossLinkTarget ex) {
            return null;
        }
    }

    public IHasher_<Object> getEnumerationValueHasher() {
        return IHasher_.EQUALS_HASHER;
    }

    private boolean hasExistingRelations(Object relationTypeID, Object roleID, Object objectID) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryRelationTypeID repositoryRelationTypeID = (IRepositoryRelationTypeID)relationTypeID;
        IRepositoryRelationContributionRoleID repositoryRelationContributionRoleID = (IRepositoryRelationContributionRoleID)roleID;
        IRepositoryPropertySetSample repositoryObjectID = (IRepositoryPropertySetSample)objectID;
        boolean[] hasExistingRelations = new boolean[1];
        IRepositorySnapshotRO repositorySnapshot = (IRepositorySnapshotRO)this.modelAccess.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)repositorySnapshot);
        ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)repositoryRelationTypeID, (IRepositoryRelationContributionRoleID)repositoryRelationContributionRoleID, (IRepositoryPropertySetSample)repositoryObjectID);
        try {
            IRepositoryIterator_ICrossLinkRepositoryRelation relations = RepositoryReferences.getAllRelationsFromReference((ICrossLinkRepositoryRelationsReference)relationsReference, (IRepositorySnapshotRO)repositorySnapshot);
            hasExistingRelations[0] = relations.hasNext();
            if (hasExistingRelations[0]) {
                relations.abortIteration();
            }
        }
        catch (EXMissingCrossLinkTarget ex) {
            hasExistingRelations[0] = false;
            LOGGER.error("EXReferenceCannotBeResolved", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (EXNotReproducibleSnapshot ex) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)ex));
        }
        return hasExistingRelations[0];
    }

    public static ICrossLinkRepositoryRelationContributionType getSecondContributionType(ICrossLinkRepositoryRelationType relationType, IRepositoryRelationContributionRoleID roleID1) {
        ICrossLinkRepositoryRelationContributionType contributionType2 = null;
        for (ICrossLinkRepositoryRelationContributionType contributionType : relationType.getAllRelationContributionTypes()) {
            if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID1, (Object)contributionType.getRepositoryRelationContributionRoleID())) continue;
            contributionType2 = contributionType;
            break;
        }
        assert (contributionType2 != null);
        return contributionType2;
    }

    public static IPropertyTypeInformation getPropertyTypeInformation(IRepositoryObjectType objectType, IRepositoryPropertyTypeID propertyTypeID) {
        final IRepositoryPropertyType propertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)propertyTypeID);
        if (propertyType.getDataType() instanceof RDTPrefixIDFormat) {
            return new IPrefixIDFormatPropertyTypeInformation(){

                @Override
                public String getDefaultPrefix() {
                    RDTPrefixIDFormat.PrefixIDFormatParameters parameters = (RDTPrefixIDFormat.PrefixIDFormatParameters)propertyType.getDataTypeParameters();
                    return parameters.getDefaultPrefix();
                }
            };
        }
        return null;
    }
}

