/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.type.exceptions;

import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabelWithDecorator;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabelWithDecorator;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.Messages;
import com.arcway.lib.icons.Decorators7x8;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.exceptions.ExceptionCategory;
import com.arcway.repository.interFace.exceptions.ExceptionLevel;
import com.arcway.repository.interFace.exceptions.IMessageSet;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;

public class RepositoryAccessExceptionLabelProvider {
    private static final PresentationContext DUMMY_PRESENTATION_CONTEXT = PresentationContext.getVirtualMachineUserLocaleForNow();

    public static IStreamResource getIconForException(RepositoryAccessException exception) {
        ExceptionCategory exceptionCategory = exception.getExceptionCategory();
        IFrontendLabelWithDecorator frontendLabel = RepositoryAccessExceptionLabelProvider.getExceptionCategoryLabel(exceptionCategory, DUMMY_PRESENTATION_CONTEXT);
        return frontendLabel.getIcon16x16();
    }

    public static IStreamResource getDecoratorForMessageSet(IMessageSet messageSet) {
        ExceptionLevel level;
        IStreamResource decorator = null;
        ExceptionCategory category = messageSet.getUniqueCategory();
        if (category != null) {
            decorator = RepositoryAccessExceptionLabelProvider.getExceptionCategoryLabel(category, DUMMY_PRESENTATION_CONTEXT).getDecorator8x8();
        }
        if (decorator == null && (level = messageSet.getHighestLevel()) != null) {
            decorator = RepositoryAccessExceptionLabelProvider.getExceptionLevelLabel(level, DUMMY_PRESENTATION_CONTEXT).getDecorator8x8();
        }
        return decorator;
    }

    public static IFrontendLabelWithDecorator getExceptionLevelLabel(ExceptionLevel exceptionLevel, PresentationContext presentationContext) {
        FrontendLabelWithDecorator label = null;
        switch (exceptionLevel) {
            case INFORMATION: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.LevelLabel.Information", presentationContext.getLocale()), Icons16x16.INFO, Decorators7x8.INFO);
                break;
            }
            case WARNING: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.LevelLabel.Warning", presentationContext.getLocale()), Icons16x16.WARNING, Decorators7x8.WARNING);
                break;
            }
            case EXCEPTION: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.LevelLabel.Exception", presentationContext.getLocale()), Icons16x16.ERROR, Decorators7x8.ERROR);
            }
        }
        return label;
    }

    public static IFrontendLabelWithDecorator getExceptionCategoryLabel(ExceptionCategory exceptionCategory, PresentationContext presentationContext) {
        FrontendLabelWithDecorator label = null;
        switch (exceptionCategory) {
            case LOCK_DENIED: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.LockDenied", presentationContext.getLocale()), Icons16x16.LOCK, Decorators7x8.ERROR);
                break;
            }
            case LOCK_MISSING: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.LockMissing", presentationContext.getLocale()), Icons16x16.INFO, Decorators7x8.INFO);
                break;
            }
            case PERMISSION_DENIED: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.PermissionDenied", presentationContext.getLocale()), Icons16x16.PERMISSION, Decorators7x8.ERROR);
                break;
            }
            case MODIFIED_DATA: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.ConflictingData", presentationContext.getLocale()), Icons16x16.MODIFIED, Decorators7x8.WARNING);
                break;
            }
            case INVALID_DATA: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.InvalidData", presentationContext.getLocale()), Icons16x16.ERROR, Decorators7x8.ERROR);
                break;
            }
            case INVALID_PROPERTY_DATA: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.InvalidPropertyData", presentationContext.getLocale()), Icons16x16.ERROR, Decorators7x8.ERROR);
                break;
            }
            case BLOCKING_INVALID_OPERATION: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.InvalidOperation", presentationContext.getLocale()), Icons16x16.ERROR, Decorators7x8.ERROR);
                break;
            }
            case NON_BLOCKING_INVALID_OPERATION: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.InvalidOperation", presentationContext.getLocale()), Icons16x16.INFO, Decorators7x8.INFO);
                break;
            }
            case TRANSACTION_EXECUTION: {
                label = new FrontendLabelWithDecorator(Messages.getString("RepositoryExceptionLabelProvider.CategoryLabel.TransactionExecution", presentationContext.getLocale()), Icons16x16.ERROR, Decorators7x8.ERROR);
            }
        }
        return label;
    }
}

