/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendObjectType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public class LabelCreationContext {
    private final IFrontendTypeManager frontendTypeManager;
    private final IRepositoryObjectType repositoryObjectType;
    private final IRepositoryObjectSample repositoryObjectSample;
    private final IRepositoryObject repositoryObject;
    private final PresentationContext userLocale;
    private final IRepositoryData now;

    public LabelCreationContext(IFrontendTypeManager frontendTypeManager, IRepositoryObject repositoryObject, PresentationContext userLocale) {
        this.frontendTypeManager = frontendTypeManager;
        this.repositoryObjectType = repositoryObject.getObjectType();
        this.repositoryObject = repositoryObject;
        this.repositoryObjectSample = null;
        this.userLocale = userLocale;
        RDTDateUTC64Bitmsec rdtDateUTC64Bitmsec = RDTDateUTC64Bitmsec.getInstance();
        try {
            IRepositoryData repositoryData = rdtDateUTC64Bitmsec.createData(userLocale.getNow());
            rdtDateUTC64Bitmsec.snapAndCheckData(repositoryData, (IRepositoryDataTypeParameters)RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_ALWAYS__FULL_RANGE__DATE_AND_TIME__IN_MS);
            this.now = repositoryData;
        }
        catch (AbstractRepositoryDataType.EXValueNotSet e) {
            throw new RuntimeException(e);
        }
        catch (EXValueInvalid e) {
            throw new RuntimeException(e);
        }
    }

    public LabelCreationContext(IFrontendTypeManager frontendTypeManager, IRepositoryObjectSample repositoryObjectSample, PresentationContext userLocale) {
        IRepositoryTypeManagerRO repositoryTypeManager = frontendTypeManager.getRepositoryTypeManager();
        this.frontendTypeManager = frontendTypeManager;
        this.repositoryObjectType = repositoryTypeManager.getObjectType(repositoryObjectSample.getObjectTypeID());
        this.repositoryObject = null;
        this.repositoryObjectSample = repositoryObjectSample;
        this.userLocale = userLocale;
        RDTDateUTC64Bitmsec rdtDateUTC64Bitmsec = RDTDateUTC64Bitmsec.getInstance();
        this.now = rdtDateUTC64Bitmsec.getNow();
    }

    public IRepositoryTypeManagerRO getRepositoryTypeManager() {
        return this.frontendTypeManager.getRepositoryTypeManager();
    }

    public IFrontendObjectType getFrontendObjectType() {
        return this.frontendTypeManager.getFrontendObjectType(this.repositoryObjectType);
    }

    public IRepositoryData getPropertyValue(IRepositoryPropertyTypeID propertyTypeID) {
        IRepositoryPropertySetSample propertySetSample;
        IRepositoryPropertySample propertySample;
        IRepositoryPropertyType repositoryPropertyType = this.getPropertyType(propertyTypeID);
        IRepositoryData propertyValue = null;
        if (this.repositoryObject != null) {
            try {
                propertyValue = this.repositoryObject.getAttributeSet(this.repositoryObjectType.getAttributeSetType(propertyTypeID)).getProperty(repositoryPropertyType).getValue();
            }
            catch (Throwable e) {
                propertyValue = null;
            }
        } else if (this.repositoryObjectSample != null && (propertySample = (propertySetSample = this.repositoryObjectSample.getPropertySetSample()).getPropertySample(propertyTypeID)) != null) {
            propertyValue = this.repositoryObjectSample.getPropertySetSample().getPropertySample(propertyTypeID).getValue();
        }
        return propertyValue;
    }

    public IRepositoryObjectTypeCategoryID getObjectTypeCategoryID() {
        IRepositoryObjectTypeCategoryID categoryID = null;
        if (this.repositoryObject != null) {
            categoryID = this.repositoryObject.getObjectTypeCategory() != null ? this.repositoryObject.getObjectTypeCategory().getObjectTypeCategoryID() : null;
        } else if (this.repositoryObjectSample != null) {
            categoryID = this.repositoryObjectSample.getObjectTypeCategoryID();
        }
        return categoryID;
    }

    public IRepositoryPropertyType getPropertyType(IRepositoryPropertyTypeID propertyTypeID) {
        IRepositoryPropertyType repositoryPropertyType = this.repositoryObjectType.getAttributeSetType(propertyTypeID).getPropertyType(propertyTypeID);
        return repositoryPropertyType;
    }

    public IFrontendLabel getFrontendPropertyValueLabel(IRepositoryPropertyTypeID propertyTypeID) {
        IFrontendLabel labelForPropertyValue;
        IRepositoryData propertyValue = this.getPropertyValue(propertyTypeID);
        if (propertyValue != null) {
            IRepositoryPropertyType repositoryPropertyType = this.getPropertyType(propertyTypeID);
            IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
            IRepositoryDataTypeParameters repositoryDataTypeParameters = repositoryPropertyType.getDataTypeParameters();
            IFrontendPropertyType frontendPropertyType = this.frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
            IFrontendDataType frontendDataType = this.frontendTypeManager.getFrontendDataType(repositoryDataType);
            IFrontendDataTypeParameters frontendDataTypeParameters = frontendPropertyType.getFrontendDataTypeParameters();
            labelForPropertyValue = frontendDataType.getLabelForValue(propertyValue, repositoryDataTypeParameters, frontendDataTypeParameters, this.userLocale);
        } else {
            labelForPropertyValue = FrontendLabel.NULL_LABEL;
        }
        return labelForPropertyValue;
    }

    public IRepositoryData getNow() {
        return this.now;
    }

    public IRepositoryDataTypeParameters getRepositoryDataTypeParametersForNow(boolean withTimeComponent) {
        if (withTimeComponent) {
            return RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_AND_TIME__IN_MS;
        }
        return RDTDateUTC64Bitmsec.Parameters.PARAMETERS__IS_SET_POTENTIALLY__FULL_RANGE__DATE_ONLY;
    }
}

