/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.ExpirationHelper;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.LabelCreationContext;
import com.arcway.lib.java.Assert;
import com.arcway.lib.resource.IStreamResource;
import java.util.Date;

public class IconIf
implements Icon {
    private final Condition ifCondition;
    private final Icon thenIcon;
    private final Icon elseIcon;

    public IconIf(Condition ifCondition, Icon thenIcon, Icon elseIcon) {
        Assert.checkArgumentBeeingNotNull((Object)ifCondition);
        Assert.checkArgumentBeeingNotNull((Object)thenIcon);
        Assert.checkArgumentBeeingNotNull((Object)elseIcon);
        this.ifCondition = ifCondition;
        this.thenIcon = thenIcon;
        this.elseIcon = elseIcon;
    }

    @Override
    public IStreamResource getIcon(LabelCreationContext context) {
        IStreamResource icon = this.ifCondition.isTrue(context) ? this.thenIcon.getIcon(context) : this.elseIcon.getIcon(context);
        return icon;
    }

    @Override
    public Date expires(LabelCreationContext labelCreationContext) {
        Date valueExpirationDate = this.ifCondition.isTrue(labelCreationContext) ? this.thenIcon.expires(labelCreationContext) : this.elseIcon.expires(labelCreationContext);
        return ExpirationHelper.getEarliestDate(new Date[]{this.ifCondition.expires(labelCreationContext), valueExpirationDate});
    }
}

