/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.LabelCreationContext;
import com.arcway.lib.java.Assert;
import java.util.Date;

public class ConditionOr
implements Condition {
    private final Condition[] conditions;

    public ConditionOr(Condition[] conditions) {
        Assert.checkArgumentBeeingNotNull((Object)conditions);
        this.conditions = conditions;
    }

    @Override
    public boolean isTrue(LabelCreationContext labelCreationContext) {
        boolean result = false;
        int i = 0;
        while (!result && i < this.conditions.length) {
            result |= this.conditions[i].isTrue(labelCreationContext);
            ++i;
        }
        return result;
    }

    @Override
    public Date expires(LabelCreationContext labelCreationContext) {
        Date expirationDate;
        Date earliestPossibleFalseToTrueSwitch = null;
        Date latestPossibleTrueToFalseSwitch = null;
        boolean hasTrueValueThatExpiresNever = false;
        Condition[] conditionArray = this.conditions;
        int n = this.conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition element = conditionArray[n2];
            boolean currentCondition = element.isTrue(labelCreationContext);
            Date currentExpirationDate = element.expires(labelCreationContext);
            if (currentCondition || currentExpirationDate != null) {
                if (!currentCondition && currentExpirationDate != null) {
                    if (earliestPossibleFalseToTrueSwitch == null) {
                        earliestPossibleFalseToTrueSwitch = currentExpirationDate;
                    } else if (earliestPossibleFalseToTrueSwitch.after(currentExpirationDate)) {
                        earliestPossibleFalseToTrueSwitch = currentExpirationDate;
                    }
                } else if (currentCondition && currentExpirationDate != null) {
                    hasTrueValueThatExpiresNever = true;
                } else if (latestPossibleTrueToFalseSwitch == null) {
                    latestPossibleTrueToFalseSwitch = currentExpirationDate;
                } else if (latestPossibleTrueToFalseSwitch.before(currentExpirationDate)) {
                    latestPossibleTrueToFalseSwitch = currentExpirationDate;
                }
            }
            ++n2;
        }
        if (hasTrueValueThatExpiresNever) {
            expirationDate = null;
        } else {
            expirationDate = earliestPossibleFalseToTrueSwitch;
            if (latestPossibleTrueToFalseSwitch != null) {
                if (expirationDate == null) {
                    expirationDate = latestPossibleTrueToFalseSwitch;
                } else if (latestPossibleTrueToFalseSwitch.before(expirationDate)) {
                    expirationDate = latestPossibleTrueToFalseSwitch;
                }
            }
        }
        return expirationDate;
    }
}

