/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.declaration.label;

import com.arcway.frontend.definition.lib.interFace.declaration.label.Condition;
import com.arcway.frontend.definition.lib.interFace.declaration.label.LabelCreationContext;
import com.arcway.lib.java.Assert;
import java.util.Date;

public class ConditionAnd
implements Condition {
    private final Condition[] conditions;

    public ConditionAnd(Condition[] conditions) {
        Assert.checkArgumentBeeingNotNull((Object)conditions);
        this.conditions = conditions;
    }

    @Override
    public boolean isTrue(LabelCreationContext labelCreationContext) {
        boolean result = true;
        int i = 0;
        while (result && i < this.conditions.length) {
            result &= this.conditions[i].isTrue(labelCreationContext);
            ++i;
        }
        return result;
    }

    @Override
    public Date expires(LabelCreationContext labelCreationContext) {
        Date expirationDate;
        boolean hasFalseValueThatExpiresNever = false;
        Date latestPossibleFalseToTrueSwitch = null;
        Date earliestPossibleTrueToFalseSwitch = null;
        Condition[] conditionArray = this.conditions;
        int n = this.conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition element = conditionArray[n2];
            boolean currentCondition = element.isTrue(labelCreationContext);
            Date currentExpirationDate = element.expires(labelCreationContext);
            if (!currentCondition && currentExpirationDate == null) {
                hasFalseValueThatExpiresNever = true;
            } else if (!currentCondition && currentExpirationDate != null) {
                if (latestPossibleFalseToTrueSwitch == null) {
                    latestPossibleFalseToTrueSwitch = currentExpirationDate;
                } else if (latestPossibleFalseToTrueSwitch.before(currentExpirationDate)) {
                    latestPossibleFalseToTrueSwitch = currentExpirationDate;
                }
            } else if (!currentCondition || currentExpirationDate == null) {
                if (earliestPossibleTrueToFalseSwitch == null) {
                    earliestPossibleTrueToFalseSwitch = currentExpirationDate;
                } else if (earliestPossibleTrueToFalseSwitch.after(currentExpirationDate)) {
                    earliestPossibleTrueToFalseSwitch = currentExpirationDate;
                }
            }
            ++n2;
        }
        if (hasFalseValueThatExpiresNever) {
            expirationDate = null;
        } else {
            expirationDate = latestPossibleFalseToTrueSwitch;
            if (earliestPossibleTrueToFalseSwitch != null) {
                if (expirationDate == null) {
                    expirationDate = earliestPossibleTrueToFalseSwitch;
                } else if (earliestPossibleTrueToFalseSwitch.before(expirationDate)) {
                    expirationDate = earliestPossibleTrueToFalseSwitch;
                }
            }
        }
        return expirationDate;
    }
}

