/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.AbstractFrontendDataTypeEnumeration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import java.util.Locale;
import java.util.Set;

public class FDTMultipleChoice
extends AbstractFrontendDataTypeEnumeration {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTMultipleChoice.class, "multiplechoice.gif");
    private static final IStreamResource EMPTY_ICON_16x16 = new FileResourceInPackage(FDTMultipleChoice.class, "multiplechoiceempty.gif");
    private final RDTMultipleChoice repositoryDataType = RDTMultipleChoice.getInstance();

    public static FDTMultipleChoice getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTMultipleChoice frontendDataType = (FDTMultipleChoice)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTMultipleChoice.getInstance());
        return frontendDataType;
    }

    public FDTMultipleChoice(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTMultipleChoice", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        IFrontendLabel label;
        AbstractFrontendDataTypeEnumeration.Parameters typedFrontendDataTypeParameters = (AbstractFrontendDataTypeEnumeration.Parameters)frontendDataTypeParameters;
        Set valueIDs = this.repositoryDataType.dataToValue(value);
        if (valueIDs == null) {
            label = new FrontendLabel(Messages.getString("FDT.NULL", userLocale.getLocale()), NULL_ICON_16x16);
        } else if (valueIDs.size() == 0) {
            label = new FrontendLabel(Messages.getString("FDTMultipleChoice.EMPTY", this.getRepositoryLocale()), EMPTY_ICON_16x16);
        } else if (valueIDs.size() == 1) {
            label = typedFrontendDataTypeParameters.getLabel((String)valueIDs.iterator().next());
        } else {
            String stringValue = null;
            for (String valueID : valueIDs) {
                IFrontendLabel currentLabel = typedFrontendDataTypeParameters.getLabel(valueID);
                String currentText = currentLabel.getText();
                if (currentText == null) {
                    currentText = "???";
                }
                stringValue = stringValue != null ? String.valueOf(stringValue) + ", " + currentText : currentText;
            }
            label = new FrontendLabel(stringValue, null);
        }
        return label;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataTypeEnumeration.FETAbstractRepositoryDataTypeEnumerationInvalidElement.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        Set actualValues = null;
        if (value != null) {
            IRepositoryData currentRepositoryValue = value;
            actualValues = this.repositoryDataType.dataToValue(currentRepositoryValue);
        }
        return actualValues;
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        Set values = null;
        if (editorValue != null) {
            values = (Set)editorValue;
        }
        IRepositoryData data = this.repositoryDataType.createData(values);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTMultipleChoice(frontendTypeManager);
        }
    }
}

