/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.AbstractFrontendDataValidationExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import java.util.Locale;

public class FDTLocale
extends AbstractFrontendDataType {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTLocale.class, "locale.gif");
    private final RDTLocale repositoryDataType = RDTLocale.getInstance();
    private final IFrontendLabel frontendLabelLanguage = Messages.createFrontendLabel("FDTLocale.Language", this.getRepositoryLocale(), null);
    private final IFrontendLabel frontendLabelCountry = Messages.createFrontendLabel("FDTLocale.Country", this.getRepositoryLocale(), null);
    private final IFrontendLabel frontendLabelVaraint = Messages.createFrontendLabel("FDTLocale.Varaint", this.getRepositoryLocale(), null);

    public static FDTLocale getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTLocale frontendDataType = (FDTLocale)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTLocale.getInstance());
        return frontendDataType;
    }

    public FDTLocale(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTLocale", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        FrontendLabel label;
        Locale valueAsLocale = this.repositoryDataType.dataToValue(value);
        if (valueAsLocale != null) {
            String valueAsString = this.repositoryDataType.isWithCountryAndVariant(repositoryDataTypeParameters) ? valueAsLocale.getDisplayName(this.getRepositoryLocale()) : valueAsLocale.getDisplayLanguage(this.getRepositoryLocale());
            label = new FrontendLabel(valueAsString, null);
        } else {
            label = new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        }
        return label;
    }

    public IFrontendLabel getFrontendLabelLanguage() {
        return this.frontendLabelLanguage;
    }

    public IFrontendLabel getFrontendLabelCountry() {
        return this.frontendLabelCountry;
    }

    public IFrontendLabel getFrontendLabelVaraint() {
        return this.frontendLabelVaraint;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        frontendExceptionTypeRegistrations.add((Object)new FETLocaleValueInvalid.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        return this.repositoryDataType.dataToValue(value);
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        IRepositoryData data = this.repositoryDataType.createData((Locale)editorValue);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FETLocaleValueInvalid
    extends AbstractFrontendDataValidationExceptionType<RDTLocale.EXLocaleValueInvalid> {
        private FETLocaleValueInvalid(IFrontendTypeManager frontendTypeManager) {
            super(frontendTypeManager);
        }

        @Override
        protected Class<RDTLocale.EXLocaleValueInvalid> getConcreteRepositoryExceptionType() {
            return RDTLocale.EXLocaleValueInvalid.class;
        }

        @Override
        protected String getExceptionMessage(PresentationContext presentationContext, RDTLocale.EXLocaleValueInvalid exception) {
            String exceptionMessage = null;
            if (exception.isWithCountryOrVariant()) {
                Messages.getString("EXValueInvalid.Locale.WithCountryOrVariant", presentationContext.getLocale());
            } else {
                Messages.getString("EXValueInvalid.Locale.NotWithCountryOrVariant", presentationContext.getLocale());
            }
            return exceptionMessage;
        }

        public static class FrontendExceptionTypeRegistration
        implements IFrontendExceptionTypeRegistration {
            @Override
            public IFrontendExceptionType createFrontendExceptionType(IFrontendTypeManager frontendTypeManager) {
                return new FETLocaleValueInvalid(frontendTypeManager);
            }
        }
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTLocale(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        public static final Parameters DEFAULTS = new Parameters();
    }
}

