/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.AbstractFrontendDataTypeNumber;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import java.util.Locale;

public class FDTInteger32Bit
extends AbstractFrontendDataTypeNumber {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTInteger32Bit.class, "integer.gif");
    private final RDTInteger32Bit repositoryDataType = RDTInteger32Bit.getInstance();

    public static FDTInteger32Bit getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTInteger32Bit frontendDataType = (FDTInteger32Bit)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTInteger32Bit.getInstance());
        return frontendDataType;
    }

    public FDTInteger32Bit(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTInteger32Bit", userLocale, ICON_16x16);
    }

    private long getFactor(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getFactor();
    }

    private int getNoOfDecimalPlaces(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.getNoOfDecimalPlaces();
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        FrontendLabel label;
        Integer valueAsInt = this.repositoryDataType.dataToValue(value);
        if (valueAsInt != null) {
            String valueAsString = this.formatNumber(valueAsInt);
            label = new FrontendLabel(valueAsString, null);
        } else {
            label = new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        }
        return label;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataTypeNumber.FETNumberValueInvalid.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        Integer intVal = this.repositoryDataType.dataToValue(value);
        if (intVal == null) {
            return null;
        }
        double newVal = intVal.doubleValue();
        newVal = intVal.doubleValue() / (double)this.getFactor(parameters);
        int noOfDecimalsPlaces = this.getNoOfDecimalPlaces(parameters);
        newVal = (double)Math.round(newVal * Math.pow(10.0, noOfDecimalsPlaces)) / Math.pow(10.0, noOfDecimalsPlaces);
        return new Double(newVal);
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        Integer newData = null;
        if (editorValue != null) {
            double newValue = (Double)editorValue * (double)this.getFactor(frontendParameters);
            newData = (int)Math.round(newValue);
        }
        IRepositoryData data = this.repositoryDataType.createData(newData);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTInteger32Bit(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        public static final Parameters DEFAULTS = new Parameters(false, 0, 1);
        private final boolean displayAsFixedPointNumber;
        private final int noOfDecimalPlaces;
        private final int factor;

        public Parameters(boolean displayAsFixedPointNumber, int noOfDecimalPlaces, int factor) {
            assert (noOfDecimalPlaces > -1);
            assert (factor != 0);
            this.displayAsFixedPointNumber = displayAsFixedPointNumber;
            this.noOfDecimalPlaces = noOfDecimalPlaces;
            this.factor = factor;
        }

        public boolean isDisplayedAsFixedPointNumber() {
            return this.displayAsFixedPointNumber;
        }

        public int getNoOfDecimalPlaces() {
            return this.noOfDecimalPlaces;
        }

        public int getFactor() {
            return this.factor;
        }
    }
}

