/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.AbstractFrontendDataValidationExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import java.util.Date;
import java.util.Locale;

public class FDTDateUTC64Bitmsec
extends AbstractFrontendDataType {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTDateUTC64Bitmsec.class, "date.gif");
    private final RDTDateUTC64Bitmsec repositoryDataType = RDTDateUTC64Bitmsec.getInstance();

    public static FDTDateUTC64Bitmsec getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTDateUTC64Bitmsec frontendDataType = (FDTDateUTC64Bitmsec)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTDateUTC64Bitmsec.getInstance());
        return frontendDataType;
    }

    public FDTDateUTC64Bitmsec(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTDate64Bitmsec", userLocale, ICON_16x16);
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        FrontendLabel label;
        Date valueAsDate = this.repositoryDataType.dataToValue(value);
        if (valueAsDate != null) {
            String valueAsString = this.repositoryDataType.isWithTimeComponent(repositoryDataTypeParameters) ? userLocale.convertDateAndTimeWithoutSecondsToString(valueAsDate, this.getRepositoryLocale()) : userLocale.convertDateWithoutTimeToString(valueAsDate, this.getRepositoryLocale());
            label = new FrontendLabel(valueAsString, null);
        } else {
            label = new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16);
        }
        return label;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        frontendExceptionTypeRegistrations.add((Object)new FETDateUTC64BitmsecValueInvalid.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        return this.repositoryDataType.dataToValue(value);
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        IRepositoryData data = this.repositoryDataType.createData((Date)editorValue);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FETDateUTC64BitmsecValueInvalid
    extends AbstractFrontendDataValidationExceptionType<RDTDateUTC64Bitmsec.EXDateUTCValueInvalid> {
        private FETDateUTC64BitmsecValueInvalid(IFrontendTypeManager frontendTypeManager) {
            super(frontendTypeManager);
        }

        @Override
        protected Class<RDTDateUTC64Bitmsec.EXDateUTCValueInvalid> getConcreteRepositoryExceptionType() {
            return RDTDateUTC64Bitmsec.EXDateUTCValueInvalid.class;
        }

        @Override
        protected String getExceptionMessage(PresentationContext presentationContext, RDTDateUTC64Bitmsec.EXDateUTCValueInvalid exception) {
            int lengthDiagnostics = exception.getLengthDiagnostics();
            if (lengthDiagnostics == 2) {
                return Messages.getString("EXValueInvalid.DateUTC64Bitmsec.TooEarly", presentationContext.getLocale());
            }
            if (lengthDiagnostics == 3) {
                return Messages.getString("EXValueInvalid.DateUTC64Bitmsec.TooLate", presentationContext.getLocale());
            }
            return Messages.getString("EXValueInvalid.DateUTC64Bitmsec", presentationContext.getLocale());
        }

        public static class FrontendExceptionTypeRegistration
        implements IFrontendExceptionTypeRegistration {
            @Override
            public IFrontendExceptionType createFrontendExceptionType(IFrontendTypeManager frontendTypeManager) {
                return new FETDateUTC64BitmsecValueInvalid(frontendTypeManager);
            }
        }
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTDateUTC64Bitmsec(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        public static final Parameters DEFAULTS = new Parameters();
    }
}

