/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.FrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.FileResourceInPackage;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import java.util.Locale;

public class FDTBoolean
extends AbstractFrontendDataType {
    private static final IStreamResource ICON_16x16 = new FileResourceInPackage(FDTBoolean.class, "boolean.gif");
    private static final IStreamResource FALSE_ICON_16x16 = new FileResourceInPackage(FDTBoolean.class, "booleanfalse.gif");
    private final RDTBoolean repositoryDataType = RDTBoolean.getInstance();
    private final IFrontendLabel frontendLabelTrue = Messages.createFrontendLabel("FDTBoolean.TRUE", this.getRepositoryLocale(), ICON_16x16);
    private final IFrontendLabel frontendLabelFalse = Messages.createFrontendLabel("FDTBoolean.FALSE", this.getRepositoryLocale(), FALSE_ICON_16x16);
    private final IFrontendLabel frontendLabelYes = Messages.createFrontendLabel("FDTBoolean.YES", this.getRepositoryLocale(), ICON_16x16);
    private final IFrontendLabel frontendLabelNo = Messages.createFrontendLabel("FDTBoolean.NO", this.getRepositoryLocale(), FALSE_ICON_16x16);
    private final IFrontendLabel frontendLabelOn = Messages.createFrontendLabel("FDTBoolean.ON", this.getRepositoryLocale(), ICON_16x16);
    private final IFrontendLabel frontendLabelOff = Messages.createFrontendLabel("FDTBoolean.OFF", this.getRepositoryLocale(), FALSE_ICON_16x16);

    public static FDTBoolean getInstance(IFrontendTypeManager frontendTypeManager) {
        FDTBoolean frontendDataType = (FDTBoolean)frontendTypeManager.getFrontendDataType((IRepositoryDataType)RDTBoolean.getInstance());
        return frontendDataType;
    }

    public FDTBoolean(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryDataType getRepositoryDataType() {
        return this.repositoryDataType;
    }

    @Override
    public IFrontendLabel getLabel(Locale userLocale) {
        return Messages.createFrontendLabel("FDTBoolean", userLocale, ICON_16x16);
    }

    public boolean isTrueFalse(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isTrueFalse();
    }

    public boolean isYesNo(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isYesNo();
    }

    public boolean isOnOff(IFrontendDataTypeParameters parameters) {
        Parameters typedParameters = (Parameters)parameters;
        return typedParameters.isOnOff();
    }

    @Override
    public IFrontendLabel getLabelForValue(IRepositoryData value, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataTypeParameters frontendDataTypeParameters, PresentationContext userLocale) {
        IFrontendLabel label;
        if (this.isTrueFalse(frontendDataTypeParameters)) {
            label = this.getLabelForValueTrueFalse(value);
        } else if (this.isYesNo(frontendDataTypeParameters)) {
            label = this.getLabelForValueYesNo(value);
        } else if (this.isOnOff(frontendDataTypeParameters)) {
            label = this.getLabelForValueOnOff(value);
        } else {
            throw new UnsupportedOperationException();
        }
        return label;
    }

    public IFrontendLabel[] getLabelsForValues(IFrontendDataTypeParameters frontendDataTypeParameters) {
        IFrontendLabel[] labels = new IFrontendLabel[2];
        if (this.isOnOff(frontendDataTypeParameters)) {
            labels[0] = this.frontendLabelOn;
            labels[1] = this.frontendLabelOff;
        }
        if (this.isYesNo(frontendDataTypeParameters)) {
            labels[0] = this.frontendLabelYes;
            labels[1] = this.frontendLabelNo;
        }
        if (this.isTrueFalse(frontendDataTypeParameters)) {
            labels[0] = this.frontendLabelTrue;
            labels[1] = this.frontendLabelFalse;
        }
        return labels;
    }

    public IFrontendLabel getLabelForValueTrueFalse(IRepositoryData value) {
        Boolean typedValue = this.repositoryDataType.dataToValue(value);
        IFrontendLabel label = typedValue == null ? new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16) : (typedValue != false ? this.frontendLabelTrue : this.frontendLabelFalse);
        return label;
    }

    public IFrontendLabel getLabelForValueYesNo(IRepositoryData value) {
        Boolean typedValue = this.repositoryDataType.dataToValue(value);
        IFrontendLabel label = typedValue == null ? new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16) : (typedValue != false ? this.frontendLabelYes : this.frontendLabelNo);
        return label;
    }

    public IFrontendLabel getLabelForValueOnOff(IRepositoryData value) {
        Boolean typedValue = this.repositoryDataType.dataToValue(value);
        IFrontendLabel label = typedValue == null ? new FrontendLabel(Messages.getString("FDT.NULL", this.getRepositoryLocale()), NULL_ICON_16x16) : (typedValue != false ? this.frontendLabelOn : this.frontendLabelOff);
        return label;
    }

    @Override
    public ICollection_<IFrontendExceptionTypeRegistration> getFrontendExceptionTypeRegistrations() {
        ArrayList_ frontendExceptionTypeRegistrations = new ArrayList_();
        frontendExceptionTypeRegistrations.add((Object)new AbstractFrontendDataType.FETValueNotSet.FrontendExceptionTypeRegistration());
        return frontendExceptionTypeRegistrations;
    }

    @Override
    public Object getCurrentValueAsEditorValue(IRepositoryData value, IFrontendDataTypeParameters parameters) {
        return this.repositoryDataType.dataToValue(value);
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        IRepositoryData data = this.repositoryDataType.createData((Boolean)editorValue);
        return new RepositoryPropertySample(data);
    }

    @Override
    public void disposePropertySample(IRepositoryPropertySample repositoryPropertySample) {
    }

    @Override
    public boolean hasResourcesAllocated() {
        return false;
    }

    public static class FrontendDataTypeRegistration
    implements IFrontendDataTypeRegistration {
        @Override
        public IFrontendDataType createFrontendDataType(IFrontendTypeManager frontendTypeManager) {
            return new FDTBoolean(frontendTypeManager);
        }
    }

    public static final class Parameters
    extends FrontendDataTypeParameters {
        public static final int IS_TRUE_FALSE = 1;
        public static final int IS_YES_NO = 2;
        public static final int IS_ON_OFF = 3;
        public static final Parameters TRUE_FALSE = new Parameters(1);
        public static final Parameters YES_NO = new Parameters(2);
        public static final Parameters ON_OFF = new Parameters(3);
        private final int mode;

        public Parameters(int mode) {
            this.mode = mode;
        }

        private boolean isTrueFalse() {
            return this.mode == 1;
        }

        private boolean isYesNo() {
            return this.mode == 2;
        }

        private boolean isOnOff() {
            return this.mode == 3;
        }
    }
}

