/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace.datatype.lib;

import com.arcway.frontend.definition.lib.interFace.datatype.AbstractFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendExceptionTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.Messages;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.AbstractFrontendDataValidationExceptionType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryStringDataType;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractFrontendDataTypeString
extends AbstractFrontendDataType {
    public AbstractFrontendDataTypeString(IFrontendTypeManager frontendTypeManager) {
        super(frontendTypeManager);
    }

    @Override
    public IRepositoryPropertySample getPropertySampleForEditorValue(Object editorValue, IRepositoryPropertyType propertyType, IFrontendDataTypeParameters frontendParameters) {
        AbstractRepositoryStringDataType.AbstractStringParameters parameters = (AbstractRepositoryStringDataType.AbstractStringParameters)propertyType.getDataTypeParameters();
        String value = (String)editorValue;
        if (value != null && value.equals("")) {
            boolean isSetAlways = parameters.isSetAlways();
            long minLength = parameters.getMinLength();
            if (isSetAlways && minLength > 0L || !isSetAlways && minLength > 0L) {
                value = null;
            }
        }
        assert (this.getRepositoryDataType() instanceof AbstractRepositoryStringDataType);
        AbstractRepositoryStringDataType stringDataType = (AbstractRepositoryStringDataType)this.getRepositoryDataType();
        IRepositoryData data = stringDataType.createData(value);
        return new RepositoryPropertySample(data);
    }

    public static class FETAbstractRepositoryStringDataTypeValueInvalid
    extends AbstractFrontendDataValidationExceptionType<AbstractRepositoryStringDataType.EXStringValueInvalid> {
        private FETAbstractRepositoryStringDataTypeValueInvalid(IFrontendTypeManager frontendTypeManager) {
            super(frontendTypeManager);
        }

        @Override
        protected Class<AbstractRepositoryStringDataType.EXStringValueInvalid> getConcreteRepositoryExceptionType() {
            return AbstractRepositoryStringDataType.EXStringValueInvalid.class;
        }

        @Override
        protected String getExceptionMessage(PresentationContext presentationContext, AbstractRepositoryStringDataType.EXStringValueInvalid exception) {
            int lengthDiagnostics = exception.getLengthDiagnostics();
            if (exception.getFirstInvalidCharacter() != null) {
                return NLS.bind((String)Messages.getString("EXValueInvalid.StringDataType.ContainsInvalidCharacters", presentationContext.getLocale()), (Object)exception.getFirstInvalidCharacter().toString());
            }
            if (lengthDiagnostics == 3) {
                return Messages.getString("EXValueInvalid.StringDataType.TooShort", presentationContext.getLocale());
            }
            if (lengthDiagnostics == 4) {
                return Messages.getString("EXValueInvalid.StringDataType.TooLong", presentationContext.getLocale());
            }
            return Messages.getString("EXValueInvalid.StringDataType", presentationContext.getLocale());
        }

        public static class FrontendExceptionTypeRegistration
        implements IFrontendExceptionTypeRegistration {
            @Override
            public IFrontendExceptionType createFrontendExceptionType(IFrontendTypeManager frontendTypeManager) {
                return new FETAbstractRepositoryStringDataTypeValueInvalid(frontendTypeManager);
            }
        }
    }
}

