/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.interFace;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.AbstractFrontendDataTypeEnumeration;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeEnumeration;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.DataValidationException;
import java.util.HashMap;

public class FrontendRepositoryProperties {
    private static final ILogger LOGGER = Logger.getLogger(FrontendRepositoryProperties.class);

    public static Object getEditorValueForPropertySample(FrontendRepositoryPropertyContext propertyContext, IRepositoryPropertySample sample) {
        IRepositoryData data = sample.getValue();
        return propertyContext.getFrontendDataType().getCurrentValueAsEditorValue(data, propertyContext.getFrontendDataTypeParameters());
    }

    public static void checkAndSnapEditorValue(FrontendRepositoryPropertyContext propertyContext, Object editorValue) throws JvmExternalResourceInteractionException, EEXDataValidation {
        IRepositoryPropertySample propertySample = propertyContext.getFrontendDataType().getPropertySampleForEditorValue(editorValue, propertyContext.getRepositoryPropertyType(), propertyContext.getFrontendDataTypeParameters());
        try {
            propertyContext.getRepositoryDataType().snapAndCheckData(propertySample.getValue(), propertyContext.getRepositoryDataTypeParameters());
        }
        catch (DataValidationException e) {
            throw new EEXDataValidation((Exception)((Object)e));
        }
    }

    public static IRepositoryPropertySample getPropertySampleForEditorValue(FrontendRepositoryPropertyContext propertyContext, Object editorValue) throws JvmExternalResourceInteractionException {
        IRepositoryPropertySample propertySample = propertyContext.getFrontendDataType().getPropertySampleForEditorValue(editorValue, propertyContext.getRepositoryPropertyType(), propertyContext.getFrontendDataTypeParameters());
        return propertySample;
    }

    public static HashMap<String, String> getValueRangeForEnumerationProperty(FrontendRepositoryPropertyContext propertyContext) {
        HashMap<String, String> valueRange;
        if (propertyContext.getRepositoryDataTypeParameters() instanceof AbstractRepositoryDataTypeEnumeration.EnumerationParameters) {
            AbstractRepositoryDataTypeEnumeration.EnumerationParameters enumerationRepositoryDataTypeParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)propertyContext.getRepositoryDataTypeParameters();
            AbstractFrontendDataTypeEnumeration.Parameters enumerationFrontendDataTypeParameters = (AbstractFrontendDataTypeEnumeration.Parameters)propertyContext.getFrontendDataTypeParameters();
            ISortedSet_ valueList = enumerationRepositoryDataTypeParameters.getValues();
            valueRange = new HashMap<String, String>();
            for (String listValue : valueList) {
                valueRange.put(listValue, enumerationFrontendDataTypeParameters.getLabel(listValue).getText());
            }
        } else {
            valueRange = null;
        }
        return valueRange;
    }

    public static IHasher_<Object> getPropertyValueHasher(IRepositoryTypeManagerRO typeManager, IRepositoryPropertyReference propertyReference) {
        return FrontendRepositoryProperties.getPropertyValueHasher(typeManager, typeManager.getObjectType(propertyReference.getObjectReference().getObjectTypeID()), propertyReference.getPropertyTypeID());
    }

    public static IHasher_<Object> getPropertyValueHasher(IRepositoryTypeManagerRO typeManager, IRepositoryObjectType objectType, IRepositoryPropertyTypeID propertyTypeID) {
        IRepositoryPropertyType propertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)propertyTypeID);
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(typeManager);
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(propertyType.getDataType());
        return frontendDataType.getEditorValueHasher();
    }

    public static FrontendRepositoryPropertyContext getPropertyContext(IRepositoryPropertyReference propertyReference, IRepositoryInterfaceRO repositoryInterface) {
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
        IRepositoryObjectReference objectReference = propertyReference.getObjectReference();
        IRepositoryObjectTypeID objectTypeID = objectReference.getObjectTypeID();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        IRepositoryAttributeSetType repositoryAttributeSetType = objectType.getAttributeSetType(propertyTypeID);
        IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
        return FrontendRepositoryProperties.getPropertyContext(repositoryPropertyType, repositoryInterface);
    }

    public static FrontendRepositoryPropertyContext getPropertyContext(IRepositoryPropertyType repositoryPropertyType, IRepositoryInterfaceRO repositoryInterface) {
        IRepositoryTypeManagerRO typeManager = repositoryInterface.getTypeManager();
        IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
        IRepositoryDataTypeParameters repositoryDataTypeParameters = repositoryPropertyType.getDataTypeParameters();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(typeManager);
        IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(repositoryDataType);
        IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(repositoryPropertyType);
        IFrontendDataTypeParameters frontendDataTypeParameters = frontendPropertyType.getFrontendDataTypeParameters();
        return new FrontendRepositoryPropertyContext(repositoryPropertyType, repositoryDataType, repositoryDataTypeParameters, frontendDataType, frontendDataTypeParameters);
    }

    public static class FrontendRepositoryPropertyContext {
        private final IRepositoryPropertyType repositoryPropertyType;
        private final IRepositoryDataType repositoryDataType;
        private final IRepositoryDataTypeParameters repositoryDataTypeParameters;
        private final IFrontendDataType frontendDataType;
        private final IFrontendDataTypeParameters frontendDataTypeParameters;

        public FrontendRepositoryPropertyContext(IRepositoryPropertyType repositoryPropertyType, IRepositoryDataType repositoryDataType, IRepositoryDataTypeParameters repositoryDataTypeParameters, IFrontendDataType frontendDataType, IFrontendDataTypeParameters frontendDataTypeParameters) {
            this.repositoryPropertyType = repositoryPropertyType;
            this.repositoryDataType = repositoryDataType;
            this.repositoryDataTypeParameters = repositoryDataTypeParameters;
            this.frontendDataType = frontendDataType;
            this.frontendDataTypeParameters = frontendDataTypeParameters;
        }

        public IRepositoryPropertyType getRepositoryPropertyType() {
            return this.repositoryPropertyType;
        }

        public IRepositoryDataType getRepositoryDataType() {
            return this.repositoryDataType;
        }

        public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
            return this.repositoryDataTypeParameters;
        }

        public IFrontendDataType getFrontendDataType() {
            return this.frontendDataType;
        }

        public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
            return this.frontendDataTypeParameters;
        }
    }
}

