/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.implementation.type;

import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.resource.IStreamResource;
import java.util.Locale;

public class BestMatchingFrontendLabel
implements IFrontendLabel {
    private final Locale wishedLocale;
    private Locale labelLocale = null;
    private int labelInheritanceLevel = Integer.MAX_VALUE;
    private Locale icon16x16Locale = null;
    private int icon16x16InheritanceLevel = Integer.MAX_VALUE;
    private String label = null;
    private IStreamResource icon16x16 = null;

    public BestMatchingFrontendLabel(Locale wishedLocale) {
        Assert.checkArgumentBeeingNotNull((Object)wishedLocale);
        this.wishedLocale = wishedLocale;
    }

    public void updateLabel(Locale localeOfLabelToMerge, IFrontendLabel labelToMerge, int inheritanceLevelToMerge) {
        IStreamResource newIcon16x16;
        String newLabel = labelToMerge.getText();
        if (newLabel != null && this.isToOverwrite(this.labelLocale, this.labelInheritanceLevel, localeOfLabelToMerge, inheritanceLevelToMerge)) {
            this.label = newLabel;
            this.labelLocale = localeOfLabelToMerge;
            this.labelInheritanceLevel = inheritanceLevelToMerge;
        }
        if ((newIcon16x16 = labelToMerge.getIcon16x16()) != null && this.isToOverwrite(this.icon16x16Locale, this.icon16x16InheritanceLevel, localeOfLabelToMerge, inheritanceLevelToMerge)) {
            this.icon16x16 = newIcon16x16;
            this.icon16x16Locale = localeOfLabelToMerge;
            this.icon16x16InheritanceLevel = inheritanceLevelToMerge;
        }
    }

    private boolean isToOverwrite(Locale currentLocale, int currentInheritanceLevel, Locale newLocale, int newInheritanceLevel) {
        boolean isToOverwrite;
        if (currentLocale == null) {
            isToOverwrite = true;
        } else if (newLocale == null) {
            isToOverwrite = false;
        } else if (newInheritanceLevel < currentInheritanceLevel) {
            isToOverwrite = true;
        } else if (newInheritanceLevel > currentInheritanceLevel) {
            isToOverwrite = false;
        } else {
            int distanceOfCurrentLocaleToWishedLocale = LocaleHelper.getDistance((Locale)currentLocale, (Locale)this.wishedLocale);
            int distanceOfNewLocaleToWishedLocale = LocaleHelper.getDistance((Locale)newLocale, (Locale)this.wishedLocale);
            if (distanceOfNewLocaleToWishedLocale < distanceOfCurrentLocaleToWishedLocale) {
                isToOverwrite = true;
            } else if (distanceOfCurrentLocaleToWishedLocale == 3) {
                int distanceOfCurrentLocaleToFallbackLocale = LocaleHelper.getDistance((Locale)currentLocale, (Locale)LocaleHelper.FALLBACK);
                int distanceOfNewLocaleToFallbackLocale = LocaleHelper.getDistance((Locale)newLocale, (Locale)LocaleHelper.FALLBACK);
                isToOverwrite = distanceOfNewLocaleToFallbackLocale < distanceOfCurrentLocaleToFallbackLocale;
            } else {
                isToOverwrite = false;
            }
        }
        return isToOverwrite;
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public IStreamResource getIcon16x16() {
        return this.icon16x16;
    }
}

