/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.supporttool;

import com.arcway.cockpit.supporttool.ISupportTool;
import com.arcway.cockpit.supporttool.SupportToolAttentionPage;
import com.arcway.cockpit.supporttool.messages.Messages;
import com.arcway.lib.eclipse.extensions.ExtensionMgr;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.FileSelectionPage;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.standalone.DisableCommand;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.update.standalone.RemoveSiteCommand;
import org.eclipse.update.standalone.UninstallCommand;

public class CHSupportTool
extends AbstractHandler {
    private static final ILogger LOGGER = Logger.getLogger(CHSupportTool.class);
    private static final String SESSIONTEMPDIRECTORIES_MAINDIRECTORY_PREFIX = "SupportTool-UpdateSites";
    private static final String SESSIONTEMPDIRECTORIES_TOOLDIRECTORY_PREFIX = "Tool";
    private static final String SESSIONTEMPDIRECTORIES_UPDATESITEDIRECTORY_NAME = "UpdateSite";
    private static final String SESSIONTEMPDIRECTORIES_INSTALLSITEDIRECTORY_NAME = "eclipse";
    private static SessionTempDirectoryManager.SessionTempDirectory mainTempDirectory = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block10: {
            Object activeWorkbenchWindow_asObject;
            boolean withInstallation = "true".equals(event.getParameter("withInstallation"));
            IWorkbenchWindow activeWorkbenchWindow = null;
            Object applicationContext = event.getApplicationContext();
            if (applicationContext instanceof IEvaluationContext && (activeWorkbenchWindow_asObject = ((IEvaluationContext)applicationContext).getVariable("activeWorkbenchWindow")) instanceof IWorkbenchWindow) {
                activeWorkbenchWindow = (IWorkbenchWindow)activeWorkbenchWindow_asObject;
            }
            if (activeWorkbenchWindow == null && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) == null) {
                LOGGER.error("Support Tool can't find active workbench window.");
                return null;
            }
            Shell shell = activeWorkbenchWindow.getShell();
            if (withInstallation) {
                try {
                    boolean installed;
                    VersionedIdentifier feature;
                    if (mainTempDirectory == null) {
                        mainTempDirectory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)SESSIONTEMPDIRECTORIES_MAINDIRECTORY_PREFIX);
                    }
                    SessionTempDirectoryManager.SessionTempDirectory toolTempDirectory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)SESSIONTEMPDIRECTORIES_TOOLDIRECTORY_PREFIX, (SessionTempDirectoryManager.SessionTempDirectory)mainTempDirectory);
                    File updateSiteDirectory = new File((File)toolTempDirectory, SESSIONTEMPDIRECTORIES_UPDATESITEDIRECTORY_NAME);
                    FileHelper.ensureDirectoryExistance((File)updateSiteDirectory);
                    File installSiteDirectory = new File((File)toolTempDirectory, SESSIONTEMPDIRECTORIES_INSTALLSITEDIRECTORY_NAME);
                    FileHelper.ensureDirectoryExistance((File)installSiteDirectory);
                    File updateSiteFile = this.requestASTFile(shell);
                    if (updateSiteFile == null || (feature = this.prepareUpdateSite(updateSiteFile, updateSiteDirectory, shell)) == null || !(installed = this.installSupportTool(feature, updateSiteDirectory, installSiteDirectory, shell))) break block10;
                    try {
                        this.runSupportTool(shell);
                    }
                    finally {
                        this.deinstallSupportTool(feature, installSiteDirectory, shell);
                    }
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    LOGGER.error("Exception while modifying the temporary directory.", (Throwable)jeriE);
                    CHSupportTool.showErrorMessageForErrorWhileAccessingTemporaryDirectory(shell);
                }
            } else {
                this.runSupportTool(shell);
            }
        }
        return null;
    }

    private void runSupportTool(Shell shell) {
        ISupportTool supportTool = this.findSupportTool(shell);
        if (supportTool != null) {
            supportTool.run(shell);
        }
    }

    private File requestASTFile(Shell shell) {
        final ObjectWrapper fileName = new ObjectWrapper(null);
        final SupportToolAttentionPage attentionPage = new SupportToolAttentionPage();
        final FileSelectionPage fileSelectionPage = new FileSelectionPage(Messages.getString("SupportTool.FileSelectionPage.Title"), Messages.getString("SupportTool.FileSelectionPage.Instruction"), Collections.singletonList("ast"), true, false, true);
        Wizard wizard = new Wizard(){

            public void addPages() {
                super.addPages();
                this.setWindowTitle(Messages.getString("SupportTool.FileSelectionPage.Title"));
                this.addPage((IWizardPage)attentionPage);
                this.addPage((IWizardPage)fileSelectionPage);
            }

            public boolean performFinish() {
                fileName.setWrappedObject((Object)fileSelectionPage.getFileName());
                return true;
            }
        };
        ArcwayWizardDialog wizardDialogue = new ArcwayWizardDialog(shell, (IWizard)wizard);
        wizardDialogue.setPageSize(400, 400);
        int dialogueConfirmed = wizardDialogue.open();
        if (dialogueConfirmed == 0) {
            return new File((String)fileName.getWrappedObject());
        }
        return null;
    }

    private VersionedIdentifier prepareUpdateSite(File updateSiteFile, File updateSiteDirectory, Shell shell) {
        try {
            Zip.unzipFile((File)updateSiteFile, (File)updateSiteDirectory);
            ISite site = SiteManager.getSite((URL)new File(updateSiteDirectory, "site.xml").toURL(), null);
            if (site.getFeatureReferences().length == 1) {
                return site.getFeatureReferences()[0].getFeature(null).getVersionedIdentifier();
            }
            LOGGER.error("More than 1 feature in the support tool update site.");
            CHSupportTool.showErrorMessageForDamagedSupportTool(shell);
        }
        catch (MalformedURLException mURLE) {
            LOGGER.error((Throwable)mURLE);
            CHSupportTool.showErrorMessageForInternalError(shell);
        }
        catch (CoreException e) {
            LOGGER.error((Throwable)e);
            CHSupportTool.showErrorMessageForDamagedSupportTool(shell);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            CHSupportTool.showErrorMessageForErrorWhileAccessingTemporaryDirectory(shell);
        }
        return null;
    }

    private boolean installSupportTool(VersionedIdentifier featureVersion, File updateSiteDirectory, File installSiteDirectory, Shell shell) {
        try {
            InstallCommand installCommand = new InstallCommand(featureVersion.getIdentifier(), featureVersion.getVersion().toString(), updateSiteDirectory.toURI().toURL().toString(), installSiteDirectory.getAbsolutePath(), null);
            installCommand.run();
            installCommand.applyChangesNow();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Could not create install command.", (Throwable)e);
            CHSupportTool.showErrorMessageForDamagedSupportTool(shell);
            return false;
        }
    }

    private void deinstallSupportTool(VersionedIdentifier featureVersion, File targetInstallSite, Shell shell) {
        try {
            String targetInstallSitePath = targetInstallSite.getAbsolutePath();
            DisableCommand disableCommand = new DisableCommand(featureVersion.getIdentifier(), featureVersion.getVersion().toString(), targetInstallSitePath, null);
            disableCommand.run();
            disableCommand.applyChangesNow();
            UninstallCommand uninstallCommand = new UninstallCommand(featureVersion.getIdentifier(), featureVersion.getVersion().toString(), targetInstallSitePath, null);
            uninstallCommand.run();
            uninstallCommand.applyChangesNow();
            RemoveSiteCommand removeSiteCommand = new RemoveSiteCommand(targetInstallSitePath);
            removeSiteCommand.run();
            removeSiteCommand.applyChangesNow();
        }
        catch (Exception e) {
            LOGGER.error("Uninstallation failed", (Throwable)e);
            CHSupportTool.showErrorMessage(Messages.getString("SupportTool.ErrorDialogue.UninstallationFailed.Message"), shell);
        }
    }

    private ISupportTool findSupportTool(Shell shell) {
        List supportToolList = ExtensionMgr.getDefault().getNewInstanceOfExtension("com.arcway.cockpit.supporttool", "supporttool", "SupportTool", "SupportTool", ISupportTool.class);
        if (supportToolList.size() == 1) {
            return (ISupportTool)supportToolList.get(0);
        }
        LOGGER.error("More than one executable extension of type ISupportTool found.");
        CHSupportTool.showErrorMessageForDamagedSupportTool(shell);
        return null;
    }

    private static final void showErrorMessageForErrorWhileAccessingTemporaryDirectory(Shell shell) {
        CHSupportTool.showErrorMessage(Messages.getString("SupportTool.ErrorDialogue.ErrorWhileAccessingTemporaryDirectory.Message"), shell);
    }

    private static final void showErrorMessageForDamagedSupportTool(Shell shell) {
        CHSupportTool.showErrorMessage(Messages.getString("SupportTool.ErrorDialogue.DamagedSupportTool.Message"), shell);
    }

    private static final void showErrorMessageForInternalError(Shell shell) {
        CHSupportTool.showErrorMessage(Messages.getString("SupportTool.ErrorDialogue.InternalError.Message"), shell);
    }

    public static final void showErrorMessage(String message, Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.getString("SupportTool.ErrorDialogue.Title"), (String)message);
    }

    public static void showResult(final String resultText, Shell shell) {
        TitleAreaDialog dialogue = new TitleAreaDialog(shell){

            protected Control createDialogArea(Composite parent) {
                parent.getShell().setText(Messages.getString("SupportTool.ResultDialogue.Title"));
                this.setTitle(Messages.getString("SupportTool.ResultDialogue.Title"));
                Composite composite = new Composite(parent, 2048);
                composite.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout gridLayout = new GridLayout();
                gridLayout.marginWidth = 15;
                gridLayout.marginHeight = 15;
                composite.setLayout((Layout)gridLayout);
                StyledText textArea = new StyledText(composite, 2826);
                GridData gridData = new GridData(4, 4, true, true);
                textArea.setLayoutData((Object)gridData);
                textArea.setText(resultText);
                return composite;
            }

            protected Point getInitialSize() {
                return new Point(500, 700);
            }

            protected boolean isResizable() {
                return true;
            }

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            }
        };
        dialogue.setBlockOnOpen(true);
        dialogue.open();
    }
}

