/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.richclientapplication;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public final class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction newEditorAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction hideShowEditorAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction minimizePartAction;
    private ActionFactory.IWorkbenchAction workbenchEditorsAction;
    private ActionFactory.IWorkbenchAction workbookEditorsAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction revertAction;
    private ActionFactory.IWorkbenchAction refreshAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction moveAction;
    private ActionFactory.IWorkbenchAction renameAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction introAction;
    private Preferences.IPropertyChangeListener prefListener;
    private IPropertyChangeListener propPrefListener;
    private IPageListener pageListener;
    private boolean isDisposed = false;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void hookListeners() {
        this.pageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        };
        this.getWindow().addPageListener(this.pageListener);
        this.propPrefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN") && ApplicationActionBarAdvisor.this.window.getShell() != null && !ApplicationActionBarAdvisor.this.window.getShell().isDisposed()) {
                    ApplicationActionBarAdvisor.this.window.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationActionBarAdvisor.this.updatePinActionToolbar();
                        }
                    });
                }
            }
        };
    }

    public void fillActionBars(int flags) {
        super.fillActionBars(flags);
        if ((flags & 1) == 0) {
            this.hookListeners();
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        MenuManager popUpMenu = new MenuManager();
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        popUpMenu.add((IContributionItem)new ActionContributionItem((IAction)this.editActionSetAction));
        coolBar.setContextMenuManager((IMenuManager)popUpMenu);
        ToolBarManager fileToolBar = new ToolBarManager(coolBar.getStyle());
        fileToolBar.add((IContributionItem)new Separator("new.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("new.ext"));
        fileToolBar.add((IContributionItem)new GroupMarker("save.group"));
        fileToolBar.add((IAction)this.saveAction);
        fileToolBar.add((IContributionItem)new GroupMarker("save.ext"));
        fileToolBar.add((IAction)this.printAction);
        fileToolBar.add((IContributionItem)new GroupMarker("print.ext"));
        fileToolBar.add((IContributionItem)new Separator("build.group"));
        fileToolBar.add((IContributionItem)new GroupMarker("build.ext"));
        fileToolBar.add((IContributionItem)new Separator("additions"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)fileToolBar, "org.eclipse.ui.workbench.file"));
        coolBar.add((IContributionItem)new GroupMarker("additions"));
        coolBar.add((IContributionItem)new GroupMarker("group.nav"));
        ToolBarManager navToolBar = new ToolBarManager(coolBar.getStyle());
        navToolBar.add((IContributionItem)new Separator("history.group"));
        navToolBar.add((IContributionItem)new GroupMarker("group.application"));
        navToolBar.add((IAction)this.backwardHistoryAction);
        navToolBar.add((IAction)this.forwardHistoryAction);
        navToolBar.add((IContributionItem)new Separator("pin.group"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)navToolBar, "org.eclipse.ui.workbench.navigate"));
        coolBar.add((IContributionItem)new GroupMarker("group.editor"));
        coolBar.add((IContributionItem)new GroupMarker("group.help"));
        ToolBarManager helpToolBar = new ToolBarManager(coolBar.getStyle());
        helpToolBar.add((IContributionItem)new Separator("group.help"));
        helpToolBar.add((IContributionItem)new GroupMarker("group.application"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)helpToolBar, "org.eclipse.ui.workbench.help"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)this.createProjectMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_file, "file");
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_edit, "edit");
        return menu;
    }

    private MenuManager createProjectMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_project, "project");
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_window, "window");
        menu.add((IAction)this.newWindowAction);
        menu.add((IContributionItem)new Separator());
        this.addPerspectiveActions(menu);
        menu.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menu);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additionsend"));
        menu.add((IAction)this.openPreferencesAction);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        String openText = IDEWorkbenchMessages.Workbench_openPerspective;
        MenuManager changePerspMenuMgr = new MenuManager(openText, "openPerspective");
        IContributionItem changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        changePerspMenuMgr.add(changePerspMenuItem);
        menu.add((IContributionItem)changePerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(IDEWorkbenchMessages.Workbench_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add((IAction)this.savePerspectiveAction);
        menu.add((IAction)this.resetPerspectiveAction);
        menu.add((IAction)this.closePerspAction);
        menu.add((IAction)this.closeAllPerspsAction);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.Workbench_shortcuts, "shortcuts");
        menu.add((IContributionItem)subMenu);
        subMenu.add((IAction)this.showPartPaneMenuAction);
        subMenu.add((IAction)this.showViewMenuAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.maximizePartAction);
        subMenu.add((IAction)this.minimizePartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.activateEditorAction);
        subMenu.add((IAction)this.nextEditorAction);
        subMenu.add((IAction)this.prevEditorAction);
        subMenu.add((IAction)this.workbookEditorsAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPartAction);
        subMenu.add((IAction)this.prevPartAction);
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)this.nextPerspectiveAction);
        subMenu.add((IAction)this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_help, "help");
        this.addSeparatorOrGroupMarker(menu, "group.intro");
        if (this.introAction != null) {
            menu.add((IAction)this.introAction);
        } else if (this.quickStartAction != null) {
            menu.add((IAction)this.quickStartAction);
        }
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.main");
        menu.add((IAction)this.helpContentsAction);
        menu.add((IAction)this.dynamicHelpAction);
        this.addSeparatorOrGroupMarker(menu, "group.assist");
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("group.main.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.tutorials");
        this.addSeparatorOrGroupMarker(menu, "group.tools");
        this.addSeparatorOrGroupMarker(menu, "group.updates");
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        this.addSeparatorOrGroupMarker(menu, "additions");
        menu.add((IContributionItem)new Separator("group.about"));
        menu.add((IAction)this.aboutAction);
        menu.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menu;
    }

    private void addSeparatorOrGroupMarker(MenuManager menu, String groupId) {
        String prefId = "useSeparator." + menu.getId() + "." + groupId;
        boolean addExtraSeparators = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(prefId);
        if (addExtraSeparators) {
            menu.add((IContributionItem)new Separator(groupId));
        } else {
            menu.add((IContributionItem)new GroupMarker(groupId));
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.pageListener != null) {
            this.window.removePageListener(this.pageListener);
            this.pageListener = null;
        }
        if (this.prefListener != null) {
            this.prefListener = null;
        }
        if (this.propPrefListener != null) {
            WorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propPrefListener);
            this.propPrefListener = null;
        }
        this.closeAction = null;
        this.closeAllAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.newWindowAction = null;
        this.newEditorAction = null;
        this.helpContentsAction = null;
        this.dynamicHelpAction = null;
        this.aboutAction = null;
        this.openPreferencesAction = null;
        this.hideShowEditorAction = null;
        this.savePerspectiveAction = null;
        this.resetPerspectiveAction = null;
        this.editActionSetAction = null;
        this.closePerspAction = null;
        this.lockToolBarAction = null;
        this.closeAllPerspsAction = null;
        this.showViewMenuAction = null;
        this.showPartPaneMenuAction = null;
        this.nextPartAction = null;
        this.prevPartAction = null;
        this.nextEditorAction = null;
        this.prevEditorAction = null;
        this.nextPerspectiveAction = null;
        this.prevPerspectiveAction = null;
        this.activateEditorAction = null;
        this.maximizePartAction = null;
        this.minimizePartAction = null;
        this.workbenchEditorsAction = null;
        this.workbookEditorsAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.cutAction = null;
        this.copyAction = null;
        this.pasteAction = null;
        this.deleteAction = null;
        this.selectAllAction = null;
        this.printAction = null;
        this.revertAction = null;
        this.refreshAction = null;
        this.propertiesAction = null;
        this.quitAction = null;
        this.moveAction = null;
        this.renameAction = null;
        this.goIntoAction = null;
        this.backAction = null;
        this.forwardAction = null;
        this.upAction = null;
        this.nextAction = null;
        this.previousAction = null;
        this.quickStartAction = null;
        this.prefListener = null;
        this.propPrefListener = null;
        this.introAction = null;
        super.dispose();
    }

    void updateModeLine(String text) {
    }

    public boolean isApplicationMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(this.getWindow());
        this.newWindowAction.setText(IDEWorkbenchMessages.Workbench_openNewWindow);
        this.register((IAction)this.newWindowAction);
        this.newEditorAction = ActionFactory.NEW_EDITOR.create(window);
        this.register((IAction)this.newEditorAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAllAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpContentsAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_OBJS_DEFAULT_PROD"));
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.makeFeatureDependentActions(window);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(window);
        this.register((IAction)this.showPartPaneMenuAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this.register((IAction)this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this.register((IAction)this.prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(window);
        this.register((IAction)this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(window);
        this.register((IAction)this.prevPartAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(window);
        this.register((IAction)this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(window);
        this.register((IAction)this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(window);
        this.register((IAction)this.activateEditorAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(window);
        this.register((IAction)this.maximizePartAction);
        this.minimizePartAction = ActionFactory.MINIMIZE.create(window);
        this.register((IAction)this.minimizePartAction);
        this.workbenchEditorsAction = ActionFactory.SHOW_OPEN_EDITORS.create(window);
        this.register((IAction)this.workbenchEditorsAction);
        this.workbookEditorsAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        this.register((IAction)this.workbookEditorsAction);
        this.hideShowEditorAction = ActionFactory.SHOW_EDITOR.create(window);
        this.register((IAction)this.hideShowEditorAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register((IAction)this.savePerspectiveAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register((IAction)this.lockToolBarAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register((IAction)this.resetPerspectiveAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register((IAction)this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register((IAction)this.closeAllPerspsAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register((IAction)this.backwardHistoryAction);
        this.revertAction = ActionFactory.REVERT.create(window);
        this.register((IAction)this.revertAction);
        this.refreshAction = ActionFactory.REFRESH.create(window);
        this.register((IAction)this.refreshAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.register((IAction)this.propertiesAction);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        this.moveAction = ActionFactory.MOVE.create(window);
        this.register((IAction)this.moveAction);
        this.renameAction = ActionFactory.RENAME.create(window);
        this.register((IAction)this.renameAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(window);
        this.register((IAction)this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(window);
        this.register((IAction)this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(window);
        this.register((IAction)this.forwardAction);
        this.upAction = ActionFactory.UP.create(window);
        this.register((IAction)this.upAction);
        this.nextAction = ActionFactory.NEXT.create(window);
        this.nextAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_NEXT_NAV"));
        this.register((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(window);
        this.previousAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_PREVIOUS_NAV"));
        this.register((IAction)this.previousAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
    }

    private void makeFeatureDependentActions(IWorkbenchWindow window) {
        AboutInfo[] infos = null;
        IPreferenceStore prefs = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String stateKey = "platformState";
        String prevState = prefs.getString(stateKey);
        String currentState = String.valueOf(Platform.getStateStamp());
        boolean sameState = currentState.equals(prevState);
        if (!sameState) {
            prefs.putValue(stateKey, currentState);
        }
        String quickStartKey = IDEActionFactory.QUICK_START.getId();
        String showQuickStart = prefs.getString(quickStartKey);
        if (sameState && "true".equals(showQuickStart)) {
            this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
            this.register((IAction)this.quickStartAction);
        } else if (!sameState || !"false".equals(showQuickStart)) {
            infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            boolean found = this.hasWelcomePage(infos);
            prefs.setValue(quickStartKey, found);
            if (found) {
                this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
                this.register((IAction)this.quickStartAction);
            }
        }
    }

    private boolean hasWelcomePage(AboutInfo[] infos) {
        AboutInfo[] aboutInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutInfo element = aboutInfoArray[n2];
            if (element.getWelcomePageURL() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void updatePinActionToolbar() {
        ICoolBarManager coolBarManager = this.getActionBarConfigurer().getCoolBarManager();
        IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.navigate");
        if (!(cbItem instanceof ToolBarContributionItem)) {
            IDEWorkbenchPlugin.log((String)"Navigation toolbar contribution item is missing");
            return;
        }
        ToolBarContributionItem toolBarItem = (ToolBarContributionItem)cbItem;
        IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
        if (toolBarManager == null) {
            IDEWorkbenchPlugin.log((String)"Navigate toolbar is missing");
            return;
        }
        toolBarManager.update(false);
        toolBarItem.update("size");
    }

    protected void fillTrayItem(IMenuManager trayItem) {
        trayItem.add((IAction)this.aboutAction);
        trayItem.add((IAction)this.quitAction);
    }
}

