/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm1.rqm1migrator.messages;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOAbstractModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.IModifiedDataItem_V0;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.ModuleIdentification;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;

public class EOReqSet
extends EOAbstractModuleData_V0
implements IModifiedDataItem_V0 {
    public static final String XML_NAME = "de.plans.fmca.modulelib.set";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_TITLE = "title";
    private static final String ATTR_TAG_DESCR = "description";
    private static final String ATTR_TAG_PARENT_UID = "parentuid";
    private static final String ATTR_TAG_SOURCE_FILE_UID = "sourceFileUid";
    private static final String ATTR_TAG_DATE_OF_CREATION = "dateOfCreation";
    private static final String ATTR_TAG_DATE_OF_CHANGE = "dateOfChange";
    private static final String ATTR_TAG_AUTHOR = "author";
    private static final String ATTR_TAG_REQ_ID_PREFIX = "reqIDPrefix";
    private static final String ATTR_TAG_OLD_UID = "uid";
    private static final String ATTR_TAG_OLD_PROJECT_UID = "projectuid";
    private static final String ATTR_TAG_REQ_ID_PATTERN = "reqIDPattern";
    private String setName;
    private String title;
    private String description;
    private String parentUID;
    private String sourceFileUID;
    private Timestamp dateOfCreation;
    private Timestamp dateOfChange;
    private String author;
    private String reqIDPattern = "0000";
    private String reqIDPrefix;

    public EOReqSet() {
        super(XML_NAME);
    }

    public EOReqSet(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public void makeSetUnique() {
        this.setUid(UUIDGenerator.getUniqueID());
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext outp) throws EXEncoderException {
        super.appendAttributesToXML(outp);
        this.appendAttrToXML(outp, ATTR_TAG_NAME, this.setName);
        this.appendAttrToXML(outp, ATTR_TAG_TITLE, this.title);
        this.appendAttrToXML(outp, ATTR_TAG_DESCR, this.description);
        this.appendAttrToXML(outp, ATTR_TAG_PARENT_UID, this.parentUID);
        this.appendAttrToXML(outp, ATTR_TAG_SOURCE_FILE_UID, this.sourceFileUID);
        this.appendAttrToXML(outp, ATTR_TAG_AUTHOR, this.author);
        this.appendAttrToXML(outp, ATTR_TAG_DATE_OF_CREATION, this.dateOfCreation);
        this.appendAttrToXML(outp, ATTR_TAG_DATE_OF_CHANGE, this.dateOfChange);
        this.appendAttrToXML(outp, ATTR_TAG_REQ_ID_PREFIX, this.reqIDPrefix);
        this.appendAttrToXML(outp, ATTR_TAG_REQ_ID_PATTERN, this.reqIDPattern);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_TAG_NAME)) {
            this.setName = value;
            return true;
        }
        if (name.equals(ATTR_TAG_TITLE)) {
            this.title = value;
            return true;
        }
        if (name.equals(ATTR_TAG_DESCR)) {
            this.description = value;
            return true;
        }
        if (name.equals(ATTR_TAG_PARENT_UID)) {
            this.parentUID = value;
            return true;
        }
        if (name.equals(ATTR_TAG_SOURCE_FILE_UID)) {
            this.sourceFileUID = value;
            return true;
        }
        if (name.equals(ATTR_TAG_AUTHOR)) {
            this.author = value;
            return true;
        }
        if (name.equals(ATTR_TAG_DATE_OF_CREATION)) {
            this.dateOfCreation = this.toTimestamp(value);
            return true;
        }
        if (name.equals(ATTR_TAG_DATE_OF_CHANGE)) {
            this.dateOfChange = this.toTimestamp(value);
            return true;
        }
        if (ATTR_TAG_REQ_ID_PREFIX.equals(name)) {
            this.reqIDPrefix = value;
            return true;
        }
        if (ATTR_TAG_REQ_ID_PATTERN.equals(name)) {
            this.reqIDPattern = value;
            return true;
        }
        if (name.equals(ATTR_TAG_OLD_UID)) {
            this.setUid(value);
            return true;
        }
        if (name.equals(ATTR_TAG_OLD_PROJECT_UID)) {
            this.setProjectUID(value);
            return true;
        }
        return super.setAttributeFromXML(name, value);
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext outp, int depth) {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (this == obj) {
            isEqual = true;
        } else if (obj instanceof EOReqSet) {
            EOReqSet set = (EOReqSet)((Object)obj);
            isEqual = this.getProjectUID().equals(set.getProjectUID()) && this.getUID().equals(set.getUID());
        } else {
            isEqual = super.equals(obj);
        }
        return isEqual;
    }

    public int hashCode() {
        return (String.valueOf(this.getProjectUID()) + this.getUID()).hashCode();
    }

    public String getSetName() {
        return this.setName;
    }

    public String getParentUID() {
        return this.parentUID;
    }

    public String getSourceFileUID() {
        return this.sourceFileUID;
    }

    public String getAuthor() {
        return this.author;
    }

    public Timestamp getDateOfChange() {
        return this.dateOfChange;
    }

    public Timestamp getDateOfCreation() {
        return this.dateOfCreation;
    }

    public void setSetName(String name) {
        assert (name != null);
        this.setName = name;
    }

    public void setSourceFileUID(String sourcefileUID) {
        this.sourceFileUID = sourcefileUID;
    }

    public void setParentUID(String parentUID) {
        this.parentUID = parentUID;
    }

    public Object getKey() {
        return this.getUID();
    }

    public void setAuthor(String author) {
        assert (author != null) : "author must not be null";
        this.author = author;
    }

    public void setDateOfChange(Timestamp date) {
        assert (date != null) : "date of change must not be null";
        this.dateOfChange = date;
    }

    public void setDateOfCreation(Timestamp date) {
        assert (date != null);
        this.dateOfCreation = date;
    }

    public String getReqIDPrefix() {
        if (this.reqIDPrefix == null) {
            return this.getGenericPrefix();
        }
        return this.reqIDPrefix;
    }

    public boolean isStandardPrefix() {
        return this.reqIDPrefix == null;
    }

    public void setReqIDPrefix(String string) {
        this.reqIDPrefix = string;
    }

    public void resetReqIDPrefix() {
        this.reqIDPrefix = null;
    }

    private String getGenericPrefix() {
        if (this.setName == null) {
            return "";
        }
        if (this.setName.length() <= 3) {
            return this.setName.toUpperCase();
        }
        return this.setName.substring(0, 3).toUpperCase();
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getReqIDPattern() {
        return this.reqIDPattern;
    }

    public void setReqIDPattern(String pattern) {
        assert (pattern != null) : "pattern is missing";
        this.reqIDPattern = pattern;
    }

    public static final boolean compareRequirementSetAttributes(EOReqSet reqSet1, EOReqSet reqSet2) {
        boolean equal = StringUtil.equals((String)reqSet1.getAuthor(), (String)reqSet2.getAuthor()) && StringUtil.equals((String)reqSet1.getDescription(), (String)reqSet2.getDescription()) && StringUtil.equals((String)reqSet1.getReqIDPattern(), (String)reqSet2.getReqIDPattern()) && StringUtil.equals((String)reqSet1.getReqIDPrefix(), (String)reqSet2.getReqIDPrefix()) && StringUtil.equals((String)reqSet1.getSetName(), (String)reqSet2.getSetName()) && StringUtil.equals((String)reqSet1.getTitle(), (String)reqSet2.getTitle());
        return equal;
    }

    public String getTypeID() {
        return EOReqSet.getDataTypeID();
    }

    public static String getDataTypeID() {
        return String.valueOf(ModuleIdentification.getModuleIdentification()) + ".reqSet";
    }
}

