/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm1.rqm1migrator.messages;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.IModifiedDataItem_V0;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EOReqAttrib;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EORequirement;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class EOReqOld
extends EOEncodableObject
implements IModifiedDataItem_V0 {
    private static final ILogger logger = Logger.getLogger(EOReqOld.class);
    public static final String XML_NAME = "requirementsmodule.req";
    private static final String ATTR_TAG_UUID = "uuid";
    private static final String ATTR_TAG_REQ_SET_UID = "reqsetuid";
    private static final String ATTR_TAG_SRC_SHEET = "srcSheet";
    private static final String ATTR_TAG_SRC_UID = "srcFileUid";
    private static final String ATTR_TAG_PROJECT_UUID = "project";
    private String uuid;
    private String reqsetUID;
    private String srcSheet;
    private String sourceUID;
    private String project;
    private EOList reqContent = new EOList();

    public EOReqOld() {
        super(XML_NAME);
    }

    public EOReqOld(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EORequirement createEORequirement() {
        EORequirement req = new EORequirement();
        req.setUid(this.getUUID());
        req.setProjectUID(this.getProjectUUID());
        req.setReqsetUID(this.getSetUID());
        req.setSrcSheet(this.getSrcSheet());
        req.setSourceUID(this.getSrcFileUID());
        req.setId(this.getRequirementAttribute("id"));
        req.setTitle(this.getRequirementAttribute("title"));
        req.setDescription(this.getRequirementAttribute("description"));
        req.setPriority(this.getRequirementAttribute("priority"));
        req.setSatisfaction(this.getRequirementAttribute("satisfaction"));
        req.setDissatisfaction(this.getRequirementAttribute("dissatisfaction"));
        req.setFitCriterion(this.getRequirementAttribute("fitCriterion"));
        req.setType(this.getRequirementAttribute("type"));
        req.setCategory(this.getRequirementAttribute("category"));
        req.setPartOfAgreement(this.getRequirementAttribute("partOfAgreement"));
        req.setAuthor(this.getRequirementAttribute("author"));
        req.setStatus(this.getRequirementAttribute("status"));
        req.setProbToChange(this.getRequirementAttribute("probToChange"));
        req.setEffortToChange(this.getRequirementAttribute("effortToChange"));
        req.setInitiator(this.getRequirementAttribute("initiator"));
        req.setVersion(this.getRequirementAttribute("version"));
        req.setRelatedReqs(this.getRequirementAttribute("relatedReqs"));
        req.setGeneralization(this.getRequirementAttribute("generalization"));
        req.setSpecialization(this.getRequirementAttribute("specilization"));
        req.setConflicts(this.getRequirementAttribute("conflicts"));
        req.setRelUseCases(this.getRequirementAttribute("relUseCases"));
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.applyPattern("MM.d.yyyy");
        String dateCreation = this.getRequirementAttribute("dateOfCreation");
        try {
            Date date = parser.parse(dateCreation);
            req.setDateOfCreation(new Timestamp(date.getTime()));
        }
        catch (ParseException e) {
            req.setDateOfCreation(new Timestamp(System.currentTimeMillis()));
        }
        String dateChange = this.getRequirementAttribute("dateOfChange");
        try {
            Date date = parser.parse(dateChange);
            req.setDateOfChange(new Timestamp(date.getTime()));
        }
        catch (ParseException e) {
            req.setDateOfChange(new Timestamp(System.currentTimeMillis()));
        }
        return req;
    }

    public void makeEOReqUnique() {
        this.uuid = UUIDGenerator.getUniqueID();
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_UUID, this.uuid);
        this.appendAttrToXML(writeContext, ATTR_TAG_REQ_SET_UID, this.reqsetUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_SRC_SHEET, this.srcSheet);
        this.appendAttrToXML(writeContext, ATTR_TAG_SRC_UID, this.sourceUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UUID, this.project);
    }

    public boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (ATTR_TAG_UUID.equals(name)) {
            this.uuid = value;
        } else if (ATTR_TAG_REQ_SET_UID.equals(name)) {
            this.reqsetUID = value;
        } else if (ATTR_TAG_SRC_SHEET.equals(name)) {
            this.srcSheet = value;
        } else if (ATTR_TAG_SRC_UID.equals(name)) {
            this.sourceUID = value;
        } else if (ATTR_TAG_PROJECT_UUID.equals(name)) {
            this.project = value;
        } else {
            success = false;
            Iterator iter = this.reqContent.iterator();
            boolean added = false;
            while (iter.hasNext()) {
                EOReqAttrib reqAttrib = (EOReqAttrib)((Object)iter.next());
                if (!reqAttrib.getAttribName().equals(name)) continue;
                try {
                    reqAttrib.addContent(value);
                }
                catch (EXDecoderException e) {
                    logger.error("could not execute", (Throwable)e);
                }
                added = true;
                success = true;
                break;
            }
            if (!added) {
                this.reqContent.add((EncodableObjectBase)new EOReqAttrib(name, value));
                success = true;
            }
        }
        return success;
    }

    protected boolean hasChildren() {
        return this.reqContent != null;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.reqContent != null) {
            this.reqContent.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = false;
        if ("List".equals(newChild.getTag())) {
            this.reqContent = (EOList)newChild;
            success = true;
        }
        return success;
    }

    public String getRequirementAttribute(String tag) {
        String attrValue = "";
        if (ATTR_TAG_REQ_SET_UID.equals(tag)) {
            attrValue = this.reqsetUID;
        } else if (ATTR_TAG_SRC_SHEET.equals(tag)) {
            attrValue = this.srcSheet;
        } else if (ATTR_TAG_SRC_UID.equals(tag)) {
            attrValue = this.sourceUID;
        } else if (ATTR_TAG_PROJECT_UUID.equals(tag)) {
            attrValue = this.project;
        } else {
            for (EOReqAttrib reqAttrib : this.reqContent) {
                if (!reqAttrib.getAttribName().equals(tag)) continue;
                attrValue = reqAttrib.getReqAttribute();
            }
        }
        return attrValue;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getSetUID() {
        return this.reqsetUID;
    }

    public String getSrcSheet() {
        return this.srcSheet;
    }

    public List getAttributes() {
        Iterator iterator = this.reqContent.iterator();
        ArrayList<String> attributes = new ArrayList<String>();
        while (iterator.hasNext()) {
            EOReqAttrib attrib = (EOReqAttrib)((Object)iterator.next());
            attributes.add(attrib.getReqAttribute());
        }
        return attributes;
    }

    public String getProjectUUID() {
        return this.project;
    }

    public void setUUID(String uuid) {
        assert (uuid != null);
        this.uuid = uuid;
    }

    public void setSetUID(String srcFileUID) {
        assert (srcFileUID != null);
        this.reqsetUID = srcFileUID;
    }

    public void setSrcSheet(String srcSheet) {
        this.srcSheet = srcSheet;
    }

    public void setProjectUUID(String project) {
        assert (project != null);
        this.project = project;
    }

    public Object getKey() {
        return this.uuid;
    }

    public void setSrcFileUID(String sourceUID) {
        this.sourceUID = sourceUID;
    }

    public String getSrcFileUID() {
        return this.sourceUID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EOReqOld)) {
            return false;
        }
        EOReqOld req = (EOReqOld)((Object)obj);
        return req == this || req.getUUID().equals(this.getUUID()) && req.getProjectUUID().equals(this.getProjectUUID());
    }

    public int hashCode() {
        return (String.valueOf(this.getProjectUUID()) + this.getUUID()).hashCode();
    }
}

