/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm1.rqm1migrator;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOAbstractModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleXMLDataEnvelope_V0;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EOReqOld;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EOReqSet;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EOReqSourceFile;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EORequirement;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.EORequirementNote;
import com.arcway.cockpit.rqm1.rqm1migrator.messages.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.util.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.util.Collection;

public class Converter {
    private static final Logger logger = Logger.getLogger(Converter.class);
    private static MessageDataFactory factory = MessageDataFactory.getInstance();
    private static final XMLDecoder xmlDecoder = new XMLDecoder();

    public static EOList convertIncomingRequirements(EOList serverRequirements) {
        EOList clientRequirements = new EOList();
        int i = 0;
        while (i < serverRequirements.size()) {
            EOModuleXMLDataEnvelope_V0 envelope = (EOModuleXMLDataEnvelope_V0)serverRequirements.get(i);
            EORequirement requirement = Converter.convertEnvelopeIntoRequirement(envelope);
            if (requirement != null) {
                clientRequirements.add((EncodableObjectBase)requirement);
            } else {
                logger.warn((Object)("RQM1: Converter.convertIncomingRequirements() - Unable to convert requirement: " + envelope.getXmlContentAsString()));
            }
            ++i;
        }
        return clientRequirements;
    }

    public static EOList convertIncomingNotes(EOList serverNotes) {
        EOList clientNotes = new EOList();
        int i = 0;
        while (i < serverNotes.size()) {
            EOModuleXMLDataEnvelope_V0 envelope = (EOModuleXMLDataEnvelope_V0)serverNotes.get(i);
            EORequirementNote note = Converter.convertEnvelopeIntoNote(envelope);
            if (note != null) {
                clientNotes.add((EncodableObjectBase)note);
            } else {
                logger.warn((Object)("RQM1: Converter.convertIncomingNotes() - Unable to convert note: " + envelope.getXmlContentAsString()));
            }
            ++i;
        }
        return clientNotes;
    }

    public static EOList convertIncomingSourceFileInfos(EOList serverSourceFileInfos, XMLDecoder decoder) {
        EOList clientSourceFileInfos = new EOList();
        int i = 0;
        while (i < serverSourceFileInfos.size()) {
            EOModuleXMLDataEnvelope_V0 envelope = (EOModuleXMLDataEnvelope_V0)serverSourceFileInfos.get(i);
            EOReqSourceFile sourceFileInfo = Converter.convertEnvelopeIntoSourceFileInfo(envelope, decoder);
            if (sourceFileInfo != null) {
                clientSourceFileInfos.add((EncodableObjectBase)sourceFileInfo);
            } else {
                logger.warn((Object)("RQM1: Converter.convertIncomingSourceFileInfos() - Unable to convert note: " + envelope.getXmlContentAsString()));
            }
            ++i;
        }
        return clientSourceFileInfos;
    }

    public static EOList convertIncomingReqSets(EOList serverReqSets) {
        EOList clientReqSets = new EOList();
        int i = 0;
        while (i < serverReqSets.size()) {
            EOModuleXMLDataEnvelope_V0 envelope = (EOModuleXMLDataEnvelope_V0)serverReqSets.get(i);
            EOReqSet set = Converter.convertEnvelopeIntoReqSet(envelope);
            if (set != null) {
                clientReqSets.add((EncodableObjectBase)set);
            } else {
                logger.warn((Object)("RQM1: Converter.convertIncomingReqSets() - Unable to convert reqSet: " + envelope.getXmlContentAsString()));
            }
            ++i;
        }
        return clientReqSets;
    }

    public static EORequirement convertEnvelopeIntoRequirement(EOModuleXMLDataEnvelope_V0 envelope) {
        EORequirement requirement = null;
        try {
            EncodableObjectBase obj = envelope.getXmlContentDecoded(xmlDecoder, (IEncodableObjectFactory)factory);
            if (obj instanceof EOReqOld) {
                EOReqOld oldReq = (EOReqOld)obj;
                requirement = oldReq.createEORequirement();
            } else if (obj instanceof EORequirement) {
                requirement = (EORequirement)obj;
            } else {
                logger.error((Object)("RMM-Converter.convertEnvelopeIntoRequirement() - unknown envelope content: " + envelope.getXmlContentAsString()));
            }
            if (requirement != null) {
                Converter.setAttributesInModuleData(requirement, envelope);
            }
            return requirement;
        }
        catch (RuntimeException e) {
            logger.warn((Object)("RQM1: Converter.convertEnvelopeIntoRequirement() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
        catch (EXDecoderException e) {
            logger.warn((Object)("RQM1: Converter.convertEnvelopeIntoRequirement() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
    }

    public static EORequirementNote convertEnvelopeIntoNote(EOModuleXMLDataEnvelope_V0 envelope) {
        try {
            EORequirementNote note = (EORequirementNote)envelope.getXmlContentDecoded(xmlDecoder, (IEncodableObjectFactory)factory);
            Converter.setAttributesInModuleData(note, envelope);
            return note;
        }
        catch (RuntimeException e) {
            logger.warn((Object)("RQM1: Converter.convertNoteFromEnvelope() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
        catch (EXDecoderException e) {
            logger.warn((Object)("RQM1: Converter.convertNoteFromEnvelope() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
    }

    public static EOReqSourceFile convertEnvelopeIntoSourceFileInfo(EOModuleXMLDataEnvelope_V0 envelope, XMLDecoder decoder) {
        try {
            EOReqSourceFile sourceFileInfo = (EOReqSourceFile)envelope.getXmlContentDecoded(decoder, (IEncodableObjectFactory)factory);
            Converter.setAttributesInModuleData((EOAbstractModuleData_V0)sourceFileInfo, envelope);
            return sourceFileInfo;
        }
        catch (RuntimeException e) {
            logger.warn((Object)("RQM1: Converter.convertEnvelopeIntoSourceFileInfo() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
        catch (EXDecoderException e) {
            logger.warn((Object)("RQM1: Converter.convertEnvelopeIntoSourceFileInfo() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
    }

    public static EOReqSet convertEnvelopeIntoReqSet(EOModuleXMLDataEnvelope_V0 envelope) {
        try {
            EOReqSet reqSet = (EOReqSet)envelope.getXmlContentDecoded(xmlDecoder, (IEncodableObjectFactory)factory);
            Converter.setAttributesInModuleData(reqSet, envelope);
            return reqSet;
        }
        catch (RuntimeException e) {
            logger.warn((Object)("RQM1: Converter.convertEnvelopeIntoRequirement() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
        catch (EXDecoderException e) {
            logger.warn((Object)("RQM1: Converter.convertEnvelopeIntoRequirement() - Invalid xml attribute: " + envelope.getXmlContentAsString()), (Throwable)e);
            return null;
        }
    }

    public static EOList convertOutgoingRequirements(Collection clientRequirements) throws EXEncoderException {
        EOList serverRequirements = new EOList();
        for (EORequirement requirement : clientRequirements) {
            EOModuleXMLDataEnvelope_V0 envelope = Converter.convertRequirementToEnvelope(requirement);
            serverRequirements.add((EncodableObjectBase)envelope);
        }
        return serverRequirements;
    }

    public static EOList convertOutgoingNotes(Collection clientNotes) throws EXEncoderException {
        EOList serverNotes = new EOList();
        for (EORequirementNote note : clientNotes) {
            EOModuleXMLDataEnvelope_V0 envelope = Converter.convertNoteToEnvelope(note);
            serverNotes.add((EncodableObjectBase)envelope);
        }
        return serverNotes;
    }

    public static EOList convertOutgoingSourceFileInfos(Collection clientSourceFileInfos) throws EXEncoderException {
        EOList serverSourceFileInfos = new EOList();
        for (EOReqSourceFile sourceFileInfo : clientSourceFileInfos) {
            EOModuleXMLDataEnvelope_V0 envelope = Converter.convertSourceFileToEnvelope(sourceFileInfo);
            serverSourceFileInfos.add((EncodableObjectBase)envelope);
        }
        return serverSourceFileInfos;
    }

    public static EOList convertOutgoingReqSet(Collection clientReqSets) throws EXEncoderException {
        EOList serverReqSets = new EOList();
        for (EOReqSet reqSet : clientReqSets) {
            EOModuleXMLDataEnvelope_V0 envelope = Converter.convertReqSetToEnvelope(reqSet);
            serverReqSets.add((EncodableObjectBase)envelope);
        }
        return serverReqSets;
    }

    public static EOModuleXMLDataEnvelope_V0 convertRequirementToEnvelope(EORequirement requirement) throws EXEncoderException {
        EOModuleXMLDataEnvelope_V0 envelope = new EOModuleXMLDataEnvelope_V0();
        Converter.setAttributesInEnvelope(envelope, requirement);
        envelope.setXmlContent((EncodableObjectBase)requirement);
        return envelope;
    }

    public static EOModuleXMLDataEnvelope_V0 convertNoteToEnvelope(EORequirementNote note) throws EXEncoderException {
        EOModuleXMLDataEnvelope_V0 envelope = new EOModuleXMLDataEnvelope_V0();
        Converter.setAttributesInEnvelope(envelope, note);
        envelope.setXmlContent((EncodableObjectBase)note);
        return envelope;
    }

    public static EOModuleXMLDataEnvelope_V0 convertSourceFileToEnvelope(EOReqSourceFile sourceFileInfo) throws EXEncoderException {
        EOModuleXMLDataEnvelope_V0 envelope = new EOModuleXMLDataEnvelope_V0();
        Converter.setAttributesInEnvelope(envelope, (EOAbstractModuleData_V0)sourceFileInfo);
        envelope.setXmlContent((EncodableObjectBase)sourceFileInfo);
        return envelope;
    }

    public static EOModuleXMLDataEnvelope_V0 convertReqSetToEnvelope(EOReqSet reqSet) throws EXEncoderException {
        EOModuleXMLDataEnvelope_V0 envelope = new EOModuleXMLDataEnvelope_V0();
        Converter.setAttributesInEnvelope(envelope, reqSet);
        envelope.setXmlContent((EncodableObjectBase)reqSet);
        return envelope;
    }

    private static void setAttributesInEnvelope(EOModuleXMLDataEnvelope_V0 envelope, EOAbstractModuleData_V0 moduleData) {
        envelope.setProjectUID(moduleData.getProjectUID());
        envelope.setUid(moduleData.getUID());
        envelope.setModCount(moduleData.getModCount());
        envelope.setUid(moduleData.getUID());
    }

    private static void setAttributesInModuleData(EOAbstractModuleData_V0 moduleData, EOModuleXMLDataEnvelope_V0 envelope) {
        moduleData.setProjectUID(envelope.getProjectUID());
        moduleData.setUid(envelope.getUID());
        moduleData.setModCount(envelope.getModCount());
        moduleData.setModTime(envelope.getModTime());
    }
}

