/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleXMLDataEnvelope_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOSourceFileInfo_V0;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOPMProject;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOTask;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.EOWorkItem;
import com.arcway.cockpit.ppm1.ppm1migrator.messages.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.util.ArrayList;
import java.util.List;

public class Converter {
    private static final ILogger logger = Logger.getLogger(Converter.class);
    private final MessageDataFactory factory = MessageDataFactory.getInstance();

    public EOList convertFromEnvelopes(List envelopes) {
        assert (envelopes != null) : "envelopes list is null";
        EOList unwrappedObjects = new EOList();
        int size = envelopes.size();
        int i = 0;
        while (i < size) {
            EOModuleXMLDataEnvelope_V0 envelope = (EOModuleXMLDataEnvelope_V0)envelopes.get(i);
            EncodableObjectBase unwrappedObject = this.convertFromEnvelope(envelope);
            if (unwrappedObject != null) {
                unwrappedObjects.add(unwrappedObject);
            } else {
                logger.warn("PMM.Converter.convertFromEnvelopes() - Unable to convert object from xml: " + envelope.getXmlContentAsString());
            }
            ++i;
        }
        return unwrappedObjects;
    }

    public EncodableObjectBase convertFromEnvelope(EOModuleXMLDataEnvelope_V0 envelope) {
        EncodableObjectBase unwrappedObject;
        block9: {
            assert (envelope != null) : "envelope is null";
            unwrappedObject = envelope.getXmlContentDecoded(new XMLDecoder(), (IEncodableObjectFactory)this.factory);
            if (unwrappedObject instanceof EOWorkItem) {
                EOWorkItem workItem = (EOWorkItem)unwrappedObject;
                workItem.setProjectUID(envelope.getProjectUID());
                workItem.setUID(envelope.getUID());
                break block9;
            }
            if (unwrappedObject instanceof EOTask) {
                EOTask task = (EOTask)unwrappedObject;
                task.setProjectUid(envelope.getProjectUID());
                task.setUid(envelope.getUID());
                break block9;
            }
            if (unwrappedObject instanceof EOPMProject) {
                EOPMProject pmProject = (EOPMProject)unwrappedObject;
                pmProject.setProjectUID(envelope.getProjectUID());
                pmProject.setUid(envelope.getUID());
                break block9;
            }
            if (unwrappedObject instanceof EOSourceFileInfo_V0) {
                EOSourceFileInfo_V0 sourceInfo = (EOSourceFileInfo_V0)unwrappedObject;
                sourceInfo.setProjectUID(envelope.getProjectUID());
                sourceInfo.setUid(envelope.getUID());
                break block9;
            }
            logger.error("PMM.Converter.convertFromEnvelope() unwrappedObject = " + unwrappedObject + " - Unexpected object type!", null);
            return null;
        }
        try {
            return unwrappedObject;
        }
        catch (RuntimeException e) {
            logger.warn("PMM.Converter.convertWorkItemFromEnvelope() - Invalid xml attribute: " + envelope.getXmlContentAsString(), (Throwable)e);
        }
        catch (EXDecoderException e) {
            logger.error("PMM.Converter.convertWorkItemFromEnvelope() - Invalid xml attribute: " + envelope.getXmlContentAsString(), (Throwable)e);
        }
        return null;
    }

    public List convertToEnvelopes(List objectsToWrap) throws EXEncoderException {
        assert (objectsToWrap != null) : " objectsToWrap list is null ";
        ArrayList<EOModuleXMLDataEnvelope_V0> envelopes = new ArrayList<EOModuleXMLDataEnvelope_V0>();
        int size = objectsToWrap.size();
        int i = 0;
        while (i < size) {
            EncodableObjectBase objectToWrap = (EncodableObjectBase)objectsToWrap.get(i);
            EOModuleXMLDataEnvelope_V0 envelope = this.convertToEnvelope(objectToWrap);
            envelopes.add(envelope);
            ++i;
        }
        return envelopes;
    }

    public EOModuleXMLDataEnvelope_V0 convertToEnvelope(EncodableObjectBase object) throws EXEncoderException {
        assert (object != null) : "object is null";
        EOModuleXMLDataEnvelope_V0 envelope = new EOModuleXMLDataEnvelope_V0();
        if (object instanceof EOWorkItem) {
            EOWorkItem workItem = (EOWorkItem)object;
            envelope.setProjectUID(workItem.getProjectUID());
            envelope.setUid(workItem.getUID());
        } else if (object instanceof EOTask) {
            EOTask task = (EOTask)object;
            envelope.setProjectUID(task.getProjectUID());
            envelope.setUid(task.getUID());
        } else if (object instanceof EOPMProject) {
            EOPMProject pmProject = (EOPMProject)object;
            envelope.setProjectUID(pmProject.getProjectUID());
            envelope.setUid(pmProject.getUID());
        } else if (object instanceof EOSourceFileInfo_V0) {
            EOSourceFileInfo_V0 sourceInfo = (EOSourceFileInfo_V0)object;
            envelope.setProjectUID(sourceInfo.getProjectUID());
            envelope.setUid(sourceInfo.getUID());
        } else {
            logger.error("PMM.Converter.convertToEnvelope(object = " + object + ") - Unexpected object type!", null);
        }
        envelope.setXmlContent(object);
        return envelope;
    }
}

