/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.exceptions.EXFailedToCreatePlanOrDirectoryException;
import com.arcway.cockpit.planimporter.exceptions.EXFilesImportException;
import com.arcway.cockpit.planimporter.exceptions.EXImportFailedException;
import com.arcway.cockpit.planimporter.exceptions.EXNoPlanFoundException;
import com.arcway.cockpit.planimporter.wizard.FileChooserDialog;
import com.arcway.cockpit.planimporter.wizard.PlansImportWizard;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PlanImportConversionPage
extends WizardPage {
    private static final ILogger logger = Logger.getLogger(PlanImportConversionPage.class);
    private Composite baseComposite;
    private File convertedFile;
    private final boolean directoryAllowed;
    private Button directoryBrowseButton;
    private Text directoryTxt;
    private String errorMessage;
    private Button fileBrowseButton;
    private Text fileTxt;
    private Plans importedPlans = null;
    private PlansImportWizard parent = null;
    private IPlansConverter plansConverter = null;
    private final String projectLanguage;
    private boolean updatedFileTxt;

    public PlanImportConversionPage(String pageName, IPlansConverter plansConverter, PlansImportWizard parent, String projectLanguage) {
        super(pageName);
        this.plansConverter = plansConverter;
        this.parent = parent;
        this.projectLanguage = projectLanguage;
        this.updatedFileTxt = false;
        this.directoryAllowed = plansConverter.getSourceFileType().isDirectoryAllowed();
    }

    public boolean canFlipToNextPage() {
        IWizardPage nextPage = super.getNextPage();
        return this.isPageComplete() && nextPage != null;
    }

    public void createControl(Composite parentComposite) {
        this.baseComposite = new Composite(parentComposite, 0);
        this.baseComposite.setLayoutData((Object)new GridData(1808));
        this.baseComposite.setLayout((Layout)new GridLayout(3, false));
        this.setPageComplete(false);
        if (this.directoryAllowed) {
            this.createControlFileAndDirectory(this.baseComposite);
        } else {
            this.createControlFile(this.baseComposite);
        }
        this.setControl((Control)this.baseComposite);
    }

    public Plans getImportPlans() {
        return this.importedPlans;
    }

    public IWizardPage getNextPage() {
        IWizardPage nextPage = super.getNextPage();
        if (this.isReadyToConvert()) {
            this.startConversion(this.getNameToConvert());
            return nextPage;
        }
        return null;
    }

    public void init() {
        this.setTitle(this.plansConverter.getLocalizedName(Locale.getDefault()));
        this.setDescription(Messages.getString("PlanImportConversion.description"));
    }

    public void startConversion(String fileName) {
        this.errorMessage = "";
        this.parent.setConversionErrorMessage(this.getDescription(), 0);
        this.setMessage(this.getDescription());
        this.importedPlans = null;
        this.convertedFile = new File(fileName);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                JFaceProgressMonitorToProgressDisplayAdapter progressDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                try {
                    PlanImportConversionPage.this.importedPlans = PlanImportConversionPage.this.plansConverter.convert(PlanImportConversionPage.this.convertedFile, (IProgressDisplay)progressDisplay, PlanImportConversionPage.this.projectLanguage);
                }
                catch (EXImportFailedException e) {
                    if (e instanceof EXFilesImportException) {
                        PlanImportConversionPage.this.importedPlans = ((EXFilesImportException)e).getImportedPlans();
                    }
                    PlanImportConversionPage planImportConversionPage = PlanImportConversionPage.this;
                    planImportConversionPage.errorMessage = String.valueOf(planImportConversionPage.errorMessage) + e.getLocalizedMessage() + " ";
                    PlanImportConversionPage.this.parent.setConversionErrorMessage(PlanImportConversionPage.this.errorMessage, 3);
                    PlanImportConversionPage.this.setMessage(PlanImportConversionPage.this.errorMessage, 3);
                }
                progressDisplay.endTask();
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            this.errorMessage = String.valueOf(this.errorMessage) + e.getLocalizedMessage() + "\n" + Messages.getString("PlanImportConversion.moreInfo", Locale.getDefault()) + "\n";
            this.parent.setConversionErrorMessage(this.errorMessage, 3);
            this.setMessage(this.errorMessage, 3);
            logger.error("InvocationTargetException", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException", (Throwable)e);
        }
        try {
            if (this.importedPlans != null) {
                try {
                    this.checkPlans(this.importedPlans);
                }
                catch (EXFailedToCreatePlanOrDirectoryException e) {
                    this.errorMessage = String.valueOf(this.errorMessage) + e.getLocalizedMessage() + "\n";
                    this.parent.setConversionErrorMessage(this.errorMessage, 2);
                    this.setMessage(this.errorMessage, 2);
                }
                Collection allPlans = this.importedPlans.getAllPlans();
                if (allPlans.isEmpty()) {
                    throw new EXNoPlanFoundException();
                }
            } else {
                throw new EXNoPlanFoundException();
            }
            this.parent.updateImportedPlans(this.importedPlans);
        }
        catch (EXNoPlanFoundException e) {
            this.errorMessage = String.valueOf(this.errorMessage) + e.getLocalizedMessage() + "\n";
            int type = this.getMessageType();
            if (type == 0) {
                type = 3;
            }
            this.parent.setConversionErrorMessage(this.errorMessage, type);
            this.setMessage(this.errorMessage, type);
        }
        this.setPageComplete(true);
    }

    /*
     * Unable to fully structure code
     */
    private void checkPlans(Plans plans) throws EXNoPlanFoundException, EXFailedToCreatePlanOrDirectoryException {
        unloadedPlans = new ArrayList<Plan>();
        emptyPlans = new ArrayList<Plan>();
        emptyDirectories = new ArrayList<PlanDirectory>();
        allPlans = plans.getAllPlans();
        if (allPlans.isEmpty()) {
            throw new EXNoPlanFoundException();
        }
        rootLevelPlans = plans.getPlans();
        for (Plan plan : rootLevelPlans) {
            loadedPlan = plan.getLoadedPlan();
            if (loadedPlan == null) {
                unloadedPlans.add(plan);
                continue;
            }
            if (loadedPlan.getPlanElementCount() != 0) continue;
            emptyPlans.add(plan);
        }
        subDirectories = plans.getPlanDirectories();
        for (PlanDirectory planDirectory : subDirectories) {
            if (planDirectory.getAllPlans().isEmpty()) {
                emptyDirectories.add(planDirectory);
                continue;
            }
            try {
                this.checkPlans((Plans)planDirectory);
                continue;
            }
            catch (EXFailedToCreatePlanOrDirectoryException e) {
                ** for (plan : e.getUnloadedPlans())
            }
lbl-1000:
            // 1 sources

            {
                planDirectory.removePlan(plan);
                continue;
            }
lbl31:
            // 2 sources

            for (Plan plan : e.getEmptyPlans()) {
                planDirectory.removePlan(plan);
            }
            for (PlanDirectory planDirectory2 : e.getEmptyDirectories()) {
                planDirectory.removePlanDirectory(planDirectory2);
            }
            unloadedPlans.addAll(e.getUnloadedPlans());
            emptyPlans.addAll(e.getEmptyPlans());
            emptyDirectories.addAll(e.getEmptyDirectories());
        }
        if (!(unloadedPlans.isEmpty() && emptyPlans.isEmpty() && emptyDirectories.isEmpty())) {
            for (Plan plan : unloadedPlans) {
                plans.removePlan(plan);
            }
            for (Plan plan : emptyPlans) {
                plans.removePlan(plan);
            }
            for (PlanDirectory planDirectory : emptyDirectories) {
                plans.removePlanDirectory(planDirectory);
            }
            throw new EXFailedToCreatePlanOrDirectoryException(unloadedPlans, emptyPlans, emptyDirectories);
        }
    }

    private void createControlFile(Composite base) {
        Label lblFile = new Label(base, 0);
        lblFile.setText(Messages.getString("PlanImportConversion.file"));
        this.fileTxt = new Text(base, 2048);
        this.fileTxt.setLayoutData((Object)new GridData(768));
        this.fileTxt.setEditable(false);
        Button browseButton = new Button(base, 0);
        browseButton.setText(Messages.getString("PlanImportConversion.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PlanImportConversionPage.this.fileTxt.getText().equals("")) {
                    PlanImportConversionPage.this.setPageComplete(false);
                }
                PlanImportConversionPage.this.startFileChooserDialog();
                PlanImportConversionPage.this.setPageComplete(true);
            }
        });
    }

    private void createControlFileAndDirectory(Composite base) {
        Button fileRadioButton = new Button(base, 16);
        fileRadioButton.setText(Messages.getString("PlanImportConversion.file"));
        this.fileTxt = new Text(base, 2048);
        this.fileTxt.setLayoutData((Object)new GridData(768));
        this.fileTxt.setEditable(false);
        this.fileBrowseButton = new Button(base, 0);
        this.fileBrowseButton.setText(Messages.getString("PlanImportConversion.browse"));
        this.fileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlanImportConversionPage.this.startFileChooserDialog();
                PlanImportConversionPage.this.updatedFileTxt = true;
                PlanImportConversionPage.this.setPageComplete(true);
            }
        });
        Button directoryRadioButton = new Button(base, 16);
        directoryRadioButton.setText(Messages.getString("PlanImportConversion.directory"));
        this.directoryTxt = new Text(base, 2048);
        this.directoryTxt.setLayoutData((Object)new GridData(768));
        this.directoryTxt.setEditable(false);
        this.directoryTxt.setEnabled(false);
        this.directoryBrowseButton = new Button(base, 0);
        this.directoryBrowseButton.setText(Messages.getString("PlanImportConversion.browse"));
        this.directoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlanImportConversionPage.this.startDirectoryChooserDialog();
                PlanImportConversionPage.this.updatedFileTxt = false;
                PlanImportConversionPage.this.setPageComplete(true);
            }
        });
        this.directoryBrowseButton.setEnabled(false);
        fileRadioButton.setSelection(true);
        fileRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PlanImportConversionPage.this.fileTxt.setEnabled(true);
                PlanImportConversionPage.this.fileBrowseButton.setEnabled(true);
                PlanImportConversionPage.this.directoryTxt.setEnabled(false);
                PlanImportConversionPage.this.directoryBrowseButton.setEnabled(false);
                PlanImportConversionPage.this.updatedFileTxt = true;
                if (PlanImportConversionPage.this.fileTxt.getText().equals("")) {
                    PlanImportConversionPage.this.setPageComplete(false);
                } else {
                    PlanImportConversionPage.this.setPageComplete(true);
                }
            }
        });
        directoryRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PlanImportConversionPage.this.fileTxt.setEnabled(false);
                PlanImportConversionPage.this.fileBrowseButton.setEnabled(false);
                PlanImportConversionPage.this.directoryTxt.setEnabled(true);
                PlanImportConversionPage.this.directoryBrowseButton.setEnabled(true);
                PlanImportConversionPage.this.updatedFileTxt = false;
                if (PlanImportConversionPage.this.directoryTxt.getText().equals("")) {
                    PlanImportConversionPage.this.setPageComplete(false);
                } else {
                    PlanImportConversionPage.this.setPageComplete(true);
                }
            }
        });
    }

    private String getNameToConvert() {
        if (this.directoryAllowed && !this.updatedFileTxt) {
            return this.directoryTxt.getText();
        }
        return this.fileTxt.getText();
    }

    private boolean isReadyToConvert() {
        String str = this.getNameToConvert();
        return !str.equals("");
    }

    private void startDirectoryChooserDialog() {
        FileChooserDialog fileDialog = new FileChooserDialog(this.plansConverter.getSourceFileType());
        String directoryName = fileDialog.openDirectoryDialog(this.getShell());
        if (directoryName != null && !directoryName.equals("")) {
            this.directoryTxt.setText(directoryName);
        }
    }

    private void startFileChooserDialog() {
        FileChooserDialog fileDialog = new FileChooserDialog(this.plansConverter.getSourceFileType());
        String fileName = fileDialog.openFileDialog(this.getShell());
        if (fileName != null && !fileName.equals("")) {
            this.fileTxt.setText(fileName);
        }
    }

    public void dispose() {
        this.baseComposite.dispose();
        super.dispose();
    }
}

