/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.SourceFileType;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import java.io.File;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileChooserDialog {
    private String[] allowedFileExtensions;

    public FileChooserDialog(SourceFileType fileType) {
        this.allowedFileExtensions = fileType.getAllowedFileExtension();
    }

    public String openFileDialog(Shell shell) {
        String file = null;
        FileDialog dialog = new FileDialog(shell, 4096);
        String extension = "";
        int i = 0;
        while (i < this.allowedFileExtensions.length - 1) {
            extension = String.valueOf(extension) + this.allowedFileExtensions[i] + "; ";
            ++i;
        }
        extension = String.valueOf(extension) + this.allowedFileExtensions[this.allowedFileExtensions.length - 1];
        this.allowedFileExtensions = new String[]{extension};
        dialog.setFilterExtensions(this.allowedFileExtensions);
        if (ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled")) {
            dialog.setFilterPath(ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getString("defaultFileSystemPath.Path"));
        }
        if (dialog.open() != null) {
            String filename = dialog.getFileName();
            int fileExtensionIndex = filename.lastIndexOf(".");
            if (fileExtensionIndex < 0) {
                filename = String.valueOf(filename) + this.allowedFileExtensions[0];
            }
            file = String.valueOf(dialog.getFilterPath()) + File.separator + filename;
        }
        return file;
    }

    public String openDirectoryDialog(Shell shell) {
        String pathname = "";
        DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
        dialog.setMessage(Messages.getString("FileChooserDialog.directory"));
        dialog.setFilterPath(ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getString("defaultFileSystemPath.Path"));
        String chosenPath = dialog.open();
        if (chosenPath != null) {
            pathname = chosenPath;
        }
        return pathname;
    }
}

