/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.exceptions;

import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.exceptions.EXImportFailedException;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class EXFilesImportException
extends EXImportFailedException {
    private final Collection<String> notImportedPlanFiles;
    private Plans plans;

    public EXFilesImportException(Plans plans, Collection<String> files) {
        this.notImportedPlanFiles = files;
        this.plans = plans;
    }

    public EXFilesImportException(Collection<String> files, Throwable e) {
        super(e);
        this.notImportedPlanFiles = files;
    }

    public Collection<String> getUnimportedPlanFiles() {
        return this.notImportedPlanFiles;
    }

    public Plans getImportedPlans() {
        return this.plans;
    }

    @Override
    public String getMessage() {
        return Messages.getString("FilesImportException.message");
    }

    @Override
    public String getLocalizedMessage() {
        String notImportedPlanFileNames = "";
        String errorMessage = "";
        if (!this.notImportedPlanFiles.isEmpty()) {
            Iterator<String> it = this.notImportedPlanFiles.iterator();
            while (it.hasNext()) {
                notImportedPlanFileNames = String.valueOf(notImportedPlanFileNames) + it.next();
                if (!it.hasNext()) continue;
                notImportedPlanFileNames = String.valueOf(notImportedPlanFileNames) + ", ";
            }
            errorMessage = String.valueOf(errorMessage) + Messages.getString("FilesImportException.unloadedPlans", Locale.getDefault()) + " " + notImportedPlanFileNames + " " + Messages.getString("FilesImportException.unloadedPlans2", Locale.getDefault()) + "\n ";
        }
        return errorMessage;
    }
}

