/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.exceptions;

import com.arcway.cockpit.planimporter.Messages;
import com.arcway.cockpit.planimporter.exceptions.EXImportFailedException;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class EXFailedToCreatePlanOrDirectoryException
extends EXImportFailedException {
    private final Collection<Plan> unloadedPlans;
    private final Collection<Plan> emptyPlans;
    private final Collection<PlanDirectory> emptyDirectories;

    public EXFailedToCreatePlanOrDirectoryException(Collection<Plan> unloadedPlans, Collection<Plan> emptyPlans, Collection<PlanDirectory> emptyDirectories) {
        this.unloadedPlans = unloadedPlans;
        this.emptyPlans = emptyPlans;
        this.emptyDirectories = emptyDirectories;
    }

    public Collection<Plan> getUnloadedPlans() {
        return this.unloadedPlans;
    }

    public Collection<Plan> getEmptyPlans() {
        return this.emptyPlans;
    }

    public Collection<PlanDirectory> getEmptyDirectories() {
        return this.emptyDirectories;
    }

    @Override
    public String getMessage() {
        return Messages.getString("FailedToCreatePlanOrDirectoryException.message");
    }

    @Override
    public String getLocalizedMessage() {
        Iterator<Plan> it;
        String unloadedPlanNames = "";
        String emptyPlanNames = "";
        String emptyDirectoryNames = "";
        String errorMessage = "";
        if (!this.unloadedPlans.isEmpty()) {
            it = this.unloadedPlans.iterator();
            while (it.hasNext()) {
                unloadedPlanNames = String.valueOf(unloadedPlanNames) + it.next().getName();
                if (!it.hasNext()) continue;
                unloadedPlanNames = String.valueOf(unloadedPlanNames) + ", ";
            }
            errorMessage = String.valueOf(errorMessage) + Messages.getString("FailedToCreatePlanOrDirectoryException.unloadedPlans", Locale.getDefault()) + " " + unloadedPlanNames + "\n ";
        }
        if (!this.emptyPlans.isEmpty()) {
            it = this.emptyPlans.iterator();
            while (it.hasNext()) {
                emptyPlanNames = String.valueOf(emptyPlanNames) + it.next().getName();
                if (!it.hasNext()) continue;
                emptyPlanNames = String.valueOf(emptyPlanNames) + ", ";
            }
            errorMessage = String.valueOf(errorMessage) + Messages.getString("FailedToCreatePlanOrDirectoryException.emptyPlans", Locale.getDefault()) + " " + emptyPlanNames + "\n ";
        }
        if (!this.emptyDirectories.isEmpty()) {
            it = this.emptyDirectories.iterator();
            while (it.hasNext()) {
                emptyDirectoryNames = String.valueOf(emptyDirectoryNames) + ((PlanDirectory)it.next()).getName();
                if (!it.hasNext()) continue;
                emptyDirectoryNames = String.valueOf(emptyDirectoryNames) + ", ";
            }
            errorMessage = String.valueOf(errorMessage) + Messages.getString("FailedToCreatePlanOrDirectoryException.emptyDirectories", Locale.getDefault()) + " " + emptyDirectoryNames + "\n ";
        }
        return errorMessage;
    }
}

