/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.converter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.lib.java.To;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.planagent.planimporterexporter.IDataElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CustomAttributesConverter {
    private static final String ATTRIBUTE_ID_PREFIX = "custom.";
    private static final String REGEXP_FOR_MULTIPLECHOICE_SEPARATION = ",";
    private static final ILogger logger = Logger.getLogger(CustomAttributesConverter.class);

    public static Collection<IAttribute> convertIntoFrameAttributes(IFrameProjectAgent projectAgent, IDataElement dataElement, String targetDataTypeID) {
        Map sourceAttributes = dataElement.getCustomAttributes();
        List attributeTypes = projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(targetDataTypeID);
        ArrayList<IAttribute> targetAttributes = new ArrayList<IAttribute>(attributeTypes.size());
        for (IAttributeType attributeType : attributeTypes) {
            IAttributeTypeID attributeTypeID = attributeType.getAttributeTypeID();
            String targetAttributeID = attributeType.getHumanReadableID();
            String sourceAttributeID = CustomAttributesConverter.getSourceAttributeID(targetAttributeID);
            IAttributeTypeDataType dataType = attributeType.getDataType();
            IValueRange valueRange = attributeType.getValueRange();
            String separator = dataType instanceof DataTypeEnumerationMultiple ? CustomAttributesConverter.getRegExpForMultipleChoiceSeparation() : null;
            if (!sourceAttributes.containsKey(sourceAttributeID)) continue;
            String sourceAttributeValue = (String)sourceAttributes.get(sourceAttributeID);
            if (!(dataType instanceof DataTypeText)) {
                sourceAttributeValue = StringUtil.removeLineBreaksAndControlCharacters((String)sourceAttributeValue).trim();
            }
            try {
                Object targetAttributeValue = dataType.getAttributeValueFromString(sourceAttributeValue, valueRange, separator);
                if (dataType.supportsValue(targetAttributeValue, valueRange)) {
                    Attribute targetAttribute = new Attribute(attributeTypeID, targetAttributeValue);
                    targetAttributes.add((IAttribute)targetAttribute);
                    continue;
                }
                logger.info("could not parse attribute with source type id  " + To.makeNotNull((Object)sourceAttributeID) + " and source value " + To.makeNotNull((Object)sourceAttributeValue) + " into target data type " + To.makeNotNull((Object)dataType.getID()) + " of attribute type " + To.makeNotNull((Object)targetAttributeID) + " of cockpit data type " + To.makeNotNull((Object)targetDataTypeID) + " on plan import: ");
            }
            catch (Throwable e) {
                logger.error("could not convert attribute with source type id  " + To.makeNotNull((Object)sourceAttributeID) + " and source value " + To.makeNotNull((Object)sourceAttributeValue) + " into target data type " + To.makeNotNull((Object)dataType.getID()) + " of attribute type " + To.makeNotNull((Object)targetAttributeID) + " of cockpit data type " + To.makeNotNull((Object)targetDataTypeID) + " on plan import: ", e);
            }
        }
        return targetAttributes;
    }

    private static String getSourceAttributeID(String targetAttributeID) {
        String sourceAttributeID = targetAttributeID.startsWith(ATTRIBUTE_ID_PREFIX) ? targetAttributeID.substring(ATTRIBUTE_ID_PREFIX.length()) : null;
        return sourceAttributeID;
    }

    private static String getRegExpForMultipleChoiceSeparation() {
        return REGEXP_FOR_MULTIPLECHOICE_SEPARATION;
    }

    private CustomAttributesConverter() {
    }
}

