/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter;

import java.util.ArrayList;
import java.util.Collection;

public class SourceFileType {
    private final boolean directoriesAllowed;
    private final Collection<String> allowedFileExtensions;

    public SourceFileType(String allowedFileExtension, boolean directoriesAllowed) {
        this.allowedFileExtensions = new ArrayList<String>(1);
        this.allowedFileExtensions.add(allowedFileExtension);
        this.directoriesAllowed = directoriesAllowed;
    }

    public SourceFileType(Collection<String> allowedFileExtensions, boolean directoriesAllowed) {
        this.allowedFileExtensions = allowedFileExtensions;
        this.directoriesAllowed = directoriesAllowed;
    }

    public boolean isAllowedFileExtension(String extension) {
        for (String allowedFileExtension : this.allowedFileExtensions) {
            if (!allowedFileExtension.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public String[] getAllowedFileExtension() {
        String[] extensions = new String[this.allowedFileExtensions.size()];
        int j = 0;
        for (String extension : this.allowedFileExtensions) {
            extensions[j++] = "*." + extension;
        }
        return extensions;
    }

    public boolean isDirectoryAllowed() {
        return this.directoriesAllowed;
    }
}

