/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.planfiles.converter;

import com.arcway.cockpit.planimporter.SourceFileType;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.exceptions.EXFileImportException;
import com.arcway.cockpit.planimporter.exceptions.EXFilesImportException;
import com.arcway.cockpit.planimporter.exceptions.EXNoPlanFoundException;
import com.arcway.cockpit.planimporter.planfiles.Messages;
import com.arcway.cockpit.planimporter.planfiles.resource.Icons16x16;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class PlanFile2PlanFileConverter
implements IPlansConverter {
    private Collection<String> notImportedPlanFiles;
    private int workReported;

    public Plans convert(File input, IProgressDisplay progressDisplay, String projectLanguage) throws EXNoPlanFoundException, EXFilesImportException {
        Plans plans = new Plans();
        this.notImportedPlanFiles = new ArrayList<String>();
        this.workReported = 0;
        int workedUnits = this.getNumberOfWorkUnits(input, 0);
        if (workedUnits <= 0) {
            throw new EXNoPlanFoundException();
        }
        progressDisplay.beginQuantifiedTask("", workedUnits, false);
        if (input.isFile()) {
            progressDisplay.reportQuantifiedProgress(this.workReported++, input.getName());
            try {
                plans.addPlan(this.convertPlanFile(input));
            }
            catch (EXFileImportException e) {
                this.notImportedPlanFiles.add(e.getFilename());
            }
        } else {
            plans = new PlanDirectory(input.getAbsolutePath(), "", false);
            this.convertPlanDirectory((PlanDirectory)plans, input, progressDisplay);
        }
        if (!this.notImportedPlanFiles.isEmpty()) {
            throw new EXFilesImportException(plans, this.notImportedPlanFiles);
        }
        return plans;
    }

    public IStreamResource getIcon16x16() {
        return Icons16x16.IMPORT;
    }

    public String getID() {
        return Messages.getString("PlanFile2PlanFileConverter.ID");
    }

    public String getLocalizedDescription(Locale language) {
        return Messages.getString("PlanFile2PlanFileConverter.description", language);
    }

    public String getLocalizedName(Locale language) {
        return Messages.getString("PlanFile2PlanFileConverter.name", language);
    }

    public SourceFileType getSourceFileType() {
        ArrayList<String> allowedFileExtensions = new ArrayList<String>();
        List planTypeDescriptions = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptions();
        for (Object name : planTypeDescriptions) {
            PlanTypeDescription planTypeDescription = (PlanTypeDescription)name;
            String extension = planTypeDescription.getFileExtension();
            if (allowedFileExtensions.contains(extension)) continue;
            allowedFileExtensions.add(extension);
        }
        return new SourceFileType(allowedFileExtensions, true);
    }

    private void convertPlanDirectory(PlanDirectory parent, File input, IProgressDisplay progressDisplay) {
        File[] fileList = input.listFiles();
        SourceFileType fileType = this.getSourceFileType();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                int index;
                String fileName = file.getName();
                String extension = fileName.substring(index = fileName.lastIndexOf(".") + 1);
                if (fileType.isAllowedFileExtension(extension)) {
                    try {
                        progressDisplay.reportQuantifiedProgress(this.workReported++, fileName);
                        Plan plan = this.convertPlanFile(file);
                        parent.addPlan(plan);
                    }
                    catch (EXFileImportException e) {
                        this.notImportedPlanFiles.add(e.getFilename());
                    }
                }
            } else {
                PlanDirectory planSubDirectory = new PlanDirectory(file.getName(), "", false);
                this.convertPlanDirectory(planSubDirectory, file, progressDisplay);
                parent.addPlanDirectory(planSubDirectory);
            }
            ++n2;
        }
        ArrayList plans = (ArrayList)parent.getAllPlans();
        int i = 0;
        while (i < plans.size()) {
            Plan plan = (Plan)plans.get(i);
            String planName = plan.getName();
            int count = 1;
            int j = i + 1;
            while (j < plans.size()) {
                Plan secondPlan = (Plan)plans.get(j);
                if (secondPlan.getName().equals(planName)) {
                    secondPlan.setName(String.valueOf(planName) + " (" + count + ")");
                    ++count;
                }
                ++j;
            }
            ++i;
        }
    }

    private Plan convertPlanFile(File input) throws EXFileImportException {
        IPMPlanRO loadedPlan = null;
        loadedPlan = this.loadPlan(input);
        Plan plan = new Plan(loadedPlan, loadedPlan.getName(), "", null, false);
        return plan;
    }

    private int getNumberOfWorkUnits(File fileName, int s) {
        int size = s;
        SourceFileType fileType = this.getSourceFileType();
        if (fileName.isFile()) {
            int index = fileName.getName().lastIndexOf(".") + 1;
            String extension = fileName.getName().substring(index);
            if (fileType.isAllowedFileExtension(extension)) {
                ++size;
            }
        }
        if (fileName.isDirectory()) {
            File[] fileList;
            File[] fileArray = fileList = fileName.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                size = this.getNumberOfWorkUnits(element, size);
                ++n2;
            }
        }
        return size;
    }

    private IPMPlanRO loadPlan(File input) throws EXFileImportException {
        PMPlan plan = null;
        if (input.exists()) {
            PlanModelMgr planModelManager = new PlanModelMgr();
            this.setupPlan(input, planModelManager);
            plan = planModelManager.getPlan();
        }
        if (plan == null) {
            throw new EXFileImportException(input.getName());
        }
        if (plan.getUid() == null) {
            throw new EXFileImportException(input.getName());
        }
        return plan;
    }

    private void setupPlan(File input, PlanModelMgr planModelMgr) throws EXFileImportException {
        PlanModelMgr planModelManager = planModelMgr;
        if (input == null || !input.exists()) {
            return;
        }
        try {
            BufferedInputStream content = new BufferedInputStream(new FileInputStream(input));
            planModelManager.load((InputStream)content);
        }
        catch (Exception e) {
            planModelManager = null;
            throw new EXFileImportException(input.getName());
        }
    }
}

