/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.excel2epc.converter;

import com.arcway.cockpit.planimporter.SourceFileType;
import com.arcway.cockpit.planimporter.converter.IPlansConverter;
import com.arcway.cockpit.planimporter.excel2epc.Messages;
import com.arcway.cockpit.planimporter.excel2epc.resource.Icons16x16;
import com.arcway.cockpit.planimporter.exceptions.EXFileImportException;
import com.arcway.cockpit.planimporter.exceptions.EXFileNotFormattedCorrectly;
import com.arcway.cockpit.planimporter.ole.excel.graphreader.ExcelGraphReader;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.planimporterexporter.bpre.epc.EPCPlanGenerator;
import com.arcway.planagent.planimporterexporter.graphs.Graph;
import com.arcway.planagent.planimporterexporter.graphs.Graphs;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class Excel2EPCConverter
implements IPlansConverter {
    public Plans convert(File file, IProgressDisplay progressDisplay, String projectLanguage) throws EXFileImportException, EXFileNotFormattedCorrectly {
        Graphs graphs = new Graphs();
        Collection<Graph> convertedGraphs = this.convertFile(file, progressDisplay, this.getLocalizedDescription(Locale.getDefault()));
        graphs.addGraphs(convertedGraphs);
        EPCPlanGenerator planGenerator = new EPCPlanGenerator();
        try {
            Plans plans = planGenerator.generatePlans(graphs);
            return plans;
        }
        catch (EXSetupPlanException e) {
            throw new EXFileImportException(file.getName(), e.getMessage());
        }
    }

    private Collection<Graph> convertFile(File file, IProgressDisplay progressDisplay, String progressDisplayDescription) throws EXFileImportException, EXFileNotFormattedCorrectly {
        String path = file.getAbsolutePath();
        int index = path.lastIndexOf(".") + 1;
        String extension = path.substring(index);
        if (this.getSourceFileType().isAllowedFileExtension(extension)) {
            ExcelGraphReader graphReader = new ExcelGraphReader();
            Collection graphs = graphReader.getGraphs(file, progressDisplay, progressDisplayDescription);
            return graphs;
        }
        return Collections.emptyList();
    }

    public IStreamResource getIcon16x16() {
        return Icons16x16.IMPORT;
    }

    public String getLocalizedDescription(Locale language) {
        return Messages.getString("Excel2EPCConverter.description", language);
    }

    public String getID() {
        return Messages.getString("Excel2EPCConverter.id");
    }

    public String getLocalizedName(Locale language) {
        return Messages.getString("Excel2EPCConverter.name", language);
    }

    public SourceFileType getSourceFileType() {
        return new SourceFileType((Collection)ExcelGraphReader.getSupportedExcelExtensions(), false);
    }
}

