/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import com.arcway.cockpit.p2.ui.UpdateUtil;
import com.arcway.lib.eclipse.update.EclipseP2DataAreaFix;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.internal.p2.ui.sdk.PreloadingRepositoryHandler;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class UpdateHandler
extends PreloadingRepositoryHandler {
    private static final ILogger LOGGER = Logger.getLogger(UpdateHandler.class);
    boolean hasNoRepos = false;
    UpdateOperation operation;

    @Override
    public Object execute(ExecutionEvent event) {
        if (EclipseP2DataAreaFix.wasEclipseP2DataAreaFixAppliedDuringStartup()) {
            EclipseP2DataAreaFix.showRestartNeededBeforeChangingTheInstallation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event));
            return null;
        }
        try {
            return super.execute(event);
        }
        catch (IllegalStateException e) {
            UpdateUtil.showInstallationModificationRestrictionsInfoDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            LOGGER.error("Unable to change Installation.", (Throwable)e);
            return null;
        }
    }

    @Override
    protected void doExecute(LoadMetadataRepositoryJob job) {
        if (this.hasNoRepos) {
            boolean goToSites;
            if (this.getProvisioningUI().getPolicy().getRepositoriesVisible() && (goToSites = MessageDialog.openQuestion((Shell)this.getShell(), (String)ProvSDKMessages.UpdateHandler_NoSitesTitle, (String)ProvSDKMessages.UpdateHandler_NoSitesMessage))) {
                this.getProvisioningUI().manipulateRepositories(this.getShell());
            }
            return;
        }
        job.reportAccumulatedStatus();
        if (this.getProvisioningUI().getPolicy().continueWorkingWithOperation((ProfileChangeOperation)this.operation, this.getShell())) {
            this.getProvisioningUI().openUpdateWizard(false, this.operation, job);
        }
    }

    @Override
    protected void doPostLoadBackgroundWork(IProgressMonitor monitor) throws OperationCanceledException {
        this.operation = this.getProvisioningUI().getUpdateOperation(null, null);
        IStatus resolveStatus = this.operation.resolveModal(monitor);
        if (resolveStatus.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
    }

    @Override
    protected boolean preloadRepositories() {
        this.hasNoRepos = false;
        RepositoryTracker repoMan = this.getProvisioningUI().getRepositoryTracker();
        if (repoMan.getKnownRepositories(this.getProvisioningUI().getSession()).length == 0) {
            this.hasNoRepos = true;
            return false;
        }
        return super.preloadRepositories();
    }

    @Override
    protected String getProgressTaskName() {
        return ProvSDKMessages.UpdateHandler_ProgressTaskName;
    }
}

