/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.issuemodule1migrator.projectfiles;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.cockpit.issuemodule1migrator.core.ISM1MigratorCore;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EOIssue;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EONote;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;

public class ISM1Migrator_ForProjectFiles {
    private static final ILogger logger = Logger.getLogger(ISM1Migrator_ForProjectFiles.class);

    public static void migrateACTOrACP(HistoricProjectFileView_0_ projectFileView_0_) {
        try {
            ArrayList<EOLink_V0> ism1IssueMELinks = new ArrayList<EOLink_V0>();
            ArrayList<EOLink_V0> ism1IssueIssueNoteLinks = new ArrayList<EOLink_V0>();
            ArrayList<EOIssue> ism1Issues = new ArrayList<EOIssue>();
            ArrayList<EONote> ism1IssueNotes = new ArrayList<EONote>();
            EOList ism2IssuesList = new EOList("com.arcway.cockpit.genericmodule.issuemodule2.issue");
            EOList ism2IssueNotesList = new EOList("com.arcway.cockpit.genericmodule.issuemodule2.issueNote");
            EOList ism2IssueSetsList = new EOList("com.arcway.cockpit.genericmodule.issuemodule2.issueSet");
            boolean ism2IssuesListExist = false;
            boolean ism2IssueNotesListExist = false;
            boolean ism2IssueSetsListExist = false;
            int ism1ModuleDataListIndex = -1;
            EOList moduleDataListList = projectFileView_0_.getDataList("module data");
            EOList linksList = projectFileView_0_.getDataList("links");
            if (moduleDataListList != null) {
                for (EOList moduleDataList : moduleDataListList) {
                    String moduleDataListRole = moduleDataList.getRole();
                    if (moduleDataListRole.equals("module. IssueModule")) {
                        ism1ModuleDataListIndex = moduleDataListList.indexOf((Object)moduleDataList);
                        EOList ism1ModuleDataListList = moduleDataList;
                        for (EOList ism1ModuleDataList : ism1ModuleDataListList) {
                            String ism1ModuleDataListRole = ism1ModuleDataList.getRole();
                            if (ism1ModuleDataListRole.equals("ISM_ISSUES")) {
                                for (EncodableObjectBase issueAsEncodableObjectBase : ism1ModuleDataList) {
                                    ism1Issues.add((EOIssue)issueAsEncodableObjectBase);
                                }
                                continue;
                            }
                            if (!ism1ModuleDataListRole.equals("ISM_ISSUE_NOTES")) continue;
                            for (EncodableObjectBase issueNoteAsEncodableObjectBase : ism1ModuleDataList) {
                                ism1IssueNotes.add((EONote)issueNoteAsEncodableObjectBase);
                            }
                        }
                        continue;
                    }
                    if (moduleDataListRole.equals("com.arcway.cockpit.genericmodule.issuemodule2.issue")) {
                        ism2IssuesList = moduleDataList;
                        ism2IssuesListExist = true;
                        continue;
                    }
                    if (moduleDataListRole.equals("com.arcway.cockpit.genericmodule.issuemodule2.issueNote")) {
                        ism2IssueNotesList = moduleDataList;
                        ism2IssueNotesListExist = true;
                        continue;
                    }
                    if (!moduleDataListRole.equals("com.arcway.cockpit.genericmodule.issuemodule2.issueSet")) continue;
                    ism2IssueSetsList = moduleDataList;
                    ism2IssueSetsListExist = true;
                }
                if (ism1ModuleDataListIndex != -1) {
                    moduleDataListList.remove(ism1ModuleDataListIndex);
                }
            }
            if (ism1Issues.isEmpty() && ism1IssueNotes.isEmpty()) {
                return;
            }
            for (EOLink_V0 eoLink : linksList) {
                String linkTypeID = eoLink.getLinkTypeID();
                if (linkTypeID.equals("LinkNoteIssue")) {
                    ism1IssueIssueNoteLinks.add(eoLink);
                    continue;
                }
                if (!linkTypeID.equals("LinkIssueUniqueElement")) continue;
                ism1IssueMELinks.add(eoLink);
            }
            ISM1MigratorCore ism1Migrator = new ISM1MigratorCore();
            ism1Migrator.migrateData(ism1Issues, ism1IssueNotes, ism1IssueMELinks, ism1IssueIssueNoteLinks, projectFileView_0_.getProjectMetaData().getProjectUID());
            ism2IssuesList.addAll(ism1Migrator.getMigratedIssues());
            ism2IssueNotesList.addAll(ism1Migrator.getMigratedIssueNotes());
            ism2IssueSetsList.addAll(ism1Migrator.getIssueSets());
            if (!ism2IssuesListExist) {
                moduleDataListList.addChild((EncodableObjectBase)ism2IssuesList);
            }
            if (!ism2IssueNotesListExist) {
                moduleDataListList.addChild((EncodableObjectBase)ism2IssueNotesList);
            }
            if (!ism2IssueSetsListExist) {
                moduleDataListList.addChild((EncodableObjectBase)ism2IssueSetsList);
            }
            linksList.removeAll(ism1Migrator.getLinksToBeDeleted());
            linksList.addAll(ism1Migrator.getNewLinks());
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
        }
    }
}

