/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages;

import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationValue;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDuration;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeInteger;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeLong;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeNonEmptyString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributePath;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeUser;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.localisation.LabelProviderUnlocalisedString;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.List;

public class AttributeHelper {
    private static final ILogger logger = Logger.getLogger(AttributeHelper.class);
    public static final String DATATYPE_MDA_STRING_SINGLE = "datatype_mda_string_single";
    public static final String DATATYPE_MDA_STRING_MULTI = "datatype_mda_string_multi";
    public static final String DATATYPE_MDA_INTEGER = "datatype_mda_integer";
    public static final String DATATYPE_MDA_LONG = "datatype_mda_long";
    public static final String DATATYPE_MDA_USER = "datatype_mda_user";
    public static final String DATATYPE_MDA_TIMESTAMP_DATEANDTIME = "datatype_mda_timestamp_dateandtime";
    public static final String DATATYPE_MDA_TIMESTAMP_DATEONLY = "datatype_mda_timestamp_dateonly";
    public static final String DATATYPE_MDA_DURATION_MINUTES = "datatype_mda_duration_minutes";
    public static final String DATATYPE_MDA_DURATION_HOURS = "datatype_mda_duration_hours";
    public static final String DATATYPE_MDA_DURATION_WORKINGDAYS = "datatype_mda_duration_workingdays";
    public static final String DATATYPE_MDA_PATH = "datatype_mda_path";
    public static final String DATATYPE_MDA_BOOLEAN = "datatype_mda_boolean";
    public static final String DATATYPE_META_ENUMERATION = "datatype_meta_enumeration";
    public static final String DATATYPE_META_LINKEDMODULEDATA = "datatype_meta_linkedmoduledata";
    public static final String DATATYPE_VIRTUAL_LINKEDFRAMEDATA = "datatype_virtual_linkedframedata";
    public static final String ROLE_SUFFIX_CHILDRENIDFORMAT_PREFIX = "-prefix";
    public static final String ROLE_SUFFIX_CHILDRENIDFORMAT_PATTERN = "-pattern";
    public static final String ROLE_SUFFIX_CHILDRENIDFORMAT_USEDEFAULTPREFIX = "-usedefaultprefix";
    public static final String ROLE_SUFFIX_CHILDRENIDFORMAT_OVERRIDEPARENTSETTINGS = "-overrideparentsettings";
    public static final String NAME_CHILDRENIDFORMAT_PREFIX = Messages.getString("AttributeName.IDFormat.Prefix");
    public static final String NAME_CHILDRENIDFORMAT_PATTERN = Messages.getString("AttributeName.IDFormat.Pattern");
    public static final String NAME_CHILDRENIDFORMAT_USEDEFAULTPREFIX = Messages.getString("AttributeName.IDFormat.NameDefaultPrefix");
    public static final String NAME_CHILDRENIDFORMAT_OVERRIDEPARENTSETTINGS = Messages.getString("AttributeName.IDFormat.NameUseThisPrefix");
    public static final String[] VALUES_CHILDRENIDFORMAT_PATTERNS = new String[]{"0", "00", "000", "0000", "00000", "000000"};
    public static final DiscreteValue[] VALUENAMES_CHILDRENIDFORMAT_PATTERNS = new DiscreteValue[VALUES_CHILDRENIDFORMAT_PATTERNS.length];

    static {
        int index = 0;
        String[] stringArray = VALUES_CHILDRENIDFORMAT_PATTERNS;
        int n = VALUES_CHILDRENIDFORMAT_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            AttributeHelper.VALUENAMES_CHILDRENIDFORMAT_PATTERNS[index] = new DiscreteValue((ILabelProvider)new LabelProviderUnlocalisedString(value));
            ++index;
            ++n2;
        }
    }

    public static IModuleDataAttribute createModuleDataAttribute(String attributeTypeID) {
        return AttributeHelper.createModuleDataAttribute(attributeTypeID, false);
    }

    public static IModuleDataAttribute createModuleDataAttribute(String attributeTypeID, boolean mandatory) {
        if (attributeTypeID.equals(DATATYPE_MDA_STRING_SINGLE)) {
            if (mandatory) {
                return new ModuleDataAttributeNonEmptyString(1);
            }
            return new ModuleDataAttributeString(1);
        }
        if (attributeTypeID.equals(DATATYPE_MDA_STRING_MULTI)) {
            if (mandatory) {
                return new ModuleDataAttributeNonEmptyString(2);
            }
            return new ModuleDataAttributeString(2);
        }
        if (attributeTypeID.equals(DATATYPE_MDA_INTEGER)) {
            return new ModuleDataAttributeInteger();
        }
        if (attributeTypeID.equals(DATATYPE_MDA_LONG)) {
            return new ModuleDataAttributeLong();
        }
        if (attributeTypeID.equals(DATATYPE_MDA_USER)) {
            return new ModuleDataAttributeUser();
        }
        if (attributeTypeID.equals(DATATYPE_MDA_TIMESTAMP_DATEANDTIME)) {
            return new ModuleDataAttributeTimestamp(true);
        }
        if (attributeTypeID.equals(DATATYPE_MDA_TIMESTAMP_DATEONLY)) {
            return new ModuleDataAttributeTimestamp(false);
        }
        if (attributeTypeID.equals(DATATYPE_MDA_DURATION_MINUTES)) {
            ModuleDataAttributeDuration durationAttribute = new ModuleDataAttributeDuration();
            durationAttribute.setUnit(2);
            return durationAttribute;
        }
        if (attributeTypeID.equals(DATATYPE_MDA_DURATION_HOURS)) {
            ModuleDataAttributeDuration durationAttribute = new ModuleDataAttributeDuration();
            durationAttribute.setUnit(1);
            return durationAttribute;
        }
        if (attributeTypeID.equals(DATATYPE_MDA_DURATION_WORKINGDAYS)) {
            ModuleDataAttributeDuration durationAttribute = new ModuleDataAttributeDuration();
            durationAttribute.setUnit(3);
            durationAttribute.setHoursPerDay(8);
            return durationAttribute;
        }
        if (attributeTypeID.equals(DATATYPE_MDA_PATH)) {
            return new ModuleDataAttributePath();
        }
        if (attributeTypeID.equals(DATATYPE_MDA_BOOLEAN)) {
            return new ModuleDataAttributeBoolean();
        }
        assert (false);
        return null;
    }

    public static IModuleDataAttributeDiscrete createModuleDataAttributeDiscrete(EnumerationAttribute enumerationAttribute, String moduleID) {
        List<EnumerationValue> enumerationValues = enumerationAttribute.getEnumerationValueList();
        DiscreteValue[] discreteValues = new DiscreteValue[enumerationValues.size()];
        int valueIndex = 0;
        for (EnumerationValue value : enumerationValues) {
            LabelProvider labelProvider = new LabelProvider(value.getValue());
            IconResource iconResource = null;
            if (value.getIcon() != null && value.getIcon().length() > 0) {
                iconResource = new IconResource(moduleID, value.getIcon());
            }
            discreteValues[valueIndex] = iconResource != null ? new DiscreteValue((ILabelProvider)labelProvider, iconResource) : new DiscreteValue((ILabelProvider)labelProvider);
            ++valueIndex;
        }
        return new ModuleDataAttributeDiscrete(discreteValues, 0);
    }

    public static IModuleDataAttribute calculateAttribute(IModuleData item, CalculatedAttribute attribute) {
        try {
            if (attribute.getCalculationTypeID().equals("string-constant")) {
                String constant = attribute.getParameter1();
                return new ModuleDataAttributeString(constant, 1);
            }
            if (attribute.getCalculationTypeID().equals("string-objecttypename")) {
                String constant = item.getModuleDataTypeDescriptionForFrame().getDisplayName();
                return new ModuleDataAttributeString(constant, 1);
            }
            if (attribute.getCalculationTypeID().equals("string-concatenation-immediate")) {
                String value1 = item.getAttribute(attribute.getParameter1()).getDisplayStringRepresentation();
                String value2 = item.getAttribute(attribute.getParameter2()).getDisplayStringRepresentation();
                return new ModuleDataAttributeString(String.valueOf(value1) + value2, 1);
            }
            if (attribute.getCalculationTypeID().equals("string-concatenation-space")) {
                String value1 = item.getAttribute(attribute.getParameter1()).getDisplayStringRepresentation();
                String value2 = item.getAttribute(attribute.getParameter2()).getDisplayStringRepresentation();
                return new ModuleDataAttributeString(String.valueOf(value1) + " " + value2, 1);
            }
            if (attribute.getCalculationTypeID().equals("string-concatenation-dash")) {
                String value1 = item.getAttribute(attribute.getParameter1()).getDisplayStringRepresentation();
                String value2 = item.getAttribute(attribute.getParameter2()).getDisplayStringRepresentation();
                return new ModuleDataAttributeString(String.valueOf(value1) + " - " + value2, 1);
            }
            if (attribute.getCalculationTypeID().equals("string-concatenation-version")) {
                String value1 = item.getAttribute(attribute.getParameter1()).getDisplayStringRepresentation();
                String value2 = item.getAttribute(attribute.getParameter2()).getDisplayStringRepresentation();
                String value3 = item.getAttribute(attribute.getParameter3()).getDisplayStringRepresentation();
                if (value1 == null || value1.length() == 0) {
                    value1 = "0";
                }
                if (value3 == null || value3.length() == 0) {
                    value3 = null;
                    if (value2 == null || value2.length() == 0) {
                        value2 = null;
                    }
                } else if (value2 == null || value2.length() == 0) {
                    value2 = "0";
                }
                String concat = value1;
                if (value2 != null) {
                    concat = String.valueOf(concat) + "." + value2;
                }
                if (value3 != null) {
                    concat = String.valueOf(concat) + "." + value3;
                }
                return new ModuleDataAttributeString(concat, 1);
            }
            if (attribute.getCalculationTypeID().equals("integer-addition")) {
                return new ModuleDataAttributeLong(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) + AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-subtraction")) {
                return new ModuleDataAttributeLong(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) - AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-multiplication")) {
                return new ModuleDataAttributeLong(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) * AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-division")) {
                return new ModuleDataAttributeLong(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) / AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-smaller")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) < AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-equal")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) == AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-greater")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) > AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-smaller-constant")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) < Long.parseLong(attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-equal-constant")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) == Long.parseLong(attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("integer-greater-constant")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getIntOrLongAttributeValue(item, attribute.getParameter1()) > Long.parseLong(attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("boolean-and")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter1()) && AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("boolean-or")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter1()) || AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("boolean-xor")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter1()) ^ AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("boolean-equivalence")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter1()) == AttributeHelper.getBooleanAttributeValue(item, attribute.getParameter2()));
            }
            if (attribute.getCalculationTypeID().equals("enumeration-valuecheck")) {
                return new ModuleDataAttributeBoolean(AttributeHelper.getEnumerationAttributeValue(item, attribute.getParameter1()) == Integer.parseInt(attribute.getParameter2()));
            }
            logger.warn("Unknown calculation type for calculated attribute: " + attribute.getCalculationTypeID());
        }
        catch (ClassCastException ccE) {
            logger.warn("Calculated attribute with dependent attribute(s) of wrong type: " + attribute.getCalculationTypeID());
        }
        catch (NumberFormatException nfE) {
            logger.warn("Calculated attribute with invalid constant parameter: " + attribute.getCalculationTypeID());
        }
        return null;
    }

    private static long getIntOrLongAttributeValue(IModuleData item, String attributeID) {
        long longValue = 0L;
        IModuleDataAttribute attribute = item.getAttribute(attributeID);
        if (attribute instanceof ModuleDataAttributeInteger) {
            longValue = ((ModuleDataAttributeInteger)attribute).getValue();
        } else if (attribute instanceof ModuleDataAttributeLong) {
            longValue = ((ModuleDataAttributeLong)attribute).getValue();
        } else {
            throw new ClassCastException();
        }
        return longValue;
    }

    private static boolean getBooleanAttributeValue(IModuleData item, String attributeID) {
        IModuleDataAttribute attribute = item.getAttribute(attributeID);
        return ((ModuleDataAttributeBoolean)attribute).getValue();
    }

    private static int getEnumerationAttributeValue(IModuleData item, String attributeID) {
        IModuleDataAttribute attribute = item.getAttribute(attributeID);
        return ((ModuleDataAttributeDiscrete)attribute).getValue();
    }

    public static String getDataTypeOfCalculatedAttribute(String calculationTypeID) {
        if ("string-constant".equals(calculationTypeID) || "string-objecttypename".equals(calculationTypeID) || "string-concatenation-immediate".equals(calculationTypeID) || "string-concatenation-version".equals(calculationTypeID) || "string-concatenation-space".equals(calculationTypeID) || "string-concatenation-dash".equals(calculationTypeID)) {
            return DATATYPE_MDA_STRING_SINGLE;
        }
        if ("integer-addition".equals(calculationTypeID) || "integer-subtraction".equals(calculationTypeID) || "integer-multiplication".equals(calculationTypeID) || "integer-division".equals(calculationTypeID)) {
            return DATATYPE_MDA_LONG;
        }
        if ("boolean-and".equals(calculationTypeID) || "boolean-or".equals(calculationTypeID) || "boolean-xor".equals(calculationTypeID) || "boolean-equivalence".equals(calculationTypeID) || "enumeration-valuecheck".equals(calculationTypeID) || "integer-greater".equals(calculationTypeID) || "integer-greater-constant".equals(calculationTypeID) || "integer-equal".equals(calculationTypeID) || "integer-equal-constant".equals(calculationTypeID) || "integer-smaller".equals(calculationTypeID) || "integer-multiplication".equals(calculationTypeID) || "integer-smaller-constant".equals(calculationTypeID)) {
            return DATATYPE_MDA_BOOLEAN;
        }
        logger.warn("Unknown calculation type for calculated attribute: " + calculationTypeID);
        return null;
    }
}

