/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.PermissionManagement;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectType
extends AbstractModuleSpecificationPart {
    private final String objectTypeID;
    private final String objectTypeName;
    private final String objectTypeIcon;
    private final String statusDependentObjectIcons;
    private final String labelAttributeID;
    private final String platformLabelAttributeID;
    private final int typeRank;
    private final String historyRecordMode;
    private final boolean disableCustomProperties;
    private final boolean disableObjectTypeCategories;
    private final Map<String, Attribute> attributeMap;
    private final List<Attribute> attributeList;
    private final Map<String, ParentType> parentTypeMap;
    private final List<ParentType> parentTypeList;
    private final Map<String, Status> statusMap;
    private final List<Status> statusList;
    private final PermissionManagement permissionManagement;

    public ObjectType(String objectTypeID, String objectTypeName, String objectTypeIcon, String statusDependentObjectIcons, String labelAttributeID, String platformLabelAttributeID, int typeRank, String historyRecordMode, boolean disableCustomProperties, boolean disableObjectTypeCategories, List<Attribute> attributeList, List<ParentType> parentTypeList, List<Status> statusList, PermissionManagement permissionManagement) {
        this.objectTypeID = objectTypeID;
        this.objectTypeName = objectTypeName;
        this.objectTypeIcon = objectTypeIcon;
        this.statusDependentObjectIcons = statusDependentObjectIcons;
        this.labelAttributeID = labelAttributeID;
        this.platformLabelAttributeID = platformLabelAttributeID;
        this.typeRank = typeRank;
        this.historyRecordMode = historyRecordMode;
        this.disableCustomProperties = disableCustomProperties;
        this.disableObjectTypeCategories = disableObjectTypeCategories;
        this.attributeMap = new HashMap<String, Attribute>();
        this.attributeList = new ArrayList<Attribute>();
        int attributeListCounter = 1;
        for (Attribute part : attributeList) {
            ((AbstractModuleSpecificationPart)((Object)part)).setIndex(attributeListCounter);
            String partID = part.getID();
            this.attributeMap.put(partID, part);
            this.attributeList.add(part);
            ++attributeListCounter;
        }
        this.parentTypeMap = new HashMap<String, ParentType>();
        this.parentTypeList = new ArrayList<ParentType>();
        int parentTypeListCounter = 1;
        for (ParentType part : parentTypeList) {
            part.setIndex(parentTypeListCounter);
            String partID = part.getID();
            this.parentTypeMap.put(partID, part);
            this.parentTypeList.add(part);
            ++parentTypeListCounter;
        }
        this.statusMap = new HashMap<String, Status>();
        this.statusList = new ArrayList<Status>();
        int statusListCounter = 1;
        for (Status part : statusList) {
            part.setIndex(statusListCounter);
            String partID = part.getID();
            this.statusMap.put(partID, part);
            this.statusList.add(part);
            ++statusListCounter;
        }
        this.permissionManagement = permissionManagement;
    }

    public String getObjectTypeID() {
        return this.objectTypeID;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public String getObjectTypeIcon() {
        return this.objectTypeIcon;
    }

    public String getStatusDependentObjectIcons() {
        return this.statusDependentObjectIcons;
    }

    public String getLabelAttributeID() {
        return this.labelAttributeID;
    }

    public String getPlatformLabelAttributeID() {
        return this.platformLabelAttributeID;
    }

    public int getTypeRank() {
        return this.typeRank;
    }

    public String getHistoryRecordMode() {
        return this.historyRecordMode;
    }

    public boolean isDisableCustomProperties() {
        return this.disableCustomProperties;
    }

    public boolean isDisableObjectTypeCategories() {
        return this.disableObjectTypeCategories;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public Attribute getAttribute(String id) {
        return this.attributeMap.get(id);
    }

    public Attribute getAttribute(int index) {
        return this.getAttributeList().get(index);
    }

    public <T extends Attribute> List<T> getAttributeListOfType(Class<T> type) {
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.attributeMap.size());
        for (Attribute child : this.attributeMap.values()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            list.add((Attribute)type.cast(child));
        }
        ObjectType.sortSpecificationPartList(list);
        return list;
    }

    public List<ParentType> getParentTypeList() {
        return this.parentTypeList;
    }

    public ParentType getParentType(String id) {
        return this.parentTypeMap.get(id);
    }

    public ParentType getParentType(int index) {
        return this.getParentTypeList().get(index);
    }

    public List<Status> getStatusList() {
        return this.statusList;
    }

    public Status getStatus(String id) {
        return this.statusMap.get(id);
    }

    public Status getStatus(int index) {
        return this.getStatusList().get(index);
    }

    public PermissionManagement getPermissionManagement() {
        return this.permissionManagement;
    }

    @Override
    public String getID() {
        return this.objectTypeID;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getAttributeList());
        children.addAll(this.getParentTypeList());
        children.addAll(this.getStatusList());
        children.add(this.permissionManagement);
        return children;
    }

    @Override
    public String getTypeID() {
        return "ObjectType";
    }
}

