/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.resources;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ResourceManager {
    private static final ILogger logger = Logger.getLogger(ResourceManager.class);
    private static final String SLASH = "/";
    private static ResourceManager singleton;
    private final Map<String, Bundle> map_moduleID_bundle = new HashMap<String, Bundle>();
    private final Map<String, Map<String, URL>> getImageURL_generated = new HashMap<String, Map<String, URL>>();
    private final Map<String, Map<String, URL>> getImageURL_notGenerated = new HashMap<String, Map<String, URL>>();

    private ResourceManager() {
    }

    public static ResourceManager getDefault() {
        if (singleton == null) {
            singleton = new ResourceManager();
        }
        return singleton;
    }

    public void registerConcreteModule(String moduleID, String pluginID) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        this.map_moduleID_bundle.put(moduleID, bundle);
    }

    public URL getResourceURL(String moduleID, String relativePath) {
        URL baseURL = this.retrieveInstallURL(moduleID);
        return this.getResourceURLForBaseURL(baseURL, relativePath, moduleID);
    }

    public URL getResourceURLByPluginID(String pluginID, String relativePath) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        URL baseURL = this.retrieveInstallURL(bundle);
        return this.getResourceURLForBaseURL(baseURL, relativePath, pluginID);
    }

    private URL getResourceURLForBaseURL(URL baseURL, String relativePath, String moduleNameForErrorMessage) {
        if (baseURL != null) {
            try {
                return new URL(baseURL, relativePath);
            }
            catch (MalformedURLException muE) {
                logger.warn("Resource for Generic Module could not be found (Module = " + moduleNameForErrorMessage + " / Path = " + relativePath + ").", (Throwable)muE);
                return null;
            }
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(String moduleID, String imageName) {
        return this.getImageDescriptor(moduleID, imageName, false);
    }

    public ImageDescriptor getImageDescriptor(String moduleID, String imageName, boolean isGenerated) {
        return ImageDescriptor.createFromURL((URL)this.getImageURL(moduleID, imageName, isGenerated));
    }

    public URL getImageURL(String moduleID, String imageName) {
        return this.getImageURL(moduleID, imageName, false);
    }

    public URL getImageURL(String moduleID, String imageName, boolean isGenerated) {
        Map<String, Map<String, URL>> cache = isGenerated ? this.getImageURL_generated : this.getImageURL_notGenerated;
        URL result = ResourceManager.readFromResultCache(cache, moduleID, imageName);
        if (result == null) {
            result = isGenerated ? this.getResourceURL(moduleID, "generated-icons/" + imageName) : this.getResourceURL(moduleID, "icons/" + imageName);
            ResourceManager.addToResultCache(cache, moduleID, imageName, result);
        }
        return result;
    }

    public Image getImage(String moduleID, String imageName) {
        return this.getImage(moduleID, imageName, false);
    }

    public Image getImage(String moduleID, String imageName, boolean isGenerated) {
        return GenericModulePlugin.getDefault().getImageDescriptorRegistry().get(this.getImageDescriptor(moduleID, imageName, isGenerated));
    }

    private URL retrieveInstallURL(String moduleID) {
        Bundle bundle = this.map_moduleID_bundle.get(moduleID);
        return this.retrieveInstallURL(bundle);
    }

    private URL retrieveInstallURL(Bundle bundle) {
        return bundle.getEntry(SLASH);
    }

    private static <K1, K2, V> V readFromResultCache(Map<K1, Map<K2, V>> twoLevelMap, K1 keyPart1, K2 keyPart2) {
        V result = null;
        Map<K2, V> secondLevelMap = twoLevelMap.get(keyPart1);
        if (secondLevelMap != null) {
            result = secondLevelMap.get(keyPart2);
        }
        return result;
    }

    private static <K1, K2, V> void addToResultCache(Map<K1, Map<K2, V>> twoLevelMap, K1 keyPart1, K2 keyPart2, V result) {
        Map<K2, V> secondLevelMap = twoLevelMap.get(keyPart1);
        if (secondLevelMap == null) {
            secondLevelMap = new HashMap<K2, V>();
            twoLevelMap.put(keyPart1, secondLevelMap);
        }
        secondLevelMap.put(keyPart2, result);
    }
}

