/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.perspective;

import com.arcway.cockpit.frame.client.global.gui.perspectives.AbstractCockpitPerspectiveFactory;
import com.arcway.cockpit.genericmodule.client.gui.dataview.ViewIDCreator;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleUISpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.View;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPlaceholderFolderLayout;

public class PerspectiveFactory
extends AbstractCockpitPerspectiveFactory
implements IExecutableExtension {
    public static final String PERSPECTIVE_ID_POSTFIX = ".perspective";
    private String moduleID;
    private ModuleUISpecification uiSpecification;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.uiSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID).getModuleUISpecification();
    }

    protected String getPerspectiveID() {
        return String.valueOf(this.moduleID) + PERSPECTIVE_ID_POSTFIX;
    }

    protected void createFoldersAndViews(IPageLayout layout, String projectNavigatorViewID, String repositoryViewID, String detailsViewID, String ueRelViewID, String[] analyseViewIDs, String[] moduleViewIDs, String[] paletteViewIDs, String[] overViewIDs) {
        String editorArea = layout.getEditorArea();
        this.createPlaceholder(layout, "topLeft", 1, 0.24f, editorArea);
        IFolderLayout detailsFolder = this.createFolder(layout, "topright", 2, 0.7f, editorArea);
        IFolderLayout dataFolder = this.createFolder(layout, "bottomLeft", 4, 0.6f, editorArea);
        ArrayList<String> manuallyPlacedViews = new ArrayList<String>();
        for (View view : this.uiSpecification.getViewList()) {
            String viewID = ViewIDCreator.getViewID(this.moduleID, view);
            manuallyPlacedViews.add(viewID);
        }
        for (String viewID : manuallyPlacedViews) {
            this.addVisibleView(layout, dataFolder, viewID, false);
        }
        this.addVisibleView(layout, detailsFolder, detailsViewID, false);
        this.addVisibleView(layout, detailsFolder, projectNavigatorViewID, false);
        this.addVisibleViews(layout, detailsFolder, analyseViewIDs, false);
        this.addInvisibleViews(layout, (IPlaceholderFolderLayout)dataFolder, moduleViewIDs, true, manuallyPlacedViews);
        this.addInvisibleView(layout, (IPlaceholderFolderLayout)detailsFolder, repositoryViewID, true);
    }

    protected boolean isEditorAreaVisible() {
        return true;
    }
}

