/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.menu.actions;

import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.menu.actions.ParentSelectionDialogueContentProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

class ParentSelectionDialogueSelectionValidator
implements ISelectionStatusValidator {
    private static final int STATUS_UNKNOWN = 0;
    private static final int STATUS_OK = 1;
    private static final int STATUS_NO_SELECTION = 2;
    private static final int STATUS_NOT_A_VALID_PARENT = 3;
    private static final int STATUS_LOCKED = 4;
    private static final int STATUS_NO_PERMISSION = 5;
    private static final int[] SEVERITIES;
    private static final String[] STATUS_MESSAGES;
    private final ObjectType objectType;
    private final ModuleLockManager lockManager;
    private final PermissionManager permissionManager;
    private LockAccess lock;

    static {
        int[] nArray = new int[6];
        nArray[0] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        nArray[5] = 4;
        SEVERITIES = nArray;
        STATUS_MESSAGES = new String[]{"", "", Messages.getString("ActionDelegateNewItemViaModelElement.StatusNoSelection"), Messages.getString("ActionDelegateNewItemViaModelElement.StatusNotAValidParent"), Messages.getString("ActionDelegateNewItemViaModelElement.StatusLocked"), Messages.getString("ActionDelegateNewItemViaModelElement.StatusNoPermission")};
    }

    public ParentSelectionDialogueSelectionValidator(ObjectType objectType, ModuleLockManager lockManager, PermissionManager permissionMgr) {
        this.objectType = objectType;
        this.lockManager = lockManager;
        this.permissionManager = permissionMgr;
        this.lock = null;
    }

    public IStatus validate(Object[] selection) {
        if (this.lock != null) {
            this.lock.releaseLocks();
            this.lock = null;
        }
        int status = 0;
        if (selection.length == 0) {
            status = 2;
        } else if (selection[0] == ParentSelectionDialogueContentProvider.ROOT) {
            String parentTypeID = "hierarchyroot";
            status = this.objectType.getParentType(parentTypeID) == null ? 3 : (!this.permissionManager.mayCreateRootItemsOfType(this.objectType.getObjectTypeID()) ? 5 : 1);
        } else {
            GenericModuleData item = (GenericModuleData)((Object)selection[0]);
            String parentTypeID = ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID());
            if (this.objectType.getParentType(parentTypeID) == null) {
                status = 3;
            } else if (!this.permissionManager.mayCreateChildren((IModuleData)item, this.objectType.getObjectTypeID())) {
                status = 5;
            } else {
                this.lock = this.lockManager.acquireInsertLock((ICockpitProjectData)item, false);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                    this.lock = null;
                    status = 4;
                } else {
                    status = 1;
                }
            }
        }
        return new Status(SEVERITIES[status], GenericModulePlugin.getDefault().getPluginID(), status, STATUS_MESSAGES[status], null);
    }
}

