/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.adapter;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.cockpitlib.client.tempfiles.CockpitTempDirectoryProvider;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataFacade;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ImExGenericModuleData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleExportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleExportAdapter;
import com.arcway.cockpit.genericmodule.client.gui.filters.GenericModuleFilters;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.IconResource;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ExportedObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Exporter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.AbstractExporterManager;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExportableData;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.file.tmp.ITempDirectoryProvider;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.repository.clientadapter.implementation.adapter.frame.filters.PlatformAdapterObjectFilter;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsProject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.filters.IRepositoryObjectFilter;
import com.arcway.repository.interFace.importexport.ImportExportException;
import com.arcway.repository.interFace.importexport.export.ExportAgent;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import de.plans.lib.eclipse.PlugInClassExtensionFactory;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.resource.ImageDescriptor;

public class ExporterManager
extends AbstractExporterManager
implements IExecutableExtension {
    private static final String EXTENSION_POINT_ID = "exporter";
    private static final String EXTENSION_KEY_ATTRIBUTE = "ExporterID";
    private static final String EXTENSION_ADAPTER_ATTRIBUTE = "ExportAdapter";
    private static final ILogger logger = Logger.getLogger(ExporterManager.class);
    private static final ITempDirectoryProvider tempDirectoryProvider = CockpitTempDirectoryProvider.createInstance((String)"gm_exporter_tempdir", (String)"file");
    private PlugInClassExtensionFactory extensionFactory;
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private Map<String, Collection<String>> map_exporterID_objectTypeID;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        try {
            this.extensionFactory = new PlugInClassExtensionFactory(false, GenericModulePlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_ID, EXTENSION_KEY_ATTRIBUTE, EXTENSION_ADAPTER_ATTRIBUTE);
            this.map_exporterID_objectTypeID = new HashMap<String, Collection<String>>();
            for (Exporter exporterSpec : this.moduleSpecification.getModuleUISpecification().getExporterList()) {
                String adapterID = exporterSpec.getIdOfAdapter();
                ArrayList<String> objectTypeIDs = new ArrayList<String>(exporterSpec.getExportedObjectTypeList().size());
                for (ExportedObjectType exportedObjectType : exporterSpec.getExportedObjectTypeList()) {
                    objectTypeIDs.add(exportedObjectType.getIdOfObjectType());
                }
                IGenericModuleExportAdapter exportAdapter = null;
                try {
                    exportAdapter = (IGenericModuleExportAdapter)this.extensionFactory.create(adapterID);
                }
                catch (PlugInClassExtensionFactoryException plugInClassExtensionFactoryException) {
                    // empty catch block
                }
                if (exportAdapter != null) {
                    String dataNameInternationalisationCode = exporterSpec.getDataName();
                    if (dataNameInternationalisationCode == null || dataNameInternationalisationCode.trim().length() == 0) {
                        dataNameInternationalisationCode = this.moduleSpecification.getModuleDataSpecification().getObjectType((String)objectTypeIDs.iterator().next()).getObjectTypeName();
                    }
                    String dataName = new LabelProvider(dataNameInternationalisationCode).getLabel(Locale.getDefault());
                    String dataIconName = exporterSpec.getDataIcon();
                    if (dataIconName == null || dataIconName.trim().length() == 0) {
                        dataIconName = this.moduleSpecification.getModuleDataSpecification().getObjectType((String)objectTypeIDs.iterator().next()).getObjectTypeIcon();
                    }
                    ImageDescriptor dataIcon = dataIconName != null && dataIconName.trim().length() > 0 ? new IconResource(this.moduleID, dataIconName).getImageDescriptor() : null;
                    exportAdapter.construct(this.moduleID, objectTypeIDs, dataName, dataIcon);
                    String exporterID = String.valueOf(adapterID) + "." + this.moduleID + "." + StringUtil.concatWithDelimiter((String[])objectTypeIDs.toArray(new String[objectTypeIDs.size()]), (char)'/', (boolean)false);
                    this.map_exporterID_objectTypeID.put(exporterID, objectTypeIDs);
                    this.putExporter(exporterID, exportAdapter);
                    continue;
                }
                logger.info("Couldn't instantiate generic module exporter (probably not installed): " + exporterSpec.getIdOfAdapter());
            }
        }
        catch (PlugInClassExtensionFactoryException e) {
            logger.error("Couldn't find generic module exporter extension point.", (Throwable)e);
        }
        catch (CoreException e) {
            logger.error("Core exception reading generic module exporter extension point.", (Throwable)e);
        }
    }

    protected void construct() {
    }

    protected IModelController getModelControllerForProject(String projectUID) {
        return GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
    }

    protected IExportableData getDataToBeExported(String projectUID, String exporterID, final Collection<AbstractFilter> filters, Locale locale) throws ImportExportException {
        Collection<String> exportedObjectTypeIDs = this.map_exporterID_objectTypeID.get(exporterID);
        IModelController modelController = this.getModelControllerForProject(projectUID);
        final GenericModuleExportableData dataToBeExported = new GenericModuleExportableData(locale);
        String exportedObjectTypeID = exportedObjectTypeIDs.iterator().next();
        DataFacade dataFacade = (DataFacade)modelController.getDataFacade();
        Collection<ImExGenericModuleData> objectsToBeExported = dataFacade.getAllObjects(exportedObjectTypeID, filters, locale);
        HashSet<ImExGenericModuleData> parents = new HashSet<ImExGenericModuleData>();
        for (ImExGenericModuleData objectToExport : objectsToBeExported) {
            ImExGenericModuleData parent = dataFacade.getParentObject(objectToExport, filters, locale);
            parents.add(parent);
        }
        ArrayList<ImExGenericModuleData> parentList = new ArrayList<ImExGenericModuleData>(parents);
        this.sortParents(parentList, dataFacade, filters, locale);
        for (ImExGenericModuleData parent : parentList) {
            List<ImExGenericModuleData> children = parent != null ? dataFacade.getChildObjects(parent, exportedObjectTypeID, filters, locale) : dataFacade.getAllRootObjects(exportedObjectTypeID, filters, locale);
            List<ImExGenericModuleData> list = dataToBeExported.map_parentItem_childItemsToExport.put(parent, children);
        }
        GenericModuleDataTypeDescription exportedTypeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, this.moduleSpecification.getModuleDataSpecification().getObjectType(exportedObjectTypeID));
        for (String attributeID : exportedTypeDescription.getPersistentAttributeIDs()) {
            String attributeName = exportedTypeDescription.getAttributeName(attributeID, locale);
            dataToBeExported.map_attributeID_attributeName.put(attributeID, attributeName);
        }
        dataToBeExported.userDefinedAttributesForChildType = dataFacade.getUserDefinedAttributesForObjectType(exportedObjectTypeID);
        final IRepositoryInterfaceRO repositoryInterface = modelController.getProjectAgent().getRepositoryInterface();
        final ObjectWrapper exception = new ObjectWrapper(null);
        RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

            public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                IRepositoryObject rootObject = repositorySnapshot.getRepositoryRootObject();
                RepositoryObjectReference rootObjectReference = new RepositoryObjectReference(rootObject);
                List<RepositoryObjectReference> rootObjects = Collections.singletonList(rootObjectReference);
                ArrayList<RepositoryObjectTypeID> objectTypesToBeExported = new ArrayList<RepositoryObjectTypeID>();
                ArrayList<RepositoryRelationTypeID> contextRelationTypes = new ArrayList<RepositoryRelationTypeID>();
                RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(RepositoryIDCreator.getCoreTypeID((String)ModuleIdentification.getModuleIDForPlatform(ExporterManager.this.moduleID)), "declaration_module_coremodule");
                objectTypesToBeExported.add(COTIDsProject.OBJECT_TYPE_ID);
                GMLinkTypeHelper_Shared linkTypehelper_shared = GMLinkTypeHelper_Shared.getDefault(ExporterManager.this.moduleID);
                for (ObjectType objectType : ExporterManager.this.moduleSpecification.getModuleDataSpecification().getObjectTypeList()) {
                    RepositoryRelationTypeID relationTypeID;
                    String linkTypeID;
                    if (!ClientDataFactory_TypesHelper.isHierarchyType(objectType)) continue;
                    RepositoryObjectTypeID objectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(ClientDataFactory_TypesHelper.getDataTypeID(ExporterManager.this.moduleID, objectType.getObjectTypeID()));
                    objectTypesToBeExported.add(objectTypeID);
                    for (LinkedModuleDataAttribute linkedModuleDataAttribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                        linkTypeID = linkTypehelper_shared.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), linkedModuleDataAttribute.getAttributeID());
                        relationTypeID = repositoryIDCreator.createRelationTypeID(linkTypeID);
                        contextRelationTypes.add(relationTypeID);
                    }
                    for (LinkedFrameDataAttribute linkedFrameDataAttribute : objectType.getAttributeListOfType(LinkedFrameDataAttribute.class)) {
                        linkTypeID = linkTypehelper_shared.getAttributeLinkTypeID_forShortTypeID(objectType.getObjectTypeID(), linkedFrameDataAttribute.getAttributeID());
                        relationTypeID = repositoryIDCreator.createRelationTypeID(linkTypeID);
                        contextRelationTypes.add(relationTypeID);
                    }
                }
                PlatformAdapterObjectFilter repositoryFilter = new PlatformAdapterObjectFilter(filters);
                ExportAgent exportAgent = new ExportAgent(repositoryInterface, tempDirectoryProvider);
                try {
                    dataToBeExported.repositorySnippet = exportAgent.compileRepositorySnippet(rootObjects, objectTypesToBeExported, Collections.emptySet(), contextRelationTypes, Collections.emptySet(), Collections.emptySet(), (IRepositoryObjectFilter)repositoryFilter);
                    dataToBeExported.typeManager = repositoryInterface.getTypeManager();
                    dataToBeExported.deprecationManager = repositoryInterface.getLocksAndPermissionsManagerDeprecated();
                }
                catch (ImportExportException ieE) {
                    exception.setWrappedObject((Object)ieE);
                }
            }
        });
        if (exception.getWrappedObject() != null) {
            throw (ImportExportException)((Object)exception.getWrappedObject());
        }
        return dataToBeExported;
    }

    private void sortParents(List<ImExGenericModuleData> parents, final DataFacade dataFacade, final Collection<AbstractFilter> filters, final Locale locale) {
        Collections.sort(parents, new Comparator<ImExGenericModuleData>(){

            @Override
            public int compare(ImExGenericModuleData o1, ImExGenericModuleData o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                List<ImExGenericModuleData> o2Ancestors = dataFacade.getAncestorObjects(o2, filters, locale);
                o2Ancestors.add(o2);
                if (o2Ancestors.contains((Object)o1)) {
                    return -1;
                }
                ImExGenericModuleData currentO1Ancestor = o1;
                ImExGenericModuleData lastO1Ancestor = null;
                while (!o2Ancestors.contains((Object)currentO1Ancestor) && currentO1Ancestor != null) {
                    lastO1Ancestor = currentO1Ancestor;
                    currentO1Ancestor = dataFacade.getParentObject(currentO1Ancestor, filters, locale);
                }
                if (o2.equals((Object)currentO1Ancestor)) {
                    return 1;
                }
                ImExGenericModuleData relevantO2Ancestor = o2Ancestors.get(o2Ancestors.indexOf((Object)currentO1Ancestor) + 1);
                return dataFacade.compareAccordingToNaturalOrder(lastO1Ancestor, relevantO2Ancestor);
            }
        });
    }

    protected Collection<IFilterItem> getFixAttributeFilterItems(String projectUID) {
        ArrayList<IFilterItem> filterItems = new ArrayList<IFilterItem>(new GenericModuleFilters(this.moduleID, this.moduleSpecification, this.getModelControllerForProject(projectUID)).createFilters(false));
        return filterItems;
    }

    protected Collection<String> getCustomPropertyFilterDataTypes() {
        IDataTypesHelper dataTypesHelper = GMDataTypesHelper.getDefault(this.moduleID);
        return dataTypesHelper.getDocumentationCustomPropertyDataTypes();
    }
}

