/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.datamanagement;

import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractModuleDataLabelProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.resources.IIconResource;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;

public class GenericModuleDataLabelProvider
extends AbstractModuleDataLabelProvider {
    private static final ILogger logger = Logger.getLogger(GenericModuleDataLabelProvider.class);
    private final String moduleID;
    private final ModuleDataSpecification moduleDataSpecification;

    public GenericModuleDataLabelProvider(String moduleID, ModuleDataSpecification moduleDataSpecification, DataManager dataManager) {
        super((AbstractDataMgr)dataManager);
        this.moduleID = moduleID;
        this.moduleDataSpecification = moduleDataSpecification;
    }

    public String getDisplayNameForType(String dataTypeID) {
        String shortTypeID = ClientDataFactory_TypesHelper.getShortTypeID(dataTypeID);
        ObjectType objectTypeSpecification = this.moduleDataSpecification.getObjectType(shortTypeID);
        GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectTypeSpecification, false);
        return typeDescription.getTypeName(Locale.getDefault());
    }

    public Image getImageForType(String dataTypeID) {
        String shortTypeID = ClientDataFactory_TypesHelper.getShortTypeID(dataTypeID);
        ObjectType objectTypeSpecification = this.moduleDataSpecification.getObjectType(shortTypeID);
        GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectTypeSpecification, false);
        IIconResource icon = typeDescription.getTypeIcon();
        return icon != null ? icon.getImage() : null;
    }

    public String getLabelForItem_internal(IModuleData item) {
        return item.getDisplayRepresentation(Locale.getDefault());
    }

    public Image getImageForItem_internal(IModuleData item) {
        return this.getImageForType(item.getTypeID());
    }
}

