/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core;

import com.arcway.cockpit.frame.client.project.core.links.linkeddataaccess.ILinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.Cardinality11;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.Cardinality1N;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityN1;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.CardinalityNN;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkCardinality;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.NaturalOrderingLinkedDataAccessFacade;
import com.arcway.cockpit.genericmodule.client.infrastructure.SpecificationConstantsHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.MDRelationParticipant;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.AbstractLinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.ModuleLinkType;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class GMLinkTypeHelper
extends AbstractLinkTypeHelper {
    private final String moduleID;
    private final ModuleDataSpecification moduleDataSpecification;
    private final GMLinkTypeHelper_Shared linkTypeHelper_shared;
    private static Map<String, GMLinkTypeHelper> singletons = new HashMap<String, GMLinkTypeHelper>();

    public static GMLinkTypeHelper getDefault(String moduleID) {
        GMLinkTypeHelper singleton = singletons.get(moduleID);
        if (singleton == null) {
            singleton = new GMLinkTypeHelper(moduleID, SpecificationProvider.getDefault().getModuleSpecification(moduleID).getModuleDataSpecification());
            singletons.put(moduleID, singleton);
        }
        return singleton;
    }

    private GMLinkTypeHelper(String moduleID, ModuleDataSpecification moduleDataSpecification) {
        super(ModuleIdentification.getFullModuleID(moduleID), (ILinkTypeHelper_Shared)GMLinkTypeHelper_Shared.getDefault(moduleID), GMDataTypesHelper.getDefault(moduleID));
        this.moduleID = moduleID;
        this.moduleDataSpecification = moduleDataSpecification;
        this.linkTypeHelper_shared = GMLinkTypeHelper_Shared.getDefault(moduleID);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<ILinkType> getAdditionalLinkTypes() {
        HashSet<ILinkType> linkTypes = new HashSet<ILinkType>();
        for (ObjectType objectType : this.moduleDataSpecification.getObjectTypeList()) {
            for (ParentType parentType : objectType.getParentTypeList()) {
                if (parentType.getParentObjectTypeID().equals("hierarchyroot") || parentType.getParentObjectTypeID().equals("noparent")) continue;
                GenericModuleDataTypeDescription childTypeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, objectType);
                GenericModuleDataTypeDescription parentTypeDescription = GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, this.moduleDataSpecification.getObjectType(parentType.getParentObjectTypeID()));
                linkTypes.add((ILinkType)new ModuleLinkType(this.linkTypeHelper_shared.getHierarchyLinkTypeID_forShortTypeIDs(parentType.getParentObjectTypeID(), objectType.getObjectTypeID()), GMLinkTypeHelper.getDisplayNameForHierarchyLink((IModuleDataTypeDescription)childTypeDescription, (IModuleDataTypeDescription)parentTypeDescription), ModuleIdentification.getFullModuleID(this.moduleID), (ILinkCardinality)new CardinalityN1(), false, false, (ILinkTypeHelper_Shared)this));
            }
            for (LinkedModuleDataAttribute linkedModuleDataAttribute : objectType.getAttributeListOfType(LinkedModuleDataAttribute.class)) {
                linkTypes.add(this.linkTypeHelper_shared.getModuleDataAttributeLinkType(objectType.getObjectTypeID(), linkedModuleDataAttribute.getAttributeID()));
            }
            for (LinkedFrameDataAttribute linkedFrameDataAttribute : objectType.getAttributeListOfType(LinkedFrameDataAttribute.class)) {
                linkTypes.add(this.linkTypeHelper_shared.getFrameAttributeLinkType(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectType.getObjectTypeID()), linkedFrameDataAttribute.getAttributeID(), SpecificationConstantsHelper.getCockpitDataTypeIDForLinkedFrameObjectType(linkedFrameDataAttribute.getFrameObjectTypeID())));
            }
        }
        for (ModuleDataRelationType relationType : this.moduleDataSpecification.getRelationTypeListOfType(ModuleDataRelationType.class)) {
            MDRelationParticipant mDRelationParticipant = relationType.getMDRelationParticipant(0);
            MDRelationParticipant linkableObjectParticipant = relationType.getMDRelationParticipant(1);
            Object cardinality = mDRelationParticipant.getCardinality().equals("none-or-one") ? (linkableObjectParticipant.getCardinality().equals("none-or-one") ? new Cardinality11() : new CardinalityN1()) : (linkableObjectParticipant.getCardinality().equals("none-or-one") ? new Cardinality1N() : new CardinalityNN());
            linkTypes.add((ILinkType)new ModuleLinkType(this.linkTypeHelper_shared.getRelationLinkTypeID(relationType.getRelationTypeID()), new LabelProvider(relationType.getRelationTypeName()).getLabel(Locale.getDefault()), ModuleIdentification.getFullModuleID(this.moduleID), (ILinkCardinality)cardinality, false, true, (ILinkTypeHelper_Shared)this));
        }
        for (ModelElementLinkType modelElementLinkType : this.moduleDataSpecification.getRelationTypeListOfType(ModelElementLinkType.class)) {
            void var4_13;
            if (modelElementLinkType.getCardinality().equals("none-or-one")) {
                CardinalityN1 cardinalityN1 = new CardinalityN1();
            } else {
                CardinalityNN cardinalityNN = new CardinalityNN();
            }
            linkTypes.add((ILinkType)new ModuleLinkType(this.linkTypeHelper_shared.getModelElementLinkTypeID_forShortTypeID(modelElementLinkType.getLinkedObjectTypeID()), GMLinkTypeHelper.getDisplayNameForModelElementLink((IModuleDataTypeDescription)GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, this.moduleDataSpecification.getObjectType(modelElementLinkType.getLinkedObjectTypeID()))), ModuleIdentification.getFullModuleID(this.moduleID), "com.arcway.cockpit.uniqueelement", (ILinkCardinality)var4_13, false, true, (ILinkTypeHelper_Shared)this));
        }
        return linkTypes;
    }

    public void getAdditionalLinkedDataAccessFacades(Collection<ILinkedDataAccessFacade> LOFacades, Collection<ILinkedDataAccessFacade> MDFacades, AbstractDataMgr dataManager) {
        HashSet<Integer> naturalOrderTypeRanks = new HashSet<Integer>();
        for (ObjectType objectType : this.moduleDataSpecification.getObjectTypeList()) {
            Integer typeRank = objectType.getTypeRank();
            naturalOrderTypeRanks.add(typeRank);
        }
        for (Integer typeRank : naturalOrderTypeRanks) {
            MDFacades.add(new NaturalOrderingLinkedDataAccessFacade(this.moduleID, this.moduleDataSpecification, typeRank, dataManager));
        }
    }
}

