/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.framestandaloneserverproxywithcommit;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.ILocalClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.datainterchange.FrameImportExportManager;
import com.arcway.cockpit.frame.client.project.datainterchange.ImportFailedException;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileFormatVersionIncompatibleException;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.ClientFunctionLicenseManager;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.DummyUser;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.FrameServerProxy;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.LocalClientProductLicenseManager;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.Messages;
import com.arcway.cockpit.framestandaloneserverproxywithcommit.ProjectNameValidator;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.memento.IArcwayMemento;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class ProjectManagerServerProxy
implements IProjectManagerServerProxy {
    private static final ILogger logger = Logger.getLogger(ProjectManagerServerProxy.class);
    private static final String KEY_LAST_LOAD_FILE = "lastLoadFile";
    private Tuple<String, ProjectFileAccess> userSelectedProjectFile = null;
    private ServerConnection serverConnection;
    private String serverID;
    private IClientFunctionLicenseManager licenseManager;
    private static final HashMap<String, String> VERSION_DEPENDEND_DESCRIPTIONS = new HashMap();

    static {
        VERSION_DEPENDEND_DESCRIPTIONS.put("reload", Messages.getString("ReloadProjectAction.Label"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("reloadtooltip", Messages.getString("ReloadProjectAction.ToolTip"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("reloaddesc", Messages.getString("ReloadProjectAction.Description"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("reloadfailed", Messages.getString("ReloadProjectAction.Failed"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("commitlabel", Messages.getString("CommitAction.Label"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("committooltip", Messages.getString("CommitAction.ToolTip"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("commitdesc", Messages.getString("CommitAction.Description"));
        VERSION_DEPENDEND_DESCRIPTIONS.put("commitfailed", Messages.getString("CommitAction.Failed"));
    }

    public void construct(ServerConnection newServerConnection) {
        this.serverConnection = newServerConnection;
        this.serverID = newServerConnection.getServerID();
        this.licenseManager = new ClientFunctionLicenseManager();
    }

    public void createProjectOnServer(EOProject newProject, File projectRoot) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        try {
            File saveFile = FrameServerProxy.getExportFile(projectRoot, newProject.getProjectUID());
            FrameImportExportManager.saveProjectMetadataAsExportFile((EOProject)newProject, (File)saveFile);
        }
        catch (IOException e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (JvmExternalResourceInteractionException e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    public EOProject createProjectSnapshotOnServer(EOProject originalProjectEO) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        return null;
    }

    public IClientProductLicenseManager getProductLicenseManager() {
        return LocalClientProductLicenseManager.getDefault();
    }

    public ILocalClientProductLicenseManager getLocalProductLicenseManager() {
        return LocalClientProductLicenseManager.getDefault();
    }

    public IClientFunctionLicenseManager getFunctionLicenseManager() {
        return this.licenseManager;
    }

    public void deleteProjectOnServer(String projectUID) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
    }

    public EOProject createProjectToPublishOnServer(EOProject originalProjectEO, String uidToSet, String projectNameProposal, Collection<EOPermission> permissions) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        return null;
    }

    public EOProject[] getAllProjectsOfServer() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        ProjectAgent[] projectAgents = ProjectMgr.getProjectMgr().getConfiguredProjects();
        EOProject[] projects = new EOProject[projectAgents.length];
        int i = 0;
        while (i < projectAgents.length) {
            ProjectAgent pa = projectAgents[i];
            Project project = pa.getProjectMetaDataManager().getProject();
            EOProject eoProject = null;
            if (project != null) {
                eoProject = project.createEncodableObject();
            } else {
                eoProject = new EOProject();
                eoProject.setProjectUID(pa.getUID());
                eoProject.setUID(pa.getUID());
                EOAttribute nameAttribute = new EOAttribute();
                EOAttributeTypeID eoAttrTypeID = new EOAttributeTypeID(ProjectAttributeTypeProvider.ATTRID_NAME.getUID(), "name");
                nameAttribute.setAttributeTypeID(eoAttrTypeID);
                nameAttribute.setValueAsEO((EOEncodableObject)new EOString(pa.getProjectName()));
                eoProject.addAttribute(nameAttribute);
            }
            projects[i] = eoProject;
            ++i;
        }
        return projects;
    }

    public Collection<EOLock> getAllLocksOnServer() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return Collections.emptyList();
    }

    public Collection<EOLock> getAllLocksOfProject(EOString projectUID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return Collections.emptyList();
    }

    public void removeLocks(Collection<EOLock> locks) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    public void reloadProject(IFrameProjectAgent projectAgent, boolean askUser, IWorkbenchPage currentPage, boolean triggerUseOnOpenActions) throws Exception {
        Shell parentShell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        boolean reloadProject = true;
        ProjectFileAccess userSelectedFileForReload = null;
        if (askUser) {
            MessageBox mbInfo = new MessageBox(parentShell, 296);
            mbInfo.setMessage(Messages.getString("ProjectManagerServerProxy.ReloadProjectAction.UserHint"));
            mbInfo.setText(Messages.getString("ProjectManagerServerProxy.ReloadProjectAction.UserHint.Label"));
            if (mbInfo.open() == 32) {
                File userSelectedFile = this.getUserFile(projectAgent, true, parentShell);
                if (userSelectedFile != null) {
                    try {
                        userSelectedFileForReload = new ProjectFileAccess(userSelectedFile, 2, parentShell);
                        EOProject current_project = projectAgent.getProjectMetaDataManager().getProject().createEncodableObject();
                        EOProject project_toload = userSelectedFileForReload.getProjectMetaData();
                        if (!current_project.getUID().equalsIgnoreCase(project_toload.getUID())) {
                            MessageBox mb = new MessageBox(parentShell, 256);
                            mb.setMessage(Messages.getString("FrameServerProxy.ProjectUID_conflict"));
                            mb.setText(ProjectMgr.getProjectMgr().getProjectManagerServerProxy(projectAgent.getServerID()).getVersionDependendDescription("reload"));
                            mb.open();
                            reloadProject = false;
                        }
                    }
                    catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
                        logger.error("Can not reload project.", (Throwable)pfaE);
                        reloadProject = false;
                    }
                }
            } else {
                reloadProject = false;
            }
        } else if (((String)this.userSelectedProjectFile.getT1()).equals(projectAgent.getProjectUID())) {
            userSelectedFileForReload = (ProjectFileAccess)this.userSelectedProjectFile.getT2();
        }
        if (reloadProject && userSelectedFileForReload != null) {
            String projectUID = projectAgent.getProjectUID();
            ProjectMgr.getProjectMgr().deleteProjectOnClient(projectAgent, false, parentShell);
            EOProject project_toload = userSelectedFileForReload.getProjectMetaData();
            this.userSelectedProjectFile = new Tuple((Object)projectUID, (Object)userSelectedFileForReload);
            this.getProjectFromServer(project_toload, currentPage, triggerUseOnOpenActions);
            ProjectAgent projectAgentOfReloadedProject = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            PropertyChanges changes = new PropertyChanges(null, (Object)projectAgentOfReloadedProject, null);
            projectAgentOfReloadedProject.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IFrameProjectAgent.class);
        }
    }

    private File getUserFile(IFrameProjectAgent projectAgent, boolean forLoad, Shell shell) {
        File userFile;
        File lastFile;
        FileChooserDialog dialog = null;
        String[] fileExtensions = new String[]{"*." + FramePlugin.getFileExtensionForProjectData()};
        IArcwayMemento ls = projectAgent.getFrameLocalSettings();
        String lastFileName = ls.getString(KEY_LAST_LOAD_FILE);
        if (lastFileName != null && (lastFile = new File(lastFileName)).getParentFile() != null && lastFile.getParentFile().exists() && (!forLoad || lastFile.exists())) {
            dialog = new FileChooserDialog(fileExtensions, lastFile.getParentFile(), true, shell);
            dialog.setStartFileName(lastFile.getName());
        }
        if (dialog == null) {
            dialog = new FileChooserDialog(fileExtensions, shell);
        }
        if ((userFile = forLoad ? dialog.openForLoad() : dialog.openForSave()) != null) {
            ls.putString(KEY_LAST_LOAD_FILE, userFile.toString());
        }
        return userFile;
    }

    public boolean restoreProject(EOProject project, File dumpFile, Shell shell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return true;
    }

    public void dumpProject(EOProject eoProject, File dumpFile, Shell shell, int timeOutInSeconds) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
    }

    public boolean restoreServer(File dumpFile, Shell shell) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        return true;
    }

    public void dumpServer(File dumpFile, Collection<? extends String> projectUIDBlackList, Shell shell) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
    }

    public EOUserAndGroupAndPermissions getUserData(boolean forceLogin) {
        EOUserAndGroupAndPermissions ugp = new EOUserAndGroupAndPermissions();
        ugp.setUser(DummyUser.getSingleUser());
        return ugp;
    }

    public boolean isAdminUser(boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        return true;
    }

    public boolean mayChangeUserName() {
        return true;
    }

    public void setUserName(String newName) {
        assert (newName != null);
        DummyUser.getSingleUser().setUserName(newName);
    }

    public boolean offersProjectsForDownload() {
        return true;
    }

    public boolean mayDumpAndRestoreProjects() {
        return false;
    }

    public String getServerName() {
        return "";
    }

    public void login(String username, String password) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
    }

    public String getServerAvailabilityState() {
        if (LocalClientProductLicenseManager.getDefault().getProductLicenses().isEmpty()) {
            return Messages.getString("ProjectManagerServerProxy.license_expired");
        }
        return null;
    }

    public EOProject[] getAvailableProjectsFromServer(Shell parentShell) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return this.getAvailableProjectsFromServer(parentShell, null);
    }

    public EOProject[] getAvailableProjectsFromServer(Shell parentShell, File p_userFile) {
        File userFile;
        if (p_userFile == null) {
            String[] fileExtensions = new String[]{"*." + FramePlugin.getFileExtensionForProjectData()};
            FileChooserDialog dialog = new FileChooserDialog(fileExtensions, parentShell);
            userFile = dialog.openForLoad();
        } else {
            userFile = p_userFile;
        }
        if (userFile != null) {
            String title;
            try {
                ProjectFileAccess projectFileAccess = new ProjectFileAccess(userFile, 2, parentShell);
                EOProject eoProject = projectFileAccess.getProjectMetaData();
                if (eoProject != null) {
                    this.userSelectedProjectFile = new Tuple((Object)eoProject.getProjectUID(), (Object)projectFileAccess);
                    EOProject[] projects = new EOProject[]{eoProject};
                    return projects;
                }
            }
            catch (SecurityException e) {
                logger.error("could not get projects from server", (Throwable)e);
                title = Messages.getString("ProjectManagerServerProxy.security_exception");
                String msg = String.valueOf(Messages.getString("ProjectManagerServerProxy.could_not_read_file")) + userFile.getAbsolutePath() + Messages.getString("ProjectManagerServerProxy.reason") + e.getLocalizedMessage();
                MessageDialog.openError((Shell)parentShell, (String)title, (String)msg);
            }
            catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
                logger.error("could not get projects from server", (Throwable)pfaE);
                title = "";
                String msg = "";
                if (pfaE.getCause() instanceof FileNotFoundException) {
                    title = Messages.getString("ProjectManagerServerProxy.file_not_found");
                    msg = String.valueOf(Messages.getString("ProjectManagerServerProxy.file")) + userFile.getAbsolutePath() + Messages.getString("ProjectManagerServerProxy.not_found");
                } else if (pfaE.getCause() instanceof IOException) {
                    title = Messages.getString("ProjectManagerServerProxy.error");
                    msg = String.valueOf(Messages.getString("ProjectManagerServerProxy.could_not_read_file")) + userFile.getAbsolutePath() + Messages.getString("ProjectManagerServerProxy.reason") + pfaE.getCause().getLocalizedMessage();
                } else {
                    title = Messages.getString("ProjectManagerServerProxy.invalid_file");
                    msg = String.valueOf(Messages.getString("ProjectManagerServerProxy.the_file")) + userFile.getAbsolutePath() + Messages.getString("ProjectManagerServerProxy.does_not_contain_valid_data");
                }
                MessageDialog.openError((Shell)parentShell, (String)title, (String)msg);
            }
            catch (ProjectFileFormatVersionIncompatibleException pffviE) {
                logger.error("could not get projects from server", (Throwable)pffviE);
                title = Messages.getString("ProjectManagerServerProxy.file_format_incompatible");
                String msg = String.valueOf(Messages.getString("ProjectManagerServerProxy.file")) + userFile.getAbsolutePath() + Messages.getString("ProjectManagerServerProxy.hasIncompatibleVersion");
                MessageDialog.openError((Shell)parentShell, (String)title, (String)msg);
            }
        }
        return null;
    }

    public void getProjectFromServer(EOProject project, IWorkbenchPage currentPage, boolean triggerUserOnOpenActions) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, IOException, ExPrematureEndOfTransfer, ImportFailedException, ExProjectOpenAbortWithMessage {
        Shell shell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        ProjectAgent projectAgent = null;
        try {
            try {
                assert (((String)this.userSelectedProjectFile.getT1()).equals(project.getProjectUID())) : "The appropriate project has been selected which can be loaded, now.";
                ProjectFileAccess projectFileAccess = (ProjectFileAccess)this.userSelectedProjectFile.getT2();
                boolean triggerUserOnOpenActionsOnOpen = false;
                projectAgent = ProjectMgr.getProjectMgr().createNewProject(project.getUID(), Project.getProjectName((EOProject)project), Project.getLanguage((EOProject)project), this.serverID, 1, triggerUserOnOpenActionsOnOpen, currentPage);
                if (projectAgent != null) {
                    projectAgent.getFrameDataImporter().loadProjectFromACP(projectFileAccess, shell);
                    projectAgent.commitProject(Messages.getString("ProjectManagerServerProxy.project_created"), false, true, shell);
                    if (triggerUserOnOpenActions) {
                        projectAgent.triggerUserOnOpenActions(currentPage);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Error while loading/committing project", (Throwable)e);
                ProjectManagerServerProxy.deleteProjectIfCreated(projectAgent, currentPage);
                throw e;
            }
            catch (ImportFailedException e) {
                logger.error("Error while loading/committing project", (Throwable)e);
                ProjectManagerServerProxy.deleteProjectIfCreated(projectAgent, currentPage);
                throw e;
            }
            catch (ExProjectOpenAbortWithMessage e) {
                logger.error("Error while loading/committing project", (Throwable)e);
                ProjectManagerServerProxy.deleteProjectIfCreated(projectAgent, currentPage);
                throw e;
            }
        }
        finally {
            ((ProjectFileAccess)this.userSelectedProjectFile.getT2()).dispose();
            this.userSelectedProjectFile = null;
        }
    }

    private static void deleteProjectIfCreated(IFrameProjectAgent projectAgent, IWorkbenchPage currentPage) {
        if (projectAgent != null) {
            ProjectMgr.getProjectMgr().deleteProjectOnServer(projectAgent, currentPage);
        }
    }

    public String getGetProjectFromServerLabel() {
        return Messages.getString("NewProjectAction.Project_from_server..._3");
    }

    public String getGetProjectFromServerDescription() {
        return Messages.getString("NewProjectAction.Gets_an_existing_project_from_the_selected_server_4");
    }

    public EOList<EOProject> getProjectsWithPermissionForOperation(String operation, String operation2) throws EXServerException, UnknownServerException, LoginCanceledException, ServerNotAvailableException {
        return new EOList();
    }

    public IInputValidator getProjectNameValidatorForCreatingNewProjectOnServer() {
        return new ProjectNameValidator(this.serverConnection);
    }

    public IInputValidator getProjectNameValidatorForGettingProjectFromServer() {
        return new ProjectNameValidator(this.serverConnection);
    }

    public IInputValidator getProjectNameValidator(IProjectAgent projectAgent) {
        return new ProjectNameValidator(projectAgent);
    }

    public void subscribeListenerOnServer(INotificationBusListener listener, String notificationtype) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
    }

    public boolean arePermissionsNeeded() {
        return false;
    }

    public int getNumberOfMaxProjectsOnServer() {
        return 1;
    }

    public EOServerResponse sendRequest(String reqGroup, String reqSubID, EncodableObjectBase reqParam) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        return null;
    }

    public String getUserRealmRepositoryType() {
        return "Single-User";
    }

    public boolean shallEditorsSupportViewMode() {
        return false;
    }

    public boolean canReaderCreateProjectsOnThisServer() {
        return true;
    }

    public boolean serverKeepsCopy() {
        return false;
    }

    public boolean mayCommitDiscardWithoutLocalChanges() {
        return true;
    }

    public IFrameServerProxy createServerProxy(IFrameProjectAgent projectAgent) {
        FrameServerProxy frameServerProxy = new FrameServerProxy();
        frameServerProxy.construct(projectAgent);
        return frameServerProxy;
    }

    public boolean isServerAlwaysConnected() {
        return true;
    }

    public void forceLogin() throws ServerNotAvailableException, EXServerException, LoginCanceledException {
    }

    public String getVersionDependendDescription(String descriptionyKey) {
        return VERSION_DEPENDEND_DESCRIPTIONS.get(descriptionyKey);
    }
}

